/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.sources;

import com.android.annotations.Nullable;
import com.android.io.NonClosingInputStream;
import com.android.sdklib.repository.IDescription;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.CanceledByUserException;
import com.android.tools.idea.sdk.remote.internal.DownloadCache;
import com.android.tools.idea.sdk.remote.internal.ITaskMonitor;
import com.android.tools.idea.sdk.remote.internal.packages.PlatformToolRemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteAddonPkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteBuildToolPkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteDocPkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteExtraPkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteNdkPkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePlatformPkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteSamplePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteSourcePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteSystemImagePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteToolPkgInfo;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSourceProperties;
import com.intellij.openapi.diagnostic.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SdkSource
implements IDescription,
Comparable<SdkSource> {
    private String mUrl;
    private RemotePkgInfo[] mPackages;
    private String mDescription;
    private String mFetchError;
    private final String mUiName;
    private static final SdkSourceProperties sSourcesProps = new SdkSourceProperties();

    public SdkSource(String url, String uiName) {
        String[] names;
        if (url == null) {
            url = "";
        }
        if ((url = url.trim()).endsWith("/") && (names = this.getDefaultXmlFileUrls()).length > 0) {
            url = url + names[0];
        }
        if (uiName == null) {
            uiName = sSourcesProps.getProperty("@name@", url, null);
        } else {
            sSourcesProps.setProperty("@name@", url, uiName);
        }
        this.mUrl = url;
        this.mUiName = uiName;
        this.setDefaultDescription();
    }

    public abstract boolean isAddonSource();

    public abstract boolean isSysImgSource();

    protected abstract String[] getDefaultXmlFileUrls();

    protected abstract int getNsLatestVersion();

    protected abstract String getNsUri();

    protected abstract String getNsPattern();

    protected abstract String getSchemaUri(int var1);

    protected abstract String getRootElementName();

    protected abstract StreamSource[] getXsdStream(int var1);

    protected abstract Document findAlternateToolsXml(@Nullable InputStream var1) throws IOException;

    public boolean equals(Object obj) {
        if (obj instanceof SdkSource) {
            SdkSource rs = (SdkSource)obj;
            return rs.getUrl().equals(this.getUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.mUrl.hashCode();
    }

    @Override
    public int compareTo(SdkSource rhs) {
        return this.getUrl().compareTo(rhs.getUrl());
    }

    public String getUiName() {
        return this.mUiName;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public RemotePkgInfo[] getPackages() {
        return this.mPackages;
    }

    protected void setPackages(RemotePkgInfo[] packages) {
        this.mPackages = packages;
        if (this.mPackages != null) {
            Arrays.sort(this.mPackages, null);
        }
    }

    public void clearPackages() {
        this.setPackages(null);
    }

    public boolean isEnabled() {
        return sSourcesProps.getProperty("@disabled@", this.mUrl, null) == null;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.clearPackages();
            sSourcesProps.setProperty("@disabled@", this.mUrl, enabled ? null : "disabled");
        }
    }

    public String toString() {
        String s = this.getShortDescription();
        if (s != null) {
            return s;
        }
        return super.toString();
    }

    public String getShortDescription() {
        if (this.mUiName != null && this.mUiName.length() > 0) {
            String host = "malformed URL";
            try {
                URL u = new URL(this.mUrl);
                host = u.getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return String.format("%1$s (%2$s)", this.mUiName, host);
        }
        return this.mUrl;
    }

    public String getLongDescription() {
        return this.mDescription == null ? "" : this.mDescription;
    }

    public String getFetchError() {
        return this.mFetchError;
    }

    public void load(DownloadCache cache, ITaskMonitor logger, boolean forceHttp) {
        int version;
        this.setDefaultDescription();
        logger.setProgressMax(7);
        if (!this.isEnabled()) {
            this.setPackages(new RemotePkgInfo[0]);
            this.mDescription = this.mDescription + "\nSource is disabled.";
            logger.incProgress(7);
            return;
        }
        String url = this.mUrl;
        if (forceHttp) {
            url = url.replaceAll("https://", "http://");
        }
        logger.setDescription("Fetching URL: %1$s", url);
        logger.incProgress(1);
        this.mFetchError = null;
        Boolean[] validatorFound = new Boolean[]{Boolean.FALSE};
        String[] validationError = new String[]{null};
        Exception[] exception = new Exception[]{null};
        Document validatedDoc = null;
        boolean usingAlternateXml = false;
        boolean usingAlternateUrl = false;
        String validatedUri = null;
        String[] defaultNames = this.getDefaultXmlFileUrls();
        String firstDefaultName = defaultNames.length > 0 ? defaultNames[0] : "";
        InputStream xml = this.fetchXmlUrl(url, cache, logger.createSubMonitor(1), exception);
        if (xml != null && (version = this.getXmlSchemaVersion(xml)) == 0) {
            this.closeStream(xml);
            xml = null;
        }
        if (xml == null && defaultNames.length > 0) {
            int pos;
            ITaskMonitor subMonitor = logger.createSubMonitor(1);
            subMonitor.setProgressMax(defaultNames.length);
            String baseUrl = url;
            if (!baseUrl.endsWith("/") && (pos = baseUrl.lastIndexOf(47)) > 0) {
                baseUrl = baseUrl.substring(0, pos + 1);
            }
            for (String name : defaultNames) {
                String newUrl = baseUrl + name;
                if (newUrl.equals(url) || (xml = this.fetchXmlUrl(newUrl, cache, subMonitor.createSubMonitor(1), exception)) == null) continue;
                int version2 = this.getXmlSchemaVersion(xml);
                if (version2 == 0) {
                    this.closeStream(xml);
                    xml = null;
                    continue;
                }
                url = newUrl;
                subMonitor.incProgress(subMonitor.getProgressMax() - subMonitor.getProgress());
                break;
            }
        } else {
            logger.incProgress(1);
        }
        if (xml == null && !url.endsWith(firstDefaultName) && !(exception[0] instanceof CanceledByUserException)) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + firstDefaultName;
            xml = this.fetchXmlUrl(url, cache, logger.createSubMonitor(1), exception);
            usingAlternateUrl = true;
        } else {
            logger.incProgress(1);
        }
        if (xml != null) {
            logger.setDescription("Validate XML: %1$s", url);
            ITaskMonitor subMonitor = logger.createSubMonitor(2);
            subMonitor.setProgressMax(2);
            for (int tryOtherUrl = 0; tryOtherUrl < 2; ++tryOtherUrl) {
                int version3 = this.getXmlSchemaVersion(xml);
                if (version3 >= 1 && version3 <= this.getNsLatestVersion()) {
                    String uri = this.validateXml(xml, url, version3, validationError, validatorFound);
                    if (uri != null) {
                        validatedDoc = this.getDocument(xml, logger);
                        validatedUri = uri;
                        if (!usingAlternateUrl || validatedDoc == null) break;
                        logger.log("Repository found at %1$s", url);
                        this.mUrl = url;
                        break;
                    }
                    if (!validatorFound[0].equals(Boolean.FALSE)) break;
                    this.mFetchError = validationError[0];
                    break;
                }
                if (version3 > this.getNsLatestVersion()) {
                    try {
                        validatedDoc = this.findAlternateToolsXml(xml);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (validatedDoc == null) break;
                    validationError[0] = null;
                    validatedUri = this.getNsUri();
                    usingAlternateXml = true;
                    break;
                }
                if (version3 < 1 && tryOtherUrl == 0 && !usingAlternateUrl) {
                    this.mFetchError = String.format("Failed to validate the XML for the repository at URL '%1$s'", url);
                    if (url.endsWith(firstDefaultName)) break;
                    if (!url.endsWith("/")) {
                        url = url + "/";
                    }
                    url = url + firstDefaultName;
                    this.closeStream(xml);
                    xml = this.fetchXmlUrl(url, cache, subMonitor.createSubMonitor(1), null);
                    subMonitor.incProgress(1);
                    if (xml == null) break;
                } else {
                    if (version3 >= 1 || !usingAlternateUrl || this.mFetchError != null) break;
                    this.mFetchError = String.format("Failed to validate the XML for the repository at URL '%1$s'", url);
                    break;
                }
                usingAlternateUrl = true;
            }
        }
        if (exception[0] != null) {
            this.mFetchError = "Failed to fetch URL";
            String reason = null;
            if (exception[0] instanceof FileNotFoundException) {
                reason = "File not found";
                this.mFetchError = this.mFetchError + ": " + reason;
            } else if (exception[0] instanceof SSLKeyException) {
                reason = "HTTPS SSL error. You might want to force download through HTTP in the settings.";
                this.mFetchError = this.mFetchError + ": HTTPS SSL error";
            } else {
                reason = exception[0].getMessage() != null ? exception[0].getClass().getSimpleName().replace("Exception", "") + ' ' + exception[0].getMessage() : exception[0].toString();
            }
            logger.warning("Failed to fetch URL %1$s, reason: %2$s", new Object[]{url, reason});
        }
        if (validationError[0] != null) {
            logger.logError("%s", validationError[0]);
        }
        if (validatedDoc == null) {
            return;
        }
        if (usingAlternateXml) {
            String info;
            boolean isADT = false;
            try {
                Class<?> adt = Class.forName("com.android.ide.eclipse.adt.AdtPlugin");
                isADT = adt != null;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (isADT) {
                info = "This repository requires a more recent version of ADT. Please update the Eclipse Android plugin.";
                this.mDescription = "This repository requires a more recent version of ADT, the Eclipse Android plugin.\nYou must update it before you can see other new packages.";
            } else {
                info = "This repository requires a more recent version of the Tools. Please update.";
                this.mDescription = "This repository requires a more recent version of the Tools.\nYou must update it before you can see other new packages.";
            }
            this.mFetchError = this.mFetchError == null ? info : this.mFetchError + ". " + info;
        }
        logger.incProgress(1);
        if (xml != null) {
            logger.setDescription("Parse XML:    %1$s", url);
            logger.incProgress(1);
            this.parsePackages(validatedDoc, validatedUri, logger);
            this.mDescription = this.mPackages == null || this.mPackages.length == 0 ? this.mDescription + "\nNo packages found." : (this.mPackages.length == 1 ? this.mDescription + "\nOne package found." : this.mDescription + String.format("\n%1$d packages found.", this.mPackages.length));
        }
        logger.incProgress(1);
        this.closeStream(xml);
    }

    private void setDefaultDescription() {
        if (this.isAddonSource()) {
            String desc = "";
            if (this.mUiName != null) {
                desc = desc + "Add-on Provider: " + this.mUiName;
                desc = desc + "\n";
            }
            this.mDescription = desc = desc + "Add-on URL: " + this.mUrl;
        } else {
            this.mDescription = String.format("SDK Source: %1$s", this.mUrl);
        }
    }

    private InputStream fetchXmlUrl(String urlString, DownloadCache cache, ITaskMonitor monitor, Exception[] outException) {
        try {
            InputStream xml = cache.openCachedUrl(urlString, monitor);
            if (xml != null) {
                xml.mark(500000);
                xml = new NonClosingInputStream(xml);
                ((NonClosingInputStream)xml).setCloseBehavior(NonClosingInputStream.CloseBehavior.RESET);
            }
            return xml;
        }
        catch (Exception e) {
            if (outException != null) {
                outException[0] = e;
            }
            return null;
        }
    }

    private void closeStream(InputStream is) {
        if (is != null) {
            if (is instanceof NonClosingInputStream) {
                ((NonClosingInputStream)is).setCloseBehavior(NonClosingInputStream.CloseBehavior.CLOSE);
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String validateXml(InputStream xml, String url, int version, String[] outError, Boolean[] validatorFound) {
        if (xml == null) {
            return null;
        }
        try {
            Validator validator = this.getValidator(version);
            if (validator == null) {
                validatorFound[0] = Boolean.FALSE;
                outError[0] = String.format("XML verification failed for %1$s.\nNo suitable XML Schema Validator could be found in your Java environment. Please consider updating your version of Java.", url);
                return null;
            }
            validatorFound[0] = Boolean.TRUE;
            assert (xml.markSupported());
            xml.reset();
            validator.validate(new StreamSource(xml));
            return this.getSchemaUri(version);
        }
        catch (SAXParseException e) {
            outError[0] = String.format("XML verification failed for %1$s.\nLine %2$d:%3$d, Error: %4$s", url, e.getLineNumber(), e.getColumnNumber(), e.toString());
        }
        catch (Exception e) {
            outError[0] = String.format("XML verification failed for %1$s.\nError: %2$s", url, e.toString());
        }
        return null;
    }

    protected int getXmlSchemaVersion(InputStream xml) {
        if (xml == null) {
            return 0;
        }
        Node doc = null;
        try {
            assert (xml.markSupported());
            xml.reset();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            doc = builder.parse(xml);
            factory.setNamespaceAware(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (doc == null) {
            return 0;
        }
        Pattern nsPattern = Pattern.compile(this.getNsPattern());
        String prefix = null;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            Matcher m;
            String uri;
            Node attr;
            if (child.getNodeType() != 1) continue;
            prefix = null;
            String name = child.getNodeName();
            int pos = name.indexOf(58);
            if (pos > 0 && pos < name.length() - 1) {
                prefix = name.substring(0, pos);
                name = name.substring(pos + 1);
            }
            if (!this.getRootElementName().equals(name)) continue;
            NamedNodeMap attrs = child.getAttributes();
            String xmlns = "xmlns";
            if (prefix != null) {
                xmlns = xmlns + ":" + prefix;
            }
            if ((attr = attrs.getNamedItem(xmlns)) == null || (uri = attr.getNodeValue()) == null || !(m = nsPattern.matcher(uri)).matches()) continue;
            String version = m.group(1);
            try {
                return Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private Validator getValidator(int version) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (factory == null) {
            return null;
        }
        Source[] xsdStreams = this.getXsdStream(version);
        Schema schema = factory.newSchema(xsdStreams);
        Validator validator = schema == null ? null : schema.newValidator();
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        return validator;
    }

    protected boolean parsePackages(Document doc, String nsUri, ITaskMonitor monitor) {
        Node root = this.getFirstChild(doc, nsUri, this.getRootElementName());
        if (root != null) {
            Node child;
            ArrayList<RemoteAddonPkgInfo> packages = new ArrayList<RemoteAddonPkgInfo>();
            HashMap<String, String> licenses = new HashMap<String, String>();
            for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                Node id;
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !child.getLocalName().equals("license") || (id = child.getAttributes().getNamedItem("id")) == null) continue;
                licenses.put(id.getNodeValue(), child.getTextContent());
            }
            for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI())) continue;
                String name = child.getLocalName();
                RemotePkgInfo p = null;
                try {
                    if ("add-on".equals(name)) {
                        p = new RemoteAddonPkgInfo(this, child, nsUri, licenses);
                    } else if ("extra".equals(name)) {
                        p = new RemoteExtraPkgInfo(this, child, nsUri, licenses);
                    } else if (!this.isAddonSource()) {
                        if ("platform".equals(name)) {
                            p = new RemotePlatformPkgInfo(this, child, nsUri, licenses);
                        } else if ("doc".equals(name)) {
                            p = new RemoteDocPkgInfo(this, child, nsUri, licenses);
                        } else if ("tool".equals(name)) {
                            p = new RemoteToolPkgInfo(this, child, nsUri, licenses);
                        } else if ("platform-tool".equals(name)) {
                            p = new PlatformToolRemotePkgInfo(this, child, nsUri, licenses);
                        } else if ("build-tool".equals(name)) {
                            p = new RemoteBuildToolPkgInfo(this, child, nsUri, licenses);
                        } else if ("sample".equals(name)) {
                            p = new RemoteSamplePkgInfo(this, child, nsUri, licenses);
                        } else if ("system-image".equals(name)) {
                            p = new RemoteSystemImagePkgInfo(this, child, nsUri, licenses);
                        } else if ("source".equals(name)) {
                            p = new RemoteSourcePkgInfo(this, child, nsUri, licenses);
                        } else if ("ndk".equals(name)) {
                            p = new RemoteNdkPkgInfo(this, child, nsUri, licenses);
                        }
                    }
                    if (p == null) continue;
                    packages.add((RemoteAddonPkgInfo)p);
                    monitor.logVerbose("Found %1$s", p.getShortDescription());
                    continue;
                }
                catch (Exception e) {
                    String msg = String.format("Ignoring invalid %1$s element: %2$s", name, e.toString());
                    monitor.logError(msg, new Object[0]);
                    Logger.getInstance(this.getClass()).error(msg, (Throwable)e);
                }
            }
            this.setPackages(packages.toArray(new RemotePkgInfo[packages.size()]));
            return true;
        }
        return false;
    }

    private Node getFirstChild(Node node, String nsUri, String xmlLocalName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || xmlLocalName != null && !child.getLocalName().equals(xmlLocalName)) continue;
            return child;
        }
        return null;
    }

    protected Document getDocument(InputStream xml, ITaskMonitor monitor) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            assert (xml.markSupported());
            xml.reset();
            Document doc = builder.parse(new InputSource(xml));
            return doc;
        }
        catch (ParserConfigurationException e) {
            monitor.logError("Failed to create XML document builder", new Object[0]);
        }
        catch (SAXException e) {
            monitor.logError("Failed to parse XML document", new Object[0]);
        }
        catch (IOException e) {
            monitor.logError("Failed to read XML document", new Object[0]);
        }
        return null;
    }
}

