/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.sources;

import com.android.prefs.AndroidLocation;
import com.android.tools.idea.sdk.remote.internal.sources.SdkAddonSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSourceCategory;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSysImgSource;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Properties;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;

public class SdkSources {
    private static final String KEY_COUNT = "count";
    private static final String KEY_SRC = "src";
    private static final String KEY_DISPLAY = "disp";
    private static final String SRC_FILENAME = "repositories.cfg";
    private static final List<SdkSource> EMPTY_LIST = ImmutableList.of();
    @GuardedBy(value="itself")
    private final EnumMap<SdkSourceCategory, List<SdkSource>> mySources = new EnumMap(SdkSourceCategory.class);
    private final ArrayList<Runnable> mChangeListeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SdkSourceCategory category, SdkSource source) {
        EnumMap<SdkSourceCategory, List<SdkSource>> enumMap = this.mySources;
        synchronized (enumMap) {
            List<SdkSource> list = this.mySources.get((Object)category);
            if (list == null || list == EMPTY_LIST) {
                list = new ArrayList<SdkSource>();
                this.mySources.put(category, list);
            }
            list.add(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(SdkSourceCategory category, Collection<SdkSource> sources) {
        EnumMap<SdkSourceCategory, List<SdkSource>> enumMap = this.mySources;
        synchronized (enumMap) {
            this.mySources.put(category, Lists.newArrayList(sources));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SdkSource source) {
        EnumMap<SdkSourceCategory, List<SdkSource>> enumMap = this.mySources;
        synchronized (enumMap) {
            for (SdkSourceCategory category : this.mySources.keySet()) {
                List<SdkSource> list = this.mySources.get((Object)category);
                if (!list.remove(source) || !list.isEmpty()) continue;
                this.mySources.put(category, EMPTY_LIST);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(SdkSourceCategory category) {
        EnumMap<SdkSourceCategory, List<SdkSource>> enumMap = this.mySources;
        synchronized (enumMap) {
            this.mySources.remove((Object)category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdkSource[] getSources(SdkSourceCategory category) {
        EnumMap<SdkSourceCategory, List<SdkSource>> enumMap = this.mySources;
        synchronized (enumMap) {
            List<SdkSource> list = this.mySources.get((Object)category);
            if (list == null) {
                return new SdkSource[0];
            }
            return list.toArray(new SdkSource[list.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sourcesLoaded(SdkSourceCategory category) {
        EnumMap<SdkSourceCategory, List<SdkSource>> enumMap = this.mySources;
        synchronized (enumMap) {
            List<SdkSource> list = this.mySources.get((Object)category);
            return list == EMPTY_LIST || list != null && !list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdkSource[] getAllSources() {
        EnumMap<SdkSourceCategory, List<SdkSource>> enumMap = this.mySources;
        synchronized (enumMap) {
            int n = 0;
            for (List<SdkSource> list : this.mySources.values()) {
                n += list.size();
            }
            SdkSource[] sources = new SdkSource[n];
            int i = 0;
            for (List<SdkSource> list : this.mySources.values()) {
                for (SdkSource source : list) {
                    sources[i++] = source;
                }
            }
            return sources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSourceUrl(SdkSource source) {
        EnumMap<SdkSourceCategory, List<SdkSource>> enumMap = this.mySources;
        synchronized (enumMap) {
            for (List<SdkSource> list : this.mySources.values()) {
                for (SdkSource s : list) {
                    if (!s.equals(source)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserAddons(ILogger log) {
        EnumMap<SdkSourceCategory, List<SdkSource>> enumMap = this.mySources;
        synchronized (enumMap) {
            this.removeAll(SdkSourceCategory.USER_ADDONS);
            FileInputStream fis = null;
            try {
                String folder = AndroidLocation.getFolder();
                File f = new File(folder, SRC_FILENAME);
                if (f.exists()) {
                    fis = new FileInputStream(f);
                    Properties props = new Properties();
                    props.load(fis);
                    int count = Integer.parseInt(props.getProperty(KEY_COUNT, "0"));
                    for (int i = 0; i < count; ++i) {
                        SdkSource s;
                        String url = props.getProperty(String.format("%s%02d", KEY_SRC, i));
                        String disp = props.getProperty(String.format("%s%02d", KEY_DISPLAY, i));
                        if (url == null || this.hasSourceUrl(s = url.endsWith("sys-img.xml") ? new SdkSysImgSource(url, disp) : new SdkAddonSource(url, disp))) continue;
                        this.add(SdkSourceCategory.USER_ADDONS, s);
                    }
                }
            }
            catch (NumberFormatException e) {
                log.error((Throwable)e, null, new Object[0]);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                log.error((Throwable)e, null, new Object[0]);
            }
            catch (IOException e) {
                log.error((Throwable)e, null, new Object[0]);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.notifyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserAddons(ILogger log) {
        EnumMap<SdkSourceCategory, List<SdkSource>> enumMap = this.mySources;
        synchronized (enumMap) {
            FileOutputStream fos = null;
            try {
                String folder = AndroidLocation.getFolder();
                File f = new File(folder, SRC_FILENAME);
                fos = new FileOutputStream(f);
                Properties props = new Properties();
                int count = 0;
                for (SdkSource s : this.getSources(SdkSourceCategory.USER_ADDONS)) {
                    props.setProperty(String.format("%s%02d", KEY_SRC, count), s.getUrl());
                    if (s.getUiName() != null) {
                        props.setProperty(String.format("%s%02d", KEY_DISPLAY, count), s.getUiName());
                    }
                    ++count;
                }
                props.setProperty(KEY_COUNT, Integer.toString(count));
                props.store(fos, "## User Sources for Android SDK Manager");
            }
            catch (AndroidLocation.AndroidLocationException e) {
                log.error((Throwable)e, null, new Object[0]);
            }
            catch (IOException e) {
                log.error((Throwable)e, null, new Object[0]);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(@NotNull Runnable changeListener) {
        if (changeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListener", "com/android/tools/idea/sdk/remote/internal/sources/SdkSources", "addChangeListener"));
        }
        ArrayList<Runnable> arrayList = this.mChangeListeners;
        synchronized (arrayList) {
            if (!this.mChangeListeners.contains(changeListener)) {
                this.mChangeListeners.add(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(@NotNull Runnable changeListener) {
        if (changeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListener", "com/android/tools/idea/sdk/remote/internal/sources/SdkSources", "removeChangeListener"));
        }
        ArrayList<Runnable> arrayList = this.mChangeListeners;
        synchronized (arrayList) {
            this.mChangeListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChangeListeners() {
        ArrayList<Runnable> arrayList = this.mChangeListeners;
        synchronized (arrayList) {
            for (Runnable runnable : this.mChangeListeners) {
                try {
                    runnable.run();
                }
                catch (Throwable ignore) {
                    assert (false) : "A SdkSource.ChangeListener failed with an exception: " + ignore.toString();
                }
            }
        }
    }
}

