/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.templates.FreemarkerConfiguration;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.PrefixTemplateLoader;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.TypedVariable;
import com.android.tools.idea.templates.parse.SaxUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.tools.idea.templates.recipe.RecipeContext;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Template {
    public static final String TEMPLATE_XML_NAME = "template.xml";
    public static final String TAG_EXECUTE = "execute";
    public static final String TAG_GLOBALS = "globals";
    public static final String TAG_GLOBAL = "global";
    public static final String TAG_PARAMETER = "parameter";
    public static final String TAG_THUMB = "thumb";
    public static final String TAG_THUMBS = "thumbs";
    public static final String TAG_DEPENDENCY = "dependency";
    public static final String TAG_ICONS = "icons";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_HELP = "help";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_CONSTRAINTS = "constraints";
    public static final String ATTR_VISIBILITY = "visibility";
    public static final String ATTR_ENABLED = "enabled";
    public static final String ATTR_SOURCE_URL = "href";
    public static final String CATEGORY_ACTIVITIES = "activities";
    public static final String CATEGORY_ACTIVITY = "Activity";
    public static final String CATEGORY_PROJECTS = "gradle-projects";
    public static final String CATEGORY_OTHER = "other";
    public static final String CATEGORY_APPLICATION = "Application";
    public static final String BLOCK_DEPENDENCIES = "dependencies";
    static final int CURRENT_FORMAT = 4;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.Template");
    private static final String DATA_ROOT = "root";
    public static Exception ourMostRecentException;
    private final List<File> myFilesToOpen;
    private final File myTemplateRoot;
    private final PrefixTemplateLoader myLoader;
    private TemplateMetadata myMetadata;
    private Project myProject;

    private Template(@NotNull File rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/android/tools/idea/templates/Template", "<init>"));
        }
        this.myFilesToOpen = Lists.newArrayList();
        this.myTemplateRoot = rootPath;
        this.myLoader = new PrefixTemplateLoader(this.myTemplateRoot.getPath());
    }

    @NotNull
    public static Template createFromPath(@NotNull File rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/android/tools/idea/templates/Template", "createFromPath"));
        }
        Template template = new Template(rootPath);
        if (template == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createFromPath"));
        }
        return template;
    }

    @NotNull
    public static Template createFromName(@NotNull String category, @NotNull String name) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/android/tools/idea/templates/Template", "createFromName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_NAME, "com/android/tools/idea/templates/Template", "createFromName"));
        }
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplates(category);
        for (File file : templates) {
            if (!file.getName().equals(name) || !category.equals(file.getParentFile().getName())) continue;
            Template template = new Template(file);
            if (template == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createFromName"));
            }
            return template;
        }
        Template template = new Template(new File(TemplateManager.getTemplateRootFolder(), category + File.separator + name));
        if (template == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createFromName"));
        }
        return template;
    }

    @NotNull
    public static Map<String, Object> createParameterMap(@NotNull Map<String, Object> args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "createParameterMap"));
        }
        Map<String, Object> paramMap = FreemarkerUtils.createParameterMap(args);
        if (ApplicationManager.getApplication() != null && TemplateManager.getTemplateRootFolder() != null) {
            paramMap.put("templateRoot", TemplateManager.getTemplateRootFolder().getAbsolutePath());
        }
        Map<String, Object> map = paramMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createParameterMap"));
        }
        return map;
    }

    private static void enforceParameterTypes(@NotNull TemplateMetadata metadata, @NotNull Map<String, Object> args) {
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/templates/Template", "enforceParameterTypes"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "enforceParameterTypes"));
        }
        for (Parameter p : metadata.getParameters()) {
            Object o = args.get(p.id);
            if (o == null) continue;
            switch (p.type) {
                case STRING: {
                    if (o instanceof String) break;
                    args.put(p.id, o.toString());
                    break;
                }
                case BOOLEAN: {
                    if (o instanceof Boolean) break;
                    args.put(p.id, Boolean.parseBoolean(o.toString()));
                    break;
                }
                case ENUM: {
                    break;
                }
                case SEPARATOR: {
                    break;
                }
                case EXTERNAL: {
                    break;
                }
            }
        }
        Template.convertApisToInt(args);
    }

    public static void convertApisToInt(@NotNull Map<String, Object> args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "convertApisToInt"));
        }
        Template.convertToInt("buildApi", args);
        Template.convertToInt("minApiLevel", args);
        Template.convertToInt("targetApi", args);
    }

    private static void convertToInt(@NotNull String key, @NotNull Map<String, Object> args) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/templates/Template", "convertToInt"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "convertToInt"));
        }
        Object value = args.get(key);
        if (value instanceof String) {
            Integer result;
            try {
                result = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                result = SdkVersionInfo.getApiByPreviewName((String)((String)value), (boolean)true);
            }
            args.put(key, result);
        }
    }

    @Deprecated
    public void render(@NotNull File outputRootPath, @NotNull File moduleRootPath, @NotNull Map<String, Object> args) {
        if (outputRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputRootPath", "com/android/tools/idea/templates/Template", "render"));
        }
        if (moduleRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootPath", "com/android/tools/idea/templates/Template", "render"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "render"));
        }
        this.render(outputRootPath, moduleRootPath, args, null);
    }

    public void render(@NotNull File outputRootPath, @NotNull File moduleRootPath, @NotNull Map<String, Object> args, @Nullable Project project) {
        if (outputRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputRootPath", "com/android/tools/idea/templates/Template", "render"));
        }
        if (moduleRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootPath", "com/android/tools/idea/templates/Template", "render"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "render"));
        }
        this.render(outputRootPath, moduleRootPath, args, project, true);
    }

    public void render(final @NotNull File outputRootPath, final @NotNull File moduleRootPath, final @NotNull Map<String, Object> args, final @Nullable Project project, final boolean gradleSyncIfNeeded) {
        if (outputRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputRootPath", "com/android/tools/idea/templates/Template", "render"));
        }
        if (moduleRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootPath", "com/android/tools/idea/templates/Template", "render"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "render"));
        }
        assert (outputRootPath.isDirectory()) : outputRootPath;
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                Template.this.doRender(outputRootPath, moduleRootPath, args, project, gradleSyncIfNeeded);
            }
        });
    }

    private void doRender(@NotNull File outputRootPath, @NotNull File moduleRootPath, @NotNull Map<String, Object> args, @Nullable Project project, boolean gradleSyncIfNeeded) {
        if (outputRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputRootPath", "com/android/tools/idea/templates/Template", "doRender"));
        }
        if (moduleRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootPath", "com/android/tools/idea/templates/Template", "doRender"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "doRender"));
        }
        this.myFilesToOpen.clear();
        if (project == null) {
            project = ProjectManagerEx.getInstanceEx().getDefaultProject();
        }
        this.myProject = project;
        Map<String, Object> paramMap = Template.createParameterMap(args);
        Template.enforceParameterTypes(this.getMetadata(), args);
        FreemarkerConfiguration freemarker = new FreemarkerConfiguration();
        freemarker.setTemplateLoader(this.myLoader);
        this.processFile(freemarker, new File(TEMPLATE_XML_NAME), paramMap, outputRootPath, moduleRootPath, gradleSyncIfNeeded);
    }

    @NotNull
    public File getRootPath() {
        File file = this.myTemplateRoot;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getRootPath"));
        }
        return file;
    }

    @Nullable
    public TemplateMetadata getMetadata() {
        if (this.myMetadata == null) {
            this.myMetadata = TemplateManager.getInstance().getTemplate(this.myTemplateRoot);
        }
        return this.myMetadata;
    }

    @NotNull
    public List<File> getFilesToOpen() {
        List<File> list = this.myFilesToOpen;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getFilesToOpen"));
        }
        return list;
    }

    private void processFile(final @NotNull Configuration freemarker, @NotNull File file, final @NotNull Map<String, Object> paramMap, final @NotNull File outputRoot, final @NotNull File moduleRoot, final boolean gradleSyncIfNeeded) {
        if (freemarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freemarker", "com/android/tools/idea/templates/Template", "processFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_FILE, "com/android/tools/idea/templates/Template", "processFile"));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/Template", "processFile"));
        }
        if (outputRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputRoot", "com/android/tools/idea/templates/Template", "processFile"));
        }
        if (moduleRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRoot", "com/android/tools/idea/templates/Template", "processFile"));
        }
        try {
            String xml;
            if (TemplateUtils.hasExtension(file, ".xml")) {
                xml = TemplateUtils.readTextFile(this.getTemplateFile(file));
                if (xml == null) {
                    return;
                }
            } else {
                this.myLoader.setTemplateFile(this.getTemplateFile(file));
                xml = FreemarkerUtils.processFreemarkerTemplate(freemarker, paramMap, file);
            }
            xml = XmlUtils.stripBom((String)xml);
            InputSource inputSource = new InputSource(new StringReader(xml));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    if (Template.TAG_PARAMETER.equals(name)) {
                        String id = attributes.getValue(Template.ATTR_ID);
                        if (!paramMap.containsKey(id)) {
                            String type;
                            String value = attributes.getValue(Template.ATTR_DEFAULT);
                            Object mapValue = value;
                            if (value != null && !value.isEmpty() && "boolean".equals(type = attributes.getValue(Template.ATTR_TYPE))) {
                                mapValue = Boolean.valueOf(value);
                            }
                            paramMap.put(id, mapValue);
                        }
                    } else if (Template.TAG_GLOBAL.equals(name)) {
                        String id = attributes.getValue(Template.ATTR_ID);
                        if (!paramMap.containsKey(id)) {
                            paramMap.put(id, TypedVariable.parseGlobal(attributes));
                        }
                    } else if (Template.TAG_GLOBALS.equals(name)) {
                        File globalsFile = SaxUtils.getPath(attributes, Template.ATTR_FILE);
                        if (globalsFile != null) {
                            Template.this.processFile(freemarker, globalsFile, paramMap, outputRoot, moduleRoot, gradleSyncIfNeeded);
                        }
                    } else if (Template.TAG_EXECUTE.equals(name)) {
                        File recipeFile = SaxUtils.getPath(attributes, Template.ATTR_FILE);
                        if (recipeFile != null) {
                            Template.this.executeRecipeFile(freemarker, recipeFile, paramMap, outputRoot, moduleRoot, gradleSyncIfNeeded);
                        }
                    } else if (!(name.equals("template") || name.equals("category") || name.equals("option") || name.equals(Template.TAG_THUMBS) || name.equals(Template.TAG_THUMB) || name.equals(Template.TAG_ICONS) || name.equals(Template.TAG_DEPENDENCY) || name.equals("formfactor"))) {
                        LOG.error("WARNING: Unknown template directive " + name);
                    }
                }
            });
        }
        catch (Exception e) {
            ourMostRecentException = e;
            LOG.warn((Throwable)e);
        }
    }

    private void executeRecipeFile(@NotNull Configuration freemarker, @NotNull File fileRecipe, @NotNull Map<String, Object> paramMap, @NotNull File outputRoot, @NotNull File moduleRoot, boolean gradleSyncIfNeeded) {
        if (freemarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freemarker", "com/android/tools/idea/templates/Template", "executeRecipeFile"));
        }
        if (fileRecipe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileRecipe", "com/android/tools/idea/templates/Template", "executeRecipeFile"));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/Template", "executeRecipeFile"));
        }
        if (outputRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputRoot", "com/android/tools/idea/templates/Template", "executeRecipeFile"));
        }
        if (moduleRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRoot", "com/android/tools/idea/templates/Template", "executeRecipeFile"));
        }
        try {
            this.myLoader.setTemplateFile(this.getTemplateFile(fileRecipe));
            String xml = FreemarkerUtils.processFreemarkerTemplate(freemarker, paramMap, fileRecipe);
            xml = XmlUtils.stripBom((String)xml);
            Recipe recipe = Recipe.parse(new StringReader(xml));
            this.myFilesToOpen.addAll(recipe.getFilesToOpen());
            RecipeContext recipeContext = new RecipeContext(this.myProject, this.myLoader, freemarker, paramMap, new File(this.myTemplateRoot, DATA_ROOT), outputRoot, moduleRoot, gradleSyncIfNeeded);
            recipe.execute(recipeContext);
        }
        catch (Exception e) {
            ourMostRecentException = e;
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    private File getTemplateFile(@NotNull File relativeFile) throws IOException {
        if (relativeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeFile", "com/android/tools/idea/templates/Template", "getTemplateFile"));
        }
        File file = new File(this.myTemplateRoot, relativeFile.getPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getTemplateFile"));
        }
        return file;
    }
}

