/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.parse;

import com.android.utils.XmlUtils;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public final class SaxUtils {
    @Nullable
    public static File getPath(@NotNull Attributes attributes, @NotNull String name) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/templates/parse/SaxUtils", "getPath"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/templates/parse/SaxUtils", "getPath"));
        }
        String value = attributes.getValue(name);
        if (value == null) {
            return null;
        }
        String unescapedString = XmlUtils.fromXmlAttributeValue((String)value);
        return new File(FileUtil.toSystemDependentName((String)unescapedString));
    }

    @NotNull
    public static String attrOrDefault(@NotNull Attributes attributes, @NotNull String name, @NotNull String defaultValue) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/templates/parse/SaxUtils", "attrOrDefault"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/templates/parse/SaxUtils", "attrOrDefault"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/android/tools/idea/templates/parse/SaxUtils", "attrOrDefault"));
        }
        String value = attributes.getValue(name);
        String string = value != null ? value : defaultValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/parse/SaxUtils", "attrOrDefault"));
        }
        return string;
    }

    @NotNull
    public static String requireAttr(@NotNull String tag, @NotNull Attributes attributes, @NotNull String name) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/templates/parse/SaxUtils", "requireAttr"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/templates/parse/SaxUtils", "requireAttr"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/templates/parse/SaxUtils", "requireAttr"));
        }
        String result = attributes.getValue(name);
        if (result == null) {
            throw new RuntimeException(String.format("Required attribute \"%1$s\" not found in element <%2$s %3$s>", name, tag, SaxUtils.attrsToString(attributes)));
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/parse/SaxUtils", "requireAttr"));
        }
        return string;
    }

    @NotNull
    private static String attrsToString(@NotNull Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/templates/parse/SaxUtils", "attrsToString"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = 0; i < attributes.getLength(); ++i) {
            builder.append(attributes.getQName(i));
            builder.append('=');
            builder.append(attributes.getValue(i));
            if (i >= attributes.getLength() - 1) continue;
            builder.append("; ");
        }
        builder.append(']');
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/parse/SaxUtils", "attrsToString"));
        }
        return string;
    }
}

