/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.expressions.integer;

import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.expressions.integer.IntExpression;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SumExpression
extends IntExpression {
    private final List<ObservableValue<Integer>> myValues;

    public SumExpression(ObservableValue<Integer> ... values) {
        super(values);
        this.myValues = Arrays.asList(values);
    }

    @Override
    @NotNull
    public Integer get() {
        int sum = 0;
        for (ObservableValue<Integer> value : this.myValues) {
            sum += value.get().intValue();
        }
        Integer n = sum;
        if (n == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/expressions/integer/SumExpression", "get"));
        }
        return n;
    }
}

