/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.AddAndroidActivityPath;
import com.android.tools.idea.wizard.DynamicWizard;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewAndroidActivityWizard
extends DynamicWizard {
    @Nullable
    private final VirtualFile myTargetFile;
    @Nullable
    private final File myTemplate;
    private AddAndroidActivityPath myPath;

    public NewAndroidActivityWizard(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/wizard/NewAndroidActivityWizard", "<init>"));
        }
        this(module, null, null);
    }

    public NewAndroidActivityWizard(Module module, @Nullable VirtualFile targetFile, @Nullable File template) {
        super(module.getProject(), module, "New Android Activity");
        this.myTargetFile = targetFile;
        this.myTemplate = template;
    }

    @Override
    public void init() {
        this.myPath = new AddAndroidActivityPath(this.myTargetFile, this.myTemplate, (Map<String, Object>)ImmutableMap.of(), this.getDisposable());
        this.addPath(this.myPath);
        super.init();
        this.myHost.setPreferredWindowSize(new Dimension(800, 640));
    }

    public void setOpenCreatedFiles(boolean openCreatedFiles) {
        this.getState().put(AddAndroidActivityPath.KEY_OPEN_EDITORS, openCreatedFiles);
    }

    @Override
    protected String getWizardActionDescription() {
        return this.myPath.getActionDescription();
    }

    @Override
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Creating activity..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewAndroidActivityWizard", "getProgressTitle"));
        }
        return "Creating activity...";
    }
}

