/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.NewProjectImportGradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.ConfigureAndroidProjectPath;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.NewFormFactorModulePath;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.Lists;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectWizardDynamic
extends DynamicWizard {
    private static final String ERROR_MSG_TITLE = "Error in New Project Wizard";
    private Project myProject;

    public NewProjectWizardDynamic(@Nullable Project project, @Nullable Module module) {
        super(project, module, "New Project");
        this.setTitle("Create New Project");
    }

    @Override
    public void init() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            String title = "SDK problem";
            String msg = "<html>Your Android SDK is missing, out of date, or is missing templates.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            return;
        }
        this.addPaths();
        this.initState();
        super.init();
    }

    protected void addPaths() {
        this.addPath(new ConfigureAndroidProjectPath(this.getDisposable()));
        for (NewFormFactorModulePath path : NewFormFactorModulePath.getAvailableFormFactorModulePaths(this.getDisposable())) {
            this.addPath(path);
        }
    }

    protected void initState() {
        String mavenUrl;
        ScopedStateStore state = this.getState();
        state.put(WizardConstants.GRADLE_VERSION_KEY, "2.4");
        state.put(WizardConstants.GRADLE_PLUGIN_VERSION_KEY, "1.2.3");
        state.put(WizardConstants.USE_PER_MODULE_REPOS_KEY, false);
        state.put(WizardConstants.IS_NEW_PROJECT_KEY, true);
        state.put(WizardConstants.IS_GRADLE_PROJECT_KEY, true);
        try {
            state.put(WizardConstants.DEBUG_KEYSTORE_SHA_1_KEY, KeystoreUtils.sha1(KeystoreUtils.getOrCreateDefaultDebugKeystore()));
        }
        catch (Exception e) {
            this.LOG.error("Could not create default debug keystore: " + e.getMessage());
            state.put(WizardConstants.DEBUG_KEYSTORE_SHA_1_KEY, "");
        }
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData != null) {
            state.put(WizardConstants.SDK_DIR_KEY, sdkData.getLocation().getPath());
        }
        if ((mavenUrl = System.getProperty("android.mavenRepoUrl")) != null) {
            state.put(WizardConstants.MAVEN_URL_KEY, mavenUrl);
        }
        state.put(WizardConstants.FILES_TO_OPEN_KEY, Lists.newArrayList());
    }

    @Override
    protected String getWizardActionDescription() {
        return String.format("Create %1$s", this.getState().get(WizardConstants.APPLICATION_NAME_KEY));
    }

    @Override
    public void performFinishingActions() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                NewProjectWizardDynamic.this.runFinish();
            }
        });
    }

    private void runFinish() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        GradleProjectImporter projectImporter = GradleProjectImporter.getInstance();
        String rootPath = this.getState().get(WizardConstants.PROJECT_LOCATION_KEY);
        if (rootPath == null) {
            this.LOG.error("No root path specified for project");
            return;
        }
        File rootLocation = new File(rootPath);
        File wrapperPropertiesFilePath = GradleUtil.getGradleWrapperPropertiesFilePath(rootLocation);
        try {
            GradleUtil.updateGradleDistributionUrl("2.4", wrapperPropertiesFilePath);
        }
        catch (IOException e) {
            this.LOG.warn("Failed to update Gradle wrapper file", (Throwable)e);
        }
        String projectName = this.getState().get(WizardConstants.APPLICATION_NAME_KEY);
        if (projectName == null) {
            projectName = "Unnamed Project";
        }
        LanguageLevel initialLanguageLevel = null;
        Iterator<FormFactorUtils.FormFactor> iterator = FormFactorUtils.FormFactor.iterator();
        while (iterator.hasNext()) {
            LanguageLevel level;
            FormFactorUtils.FormFactor factor = iterator.next();
            String version = this.getState().get(FormFactorUtils.getLanguageLevelKey(factor));
            if (version == null || (level = LanguageLevel.parse((String)version.toString())) == null || initialLanguageLevel != null && !level.isAtLeast(initialLanguageLevel)) continue;
            initialLanguageLevel = level;
        }
        try {
            projectImporter.importNewlyCreatedProject(projectName, rootLocation, new NewProjectImportGradleSyncListener(){

                @Override
                public void syncSucceeded(final @NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/wizard/NewProjectWizardDynamic$2", "syncSucceeded"));
                    }
                    StartupManagerEx manager = StartupManagerEx.getInstanceEx((Project)project);
                    if (!manager.postStartupActivityPassed()) {
                        manager.registerPostStartupActivity(new Runnable(){

                            @Override
                            public void run() {
                                this.openTemplateFiles(project);
                            }
                        });
                    } else {
                        this.openTemplateFiles(project);
                    }
                }

                private boolean openTemplateFiles(Project project) {
                    List<File> filesToOpen = NewProjectWizardDynamic.this.myState.get(WizardConstants.FILES_TO_OPEN_KEY);
                    assert (filesToOpen != null);
                    return TemplateUtils.openEditors(project, filesToOpen, true);
                }
            }, null, initialLanguageLevel);
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)ERROR_MSG_TITLE);
            this.LOG.error((Throwable)e);
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)ERROR_MSG_TITLE);
            this.LOG.error((Throwable)e);
        }
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Creating project..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewProjectWizardDynamic", "getProgressTitle"));
        }
        return "Creating project...";
    }

    @Override
    protected void doFinish() throws IOException {
        final String location = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        String name = this.myState.get(WizardConstants.APPLICATION_NAME_KEY);
        assert (location != null && name != null);
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                VfsUtil.createDirectoryIfMissing((String)location);
            }
        }.execute();
        this.myProject = ProjectManager.getInstance().createProject(name, location);
        super.doFinish();
    }

    @Override
    @Nullable
    protected Project getProject() {
        return this.myProject;
    }
}

