/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.ui.TextAccessors;
import com.android.tools.idea.wizard.ComboBoxItem;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.TextAccessor;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopedDataBinder
implements ScopedStateStore.ScopedStoreListener,
FocusListener,
ChangeListener,
ActionListener,
DocumentListener,
ItemListener {
    protected ScopedStateStore myState;
    private Map<Document, JComponent> myDocumentsToComponent = Maps.newIdentityHashMap();
    private Map<ScopedStateStore.Key, ValueDeriver> myValueDerivers = Maps.newHashMap();
    private Table<JComponent, ScopedStateStore.Key<?>, ComponentBinding<?, ?>> myComponentBindings = HashBasedTable.create();
    private Set<ScopedStateStore.Key> myGuardedKeys = Sets.newHashSet();
    private Set<ScopedStateStore.Key> myUserEditedKeys = Sets.newHashSet();
    private boolean myAlreadySavingState;
    private JComponent myUpdateTrigger;

    public ScopedDataBinder() {
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, null, this);
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (changedKey == null) {
            ImmutableSet allKeys = ImmutableSet.copyOf((Collection)this.myComponentBindings.columnKeySet());
            this.myGuardedKeys.addAll((Collection<ScopedStateStore.Key>)allKeys);
            for (ScopedStateStore.Key key : allKeys) {
                if (!this.myComponentBindings.containsColumn((Object)key)) continue;
                this.internalUpdateKey(key);
            }
            this.deriveValues(null);
        } else {
            this.myGuardedKeys.add(changedKey);
            this.internalUpdateKey(changedKey);
        }
    }

    private <T> void internalUpdateKey(@NotNull ScopedStateStore.Key<T> changedKey) {
        if (changedKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedKey", "com/android/tools/idea/wizard/ScopedDataBinder", "internalUpdateKey"));
        }
        T value = this.myState.get(changedKey);
        ImmutableMap keyBindings = ImmutableMap.copyOf((Map)this.myComponentBindings.column(changedKey));
        for (Map.Entry entry : keyBindings.entrySet()) {
            JComponent component = (JComponent)entry.getKey();
            if (!this.myComponentBindings.contains((Object)component, changedKey) || Objects.equal((Object)component, (Object)this.myUpdateTrigger)) continue;
            ComponentBinding binding = (ComponentBinding)this.myComponentBindings.get((Object)component, changedKey);
            try {
                binding.setValue(value, component);
            }
            catch (UnsupportedOperationException e) {}
        }
        this.deriveValues(changedKey);
        this.myGuardedKeys.remove(changedKey);
    }

    private <T> void deriveValues(@Nullable ScopedStateStore.Key<T> changedKey) {
        for (ScopedStateStore.Key key : this.myValueDerivers.keySet()) {
            if (this.myGuardedKeys.contains(key)) continue;
            ValueDeriver deriver = this.myValueDerivers.get(key);
            if (this.myUserEditedKeys.contains(key) && deriver.respectUserEdits()) continue;
            Set<ScopedStateStore.Key<?>> triggerKeys = deriver.getTriggerKeys();
            if (changedKey != null && triggerKeys != null && !triggerKeys.contains(changedKey)) continue;
            this.deriveValue(key, deriver, changedKey);
        }
    }

    private <T> void deriveValue(@NotNull ScopedStateStore.Key<T> key, @NotNull ValueDeriver<T> deriver, @Nullable ScopedStateStore.Key<?> changedKey) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "deriveValue"));
        }
        if (deriver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deriver", "com/android/tools/idea/wizard/ScopedDataBinder", "deriveValue"));
        }
        T currentValue = this.myState.get(key);
        T newValue = deriver.deriveValue(this.myState, changedKey, currentValue);
        if (newValue != null && !key.expectedClass.isInstance(newValue)) {
            throw new IllegalArgumentException(String.format("Deriver %1$s returned value for key %2$s of type %3$s, should be %4$s", deriver.toString(), key.name, newValue.getClass().getName(), key.expectedClass.getName()));
        }
        this.myState.put(key, newValue);
    }

    protected <T> void saveState(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder", "saveState"));
        }
        if (this.myAlreadySavingState) {
            return;
        }
        this.myAlreadySavingState = true;
        for (Map.Entry entry : this.myComponentBindings.row((Object)component).entrySet()) {
            if (this.myGuardedKeys.contains(entry.getKey())) continue;
            ComponentBinding binding = (ComponentBinding)entry.getValue();
            try {
                Object value = binding.getValue(component);
                this.storeValue((ScopedStateStore.Key)entry.getKey(), component, value);
            }
            catch (UnsupportedOperationException e) {}
        }
        this.myAlreadySavingState = false;
    }

    private <T> void storeValue(@NotNull ScopedStateStore.Key<T> key, @NotNull JComponent updateTrigger, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "storeValue"));
        }
        if (updateTrigger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateTrigger", "com/android/tools/idea/wizard/ScopedDataBinder", "storeValue"));
        }
        T oldValue = this.myState.get(key);
        if (oldValue != null && !oldValue.equals(value) && !this.myGuardedKeys.contains(key)) {
            this.myUserEditedKeys.add(key);
        }
        this.myUpdateTrigger = updateTrigger;
        this.myState.put(key, value);
        this.myUpdateTrigger = null;
    }

    @Nullable
    protected Object getComponentValue(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder", "getComponentValue"));
        }
        Object newValue = null;
        if (component instanceof JCheckBox) {
            newValue = ((JCheckBox)component).isSelected();
        } else if (component instanceof JComboBox) {
            Object selectedObject = ((JComboBox)component).getSelectedItem();
            if (selectedObject instanceof ComboBoxItem) {
                ComboBoxItem selectedItem = (ComboBoxItem)selectedObject;
                newValue = selectedItem.id;
            } else {
                newValue = selectedObject;
            }
        } else if (component instanceof JSlider) {
            newValue = ((JSlider)component).getValue();
        } else if (component instanceof JSpinner) {
            newValue = ((JSpinner)component).getValue();
        } else if (component instanceof ColorPanel) {
            newValue = ((ColorPanel)component).getSelectedColor();
        } else {
            TextAccessor accessor = TextAccessors.getTextAccessor(component);
            if (accessor != null) {
                newValue = accessor.getText();
            }
        }
        return newValue;
    }

    protected void setComponentValue(@Nullable Object value, @NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder", "setComponentValue"));
        }
        if (component instanceof JCheckBox) {
            ((JCheckBox)component).setSelected(Boolean.TRUE.equals(value));
        } else if (component instanceof JComboBox) {
            ScopedDataBinder.setSelectedItem((JComboBox)component, value);
        } else if (component instanceof JSlider) {
            assert (value != null);
            ((JSlider)component).setValue((Integer)value);
        } else if (component instanceof JSpinner) {
            ((JSpinner)component).setValue(value);
        } else if (component instanceof ColorPanel && value != null) {
            ((ColorPanel)component).setSelectedColor((Color)value);
        } else {
            String newValue;
            TextAccessor accessor = TextAccessors.getTextAccessor(component);
            if (accessor != null && !(newValue = StringUtil.notNullize((String)((String)value))).equals(accessor.getText())) {
                accessor.setText(newValue);
            }
        }
    }

    protected <T> void registerValueDeriver(@NotNull ScopedStateStore.Key<T> key, @NotNull ValueDeriver<T> deriver) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "registerValueDeriver"));
        }
        if (deriver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deriver", "com/android/tools/idea/wizard/ScopedDataBinder", "registerValueDeriver"));
        }
        this.myValueDerivers.put(key, deriver);
    }

    protected <T> void unregisterValueDeriver(@NotNull ScopedStateStore.Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "unregisterValueDeriver"));
        }
        this.myValueDerivers.remove(key);
    }

    protected <T, C extends JComponent> void register(@NotNull ScopedStateStore.Key<T> key, @NotNull C component, @NotNull ComponentBinding<T, ? super C> binding) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (binding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        T value = this.bindAndGet(key, component, binding);
        if (value != null) {
            try {
                binding.setValue(value, component);
            }
            catch (UnsupportedOperationException e) {}
        } else {
            try {
                this.myState.put(key, binding.getValue(component));
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        component.addFocusListener(this);
        binding.addActionListener(this, component);
        binding.addChangeListener(this, component);
        binding.addItemListener(this, component);
        Document document = binding.getDocument(component);
        if (document != null) {
            this.myDocumentsToComponent.put(document, component);
            document.addDocumentListener(this);
        }
    }

    @Nullable
    private <T> T bindAndGet(@NotNull ScopedStateStore.Key<T> key, @NotNull JComponent component, @Nullable ComponentBinding<T, ?> binding) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "bindAndGet"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder", "bindAndGet"));
        }
        DefaultBinding b = binding == null ? new DefaultBinding() : binding;
        this.myComponentBindings.put((Object)component, key, (Object)b);
        return this.myState.get(key);
    }

    protected void register(@NotNull ScopedStateStore.Key<Boolean> key, @NotNull JCheckBox checkBox) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (checkBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBox", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        Boolean value = this.bindAndGet(key, checkBox, null);
        if (value != null) {
            checkBox.setSelected(value);
        } else {
            this.myState.put(key, false);
        }
        checkBox.addFocusListener(this);
        checkBox.addItemListener(this);
    }

    protected <T> void register(@NotNull ScopedStateStore.Key<T> key, @NotNull JComboBox comboBox) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        T value = this.bindAndGet(key, comboBox, null);
        if (value != null) {
            ScopedDataBinder.setSelectedItem(comboBox, value);
        }
        comboBox.addFocusListener(this);
        comboBox.addActionListener(this);
    }

    public static <T> void setSelectedItem(JComboBox comboBox, @Nullable T value) {
        int index = -1;
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            Object item = comboBox.getItemAt(i);
            if (item instanceof ComboBoxItem) {
                item = ((ComboBoxItem)item).id;
            }
            if (!Objects.equal(item, value)) continue;
            index = i;
            break;
        }
        comboBox.setSelectedIndex(index);
    }

    protected void register(@NotNull ScopedStateStore.Key<String> key, @NotNull JTextField textField) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        this.myDocumentsToComponent.put(textField.getDocument(), textField);
        String value = this.bindAndGet(key, textField, null);
        if (value != null) {
            textField.setText(value);
        } else {
            this.myState.put(key, textField.getText());
        }
        textField.addFocusListener(this);
        textField.getDocument().addDocumentListener(this);
    }

    protected void register(@NotNull ScopedStateStore.Key<String> key, @NotNull JLabel label) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        String value = this.bindAndGet(key, label, null);
        if (value != null) {
            label.setText(value);
        } else {
            this.myState.put(key, label.getText());
        }
    }

    protected void register(@NotNull ScopedStateStore.Key<Integer> key, @NotNull JSlider paddingSlider) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (paddingSlider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paddingSlider", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        Integer value = this.bindAndGet(key, paddingSlider, null);
        if (value != null) {
            paddingSlider.setValue(value);
        } else {
            this.myState.put(key, paddingSlider.getValue());
        }
        paddingSlider.addFocusListener(this);
        paddingSlider.addChangeListener(this);
    }

    protected void register(@NotNull ScopedStateStore.Key<Object> key, @NotNull JSpinner spinner) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (spinner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spinner", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        Object value = this.bindAndGet(key, spinner, null);
        if (value != null) {
            spinner.setValue(value);
        } else {
            this.myState.put(key, spinner.getValue());
        }
        spinner.addFocusListener(this);
        spinner.addChangeListener(this);
    }

    protected void register(@NotNull ScopedStateStore.Key<String> key, @NotNull TextFieldWithBrowseButton field) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        this.myDocumentsToComponent.put(field.getTextField().getDocument(), (JComponent)field);
        String value = this.bindAndGet(key, (JComponent)field, null);
        if (value != null) {
            field.setText(value);
        } else {
            this.myState.put(key, field.getText());
        }
        field.addFocusListener((FocusListener)this);
        field.getTextField().getDocument().addDocumentListener(this);
        field.getTextField().addFocusListener(this);
    }

    protected void register(@NotNull ScopedStateStore.Key<String> key, @NotNull TextAccessor field) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        assert (field instanceof JComponent);
        JComponent component = (JComponent)field;
        String value = this.bindAndGet(key, component, null);
        if (value != null) {
            field.setText(value);
        } else {
            this.myState.put(key, field.getText());
        }
        component.addFocusListener(this);
    }

    protected void register(@NotNull ScopedStateStore.Key<Color> key, @NotNull ColorPanel colorPanel) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        if (colorPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorPanel", "com/android/tools/idea/wizard/ScopedDataBinder", "register"));
        }
        Color value = this.bindAndGet(key, (JComponent)colorPanel, null);
        if (value != null) {
            colorPanel.setSelectedColor(value);
        } else {
            this.myState.put(key, colorPanel.getSelectedColor());
        }
        colorPanel.addFocusListener((FocusListener)this);
        colorPanel.addActionListener((ActionListener)this);
    }

    protected void deregister(JComponent component) {
        if (this.myComponentBindings.rowMap().remove(component) != null) {
            component.removeFocusListener(this);
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).removeItemListener(this);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).removeActionListener(this);
            } else if (component instanceof JTextField) {
                ((JTextField)component).getDocument().removeDocumentListener(this);
            } else if (component instanceof JRadioButton) {
                ((JRadioButton)component).removeActionListener(this);
            } else if (component instanceof JSlider) {
                ((JSlider)component).removeChangeListener(this);
            } else if (component instanceof JSpinner) {
                ((JSpinner)component).removeChangeListener(this);
            } else if (component instanceof TextFieldWithBrowseButton) {
                ((TextFieldWithBrowseButton)component).getTextField().getDocument().removeDocumentListener(this);
                ((TextFieldWithBrowseButton)component).getTextField().removeFocusListener(this);
            } else if (component instanceof ColorPanel) {
                ((ColorPanel)component).removeActionListener((ActionListener)this);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.saveState(this.myDocumentsToComponent.get(e.getDocument()));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.saveState(this.myDocumentsToComponent.get(e.getDocument()));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private class DefaultBinding
    extends ComponentBinding<Object, JComponent> {
        private DefaultBinding() {
        }

        @Override
        public void setValue(@Nullable Object newValue, @NotNull JComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder$DefaultBinding", "setValue"));
            }
            ScopedDataBinder.this.setComponentValue(newValue, component);
        }

        @Override
        @Nullable
        public Object getValue(@NotNull JComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder$DefaultBinding", "getValue"));
            }
            return ScopedDataBinder.this.getComponentValue(component);
        }
    }

    public static abstract class ComponentBinding<T, C extends JComponent> {
        public void setValue(@Nullable T newValue, @NotNull C component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder$ComponentBinding", "setValue"));
            }
            throw new UnsupportedOperationException();
        }

        @Nullable
        public T getValue(@NotNull C component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder$ComponentBinding", "getValue"));
            }
            throw new UnsupportedOperationException();
        }

        public void addActionListener(@NotNull ActionListener listener, @NotNull C component) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/wizard/ScopedDataBinder$ComponentBinding", "addActionListener"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder$ComponentBinding", "addActionListener"));
            }
        }

        public void addChangeListener(@NotNull ChangeListener listener, @NotNull C component) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/wizard/ScopedDataBinder$ComponentBinding", "addChangeListener"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder$ComponentBinding", "addChangeListener"));
            }
        }

        public void addItemListener(@NotNull ItemListener listener, @NotNull C component) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/wizard/ScopedDataBinder$ComponentBinding", "addItemListener"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder$ComponentBinding", "addItemListener"));
            }
        }

        @Nullable
        public Document getDocument(@NotNull C component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ScopedDataBinder$ComponentBinding", "getDocument"));
            }
            return null;
        }
    }

    public static abstract class ValueDeriver<T> {
        public boolean respectUserEdits() {
            return true;
        }

        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return null;
        }

        @Nullable
        protected static Set<ScopedStateStore.Key<?>> makeSetOf(ScopedStateStore.Key<?> ... elements) {
            HashSet keys = new HashSet(elements.length);
            Collections.addAll(keys, elements);
            return keys;
        }

        @Nullable
        public abstract T deriveValue(@NotNull ScopedStateStore var1, @Nullable ScopedStateStore.Key var2, @Nullable T var3);
    }
}

