/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.tools.idea.wizard.AssetStudioAssetGenerator;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public final class TemplateWizardContextAdapter
implements AssetStudioAssetGenerator.AssetStudioContext {
    private final TemplateWizardState myWizardState;

    public TemplateWizardContextAdapter(TemplateWizardState wizardState) {
        this.myWizardState = wizardState;
    }

    @Override
    public int getPadding() {
        return this.myWizardState.getInt("padding");
    }

    @Override
    public void setPadding(int padding) {
        this.myWizardState.put("padding", padding);
    }

    @Override
    public AssetStudioAssetGenerator.SourceType getSourceType() {
        return (AssetStudioAssetGenerator.SourceType)((Object)this.myWizardState.get("sourceType"));
    }

    @Override
    public void setSourceType(AssetStudioAssetGenerator.SourceType sourceType) {
        this.myWizardState.put("sourceType", (Object)sourceType);
    }

    @Override
    @Nullable
    public AssetStudioAssetGenerator.AssetType getAssetType() {
        String o = (String)this.myWizardState.get("assetType");
        return StringUtil.isEmpty((String)o) ? null : AssetStudioAssetGenerator.AssetType.valueOf(o);
    }

    @Override
    public boolean isTrim() {
        return this.myWizardState.getBoolean("trim");
    }

    @Override
    public void setTrim(boolean trim) {
        this.myWizardState.put("trim", trim);
    }

    @Override
    public boolean isDogear() {
        return this.myWizardState.getBoolean("dogear");
    }

    @Override
    public void setDogear(boolean dogEar) {
        this.myWizardState.put("dogear", dogEar);
    }

    @Override
    @Nullable
    public String getImagePath() {
        return (String)this.myWizardState.get("imagePath");
    }

    @Override
    @Nullable
    public String getText() {
        return (String)this.myWizardState.get("text");
    }

    @Override
    public void setText(String text) {
        this.myWizardState.put("text", text);
    }

    @Override
    @Nullable
    public String getClipartName() {
        return (String)this.myWizardState.get("clipartPath");
    }

    @Override
    public void setClipartName(String clipartName) {
        this.myWizardState.put("clipartPath", clipartName);
    }

    @Override
    public Color getForegroundColor() {
        return this.getNonNullValue("foregroundColor", Color.class);
    }

    @Override
    public void setForegroundColor(Color fg) {
        this.myWizardState.put("foregroundColor", fg);
    }

    @Override
    @Nullable
    public String getFont() {
        return (String)this.myWizardState.get("font");
    }

    @Override
    public void setFont(String font) {
        this.myWizardState.put("font", font);
    }

    @Override
    public int getFontSize() {
        return this.myWizardState.getInt("fontSize");
    }

    @Override
    public void setFontSize(int fontSize) {
        this.myWizardState.put("fontSize", fontSize);
    }

    @Override
    public AssetStudioAssetGenerator.Scaling getScaling() {
        return this.getNonNullValue("scaling", AssetStudioAssetGenerator.Scaling.class);
    }

    @Override
    public void setScaling(AssetStudioAssetGenerator.Scaling scaling) {
        this.myWizardState.put("scaling", (Object)scaling);
    }

    private <T> T getNonNullValue(String attribute, Class<T> type) {
        Object scaling = this.myWizardState.get(attribute);
        assert (type.isInstance(scaling));
        return type.cast(scaling);
    }

    @Override
    @Nullable
    public String getAssetName() {
        return (String)this.myWizardState.get("assetName");
    }

    @Override
    public GraphicGenerator.Shape getShape() {
        return this.getNonNullValue("shape", GraphicGenerator.Shape.class);
    }

    @Override
    public void setShape(GraphicGenerator.Shape shape) {
        this.myWizardState.put("shape", shape);
    }

    @Override
    public Color getBackgroundColor() {
        return this.getNonNullValue("backgroundColor", Color.class);
    }

    @Override
    public void setBackgroundColor(Color bg) {
        this.myWizardState.put("backgroundColor", bg);
    }

    @Override
    @Nullable
    public String getAssetTheme() {
        return (String)this.myWizardState.get("assetTheme");
    }

    @Override
    @Nullable
    public String getErrorLog() {
        return (String)this.myWizardState.get("errorLog");
    }

    @Override
    public void setErrorLog(String log) {
        this.myWizardState.put("errorLog", log);
    }
}

