/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.resources.Density;
import com.android.tools.idea.wizard.AssetStudioAssetGenerator;
import com.android.tools.idea.wizard.CommonAssetSetStep;
import com.android.tools.idea.wizard.ImageComponent;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VectorAssetSetStep
extends CommonAssetSetStep {
    private static final Logger LOG = Logger.getInstance(VectorAssetSetStep.class);
    private JPanel myPanel;
    private JLabel myError;
    private JLabel myDescription;
    private ImageComponent myImagePreview;
    private TextFieldWithBrowseButton myImageFile;
    private JLabel myImageFileLabel;
    private JLabel myResourceNameLabel;
    private JTextField myResourceNameField;
    private JPanel myErrorPanel;
    private JLabel myConvertError;
    private HyperlinkLabel myMoreErrors;
    private MoreErrorHyperlinkAdapter myMoreErrorHyperlinkAdapter;

    public VectorAssetSetStep(TemplateWizardState state, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, @Nullable VirtualFile invocationTarget) {
        super(state, project, module, sidePanelIcon, updateListener, invocationTarget);
        this.$$$setupUI$$$();
        this.myMoreErrorHyperlinkAdapter = new MoreErrorHyperlinkAdapter();
        this.myImageFile.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileDescriptor((String)"svg"));
        this.myTemplateState.put("assetType", AssetStudioAssetGenerator.AssetType.ACTIONBAR.name());
        this.mySelectedAssetType = AssetStudioAssetGenerator.AssetType.ACTIONBAR;
        this.register("assetName", this.myResourceNameField);
        this.myMoreErrors.addHyperlinkListener((HyperlinkListener)((Object)this.myMoreErrorHyperlinkAdapter));
        this.myErrorPanel.setVisible(false);
    }

    @Override
    public void deriveValues() {
        super.deriveValues();
        if (!this.myTemplateState.myModified.contains("assetName")) {
            this.updateDerivedValue("assetName", this.myResourceNameField, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return VectorAssetSetStep.this.computeResourceName();
                }
            });
        }
    }

    @Override
    protected void updatePreviewImages() {
        if (this.mySelectedAssetType != null && this.myImageMap != null && this.myImageMap.size() != 0) {
            String errorMessage = (String)this.myTemplateState.get("errorLog");
            if (Strings.isNullOrEmpty((String)errorMessage)) {
                this.myErrorPanel.setVisible(false);
                this.myIsValid = true;
            } else {
                this.myErrorPanel.setVisible(true);
                this.myIsValid = this.setupErrorMessages(errorMessage);
            }
            BufferedImage previewImage = VectorAssetSetStep.getImage(this.myImageMap, Density.ANYDPI.getResourceValue());
            VectorAssetSetStep.setIconOrClear(this.myImagePreview, previewImage);
        } else {
            this.myIsValid = false;
        }
        this.myUpdateListener.update();
    }

    private boolean setupErrorMessages(String errorMessage) {
        boolean isPreviewValid = !errorMessage.startsWith("Empty preview image!");
        int firstLineBreak = errorMessage.indexOf("\n");
        boolean moreErrors = firstLineBreak > 0 && firstLineBreak < errorMessage.length() - 1;
        String firstLineError = moreErrors ? errorMessage.substring(0, firstLineBreak) : errorMessage;
        this.myConvertError.setText(firstLineError);
        if (moreErrors) {
            this.myMoreErrors.setVisible(true);
            this.myMoreErrors.setHyperlinkText("More...");
            this.myMoreErrorHyperlinkAdapter.setErrorMessage(errorMessage);
        } else {
            this.myMoreErrors.setVisible(false);
        }
        return isPreviewValid;
    }

    @Nullable
    private static BufferedImage getImage(@NotNull Map<String, Map<String, BufferedImage>> map, @NotNull String name) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/android/tools/idea/wizard/VectorAssetSetStep", "getImage"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/wizard/VectorAssetSetStep", "getImage"));
        }
        Map<String, BufferedImage> images = map.get(name);
        if (images == null) {
            return null;
        }
        Collection<BufferedImage> values = images.values();
        return values.isEmpty() ? null : values.iterator().next();
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    protected void initialize() {
        this.register("imagePath", this.myImageFile);
    }

    @Override
    @NotNull
    protected String computeResourceName() {
        String resourceName = null;
        if (resourceName == null) {
            resourceName = String.format("ic_vector_name", "name");
        }
        if (this.drawableExists(resourceName)) {
            int i = 1;
            while (this.drawableExists(resourceName + Integer.toString(i))) {
                ++i;
            }
            resourceName = resourceName + Integer.toString(i);
        }
        String string = resourceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/VectorAssetSetStep", "computeResourceName"));
        }
        return string;
    }

    @Override
    protected void generateAssetFiles(File targetResDir) {
        this.myAssetGenerator.outputXmlToRes(targetResDir);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myImageFile;
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JLabel jLabel = this.myDescription;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/VectorAssetSetStep", "getDescription"));
        }
        return jLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/VectorAssetSetStep", "getError"));
        }
        return jLabel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ImageComponent imageComponent;
        HyperlinkLabel hyperlinkLabel;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        JTextField jTextField;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel5;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setToolTipText("");
        this.myImageFileLabel = jLabel5 = new JLabel();
        jLabel5.setText("Image file:");
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImageFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myResourceNameLabel = jLabel4 = new JLabel();
        jLabel4.setText("Resource name:");
        jPanel2.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResourceNameField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myErrorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, "Error", 0, 0, null, null));
        this.myDescription = jLabel3 = new JLabel();
        jLabel3.setText("");
        ((Component)jLabel3).setVisible(false);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 3, null, null, null));
        this.myError = jLabel2 = new JLabel();
        jLabel2.setText(" ");
        jLabel2.setVerticalTextPosition(3);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 3, null, null, null));
        this.myConvertError = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        this.myMoreErrors = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(3, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Choose local SVG file:");
        jPanel2.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, new Dimension(1, 1), null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(20, 20, 20, 20), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 0, 3, 3, null, null, null));
        this.myImagePreview = imageComponent = new ImageComponent();
        jPanel3.add((Component)((Object)imageComponent), new GridConstraints(1, 0, 1, 1, 0, 0, 3, 7, new Dimension(144, 144), new Dimension(144, 144), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Vector Drawable Preview");
        jPanel3.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public class MoreErrorHyperlinkAdapter
    extends HyperlinkAdapter {
        private String mErrorLog;

        public void setErrorMessage(String error) {
            this.mErrorLog = error;
        }

        protected void hyperlinkActivated(HyperlinkEvent e) {
            JTextArea textArea = new JTextArea(25, 80);
            textArea.setText(this.mErrorLog);
            textArea.setEditable(false);
            textArea.setCaretPosition(0);
            JScrollPane scrollPane = new JScrollPane(textArea);
            JOptionPane.showMessageDialog(VectorAssetSetStep.this.myPanel, scrollPane);
        }
    }
}

