/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationToolBar;
import com.android.tools.idea.configurations.OverlayContainer;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.HoverOverlay;
import com.android.tools.idea.rendering.IncludeOverlay;
import com.android.tools.idea.rendering.ModuleResourceRepository;
import com.android.tools.idea.rendering.Overlay;
import com.android.tools.idea.rendering.RenderErrorPanel;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.RenderedImage;
import com.android.tools.idea.rendering.RenderedView;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.android.tools.idea.rendering.multi.RenderPreviewManager;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.google.common.primitives.Ints;
import com.intellij.android.designer.componentTree.AndroidTreeDecorator;
import com.intellij.android.designer.designSurface.AndroidDesignerActionPanel;
import com.intellij.android.designer.designSurface.AndroidPasteFactory;
import com.intellij.android.designer.designSurface.AndroidRefactoringActionWrapper;
import com.intellij.android.designer.designSurface.ExternalPSIChangeListener;
import com.intellij.android.designer.designSurface.RootView;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.inspection.ErrorAnalyzer;
import com.intellij.android.designer.model.AndroidWrapInProvider;
import com.intellij.android.designer.model.IConfigurableComponent;
import com.intellij.android.designer.model.PropertyParser;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.android.designer.model.layout.actions.ToggleRenderModeAction;
import com.intellij.designer.DesignerEditor;
import com.intellij.designer.DesignerToolWindow;
import com.intellij.designer.DesignerToolWindowManager;
import com.intellij.designer.actions.DesignerActionPanel;
import com.intellij.designer.componentTree.TreeComponentDecorator;
import com.intellij.designer.designSurface.CaptionPanel;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.EmptyComponentDecorator;
import com.intellij.designer.designSurface.ZoomType;
import com.intellij.designer.designSurface.tools.ComponentCreationFactory;
import com.intellij.designer.designSurface.tools.ComponentPasteFactory;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadVisualComponent;
import com.intellij.designer.model.WrapInProvider;
import com.intellij.designer.palette.DefaultPaletteItem;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.palette.PaletteToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.uipreview.RenderingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidDesignerEditorPanel
extends DesignerEditorPanel
implements RenderContext,
ResourceFolderManager.ResourceFolderListener,
OverlayContainer {
    private static final int DEFAULT_HORIZONTAL_MARGIN = 30;
    private static final int DEFAULT_VERTICAL_MARGIN = 20;
    private static final Integer LAYER_ERRORS = LAYER_INPLACE_EDITING + 150;
    private static final Integer LAYER_PREVIEW = LAYER_INPLACE_EDITING + 170;
    private final TreeComponentDecorator myTreeDecorator;
    private final XmlFile myXmlFile;
    private final ExternalPSIChangeListener myPsiChangeListener;
    private final Alarm mySessionAlarm;
    private final MergingUpdateQueue mySessionQueue;
    private final LayoutConfigurationListener myConfigListener;
    private final AndroidFacet myFacet;
    private volatile RenderSession mySession;
    private volatile long mySessionId;
    private final Lock myRendererLock;
    private WrapInProvider myWrapInProvider;
    private RootView myRootView;
    private boolean myShowingRoot;
    private RenderPreviewTool myPreviewTool;
    private RenderResult myRenderResult;
    private PropertyParser myPropertyParser;
    @Nullable
    private Configuration myConfiguration;
    private int myConfigurationDirty;
    private boolean myActive;
    private boolean myVariantChanged;
    private double myZoom;
    private ZoomType myZoomMode;
    private RenderPreviewManager myPreviewManager;
    private final HoverOverlay myHover;
    private final List<Overlay> myOverlays;
    private MyRenderPanelWrapper myErrorPanelWrapper;
    private boolean myZoomInProgress;
    private static final double ZOOM_FACTOR = 1.2;
    private int myMaxWidth;
    private int myMaxHeight;
    private boolean myUseLargeShadows;
    private boolean myShowDeviceFrames;

    public AndroidDesignerEditorPanel(@NotNull DesignerEditor editor, @NotNull Project project, @NotNull Module module, @NotNull VirtualFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "<init>"));
        }
        super(editor, project, module, file);
        this.mySessionAlarm = new Alarm();
        this.myRendererLock = new ReentrantLock();
        this.myZoom = 1.0;
        this.myZoomMode = ZoomType.FIT_INTO;
        this.myHover = new HoverOverlay(this);
        this.myOverlays = Arrays.asList(this.myHover, new IncludeOverlay(this));
        this.myUseLargeShadows = true;
        this.myShowDeviceFrames = true;
        this.myTreeDecorator = new AndroidTreeDecorator(project);
        this.showProgress("Loading configuration...");
        AndroidFacet facet = AndroidFacet.getInstance(this.getModule());
        assert (facet != null);
        this.myFacet = facet;
        if (facet.isGradleProject()) {
            ModuleResourceRepository.getModuleResources(facet, true);
            this.myFacet.getResourceFolderManager().addListener(this);
        }
        this.myConfigListener = new LayoutConfigurationListener();
        this.initializeConfiguration();
        this.mySessionQueue = new MergingUpdateQueue("android.designer", 10, true, null, (Disposable)editor, null, Alarm.ThreadToUse.OWN_THREAD);
        this.myXmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.getProject(), this.myFile);
        assert (this.myXmlFile != null) : this.myFile;
        this.myPsiChangeListener = new ExternalPSIChangeListener(this, (PsiFile)this.myXmlFile, 100, new Runnable(){

            @Override
            public void run() {
                AndroidDesignerEditorPanel.this.reparseFile();
            }
        });
        this.addActions();
        this.myActive = true;
        this.myPsiChangeListener.setInitialize();
    }

    private void initializeConfiguration() {
        this.myConfiguration = this.myFacet.getConfigurationManager().getConfiguration(this.myFile);
        this.myConfiguration.addListener(this.myConfigListener);
    }

    private void addActions() {
        this.addConfigurationActions();
        this.myActionPanel.getPopupGroup().addSeparator();
        this.myActionPanel.getPopupGroup().add((AnAction)AndroidDesignerEditorPanel.buildRefactorActionGroup());
        this.addGotoDeclarationAction();
    }

    private void addGotoDeclarationAction() {
        AnAction gotoDeclaration = new AnAction("Go To Declaration"){

            public void update(AnActionEvent e) {
                EditableArea area = (EditableArea)e.getData(EditableArea.DATA_KEY);
                e.getPresentation().setEnabled(area != null && area.getSelection().size() == 1);
            }

            public void actionPerformed(AnActionEvent e) {
                EditableArea area = (EditableArea)e.getData(EditableArea.DATA_KEY);
                if (area != null) {
                    RadViewComponent component = (RadViewComponent)((Object)area.getSelection().get(0));
                    PsiNavigateUtil.navigate((PsiElement)component.getTag());
                }
            }
        };
        this.myActionPanel.registerAction(gotoDeclaration, "GotoDeclaration");
        this.myActionPanel.getPopupGroup().add(gotoDeclaration);
    }

    private void addConfigurationActions() {
        DefaultActionGroup designerActionGroup = this.getActionPanel().getActionGroup();
        DefaultActionGroup group = ConfigurationToolBar.createActions(this);
        designerActionGroup.add((AnAction)group);
    }

    protected DesignerActionPanel createActionPanel() {
        return new AndroidDesignerActionPanel(this, (JComponent)this.myGlassLayer);
    }

    protected CaptionPanel createCaptionPanel(boolean horizontal) {
        return new CaptionPanel((DesignerEditorPanel)this, horizontal, false);
    }

    protected JScrollPane createScrollPane(@NotNull JLayeredPane content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "createScrollPane"));
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)content);
        scrollPane.setBackground(null);
        return scrollPane;
    }

    @NotNull
    private static ActionGroup buildRefactorActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup("_Refactor", true);
        ActionManager manager = ActionManager.getInstance();
        AnAction action = manager.getAction("AndroidExtractStyleAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("_Extract Style...", action));
        action = manager.getAction("AndroidInlineStyleReferenceAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("_Inline Style...", action));
        action = manager.getAction("AndroidExtractAsIncludeAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("E_xtract Layout...", action));
        action = manager.getAction("AndroidInlineIncludeAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("I_nline Layout...", action));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "buildRefactorActionGroup"));
        }
        return defaultActionGroup;
    }

    private void reparseFile() {
        try {
            this.storeState();
            this.showDesignerCard();
            this.parseFile(new Runnable(){

                @Override
                public void run() {
                    AndroidDesignerEditorPanel.this.showDesignerCard();
                    AndroidDesignerEditorPanel.this.myLayeredPane.revalidate();
                    AndroidDesignerEditorPanel.this.restoreState();
                }
            });
        }
        catch (RuntimeException e) {
            this.myPsiChangeListener.clear();
            this.showError("Parsing error", e.getCause() == null ? e : e.getCause());
        }
    }

    private void parseFile(final Runnable runnable) {
        if (this.myConfiguration == null) {
            return;
        }
        this.createRenderer(new ThrowableConsumer<RenderResult, Throwable>(){

            public void consume(RenderResult result) throws Throwable {
                RenderPreviewManager previewManager;
                RadViewComponent rootComponent;
                boolean insertPanel;
                RenderSession session = result.getSession();
                if (session == null) {
                    return;
                }
                AndroidDesignerEditorPanel.this.updateDeviceFrameVisibility(result);
                if (!session.getResult().isSuccess()) {
                    if (AndroidDesignerEditorPanel.this.myRootView != null && AndroidDesignerEditorPanel.this.myRootView.getImage() != null && session.getImage() != null && session.getImage().getWidth() == AndroidDesignerEditorPanel.this.myRootView.getImage().getWidth() && session.getImage().getHeight() == AndroidDesignerEditorPanel.this.myRootView.getImage().getHeight()) {
                        AndroidDesignerEditorPanel.this.myRootView.setRenderedImage(result.getImage());
                        AndroidDesignerEditorPanel.this.myRootView.repaint();
                    }
                    return;
                }
                boolean bl = insertPanel = !AndroidDesignerEditorPanel.this.myShowingRoot;
                if (AndroidDesignerEditorPanel.this.myRootView == null) {
                    AndroidDesignerEditorPanel.this.myRootView = new RootView(AndroidDesignerEditorPanel.this, 0, 0, result);
                    AndroidDesignerEditorPanel.this.myRootView.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent componentEvent) {
                            AndroidDesignerEditorPanel.this.zoomToFitIfNecessary();
                        }
                    });
                    insertPanel = true;
                } else {
                    AndroidDesignerEditorPanel.this.myRootView.setRenderedImage(result.getImage());
                    AndroidDesignerEditorPanel.this.myRootView.updateBounds(true);
                }
                boolean firstRender = AndroidDesignerEditorPanel.this.myRootComponent == null;
                try {
                    AndroidDesignerEditorPanel.this.myRootComponent = (RadComponent)RadModelBuilder.update(AndroidDesignerEditorPanel.this, result, (RadViewComponent)AndroidDesignerEditorPanel.this.myRootComponent, AndroidDesignerEditorPanel.this.myRootView);
                }
                catch (Throwable e) {
                    AndroidDesignerEditorPanel.this.myRootComponent = null;
                    throw e;
                }
                if (firstRender && (rootComponent = AndroidDesignerEditorPanel.this.getLayoutRoot()) != null) {
                    AndroidDesignerEditorPanel.this.mySurfaceArea.setSelection(Collections.singletonList(rootComponent));
                }
                if (insertPanel) {
                    JPanel rootPanel = new JPanel(new LayoutManager(){

                        @Override
                        public void addLayoutComponent(String s, Component component) {
                        }

                        @Override
                        public void removeLayoutComponent(Component component) {
                        }

                        @Override
                        public Dimension preferredLayoutSize(Container container) {
                            return new Dimension(0, 0);
                        }

                        @Override
                        public Dimension minimumLayoutSize(Container container) {
                            return new Dimension(0, 0);
                        }

                        @Override
                        public void layoutContainer(Container container) {
                            AndroidDesignerEditorPanel.this.myRootView.updateBounds(false);
                            int x = Math.max(2, Math.min(30, (container.getWidth() - AndroidDesignerEditorPanel.this.myRootView.getWidth()) / 2));
                            int y = Math.max(2, Math.min(20, (container.getHeight() - AndroidDesignerEditorPanel.this.myRootView.getHeight()) / 2));
                            if (AndroidDesignerEditorPanel.this.myRootView.getShowDropShadow()) {
                                if (x <= 2) {
                                    x += 6;
                                }
                                if (y <= 2) {
                                    y += 6;
                                }
                            }
                            if (AndroidDesignerEditorPanel.this.myMaxWidth > 0) {
                                AndroidDesignerEditorPanel.this.myRootView.setLocation(Math.max(0, (AndroidDesignerEditorPanel.this.myMaxWidth - AndroidDesignerEditorPanel.this.myRootView.getScaledWidth()) / 2), 2 + Math.max(0, (AndroidDesignerEditorPanel.this.myMaxHeight - AndroidDesignerEditorPanel.this.myRootView.getScaledHeight()) / 2));
                            } else {
                                AndroidDesignerEditorPanel.this.myRootView.setLocation(x, y);
                            }
                        }
                    });
                    rootPanel.setBackground((Color)DrawingStyle.DESIGNER_BACKGROUND_COLOR);
                    rootPanel.setOpaque(true);
                    rootPanel.add(AndroidDesignerEditorPanel.this.myRootView);
                    AndroidDesignerEditorPanel.this.myLayeredPane.add((Component)rootPanel, LAYER_COMPONENT);
                    AndroidDesignerEditorPanel.this.myShowingRoot = true;
                }
                AndroidDesignerEditorPanel.this.zoomToFitIfNecessary();
                AndroidDesignerEditorPanel.this.loadInspections((ProgressIndicator)new EmptyProgressIndicator());
                AndroidDesignerEditorPanel.this.updateInspections();
                if (RenderPreviewMode.getCurrent() != RenderPreviewMode.NONE && (previewManager = AndroidDesignerEditorPanel.this.getPreviewManager(true)) != null) {
                    previewManager.renderPreviews();
                }
                runnable.run();
            }
        });
    }

    private void createRenderer(final ThrowableConsumer<RenderResult, Throwable> runnable) {
        this.disposeRenderer();
        if (this.myConfiguration == null) {
            return;
        }
        this.mySessionAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (AndroidDesignerEditorPanel.this.mySession == null) {
                    AndroidDesignerEditorPanel.this.showProgress(AndroidDesignerEditorPanel.this.mySessionId <= 1L ? "Initializing Rendering Library..." : "Rendering... ");
                }
            }
        }, 500);
        final long sessionId = ++this.mySessionId;
        this.mySessionQueue.queue(new Update("render"){

            private void cancel() {
                AndroidDesignerEditorPanel.this.mySessionAlarm.cancelAllRequests();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!AndroidDesignerEditorPanel.this.isProjectClosed()) {
                            AndroidDesignerEditorPanel.this.hideProgress();
                        }
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    RenderResult renderResult;
                    if (sessionId != AndroidDesignerEditorPanel.this.mySessionId) {
                        this.cancel();
                        return;
                    }
                    RenderService renderService = RenderService.get(AndroidDesignerEditorPanel.this.myFacet);
                    RenderLogger logger = renderService.createLogger();
                    if (AndroidDesignerEditorPanel.this.myConfiguration.getTarget() == null) {
                        logger.error(null, "No render target selected", null);
                    } else if (AndroidDesignerEditorPanel.this.myConfiguration.getTheme() == null) {
                        logger.error(null, "No theme selected", null);
                    }
                    if (logger.hasProblems()) {
                        this.cancel();
                        RenderResult renderResult2 = RenderResult.createBlank((PsiFile)AndroidDesignerEditorPanel.this.myXmlFile, logger);
                        runnable.consume((Object)renderResult2);
                        AndroidDesignerEditorPanel.this.updateErrors(renderResult2);
                        return;
                    }
                    AndroidDesignerEditorPanel renderContext = AndroidDesignerEditorPanel.this;
                    if (AndroidDesignerEditorPanel.this.myRendererLock.tryLock()) {
                        try {
                            RenderTask task = renderService.createTask((PsiFile)AndroidDesignerEditorPanel.this.myXmlFile, AndroidDesignerEditorPanel.this.myConfiguration, logger, renderContext);
                            if (task != null) {
                                if (!ToggleRenderModeAction.isRenderViewPort()) {
                                    task.useDesignMode((PsiFile)AndroidDesignerEditorPanel.this.myXmlFile);
                                }
                                renderResult = task.render();
                                task.dispose();
                            } else {
                                renderResult = RenderResult.createBlank((PsiFile)AndroidDesignerEditorPanel.this.myXmlFile, logger);
                            }
                            AndroidDesignerEditorPanel.this.myRenderResult = renderResult;
                        }
                        finally {
                            AndroidDesignerEditorPanel.this.myRendererLock.unlock();
                        }
                    } else {
                        this.cancel();
                        return;
                    }
                    if (sessionId != AndroidDesignerEditorPanel.this.mySessionId) {
                        this.cancel();
                        return;
                    }
                    if (renderResult == null) {
                        throw new RenderingException();
                    }
                    AndroidDesignerEditorPanel.this.mySessionAlarm.cancelAllRequests();
                    Runnable uiRunnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!AndroidDesignerEditorPanel.this.isProjectClosed()) {
                                    AndroidDesignerEditorPanel.this.hideProgress();
                                    if (sessionId == AndroidDesignerEditorPanel.this.mySessionId) {
                                        runnable.consume((Object)renderResult);
                                        AndroidDesignerEditorPanel.this.updateErrors(renderResult);
                                    }
                                }
                            }
                            catch (Throwable e) {
                                AndroidDesignerEditorPanel.this.myPsiChangeListener.clear();
                                AndroidDesignerEditorPanel.this.showError("Parsing error", e);
                            }
                        }
                    };
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        ApplicationManager.getApplication().invokeAndWait(uiRunnable, ModalityState.defaultModalityState());
                    } else {
                        ApplicationManager.getApplication().invokeLater(uiRunnable);
                    }
                }
                catch (Throwable e) {
                    AndroidDesignerEditorPanel.this.myPsiChangeListener.clear();
                    AndroidDesignerEditorPanel.this.mySessionAlarm.cancelAllRequests();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AndroidDesignerEditorPanel.this.myPsiChangeListener.clear();
                            AndroidDesignerEditorPanel.this.showError("Render error", e);
                        }
                    });
                }
            }
        });
    }

    public int getDpi() {
        return this.myConfiguration != null ? this.myConfiguration.getDensity().getDpiValue() : 160;
    }

    private void updateErrors(final @NotNull RenderResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "updateErrors"));
        }
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread()) {
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AndroidDesignerEditorPanel.this.updateErrors(result);
                }
            });
            return;
        }
        RenderLogger logger = result.getLogger();
        if (!logger.hasProblems()) {
            if (this.myErrorPanelWrapper == null) {
                return;
            }
            this.myLayeredPane.remove(this.myErrorPanelWrapper);
            this.myErrorPanelWrapper = null;
            this.myLayeredPane.repaint();
        } else {
            if (this.myErrorPanelWrapper == null) {
                this.myErrorPanelWrapper = new MyRenderPanelWrapper(new RenderErrorPanel());
            }
            this.myErrorPanelWrapper.getErrorPanel().showErrors(result);
            this.myLayeredPane.add((Component)this.myErrorPanelWrapper, LAYER_ERRORS);
            this.myLayeredPane.repaint();
        }
    }

    private void disposeRenderer() {
        if (this.mySession != null) {
            this.mySession.dispose();
            this.mySession = null;
        }
    }

    private void updateRenderer(final boolean updateProperties) {
        if (this.myConfiguration == null) {
            return;
        }
        if (this.myRootComponent == null) {
            this.reparseFile();
            return;
        }
        this.createRenderer(new ThrowableConsumer<RenderResult, Throwable>(){

            public void consume(RenderResult result) throws Throwable {
                RenderPreviewManager previewManager;
                RenderSession session = result.getSession();
                if (session == null || session.getImage() == null) {
                    return;
                }
                AndroidDesignerEditorPanel.this.updateDeviceFrameVisibility(result);
                AndroidDesignerEditorPanel.this.myRootComponent = (RadComponent)RadModelBuilder.update(AndroidDesignerEditorPanel.this, result, (RadViewComponent)AndroidDesignerEditorPanel.this.myRootComponent, AndroidDesignerEditorPanel.this.myRootView);
                AndroidDesignerEditorPanel.this.myRootView.setRenderedImage(result.getImage());
                AndroidDesignerEditorPanel.this.zoomToFitIfNecessary();
                AndroidDesignerEditorPanel.this.myLayeredPane.revalidate();
                AndroidDesignerEditorPanel.this.myHorizontalCaption.update();
                AndroidDesignerEditorPanel.this.myVerticalCaption.update();
                DesignerToolWindow toolWindow = AndroidDesignerEditorPanel.this.getToolWindow();
                if (toolWindow != null) {
                    toolWindow.refresh(updateProperties);
                }
                if (RenderPreviewMode.getCurrent() != RenderPreviewMode.NONE && (previewManager = AndroidDesignerEditorPanel.this.getPreviewManager(true)) != null) {
                    previewManager.renderPreviews();
                }
            }
        });
    }

    @Nullable
    public DesignerToolWindow getToolWindow() {
        try {
            return DesignerToolWindowManager.getInstance((DesignerEditorPanel)this);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void restoreState() {
        DesignerToolWindow toolWindow = this.getToolWindow();
        if (toolWindow != null) {
            super.restoreState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void zoomToFitIfNecessary() {
        if (this.isZoomToFit()) {
            if (this.myZoomInProgress) {
                return;
            }
            try {
                this.myZoomInProgress = true;
                this.updateZoom();
            }
            finally {
                this.myZoomInProgress = false;
            }
        }
    }

    private void removeNativeRoot() {
        Component component;
        if (this.myRootComponent != null && (component = ((RadVisualComponent)this.myRootComponent).getNativeComponent()) != null) {
            this.myLayeredPane.remove(component.getParent());
            this.myShowingRoot = false;
        }
    }

    protected void configureError(@NotNull DesignerEditorPanel.ErrorInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "configureError"));
        }
        info.myShowMessage = false;
        info.myShowLog = true;
        StringBuilder builder = new StringBuilder();
        builder.append("ActiveTool: ").append(this.myToolProvider.getActiveTool());
        builder.append("\nSDK: ");
        try {
            AndroidPlatform platform = AndroidPlatform.getInstance(this.getModule());
            if (platform != null) {
                IAndroidTarget target = platform.getTarget();
                builder.append(target.getFullName()).append(" - ").append(target.getVersion());
            }
        }
        catch (Throwable e) {
            builder.append("<unknown>");
        }
        if (info.myThrowable instanceof IndexOutOfBoundsException && this.myRootComponent != null && this.mySession != null) {
            builder.append("\n-------- RadTree --------\n");
            RadComponentOperations.printTree(builder, this.myRootComponent, 0);
            builder.append("\n-------- ViewTree(").append(this.mySession.getRootViews().size()).append(") --------\n");
            for (ViewInfo viewInfo : this.mySession.getRootViews()) {
                RadComponentOperations.printTree(builder, viewInfo, 0);
            }
        }
        info.myMessage = builder.toString();
    }

    protected void showErrorPage(DesignerEditorPanel.ErrorInfo info) {
        this.myPsiChangeListener.clear();
        this.mySessionAlarm.cancelAllRequests();
        this.removeNativeRoot();
        super.showErrorPage(info);
    }

    public void activate() {
        RenderPreviewManager previewManager;
        this.myActive = true;
        this.myPsiChangeListener.activate();
        if (this.myVariantChanged || this.myPsiChangeListener.isUpdateRenderer() || (this.myConfigurationDirty & 0xFE) != 0) {
            this.myVariantChanged = false;
            this.updateRenderer(true);
        } else if (this.myRootComponent != null && this.myRootView != null && RenderPreviewMode.getCurrent() != RenderPreviewMode.NONE && (previewManager = this.getPreviewManager(true)) != null) {
            previewManager.renderPreviews();
        }
        this.myConfigurationDirty = 0;
    }

    public void deactivate() {
        this.myActive = false;
        this.myPsiChangeListener.deactivate();
    }

    public void buildProject() {
        if (this.myPsiChangeListener.ensureUpdateRenderer()) {
            this.updateRenderer(true);
        }
    }

    public void dispose() {
        this.myPsiChangeListener.dispose();
        if (this.myConfiguration != null) {
            this.myConfiguration.removeListener(this.myConfigListener);
        }
        super.dispose();
        this.disposeRenderer();
        if (this.myPreviewManager != null) {
            this.myPreviewManager.dispose();
            this.myPreviewManager = null;
        }
        this.myFacet.getResourceFolderManager().removeListener(this);
    }

    @Nullable
    protected Module findModule(Project project, VirtualFile file) {
        Module module = super.findModule(project, file);
        if (module == null) {
            module = AndroidPsiUtils.getModuleSafely((PsiElement)this.myXmlFile);
        }
        return module;
    }

    public String getPlatformTarget() {
        return "android";
    }

    public TreeComponentDecorator getTreeDecorator() {
        return this.myTreeDecorator;
    }

    public WrapInProvider getWrapInProvider() {
        if (this.myWrapInProvider == null) {
            this.myWrapInProvider = new AndroidWrapInProvider(this.getProject());
        }
        return this.myWrapInProvider;
    }

    protected ComponentDecorator getRootSelectionDecorator() {
        return EmptyComponentDecorator.INSTANCE;
    }

    public List<PaletteGroup> getPaletteGroups() {
        return ViewsMetaManager.getInstance(this.getProject()).getPaletteGroups();
    }

    @NotNull
    public String getVersionLabel(@Nullable String version) {
        if (StringUtil.isEmpty((String)version)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getVersionLabel"));
            }
            return "";
        }
        Integer api = Ints.tryParse((String)version);
        assert (api != null) : version;
        int since = api;
        if (since <= 1) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getVersionLabel"));
            }
            return "";
        }
        String name = SdkVersionInfo.getAndroidName((int)since);
        if (name == null) {
            name = String.format("API %1$d", since);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getVersionLabel"));
        }
        return string;
    }

    public boolean isDeprecated(@Nullable String deprecatedIn) {
        IAndroidTarget target;
        if (deprecatedIn == null) {
            return false;
        }
        IAndroidTarget iAndroidTarget = target = this.myConfiguration != null ? this.myConfiguration.getTarget() : null;
        if (target == null) {
            return super.isDeprecated(deprecatedIn);
        }
        if (StringUtil.isEmpty((String)deprecatedIn)) {
            return false;
        }
        Integer api = Ints.tryParse((String)deprecatedIn);
        assert (api != null) : deprecatedIn;
        return api <= target.getVersion().getApiLevel();
    }

    public PropertyParser getPropertyParser(@Nullable RenderResult result) {
        if (this.myPropertyParser == null) {
            this.myPropertyParser = new PropertyParser(result != null ? result : this.myRenderResult);
        }
        return this.myPropertyParser;
    }

    @Nullable
    public RadViewComponent getRootViewComponent() {
        return (RadViewComponent)this.myRootComponent;
    }

    public RenderResult getLastRenderResult() {
        return this.myRenderResult;
    }

    @NotNull
    protected ComponentCreationFactory createCreationFactory(final PaletteItem paletteItem) {
        ComponentCreationFactory componentCreationFactory = new ComponentCreationFactory(){

            @NotNull
            public RadComponent create() throws Exception {
                RadViewComponent component = RadComponentOperations.createComponent(null, paletteItem.getMetaModel());
                component.setInitialPaletteItem(paletteItem);
                if (component instanceof IConfigurableComponent) {
                    ((IConfigurableComponent)((Object)component)).configure(AndroidDesignerEditorPanel.this.myRootComponent);
                }
                RadViewComponent radViewComponent = component;
                if (radViewComponent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel$9", "create"));
                }
                return radViewComponent;
            }
        };
        if (componentCreationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "createCreationFactory"));
        }
        return componentCreationFactory;
    }

    public ComponentPasteFactory createPasteFactory(String xmlComponents) {
        IAndroidTarget target;
        if (this.myConfiguration != null && (target = this.myConfiguration.getTarget()) != null) {
            return new AndroidPasteFactory(this.getModule(), target, xmlComponents);
        }
        return null;
    }

    private void updatePalette(IAndroidTarget target) {
        try {
            for (PaletteGroup group : this.getPaletteGroups()) {
                for (PaletteItem item : group.getItems()) {
                    String version = item.getVersion();
                    if (version == null) continue;
                    Integer api = Ints.tryParse((String)version);
                    assert (api != null) : version;
                    DefaultPaletteItem paletteItem = (DefaultPaletteItem)item;
                    paletteItem.setEnabled(api <= target.getVersion().getApiLevel());
                }
            }
            PaletteItem item = this.getActivePaletteItem();
            if (item != null && !item.isEnabled()) {
                this.activatePaletteItem(null);
            }
            PaletteToolWindowManager.getInstance((DesignerEditorPanel)this).refresh();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getEditorText() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return AndroidDesignerEditorPanel.this.myXmlFile.getText();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(ThrowableRunnable<Exception> operation, final boolean updateProperties) {
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)this.getProject(), (VirtualFile[])new VirtualFile[]{this.myFile})) {
            return false;
        }
        try {
            this.myPsiChangeListener.stop();
            operation.run();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean active = AndroidDesignerEditorPanel.this.myPsiChangeListener.isActive();
                    if (active) {
                        AndroidDesignerEditorPanel.this.myPsiChangeListener.stop();
                    }
                    AndroidDesignerEditorPanel.this.updateRenderer(updateProperties);
                    if (active) {
                        AndroidDesignerEditorPanel.this.myPsiChangeListener.start();
                    }
                }
            });
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.showError("Execute command", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.myPsiChangeListener.start();
        }
    }

    protected void executeWithReparse(ThrowableRunnable<Exception> operation) {
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)this.getProject(), (VirtualFile[])new VirtualFile[]{this.myFile})) {
            return;
        }
        try {
            this.myPsiChangeListener.stop();
            operation.run();
            this.myPsiChangeListener.start();
            this.reparseFile();
        }
        catch (Throwable e) {
            this.showError("Execute command", e);
            this.myPsiChangeListener.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(List<EditOperation> operations) {
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)this.getProject(), (VirtualFile[])new VirtualFile[]{this.myFile})) {
            return;
        }
        try {
            this.myPsiChangeListener.stop();
            for (EditOperation operation : operations) {
                operation.execute();
            }
            this.updateRenderer(true);
        }
        catch (Throwable e) {
            this.showError("Execute command", e);
        }
        finally {
            this.myPsiChangeListener.start();
        }
    }

    public void loadInspections(ProgressIndicator progress) {
        if (this.myRootComponent != null) {
            ErrorAnalyzer.load(this.getProject(), this.myXmlFile, this.myRootComponent, progress);
        }
    }

    public boolean isZoomToFit() {
        return this.myZoomMode == ZoomType.FIT || this.myZoomMode == ZoomType.FIT_INTO;
    }

    public boolean isZoomSupported() {
        return true;
    }

    public void setZoom(double zoom) {
        if (this.myMaxWidth > 0 && this.myRootComponent != null) {
            assert (this.myMaxHeight > 0);
            Rectangle bounds = this.myRootComponent.getBounds();
            double imageWidth = bounds.getWidth();
            double imageHeight = bounds.getHeight();
            if (imageHeight > 0.0) {
                zoom = Math.min((double)this.myMaxWidth / imageWidth, (double)this.myMaxHeight / imageHeight);
                if (this.myZoomMode == ZoomType.FIT_INTO && zoom > 1.0) {
                    zoom = 1.0;
                }
            }
        }
        if (zoom != this.myZoom) {
            this.myZoom = zoom;
            this.normalizeScale();
            this.viewZoomed();
            this.mySurfaceArea.scrollToSelection();
            this.repaint();
        }
    }

    private void normalizeScale() {
        if (Math.abs(this.myZoom - 1.0) < 0.01) {
            this.myZoom = 1.0;
        }
    }

    public double getZoom() {
        return this.myZoom;
    }

    public boolean isUseLargeShadows() {
        return this.myUseLargeShadows;
    }

    public void zoom(@NotNull ZoomType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "zoom"));
        }
        this.myZoomMode = type;
        this.updateZoom();
    }

    private void updateZoom() {
        switch (this.myZoomMode) {
            case IN: {
                this.setZoom(this.myZoom * 1.2);
                break;
            }
            case OUT: {
                this.setZoom(this.myZoom / 1.2);
                break;
            }
            case ACTUAL: {
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    this.setZoom(0.5);
                    break;
                }
                this.setZoom(1.0);
                break;
            }
            case FIT_INTO: 
            case FIT: {
                if (this.myRootComponent == null) {
                    return;
                }
                Dimension sceneSize = this.myRootComponent.getBounds().getSize();
                Dimension screenSize = this.getDesignerViewSize();
                if (screenSize.width <= 0 || screenSize.height <= 0) break;
                int sceneWidth = sceneSize.width;
                int sceneHeight = sceneSize.height;
                if (sceneWidth <= 0 || sceneHeight <= 0) break;
                int viewWidth = screenSize.width;
                int viewHeight = screenSize.height;
                int hDelta = viewWidth - sceneWidth;
                int xMargin = 0;
                if (hDelta > 60) {
                    xMargin = 30;
                } else if (hDelta > 0) {
                    xMargin = hDelta / 2;
                }
                int vDelta = viewHeight - sceneHeight;
                int yMargin = 0;
                if (vDelta > 40) {
                    yMargin = 20;
                } else if (vDelta > 0) {
                    yMargin = vDelta / 2;
                }
                double hScale = (double)(viewWidth - 2 * xMargin) / (double)sceneWidth;
                double vScale = (double)(viewHeight - 2 * yMargin) / (double)sceneHeight;
                double scale = Math.min(hScale, vScale);
                if (this.myZoomMode == ZoomType.FIT_INTO) {
                    scale = Math.min(1.0, scale);
                }
                this.setZoom(scale);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented: " + this.myZoomMode);
            }
        }
    }

    @NotNull
    private Dimension getDesignerViewSize() {
        Dimension size = this.myScrollPane.getSize();
        size.width -= 2;
        size.height -= 2;
        RootView rootView = this.getRootView();
        if (rootView != null) {
            if (rootView.getShowDropShadow()) {
                size.width -= 20;
                size.height -= 20;
            }
            int MIN_SIZE = 200;
            if (this.myPreviewManager != null && size.width > 200) {
                int previewWidth = this.myPreviewManager.computePreviewWidth();
                size.width = Math.max(200, size.width - previewWidth);
            }
        }
        Dimension dimension = size;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getDesignerViewSize"));
        }
        return dimension;
    }

    @NotNull
    protected Dimension getSceneSize(@NotNull Component target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getSceneSize"));
        }
        int width = 0;
        int height = 0;
        if (this.myRootComponent != null) {
            Rectangle bounds = this.myRootComponent.getBounds(target);
            width = Math.max(width, (int)bounds.getMaxX());
            height = Math.max(height, (int)bounds.getMaxY());
            Dimension dimension = new Dimension(++width, ++height);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getSceneSize"));
            }
            return dimension;
        }
        Dimension dimension = super.getSceneSize(target);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getSceneSize"));
        }
        return dimension;
    }

    protected void viewZoomed() {
        RootView rootView = this.getRootView();
        if (rootView != null) {
            rootView.updateSize();
        }
        this.revalidate();
        this.myHorizontalCaption.update();
        this.myVerticalCaption.update();
        super.viewZoomed();
    }

    public RootView getCurrentRootView() {
        assert (this.myRootView == this.getRootView());
        return this.myRootView;
    }

    @Nullable
    private RootView getRootView() {
        Component nativeComponent;
        if (this.myRootComponent instanceof RadViewComponent && (nativeComponent = ((RadViewComponent)this.myRootComponent).getNativeComponent()) instanceof RootView) {
            return (RootView)nativeComponent;
        }
        return null;
    }

    @Nullable
    private RadViewComponent getLayoutRoot() {
        RadComponent component;
        if (this.myRootComponent != null && this.myRootComponent.getChildren().size() == 1 && (component = (RadComponent)this.myRootComponent.getChildren().get(0)).isBackground() && component instanceof RadViewComponent) {
            return (RadViewComponent)component;
        }
        return null;
    }

    @Nullable
    protected RadComponent findTarget(int x, int y, @Nullable ComponentTargetFilter filter) {
        RadViewComponent rootTarget;
        RadComponent target = super.findTarget(x, y, filter);
        if (target == null && (rootTarget = this.getLayoutRoot()) != null && filter != null && filter.preFilter(this.myRootComponent) && filter.resultFilter((RadComponent)rootTarget)) {
            return rootTarget;
        }
        return target;
    }

    private void saveState() {
        if (this.myConfiguration != null) {
            this.myConfiguration.save();
        }
    }

    @Override
    @Nullable
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    public void setConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "setConfiguration"));
        }
        if (configuration != this.myConfiguration) {
            if (this.myConfiguration != null) {
                this.myConfiguration.removeListener(this.myConfigListener);
            }
            this.myConfiguration = configuration;
            this.myConfiguration.addListener(this.myConfigListener);
            this.myConfigListener.changed(65535);
        }
    }

    @Override
    public void requestRender() {
        this.updateRenderer(false);
        this.mySessionQueue.sendFlush();
    }

    public void requestImmediateRender() {
        this.updateRenderer(true);
        this.mySessionQueue.sendFlush();
    }

    public boolean isRenderPending() {
        return !this.mySessionQueue.isEmpty() && !this.mySessionQueue.isFlushing();
    }

    @Override
    @NotNull
    public RenderContext.UsageType getType() {
        RenderContext.UsageType usageType = RenderContext.UsageType.LAYOUT_EDITOR;
        if (usageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getType"));
        }
        return usageType;
    }

    @Override
    @NotNull
    public XmlFile getXmlFile() {
        XmlFile xmlFile = this.myXmlFile;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getXmlFile"));
        }
        return xmlFile;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    @Override
    public boolean hasAlphaChannel() {
        return !this.myRootView.getShowDropShadow();
    }

    @Override
    @NotNull
    public Component getComponent() {
        JLayeredPane jLayeredPane = this.myLayeredPane;
        if (jLayeredPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getComponent"));
        }
        return jLayeredPane;
    }

    @Override
    public void updateLayout() {
        this.zoom(ZoomType.FIT_INTO);
        Component component = this.getComponent();
        if (component instanceof JComponent) {
            JComponent jc = (JComponent)component;
            jc.revalidate();
        } else {
            component.validate();
        }
        this.layoutParent();
        component.repaint();
    }

    private void layoutParent() {
        if (this.myRootView != null) {
            ((JComponent)this.myRootView.getParent()).revalidate();
        }
    }

    @Override
    public void setDeviceFramesEnabled(boolean on) {
        RenderedImage image;
        this.myShowDeviceFrames = on;
        if (this.myRootView != null && (image = this.myRootView.getRenderedImage()) != null) {
            image.setDeviceFrameEnabled(on);
        }
    }

    private void updateDeviceFrameVisibility(@Nullable RenderResult result) {
        RenderedImage image;
        if (result != null && (image = result.getImage()) != null) {
            RenderTask renderTask = result.getRenderTask();
            image.setDeviceFrameEnabled(this.myShowDeviceFrames && renderTask != null && renderTask.getRenderingMode() == SessionParams.RenderingMode.NORMAL && renderTask.getShowDecorations());
        }
    }

    @Override
    @Nullable
    public BufferedImage getRenderedImage() {
        return this.myRootView != null ? this.myRootView.getImage() : null;
    }

    @Override
    @Nullable
    public RenderResult getLastResult() {
        return this.myRenderResult;
    }

    @Override
    @Nullable
    public RenderedViewHierarchy getViewHierarchy() {
        return this.myRenderResult != null ? this.myRenderResult.getHierarchy() : null;
    }

    @Override
    @NotNull
    public Dimension getFullImageSize() {
        BufferedImage image;
        if (this.myRootView != null && (image = this.myRootView.getImage()) != null) {
            Dimension dimension = new Dimension(image.getWidth(), image.getHeight());
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getFullImageSize"));
            }
            return dimension;
        }
        Dimension dimension = NO_SIZE;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getFullImageSize"));
        }
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getScaledImageSize() {
        BufferedImage image;
        if (this.myRootView != null && (image = this.myRootView.getImage()) != null) {
            Dimension dimension = new Dimension((int)(this.myZoom * (double)image.getWidth()), (int)(this.myZoom * (double)image.getHeight()));
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getScaledImageSize"));
            }
            return dimension;
        }
        Dimension dimension = NO_SIZE;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getScaledImageSize"));
        }
        return dimension;
    }

    @Override
    public void setMaxSize(int width, int height) {
        this.myMaxWidth = width;
        this.myMaxHeight = height;
        this.myUseLargeShadows = width <= 0;
        this.layoutParent();
    }

    @Override
    public void zoomFit(boolean onlyZoomOut, boolean allowZoomIn) {
        this.zoom(allowZoomIn ? ZoomType.FIT : ZoomType.FIT_INTO);
    }

    @Override
    @NotNull
    public Rectangle getClientArea() {
        Rectangle rectangle = this.myScrollPane.getViewport().getViewRect();
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "getClientArea"));
        }
        return rectangle;
    }

    @Override
    public boolean supportsPreviews() {
        return true;
    }

    @Override
    @Nullable
    public RenderPreviewManager getPreviewManager(boolean createIfNecessary) {
        if (this.myPreviewManager == null && createIfNecessary) {
            this.myPreviewManager = new RenderPreviewManager(this);
            RenderPreviewPanel panel = new RenderPreviewPanel();
            this.myLayeredPane.add((Component)panel, LAYER_PREVIEW);
            this.myLayeredPane.revalidate();
            this.myLayeredPane.repaint();
        }
        return this.myPreviewManager;
    }

    @Override
    @NotNull
    public Rectangle fromModel(@NotNull Component target, @NotNull Rectangle rectangle) {
        Rectangle imageBounds;
        RenderedImage renderedImage;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "fromModel"));
        }
        if (rectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectangle", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "fromModel"));
        }
        Rectangle r = this.myRootComponent.fromModel(target, rectangle);
        if (target == this.myRootView) {
            double scale = this.myRootView.getScale();
            r.x = (int)((double)r.x * scale);
            r.y = (int)((double)r.y * scale);
            r.width = (int)((double)r.width * scale);
            r.height = (int)((double)r.height * scale);
        }
        if ((renderedImage = this.myRootView.getRenderedImage()) != null && (imageBounds = renderedImage.getImageBounds()) != null) {
            r.x += imageBounds.x;
            r.y += imageBounds.y;
        }
        Rectangle rectangle2 = r;
        if (rectangle2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "fromModel"));
        }
        return rectangle2;
    }

    @Override
    @NotNull
    public Rectangle toModel(@NotNull Component source, @NotNull Rectangle rectangle) {
        Rectangle imageBounds;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "toModel"));
        }
        if (rectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectangle", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "toModel"));
        }
        RenderedImage renderedImage = this.myRootView.getRenderedImage();
        if (renderedImage != null && (imageBounds = renderedImage.getImageBounds()) != null && imageBounds.x != 0 && imageBounds.y != 0) {
            rectangle = new Rectangle(rectangle);
            rectangle.x -= imageBounds.x;
            rectangle.y -= imageBounds.y;
        }
        Rectangle r = this.myRootComponent.toModel(source, rectangle);
        if (source == this.myRootView) {
            double scale = this.myRootView.getScale();
            r.x = (int)((double)r.x / scale);
            r.y = (int)((double)r.y / scale);
            r.width = (int)((double)r.width / scale);
            r.height = (int)((double)r.height / scale);
        }
        Rectangle rectangle2 = r;
        if (rectangle2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "toModel"));
        }
        return rectangle2;
    }

    @Override
    @Nullable
    public List<Overlay> getOverlays() {
        return this.myOverlays;
    }

    @Override
    public boolean isSelected(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "isSelected"));
        }
        for (RadComponent component : this.getSurfaceArea().getSelection()) {
            RadViewComponent rv;
            if (!(component instanceof RadViewComponent) || tag != (rv = (RadViewComponent)component).getTag()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resourceFoldersChanged(@NotNull AndroidFacet facet, @NotNull List<VirtualFile> folders, @NotNull Collection<VirtualFile> added, @NotNull Collection<VirtualFile> removed) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "resourceFoldersChanged"));
        }
        if (folders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folders", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "resourceFoldersChanged"));
        }
        if (added == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "added", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "resourceFoldersChanged"));
        }
        if (removed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removed", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel", "resourceFoldersChanged"));
        }
        if (facet == this.myFacet) {
            if (this.myActive) {
                this.updateRenderer(true);
            } else {
                this.myVariantChanged = true;
            }
        }
    }

    protected DesignerEditorPanel.DesignerEditableArea createEditableArea() {
        return new AndroidEditableArea();
    }

    private class RenderPreviewTool
    extends InputTool {
        private RenderPreviewTool() {
        }

        public void mouseMove(MouseEvent event, EditableArea area) throws Exception {
            if (AndroidDesignerEditorPanel.this.myPreviewManager != null) {
                AndroidDesignerEditorPanel.this.myPreviewManager.moved(event);
            }
        }

        public void mouseUp(MouseEvent event, EditableArea area) throws Exception {
            super.mouseUp(event, area);
            if (AndroidDesignerEditorPanel.this.myPreviewManager != null && event.getClickCount() > 0) {
                AndroidDesignerEditorPanel.this.myPreviewManager.click(event);
            }
        }

        public void mouseEntered(MouseEvent event, EditableArea area) throws Exception {
            super.mouseEntered(event, area);
            if (AndroidDesignerEditorPanel.this.myPreviewManager != null) {
                AndroidDesignerEditorPanel.this.myPreviewManager.enter(event);
            }
        }

        public void mouseExited(MouseEvent event, EditableArea area) throws Exception {
            super.mouseExited(event, area);
            if (AndroidDesignerEditorPanel.this.myPreviewManager != null) {
                AndroidDesignerEditorPanel.this.myPreviewManager.exit(event);
            }
        }
    }

    private class AndroidEditableArea
    extends DesignerEditorPanel.DesignerEditableArea {
        private AndroidEditableArea() {
            super((DesignerEditorPanel)AndroidDesignerEditorPanel.this);
        }

        public InputTool findTargetTool(int x, int y) {
            if (AndroidDesignerEditorPanel.this.myPreviewManager != null && AndroidDesignerEditorPanel.this.myRootView != null) {
                if (AndroidDesignerEditorPanel.this.myPreviewTool == null) {
                    AndroidDesignerEditorPanel.this.myPreviewTool = new RenderPreviewTool();
                }
                if (x > AndroidDesignerEditorPanel.this.myRootView.getX() + AndroidDesignerEditorPanel.this.myRootView.getWidth() || y > AndroidDesignerEditorPanel.this.myRootView.getY() + AndroidDesignerEditorPanel.this.myRootView.getHeight()) {
                    return AndroidDesignerEditorPanel.this.myPreviewTool;
                }
            }
            if (AndroidDesignerEditorPanel.this.myRootComponent != null && AndroidDesignerEditorPanel.this.myRenderResult != null) {
                RadComponent target = this.findTarget(x, y, null);
                RenderedView leaf = null;
                if (target instanceof RadViewComponent) {
                    RadViewComponent rv = (RadViewComponent)target;
                    RenderedViewHierarchy hierarchy = AndroidDesignerEditorPanel.this.myRenderResult.getHierarchy();
                    if (hierarchy != null) {
                        leaf = hierarchy.findViewByTag(rv.getTag());
                    }
                }
                if (AndroidDesignerEditorPanel.this.myHover.setHoveredView(leaf)) {
                    AndroidDesignerEditorPanel.this.repaint();
                }
            }
            return super.findTargetTool(x, y);
        }
    }

    private class RenderPreviewPanel
    extends JComponent {
        RenderPreviewPanel() {
            this.setBackground(null);
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (AndroidDesignerEditorPanel.this.myPreviewManager != null) {
                AndroidDesignerEditorPanel.this.myPreviewManager.paint((Graphics2D)g);
            }
        }
    }

    private class LayoutConfigurationListener
    implements ConfigurationListener {
        private LayoutConfigurationListener() {
        }

        @Override
        public boolean changed(int flags) {
            if (AndroidDesignerEditorPanel.this.isProjectClosed()) {
                return true;
            }
            if (AndroidDesignerEditorPanel.this.myActive) {
                AndroidDesignerEditorPanel.this.updateRenderer(false);
                if ((flags & 0x20) != 0) {
                    IAndroidTarget target;
                    IAndroidTarget iAndroidTarget = target = AndroidDesignerEditorPanel.this.myConfiguration != null ? AndroidDesignerEditorPanel.this.myConfiguration.getTarget() : null;
                    if (target != null) {
                        AndroidDesignerEditorPanel.this.updatePalette(target);
                    }
                }
                AndroidDesignerEditorPanel.this.saveState();
            } else {
                AndroidDesignerEditorPanel.this.myConfigurationDirty |= flags;
            }
            return true;
        }
    }

    private static class MyRenderPanelWrapper
    extends JPanel {
        private final RenderErrorPanel myErrorPanel;
        private int myErrorPanelHeight;

        public MyRenderPanelWrapper(@NotNull RenderErrorPanel errorPanel) {
            if (errorPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPanel", "com/intellij/android/designer/designSurface/AndroidDesignerEditorPanel$MyRenderPanelWrapper", "<init>"));
            }
            super(new BorderLayout());
            this.myErrorPanelHeight = -1;
            this.myErrorPanel = errorPanel;
            this.setBackground(null);
            this.setOpaque(false);
            this.add(errorPanel);
        }

        private RenderErrorPanel getErrorPanel() {
            return this.myErrorPanel;
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.positionErrorPanel();
        }

        private void positionErrorPanel() {
            int size;
            int height = this.getHeight();
            int width = this.getWidth();
            if (this.myErrorPanelHeight == -1) {
                size = height * 3 / 4;
                int preferredHeight = this.myErrorPanel.getPreferredHeight(width) + 8;
                if (preferredHeight < size) {
                    this.myErrorPanelHeight = size = Math.max(preferredHeight, Math.min(height / 4, size));
                }
            } else {
                size = this.myErrorPanelHeight;
            }
            this.myErrorPanel.setSize(width, size);
            this.myErrorPanel.setLocation(0, height - size);
        }
    }
}

