/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout;

import com.intellij.android.designer.designSurface.layout.grid.GridOperation;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.grid.GridInsertType;
import com.intellij.android.designer.model.layout.table.RadTableLayoutComponent;
import com.intellij.android.designer.model.layout.table.RadTableRowLayout;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TableLayoutOperation
extends GridOperation {
    public TableLayoutOperation(RadComponent container, OperationContext context) {
        super(container, context);
    }

    @Override
    protected boolean isMoveOperation() {
        if (this.myContext.isPaste() || this.myContext.isCreate()) {
            return false;
        }
        if (this.myContext.isMove()) {
            return true;
        }
        final RadComponent editComponent = (RadComponent)this.myContext.getComponents().get(0);
        final boolean[] move = new boolean[1];
        this.myContainer.accept(new RadComponentVisitor(){

            public boolean visit(RadComponent component) {
                if (editComponent == component) {
                    move[0] = true;
                    return false;
                }
                return true;
            }

            public void endVisit(RadComponent component) {
            }
        }, true);
        return move[0];
    }

    @Override
    protected int getMovedIndex(boolean row) {
        RadComponent movedComponent = (RadComponent)this.myContext.getComponents().get(0);
        List children = this.myContainer.getChildren();
        if (row) {
            if (movedComponent.getParent() == this.myContainer) {
                return children.indexOf(movedComponent);
            }
            return children.indexOf(movedComponent.getParent());
        }
        if (movedComponent.getParent() == this.myContainer) {
            return 0;
        }
        int columnIndex = RadTableLayoutComponent.getCellIndex(movedComponent);
        if (columnIndex != -1) {
            return columnIndex;
        }
        int rowIndex = children.indexOf(movedComponent.getParent());
        Object[] components = this.getGridInfo().components[rowIndex];
        return ArrayUtil.indexOf((Object[])components, (Object)movedComponent);
    }

    @Override
    protected boolean isSingleMovedAxis(boolean row) {
        RadComponent movedComponent = (RadComponent)this.myContext.getComponents().get(0);
        RadComponent[][] components = this.getGridInfo().components;
        if (row) {
            if (movedComponent.getParent() == this.myContainer) {
                return true;
            }
            int rowIndex = this.myContainer.getChildren().indexOf(movedComponent.getParent());
            return this.getSizeInRow(rowIndex, movedComponent) == 0;
        }
        int columnCount = components[0].length;
        if (movedComponent.getParent() == this.myContainer) {
            return this.getSizeInColumn(0, columnCount, movedComponent) == 0;
        }
        int columnIndex = this.getMovedIndex(false);
        int span = RadTableLayoutComponent.getCellSpan(movedComponent);
        for (int i = 0; i < span; ++i) {
            if (this.getSizeInColumn(columnIndex + i, columnCount, movedComponent) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canExecute() {
        RadComponent editComponent = (RadComponent)this.myComponents.get(0);
        boolean isTableRowElement = "TableRow".equals(editComponent.getMetaModel().getTag());
        if (isTableRowElement && TableLayoutOperation.rowExists(this.getGridInfo().components, this.myRow)) {
            return false;
        }
        return super.canExecute();
    }

    @Override
    public void execute() throws Exception {
        GridInfo gridInfo = this.getGridInfo();
        RadViewComponent container = (RadViewComponent)this.myContainer;
        List rows = this.myContainer.getChildren();
        RadComponent editComponent = (RadComponent)this.myComponents.get(0);
        ViewsMetaManager metaManager = ViewsMetaManager.getInstance(container.getTag().getProject());
        MetaModel tableRowModel = metaManager.getModelByTag("TableRow");
        if (this.myInsertType == GridInsertType.in_cell) {
            if (gridInfo.components != null && this.myRow < gridInfo.components.length) {
                RadViewComponent rowComponent = (RadViewComponent)((Object)rows.get(this.myRow));
                if (RadTableRowLayout.is((RadComponent)rowComponent)) {
                    this.insertInRow(rowComponent, null, true, this.myColumn + 1, this.myColumn);
                } else {
                    this.convertToTableRowAndExecute(rowComponent, false, tableRowModel, this.myColumn);
                }
            } else {
                RadViewComponent newRowComponent = null;
                for (int i = rows.size(); i <= this.myRow; ++i) {
                    newRowComponent = RadComponentOperations.createComponent(null, tableRowModel);
                    RadComponentOperations.addComponent(container, newRowComponent, null);
                }
                TableLayoutOperation.execute(this.myContext, newRowComponent, this.myComponents, null);
                RadTableLayoutComponent.setCellIndex(editComponent, this.myColumn);
            }
        } else if (this.myInsertType == GridInsertType.before_h_cell || this.myInsertType == GridInsertType.after_h_cell) {
            this.insertInNewRow(tableRowModel, this.myInsertType == GridInsertType.before_h_cell, this.myRow, this.myColumn);
        } else if (this.myInsertType == GridInsertType.before_v_cell || this.myInsertType == GridInsertType.after_v_cell) {
            int column = this.myColumn;
            if (this.myInsertType == GridInsertType.after_v_cell) {
                ++column;
            }
            this.shiftColumns(column);
            RadViewComponent rowComponent = (RadViewComponent)((Object)rows.get(this.myRow));
            if (RadTableRowLayout.is((RadComponent)rowComponent)) {
                this.insertInRow(rowComponent, this.myInsertType == GridInsertType.before_v_cell ? gridInfo.components[this.myRow][column] : null, this.myInsertType == GridInsertType.after_v_cell, column, column);
            } else {
                this.convertToTableRowAndExecute(rowComponent, this.myInsertType == GridInsertType.before_v_cell, tableRowModel, column);
            }
        } else {
            int column = this.myColumn;
            if (this.myInsertType == GridInsertType.corner_top_right || this.myInsertType == GridInsertType.corner_bottom_right) {
                ++column;
            }
            this.shiftColumns(column);
            this.insertInNewRow(tableRowModel, this.myInsertType == GridInsertType.corner_top_left || this.myInsertType == GridInsertType.corner_top_right, this.myRow, column);
        }
    }

    private void insertInRow(RadViewComponent rowComponent, @Nullable RadComponent insertBefore, boolean calculateInsert, int startColumn, int column) throws Exception {
        RadComponent editComponent;
        if (calculateInsert) {
            GridInfo gridInfo = this.getGridInfo();
            RadComponent[] rowComponents = gridInfo.components[this.myRow];
            for (int i = startColumn; i < rowComponents.length && (insertBefore = rowComponents[i]) == null; ++i) {
            }
        }
        if ((editComponent = (RadComponent)this.myComponents.get(0)) != insertBefore) {
            TableLayoutOperation.execute(this.myContext, rowComponent, this.myComponents, (RadViewComponent)insertBefore);
        }
        RadTableLayoutComponent.setCellIndex(editComponent, column);
    }

    private void insertInNewRow(MetaModel tableRowModel, boolean before, int row, int column) throws Exception {
        List rows = this.myContainer.getChildren();
        RadComponent insertBefore = null;
        if (before) {
            insertBefore = (RadComponent)rows.get(row);
        } else if (row + 1 < rows.size()) {
            insertBefore = (RadComponent)rows.get(row + 1);
        }
        RadViewComponent newRowComponent = RadComponentOperations.createComponent(null, tableRowModel);
        RadComponentOperations.addComponent((RadViewComponent)this.myContainer, newRowComponent, (RadViewComponent)insertBefore);
        TableLayoutOperation.execute(this.myContext, newRowComponent, this.myComponents, null);
        RadTableLayoutComponent.setCellIndex((RadComponent)this.myComponents.get(0), column);
    }

    private void convertToTableRowAndExecute(RadViewComponent rowComponent, boolean insertBefore, MetaModel tableRowModel, int column) throws Exception {
        RadViewComponent newRowComponent = RadComponentOperations.createComponent(null, tableRowModel);
        RadComponentOperations.addComponent((RadViewComponent)this.myContainer, newRowComponent, rowComponent);
        RadComponentOperations.moveComponent(newRowComponent, rowComponent, null);
        RadComponent editComponent = (RadComponent)this.myComponents.get(0);
        if (!insertBefore || editComponent != rowComponent) {
            TableLayoutOperation.execute(this.myContext, newRowComponent, this.myComponents, insertBefore ? rowComponent : null);
        }
        if (column > 1) {
            RadTableLayoutComponent.setCellIndex(editComponent, column);
        }
    }

    private void shiftColumns(int startColumn) {
        List rows = this.myContainer.getChildren();
        RadComponent[][] components = this.getGridInfo().components;
        for (int i = 0; i < components.length; ++i) {
            if (!RadTableRowLayout.is((RadComponent)rows.get(i))) continue;
            RadComponent[] rowComponents = components[i];
            for (int j = startColumn; j < rowComponents.length; ++j) {
                RadComponent cellComponent = rowComponents[j];
                if (cellComponent == null) continue;
                if (j == startColumn && startColumn > 0 && cellComponent == rowComponents[j - 1]) {
                    RadTableLayoutComponent.setCellSpan(cellComponent, RadTableLayoutComponent.getCellSpan(cellComponent) + 1);
                } else {
                    RadTableLayoutComponent.setCellIndex(cellComponent, j + 1);
                }
                while (j + 1 < rowComponents.length && cellComponent == rowComponents[j + 1]) {
                    ++j;
                }
            }
        }
    }
}

