/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidDesignerIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public enum Gravity {
    left,
    right,
    center,
    top,
    bottom;

    public static Icon ICON;
    public static final int NONE = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int CENTER_VERTICAL = 16;
    public static final int FILL_VERTICAL = 32;
    public static final int CENTER_HORIZONTAL = 64;
    public static final int FILL_HORIZONTAL = 128;
    public static final int CENTER = 80;
    public static final int FILL = 160;
    public static final int CLIP_VERTICAL = 256;
    public static final int CLIP_HORIZONTAL = 512;
    public static final int START = 1028;
    public static final int END = 2056;

    @Nullable
    public static String getValue(@Nullable Gravity horizontal, @Nullable Gravity vertical) {
        StringBuilder gravity = new StringBuilder();
        if (horizontal == center && vertical == center) {
            gravity.append("center");
        } else {
            if (horizontal == left) {
                gravity.append("left");
            } else if (horizontal == center) {
                gravity.append("center_horizontal");
            } else if (horizontal == right) {
                gravity.append("right");
            }
            if (vertical == top) {
                if (gravity.length() > 0) {
                    gravity.append("|");
                }
                gravity.append("top");
            } else if (vertical == center) {
                if (gravity.length() > 0) {
                    gravity.append("|");
                }
                gravity.append("center_vertical");
            } else if (vertical == bottom) {
                if (gravity.length() > 0) {
                    gravity.append("|");
                }
                gravity.append("bottom");
            }
        }
        return gravity.length() == 0 ? null : gravity.toString();
    }

    public static int getFlags(RadComponent component) {
        String value = ((RadViewComponent)component).getTag().getAttributeValue("layout_gravity", "http://schemas.android.com/apk/res/android");
        int flags = 0;
        if (!StringUtil.isEmpty((String)value)) {
            for (String option : StringUtil.split((String)value, (String)"|")) {
                if ("top".equals(option = option.trim())) {
                    flags |= 1;
                    continue;
                }
                if ("bottom".equals(option)) {
                    flags |= 2;
                    continue;
                }
                if ("left".equals(option)) {
                    flags |= 4;
                    continue;
                }
                if ("right".equals(option)) {
                    flags |= 8;
                    continue;
                }
                if ("center_vertical".equals(option)) {
                    flags |= 0x10;
                    continue;
                }
                if ("fill_vertical".equals(option)) {
                    flags |= 0x20;
                    continue;
                }
                if ("center_horizontal".equals(option)) {
                    flags |= 0x40;
                    continue;
                }
                if ("fill_horizontal".equals(option)) {
                    flags |= 0x80;
                    continue;
                }
                if ("center".equals(option)) {
                    flags |= 0x50;
                    continue;
                }
                if ("fill".equals(option)) {
                    flags |= 0xA0;
                    continue;
                }
                if ("clip_vertical".equals(option)) {
                    flags |= 0x100;
                    continue;
                }
                if ("clip_horizontal".equals(option)) {
                    flags |= 0x200;
                    continue;
                }
                if ("start".equals(option)) {
                    flags |= 0x404;
                    continue;
                }
                if (!"end".equals(option)) continue;
                flags |= 0x808;
            }
        }
        return flags;
    }

    public static List<Gravity> flagToValues(int flags) {
        ArrayList<Gravity> values = new ArrayList<Gravity>();
        if ((flags & 4) != 0) {
            values.add(left);
        }
        if ((flags & 8) != 0) {
            values.add(right);
        }
        if ((flags & 1) != 0) {
            values.add(top);
        }
        if ((flags & 2) != 0) {
            values.add(bottom);
        }
        if ((flags & 0x50) != 0) {
            values.add(center);
        }
        return values;
    }

    public static Pair<Gravity, Gravity> getSides(RadComponent component) {
        int flags = Gravity.getFlags(component);
        Gravity horizontal = left;
        if ((flags & 4) != 0) {
            horizontal = left;
        } else if ((flags & 8) != 0) {
            horizontal = right;
        } else if ((flags & 0x40) != 0) {
            horizontal = center;
        }
        Gravity vertical = top;
        if ((flags & 1) != 0) {
            vertical = top;
        } else if ((flags & 2) != 0) {
            vertical = bottom;
        } else if ((flags & 0x10) != 0) {
            vertical = center;
        }
        return Pair.create((Object)((Object)horizontal), (Object)((Object)vertical));
    }

    static {
        ICON = AndroidDesignerIcons.Gravity;
    }
}

