/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.builder.model.AndroidLibrary;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.Lists;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameJavaVariableProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameXmlAttributeProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.AndroidFindUsagesHandlerFactory;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceRenameResourceProcessor
extends RenamePsiElementProcessor {
    public static volatile boolean ASK = true;

    public boolean canProcessElement(final @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/AndroidResourceRenameResourceProcessor", "canProcessElement"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                PsiClass cls;
                PsiElement element1 = LazyValueResourceElementWrapper.computeLazyElement(element);
                if (element1 == null) {
                    return false;
                }
                if (element1 instanceof PsiFile) {
                    return AndroidFacet.getInstance(element1) != null && AndroidResourceUtil.isInResourceSubdirectory((PsiFile)element1, null);
                }
                if (element1 instanceof PsiField) {
                    PsiField field = (PsiField)element1;
                    if (AndroidResourceUtil.isResourceField(field)) {
                        return AndroidResourceUtil.findResourcesByField(field).size() > 0;
                    }
                } else if (element1 instanceof XmlAttributeValue) {
                    LocalResourceManager manager = LocalResourceManager.getInstance(element1);
                    if (manager != null) {
                        if (AndroidResourceUtil.isIdDeclaration((XmlAttributeValue)element1)) {
                            return true;
                        }
                        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element1, XmlTag.class);
                        return tag != null && DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag) instanceof ResourceElement && manager.getValueResourceType(tag) != null;
                    }
                } else if (element1 instanceof PsiClass && AndroidDomUtil.isInheritor(cls = (PsiClass)element1, "android.view.View")) {
                    return true;
                }
                return false;
            }
        });
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        PsiElement element1 = LazyValueResourceElementWrapper.computeLazyElement(element);
        if (element1 == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element1);
        assert (facet != null);
        if (element1 instanceof PsiFile) {
            AndroidResourceRenameResourceProcessor.prepareResourceFileRenaming((PsiFile)element1, newName, allRenames, facet);
        } else if (element1 instanceof PsiClass) {
            PsiClass cls = (PsiClass)element1;
            if (AndroidDomUtil.isInheritor(cls, "android.view.View")) {
                AndroidResourceRenameResourceProcessor.prepareCustomViewRenaming(cls, newName, allRenames, facet);
            }
        } else if (element1 instanceof XmlAttributeValue) {
            XmlAttributeValue value = (XmlAttributeValue)element1;
            if (AndroidResourceUtil.isIdDeclaration(value)) {
                AndroidResourceRenameResourceProcessor.prepareIdRenaming(value, newName, allRenames, facet);
            } else {
                AndroidResourceRenameResourceProcessor.prepareValueResourceRenaming(element1, newName, allRenames, facet);
            }
        } else if (element1 instanceof PsiField) {
            AndroidResourceRenameResourceProcessor.prepareResourceFieldRenaming((PsiField)element1, newName, allRenames);
        }
    }

    private static void prepareCustomViewRenaming(PsiClass cls, String newName, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        String oldName;
        AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, true);
        if (appResources.hasResourceItem(ResourceType.DECLARE_STYLEABLE, oldName = cls.getName())) {
            LocalResourceManager manager = facet.getLocalResourceManager();
            for (PsiElement element : manager.findResourcesByFieldName(ResourceType.STYLEABLE.getName(), oldName)) {
                XmlTag tag;
                String tagName;
                if (!(element instanceof XmlAttributeValue) || !(element.getParent() instanceof XmlAttribute) || !(tagName = (tag = ((XmlAttribute)element.getParent()).getParent()).getName()).equals("declare-styleable")) continue;
                for (PsiField field : AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), oldName, false)) {
                    String escaped = AndroidResourceUtil.getFieldNameByResourceName(newName);
                    allRenames.put((PsiElement)field, escaped);
                }
                PsiField[] styleableFields = AndroidResourceUtil.findStyleableAttributeFields(tag, false);
                if (styleableFields.length <= 0) continue;
                for (PsiField resField : styleableFields) {
                    String fieldName = resField.getName();
                    String newAttributeName = fieldName.startsWith(oldName) ? newName + fieldName.substring(oldName.length()) : oldName;
                    String escaped = AndroidResourceUtil.getFieldNameByResourceName(newAttributeName);
                    allRenames.put((PsiElement)resField, escaped);
                }
            }
        }
    }

    private static void prepareIdRenaming(XmlAttributeValue value, String newName, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        LocalResourceManager manager = facet.getLocalResourceManager();
        allRenames.remove(value);
        String id = AndroidResourceUtil.getResourceNameByReferenceText(value.getValue());
        assert (id != null);
        List<XmlAttributeValue> idDeclarations = manager.findIdDeclarations(id);
        for (XmlAttributeValue idDeclaration : idDeclarations) {
            if (!"id".equals(((XmlAttribute)idDeclaration.getParent()).getLocalName())) continue;
            allRenames.put(new ValueResourceElementWrapper(idDeclaration), newName);
        }
        String name = AndroidResourceUtil.getResourceNameByReferenceText(newName);
        if (name != null) {
            for (PsiField resField : AndroidResourceUtil.findIdFields(value)) {
                allRenames.put((PsiElement)resField, AndroidResourceUtil.getFieldNameByResourceName(name));
            }
        }
    }

    @Nullable
    private static String getResourceName(Project project, String newFieldName, String oldResourceName) {
        if (newFieldName.indexOf(95) < 0) {
            return newFieldName;
        }
        if (oldResourceName.indexOf(95) < 0 && oldResourceName.indexOf(46) >= 0) {
            String suggestion = newFieldName.replace('_', '.');
            newFieldName = Messages.showInputDialog((Project)project, (String)AndroidBundle.message("rename.resource.dialog.text", oldResourceName), (String)RefactoringBundle.message((String)"rename.title"), (Icon)Messages.getQuestionIcon(), (String)suggestion, null);
        }
        return newFieldName;
    }

    private static void prepareResourceFieldRenaming(PsiField field, String newName, Map<PsiElement, String> allRenames) {
        new RenameJavaVariableProcessor().prepareRenaming((PsiElement)field, newName, allRenames);
        List<PsiElement> resources = AndroidResourceUtil.findResourcesByField(field);
        PsiElement res = resources.get(0);
        String resName = res instanceof XmlAttributeValue ? ((XmlAttributeValue)res).getValue() : ((PsiFile)res).getName();
        String newResName = AndroidResourceRenameResourceProcessor.getResourceName(field.getProject(), newName, resName);
        for (PsiElement resource : resources) {
            XmlAttribute parent;
            XmlTag tag;
            if (resource instanceof PsiFile) {
                PsiFile file = (PsiFile)resource;
                String extension = FileUtilRt.getExtension((String)file.getName());
                allRenames.put(resource, newResName + '.' + extension);
                continue;
            }
            if (!(resource instanceof XmlAttributeValue)) continue;
            XmlAttributeValue value = (XmlAttributeValue)resource;
            String s = AndroidResourceUtil.isIdDeclaration(value) ? "@+id/" + newResName : newResName;
            allRenames.put(new ValueResourceElementWrapper(value), s);
            if (!(value.getParent() instanceof XmlAttribute) || !(tag = (parent = (XmlAttribute)value.getParent()).getParent()).getName().equals("declare-styleable")) continue;
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            String oldName = tag.getAttributeValue("name");
            if (facet == null || oldName == null) continue;
            for (XmlTag attr : tag.getSubTags()) {
                String name;
                if (!attr.getName().equals("attr") || (name = attr.getAttributeValue("name")) == null) continue;
                String oldAttributeName = oldName + '_' + name;
                PsiField[] fields = AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), oldAttributeName, true);
                if (fields.length <= 0) continue;
                String newAttributeName = newName + '_' + name;
                for (PsiField f : fields) {
                    allRenames.put((PsiElement)f, newAttributeName);
                }
            }
        }
    }

    private static void prepareValueResourceRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        PsiField[] resFields;
        LocalResourceManager manager = facet.getLocalResourceManager();
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        assert (tag != null);
        String type = manager.getValueResourceType(tag);
        assert (type != null);
        Project project = tag.getProject();
        DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
        assert (domElement instanceof ResourceElement);
        String name = (String)((ResourceElement)domElement).getName().getValue();
        assert (name != null);
        List<ResourceElement> resources = manager.findValueResources(type, name);
        for (ResourceElement resource : resources) {
            XmlAttributeValue xmlElement = resource.getName().getXmlAttributeValue();
            if (element.getManager().areElementsEquivalent(element, (PsiElement)xmlElement)) continue;
            allRenames.put((PsiElement)xmlElement, newName);
        }
        for (PsiField resField : resFields = AndroidResourceUtil.findResourceFieldsForValueResource(tag, false)) {
            String escaped = AndroidResourceUtil.getFieldNameByResourceName(newName);
            allRenames.put((PsiElement)resField, escaped);
        }
        PsiField[] styleableFields = AndroidResourceUtil.findStyleableAttributeFields(tag, false);
        if (styleableFields.length > 0) {
            boolean isAttr;
            String tagName = tag.getName();
            boolean isDeclareStyleable = tagName.equals("declare-styleable");
            boolean bl = isAttr = !isDeclareStyleable && tagName.equals("attr") && tag.getParentTag() != null;
            assert (isDeclareStyleable || isAttr);
            String style = isAttr ? tag.getParentTag().getAttributeValue("name") : null;
            for (PsiField resField : styleableFields) {
                String fieldName = resField.getName();
                String newAttributeName = isDeclareStyleable && fieldName.startsWith(name) ? newName + fieldName.substring(name.length()) : (isAttr && style != null ? style + '_' + newName : name);
                String escaped = AndroidResourceUtil.getFieldNameByResourceName(newAttributeName);
                allRenames.put((PsiElement)resField, escaped);
            }
        }
    }

    private static void prepareResourceFileRenaming(PsiFile file, String newName, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        PsiField[] resFields;
        Project project = file.getProject();
        LocalResourceManager manager = facet.getLocalResourceManager();
        String type = manager.getFileResourceType(file);
        if (type == null) {
            return;
        }
        String name = file.getName();
        if (AndroidCommonUtils.getResourceName((String)type, (String)name).equals(AndroidCommonUtils.getResourceName((String)type, (String)newName))) {
            return;
        }
        List<PsiFile> resourceFiles = manager.findResourceFiles(type, AndroidCommonUtils.getResourceName((String)type, (String)name), true, false, new String[0]);
        ArrayList<PsiFile> alternativeResources = new ArrayList<PsiFile>();
        for (PsiFile resourceFile : resourceFiles) {
            if (resourceFile.getManager().areElementsEquivalent((PsiElement)file, (PsiElement)resourceFile) || !resourceFile.getName().equals(name)) continue;
            alternativeResources.add(resourceFile);
        }
        if (alternativeResources.size() > 0) {
            int r = 0;
            if (ASK) {
                r = Messages.showDialog((Project)project, (String)AndroidBundle.message("rename.alternate.resources.question", new Object[0]), (String)AndroidBundle.message("rename.dialog.title", new Object[0]), (String[])new String[]{Messages.YES_BUTTON, Messages.NO_BUTTON}, (int)1, (Icon)Messages.getQuestionIcon());
            }
            if (r == 0) {
                for (PsiFile candidate : alternativeResources) {
                    allRenames.put((PsiElement)candidate, newName);
                }
            } else {
                return;
            }
        }
        for (PsiField resField : resFields = AndroidResourceUtil.findResourceFieldsForFileResource(file, false)) {
            String newFieldName = AndroidCommonUtils.getResourceName((String)type, (String)newName);
            allRenames.put((PsiElement)resField, AndroidResourceUtil.getFieldNameByResourceName(newFieldName));
        }
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (element instanceof PsiField) {
            new RenameJavaVariableProcessor().renameElement(element, newName, usages, listener);
        } else if (element instanceof PsiNamedElement) {
            VirtualFile virtualFile;
            super.renameElement(element, newName, usages, listener);
            if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null && !LocalHistory.getInstance().isUnderControl(virtualFile)) {
                DocumentReference ref = DocumentReferenceManager.getInstance().create(virtualFile);
                UndoManager.getInstance((Project)element.getProject()).nonundoableActionPerformed(ref, false);
            }
        } else if (element instanceof XmlAttributeValue) {
            new RenameXmlAttributeProcessor().renameElement(element, newName, usages, listener);
        }
    }

    public void findExistingNameConflicts(PsiElement originalElement, String newName, MultiMap<PsiElement, String> conflicts) {
        String name;
        AppResourceRepository appResources;
        ResourceType type = AndroidResourceRenameResourceProcessor.getResourceType(originalElement);
        if (type == null) {
            return;
        }
        PsiElement element = LazyValueResourceElementWrapper.computeLazyElement(originalElement);
        if (element == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            return;
        }
        if (element instanceof PsiFile) {
            newName = AndroidCommonUtils.getResourceName((String)type.getName(), (String)newName);
        }
        if ((appResources = AppResourceRepository.getAppResources(facet, true)).hasResourceItem(type, newName)) {
            FindUsagesHandler handler;
            AndroidFindUsagesHandlerFactory factory;
            boolean foundElements = false;
            PsiField[] resourceFields = AndroidResourceUtil.findResourceFields(facet, type.getName(), newName, true);
            String message = String.format("Resource @%1$s/%2$s already exists", type, newName);
            if (resourceFields.length > 0 && (factory = new AndroidFindUsagesHandlerFactory()).canFindUsages(originalElement) && (handler = factory.createFindUsagesHandler((PsiElement)resourceFields[0], false)) != null) {
                PsiElement[] elements;
                for (PsiElement e : elements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler.getPrimaryElements(), (Object[])handler.getSecondaryElements())) {
                    if (e instanceof LightElement) continue;
                    conflicts.putValue((Object)e, (Object)message);
                    foundElements = true;
                }
            }
            if (!foundElements) {
                conflicts.putValue((Object)originalElement, (Object)message);
            }
        }
        if ((name = AndroidResourceRenameResourceProcessor.getResourceName(originalElement)) != null) {
            List<ResourceItem> local;
            Project project = facet.getModule().getProject();
            List<ResourceItem> all = appResources.getResourceItem(type, name);
            if (all == null) {
                all = Collections.emptyList();
            }
            if ((local = ProjectResourceRepository.getProjectResources(facet, true).getResourceItem(type, name)) == null) {
                local = Collections.emptyList();
            }
            HtmlBuilder builder = null;
            if (local.size() == 0 && all.size() > 0) {
                builder = new HtmlBuilder(new StringBuilder(300));
                builder.add("Resource is also only defined in external libraries and cannot be renamed.");
            } else if (local.size() < all.size()) {
                builder = new HtmlBuilder(new StringBuilder(300));
                builder.add("The resource ").beginBold().add("@").add(type.getName()).add("/").add(name).endBold();
                builder.add(" is defined outside of the project (in one of the libraries) and cannot ");
                builder.add("be updated. This can change the behavior of the application.").newline().newline();
                builder.add("Are you sure you want to do this?");
            }
            if (builder != null) {
                AndroidResourceRenameResourceProcessor.appendUnhandledReferences(project, facet, all, local, builder);
                conflicts.putValue((Object)originalElement, (Object)builder.getHtml());
            }
        }
    }

    @Nullable
    private static ResourceType getResourceType(PsiElement originalElement) {
        LocalResourceManager manager;
        PsiElement element = LazyValueResourceElementWrapper.computeLazyElement(originalElement);
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFile) {
            List types;
            ResourceFolderType folderType = ResourceHelper.getFolderType((PsiFile)element);
            if (folderType != null && folderType != ResourceFolderType.VALUES && !(types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)).isEmpty()) {
                return (ResourceType)types.get(0);
            }
        } else if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            if (AndroidResourceUtil.isResourceField(field)) {
                return ResourceType.getEnum((String)AndroidResourceUtil.getResourceClassName(field));
            }
        } else if (element instanceof XmlAttributeValue && (manager = LocalResourceManager.getInstance(element)) != null) {
            String typeName;
            if (AndroidResourceUtil.isIdDeclaration((XmlAttributeValue)element)) {
                return ResourceType.ID;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag != null && DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag) instanceof ResourceElement && (typeName = manager.getValueResourceType(tag)) != null) {
                return ResourceType.getEnum((String)typeName);
            }
        }
        return null;
    }

    @Nullable
    private static String getResourceName(PsiElement originalElement) {
        PsiElement element = LazyValueResourceElementWrapper.computeLazyElement(originalElement);
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFile) {
            String type;
            PsiFile file = (PsiFile)element;
            LocalResourceManager manager = LocalResourceManager.getInstance(element);
            if (manager != null && (type = manager.getFileResourceType(file)) != null) {
                String name = file.getName();
                return AndroidCommonUtils.getResourceName((String)type, (String)name);
            }
            return LintUtils.getBaseName((String)file.getName());
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            return field.getName();
        }
        if (element instanceof XmlAttributeValue) {
            DomElement domElement;
            if (AndroidResourceUtil.isIdDeclaration((XmlAttributeValue)element)) {
                return AndroidResourceUtil.getResourceNameByReferenceText(((XmlAttributeValue)element).getValue());
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag != null && (domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag)) instanceof ResourceElement) {
                return (String)((ResourceElement)domElement).getName().getValue();
            }
        }
        return null;
    }

    private static void appendUnhandledReferences(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull List<ResourceItem> all, @NotNull List<ResourceItem> local, @NotNull HtmlBuilder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidResourceRenameResourceProcessor", "appendUnhandledReferences"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/AndroidResourceRenameResourceProcessor", "appendUnhandledReferences"));
        }
        if (all == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "all", "org/jetbrains/android/AndroidResourceRenameResourceProcessor", "appendUnhandledReferences"));
        }
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "org/jetbrains/android/AndroidResourceRenameResourceProcessor", "appendUnhandledReferences"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/android/AndroidResourceRenameResourceProcessor", "appendUnhandledReferences"));
        }
        File root = VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir());
        Collection<AndroidLibrary> libraries = null;
        ArrayList descriptions = Lists.newArrayList();
        for (ResourceItem item : all) {
            if (local.contains(item)) continue;
            ResourceFile source = (ResourceFile)item.getSource();
            if (libraries == null) {
                libraries = AppResourceRepository.findAarLibraries(facet);
            }
            if (source == null) continue;
            File sourceFile = source.getFile();
            File localRoot = root;
            File prev = sourceFile;
            for (File current = sourceFile.getParentFile(); current != null; current = current.getParentFile()) {
                String name = current.getName();
                if ("exploded-aar".equals(name) || "exploded-bundles".equals(name)) {
                    localRoot = prev;
                    break;
                }
                prev = current;
            }
            if (FileUtil.isAncestor((File)localRoot, (File)sourceFile, (boolean)true)) {
                descriptions.add(FileUtil.getRelativePath((File)localRoot, (File)sourceFile));
                continue;
            }
            descriptions.add(sourceFile.getPath());
        }
        Collections.sort(descriptions);
        builder.newline().newline();
        builder.add("Unhandled references:");
        builder.newline();
        int count = 0;
        for (String s : descriptions) {
            builder.add(s).newline();
            if (++count != 10) continue;
            builder.add("...").newline();
            builder.add("(Additional results truncated)");
            break;
        }
    }
}

