/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.ddms.adb.AdbService;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidDebugRunner;
import org.jetbrains.android.run.AndroidSessionInfo;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidEnableAdbServiceAction
extends ToggleAction {
    private static final String ENABLE_ADB_SERVICE_PROPERTY_NAME = "AndroidEnableDdms";

    public AndroidEnableAdbServiceAction() {
        this(null);
    }

    public AndroidEnableAdbServiceAction(@Nullable Icon icon) {
        super(AndroidBundle.message("android.enable.adb.service.action.title", new Object[0]), AndroidBundle.message("android.enable.adb.service.action.description", new Object[0]), icon);
    }

    public boolean isSelected(AnActionEvent e) {
        return AndroidEnableAdbServiceAction.isAdbServiceEnabled();
    }

    public static boolean isAdbServiceEnabled() {
        String enableDdmsProperty = PropertiesComponent.getInstance().getValue(ENABLE_ADB_SERVICE_PROPERTY_NAME);
        return enableDdmsProperty == null || Boolean.parseBoolean(enableDdmsProperty);
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (state) {
            AndroidEnableAdbServiceAction.setAdbServiceEnabled(project, true);
        } else {
            AndroidEnableAdbServiceAction.disableAdbService(project);
        }
    }

    public static boolean disableAdbService(Project project) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!AndroidEnableAdbServiceAction.askForClosingDebugSessions(project)) {
            return false;
        }
        AndroidEnableAdbServiceAction.setAdbServiceEnabled(project, false);
        return true;
    }

    public static void setAdbServiceEnabled(Project project, boolean state) {
        boolean oldState = AndroidEnableAdbServiceAction.isAdbServiceEnabled();
        PropertiesComponent.getInstance().setValue(ENABLE_ADB_SERVICE_PROPERTY_NAME, Boolean.toString(state));
        if (oldState != state) {
            AdbService.getInstance().restartDdmlib(project);
        }
    }

    private static boolean askForClosingDebugSessions(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/AndroidEnableAdbServiceAction", "askForClosingDebugSessions"));
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            ProcessHandler[] processes;
            for (ProcessHandler process : processes = ExecutionManager.getInstance((Project)p).getRunningProcesses()) {
                AndroidSessionInfo info;
                if (process.isProcessTerminated() || (info = (AndroidSessionInfo)process.getUserData(AndroidDebugRunner.ANDROID_SESSION_INFO)) == null) continue;
                pairs.add(Pair.create((Object)process, (Object)info.getDescriptor()));
            }
        }
        if (pairs.size() == 0) {
            return true;
        }
        StringBuilder s = new StringBuilder();
        for (Pair pair : pairs) {
            if (s.length() > 0) {
                s.append('\n');
            }
            s.append(((RunContentDescriptor)pair.getSecond()).getDisplayName());
        }
        int r = Messages.showYesNoDialog((Project)project, (String)AndroidBundle.message("android.debug.sessions.will.be.closed", s), (String)AndroidBundle.message("android.disable.adb.service.title", new Object[0]), (Icon)Messages.getQuestionIcon());
        return r == 0;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null && ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).size() > 0);
    }
}

