/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticEnumConverter
extends ResolvingConverter<String> {
    private final Set<String> myValues = new HashSet<String>();

    public StaticEnumConverter(String ... values) {
        Collections.addAll(this.myValues, values);
    }

    @NotNull
    public Collection<? extends String> getVariants(ConvertContext context) {
        Collection<String> collection = Collections.unmodifiableCollection(this.myValues);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/StaticEnumConverter", "getVariants"));
        }
        return collection;
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return this.myValues.contains(s) ? s : null;
    }

    public String toString() {
        return "StaticEnumConverter " + this.myValues.toString();
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }
}

