/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileResourceElementWrapper
implements PsiFile,
ResourceElementWrapper,
PsiElementNavigationItem {
    private final PsiFile myWrappee;
    private final PsiDirectory myResourceDir;

    public FileResourceElementWrapper(@NotNull PsiFile wrappeeElement) {
        if (wrappeeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappeeElement", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "<init>"));
        }
        this.myWrappee = wrappeeElement;
        this.myResourceDir = this.getContainingFile().getContainingDirectory();
    }

    @Override
    public PsiElement getWrappee() {
        return this.myWrappee;
    }

    @NotNull
    public Project getProject() throws PsiInvalidElementAccessException {
        Project project = this.myWrappee.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getProject"));
        }
        return project;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myWrappee.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getLanguage"));
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myWrappee.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.myWrappee.getChildren();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getChildren"));
        }
        return psiElementArray;
    }

    public VirtualFile getVirtualFile() {
        return this.myWrappee.getVirtualFile();
    }

    public PsiDirectory getContainingDirectory() {
        return this.myWrappee.getContainingDirectory();
    }

    public boolean isDirectory() {
        return this.myWrappee.isDirectory();
    }

    public PsiDirectory getParent() {
        return this.myWrappee.getParent();
    }

    public long getModificationStamp() {
        return this.myWrappee.getModificationStamp();
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myWrappee.getOriginalFile();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getOriginalFile"));
        }
        return psiFile;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myWrappee.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getFileType"));
        }
        return fileType;
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = this.myWrappee.getPsiRoots();
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getPsiRoots"));
        }
        return psiFileArray;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myWrappee.getViewProvider();
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getViewProvider"));
        }
        return fileViewProvider;
    }

    @Nullable
    public PsiElement getFirstChild() {
        return this.myWrappee.getFirstChild();
    }

    @Nullable
    public PsiElement getLastChild() {
        return this.myWrappee.getLastChild();
    }

    @Nullable
    public PsiElement getNextSibling() {
        return this.myWrappee.getNextSibling();
    }

    @Nullable
    public PsiElement getPrevSibling() {
        return this.myWrappee.getPrevSibling();
    }

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return this.myWrappee.getContainingFile();
    }

    public TextRange getTextRange() {
        return this.myWrappee.getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.myWrappee.getStartOffsetInParent();
    }

    public int getTextLength() {
        return this.myWrappee.getTextLength();
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.myWrappee.findElementAt(offset);
    }

    @Nullable
    public PsiReference findReferenceAt(int offset) {
        return this.myWrappee.findReferenceAt(offset);
    }

    public int getTextOffset() {
        return this.myWrappee.getTextOffset();
    }

    @NonNls
    public String getText() {
        return this.myWrappee.getText();
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.myWrappee.textToCharArray();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "textToCharArray"));
        }
        return cArray;
    }

    public PsiElement getNavigationElement() {
        return this.myWrappee.getNavigationElement();
    }

    public PsiElement getOriginalElement() {
        return this.myWrappee.getOriginalElement();
    }

    public boolean textMatches(@NotNull @NonNls CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "textMatches"));
        }
        return this.myWrappee.textMatches(text);
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "textMatches"));
        }
        return this.myWrappee.textMatches(element);
    }

    public boolean textContains(char c) {
        return this.myWrappee.textContains(c);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "accept"));
        }
        this.myWrappee.accept(visitor);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "acceptChildren"));
        }
        this.myWrappee.acceptChildren(visitor);
    }

    public PsiElement copy() {
        return this.myWrappee.copy();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "add"));
        }
        return this.myWrappee.add(element);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "addBefore"));
        }
        return this.myWrappee.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "addAfter"));
        }
        return this.myWrappee.addAfter(element, anchor);
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "checkAdd"));
        }
        this.myWrappee.checkAdd(element);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return this.myWrappee.addRange(first, last);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "addRangeBefore"));
        }
        return this.myWrappee.addRangeBefore(first, last, anchor);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappee.addRangeAfter(first, last, anchor);
    }

    public void delete() throws IncorrectOperationException {
        this.myWrappee.delete();
    }

    public void checkDelete() throws IncorrectOperationException {
        this.myWrappee.checkDelete();
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        this.myWrappee.deleteChildRange(first, last);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "replace"));
        }
        return this.myWrappee.replace(newElement);
    }

    public boolean isValid() {
        return this.myWrappee.isValid();
    }

    public boolean isWritable() {
        return this.myWrappee.isWritable();
    }

    @Nullable
    public PsiReference getReference() {
        return this.myWrappee.getReference();
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.myWrappee.getReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    public <T> T getCopyableUserData(Key<T> key) {
        return (T)this.myWrappee.getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(Key<T> key, T value) {
        this.myWrappee.putCopyableUserData(key, value);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "processDeclarations"));
        }
        return this.myWrappee.processDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    public PsiElement getContext() {
        return this.myWrappee.getContext();
    }

    public boolean isPhysical() {
        return this.myWrappee.isPhysical();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myWrappee.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = this.myWrappee.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getUseScope"));
        }
        return searchScope;
    }

    @Nullable
    public FileASTNode getNode() {
        return this.myWrappee.getNode();
    }

    public void subtreeChanged() {
        this.myWrappee.subtreeChanged();
    }

    @NonNls
    public String toString() {
        return this.myWrappee.toString();
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof FileResourceElementWrapper) {
            another = ((FileResourceElementWrapper)another).getWrappee();
        }
        return this.myWrappee == another || this.myWrappee.isEquivalentTo(another);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getUserData"));
        }
        return (T)this.myWrappee.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "putUserData"));
        }
        this.myWrappee.putUserData(key, value);
    }

    public Icon getIcon(int flags) {
        return this.myWrappee.getIcon(flags);
    }

    @NotNull
    public String getName() {
        String string = this.myWrappee.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/wrappers/FileResourceElementWrapper", "setName"));
        }
        return this.myWrappee.setName(name);
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return this.myWrappee.processChildren(processor);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                String name = FileResourceElementWrapper.this.myWrappee.getName();
                if (FileResourceElementWrapper.this.myResourceDir == null) {
                    return name;
                }
                return name + " (" + FileResourceElementWrapper.this.myResourceDir.getName() + ')';
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    public void navigate(boolean requestFocus) {
        this.myWrappee.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myWrappee.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myWrappee.canNavigateToSource();
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        this.myWrappee.checkSetName(name);
    }

    public PsiElement getTargetElement() {
        return this.myWrappee;
    }
}

