/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.google.common.base.Function;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AndroidSourceType {
    MANIFEST("manifest", IdeaSourceProvider.MANIFEST_PROVIDER, AllIcons.Modules.SourceRoot),
    JAVA("java", IdeaSourceProvider.JAVA_PROVIDER, AllIcons.Modules.SourceRoot),
    RES("res", IdeaSourceProvider.RES_PROVIDER, AllIcons.Modules.ResourcesRoot),
    AIDL("aidl", IdeaSourceProvider.AIDL_PROVIDER, AllIcons.Modules.SourceRoot),
    RESOURCES("resources", IdeaSourceProvider.RESOURCES_PROVIDER, AllIcons.Modules.ResourcesRoot),
    C("c", IdeaSourceProvider.C_PROVIDER, AllIcons.Modules.SourceRoot),
    Cpp("cpp", IdeaSourceProvider.CPP_PROVIDER, AllIcons.Modules.SourceRoot),
    JNILIBS("jniLibs", IdeaSourceProvider.JNI_LIBS_PROVIDER, AllIcons.Modules.ResourcesRoot),
    ASSETS("assets", IdeaSourceProvider.ASSETS_PROVIDER, AllIcons.Modules.ResourcesRoot),
    RS("rs", IdeaSourceProvider.RS_PROVIDER, AllIcons.Modules.SourceRoot);

    private final String myName;
    private final Function<IdeaSourceProvider, List<VirtualFile>> mySourceExtractor;
    private final Icon myIcon;

    private AndroidSourceType(String name, Function<IdeaSourceProvider, List<VirtualFile>> sourceExtractor, Icon icon) {
        this.myName = name;
        this.mySourceExtractor = sourceExtractor;
        this.myIcon = icon;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<VirtualFile> getSources(IdeaSourceProvider provider) {
        List files = (List)this.mySourceExtractor.apply((Object)provider);
        List list = files == null ? Collections.emptyList() : files;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidSourceType", "getSources"));
        }
        return list;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }
}

