/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ClassMapConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleClassMapConstructor
implements ClassMapConstructor {
    private SimpleClassMapConstructor() {
    }

    public static SimpleClassMapConstructor getInstance() {
        return SimpleClassMapConstructorHolder.INSTANCE;
    }

    @Override
    @NotNull
    public String[] getTagNamesByClass(final @NotNull PsiClass c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/android/facet/SimpleClassMapConstructor", "getTagNamesByClass"));
        }
        String[] stringArray = (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

            public String[] compute() {
                String name = c.getName();
                if (name != null) {
                    String qualifiedName = c.getQualifiedName();
                    if (qualifiedName != null) {
                        if (!SimpleClassMapConstructor.isAndroidLibraryClass(qualifiedName)) {
                            return new String[]{qualifiedName};
                        }
                        return new String[]{name, qualifiedName};
                    }
                    return new String[]{name};
                }
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
        });
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/SimpleClassMapConstructor", "getTagNamesByClass"));
        }
        return stringArray;
    }

    protected static boolean isAndroidLibraryClass(@NotNull String qualifiedClassName) {
        if (qualifiedClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedClassName", "org/jetbrains/android/facet/SimpleClassMapConstructor", "isAndroidLibraryClass"));
        }
        String[] ar = qualifiedClassName.split("\\.");
        return ar.length < 0 || ar[0].equals("android");
    }

    @Nullable
    public static PsiClass findClassByTagName(@NotNull AndroidFacet facet, @NotNull String name, @NotNull PsiClass baseClass) {
        PsiClass[] classes;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/SimpleClassMapConstructor", "findClassByTagName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/facet/SimpleClassMapConstructor", "findClassByTagName"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/android/facet/SimpleClassMapConstructor", "findClassByTagName"));
        }
        Module module = facet.getModule();
        Project project = module.getProject();
        if (!name.contains(".")) {
            PsiClass[] classes2;
            for (PsiClass aClass : classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(name, module.getModuleWithLibrariesScope())) {
                String qName = aClass.getQualifiedName();
                if (qName == null || !SimpleClassMapConstructor.isAndroidLibraryClass(qName) || !aClass.isInheritor(baseClass, true)) continue;
                return aClass;
            }
            return null;
        }
        for (PsiClass aClass : classes = JavaPsiFacade.getInstance((Project)project).findClasses(name, module.getModuleWithDependenciesAndLibrariesScope(false))) {
            if (!aClass.isInheritor(baseClass, true)) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    public static PsiClass findClassByTagName(@NotNull AndroidFacet facet, @NotNull String name, @NotNull String baseClassQName) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/SimpleClassMapConstructor", "findClassByTagName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/facet/SimpleClassMapConstructor", "findClassByTagName"));
        }
        if (baseClassQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassQName", "org/jetbrains/android/facet/SimpleClassMapConstructor", "findClassByTagName"));
        }
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)facet.getModule().getProject()).findClass(baseClassQName, facet.getModule().getModuleWithLibrariesScope());
        return baseClass != null ? SimpleClassMapConstructor.findClassByTagName(facet, name, baseClass) : null;
    }

    private static class SimpleClassMapConstructorHolder {
        private static final SimpleClassMapConstructor INSTANCE = new SimpleClassMapConstructor();

        private SimpleClassMapConstructorHolder() {
        }
    }
}

