/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.importDependencies.ModuleProvidingTask;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

class CreateNewModuleTask
extends ModuleProvidingTask {
    private final Project myProject;
    private final VirtualFile myContentRoot;

    public CreateNewModuleTask(@NotNull Project project, @NotNull VirtualFile contentRoot) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/importDependencies/CreateNewModuleTask", "<init>"));
        }
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "org/jetbrains/android/importDependencies/CreateNewModuleTask", "<init>"));
        }
        this.myContentRoot = contentRoot;
        this.myProject = project;
    }

    @Override
    public Exception perform() {
        Module depModule = (Module)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Module>(){

            public Module compute() {
                Module depModule = ModuleManager.getInstance((Project)CreateNewModuleTask.this.myProject).newModule(CreateNewModuleTask.this.myContentRoot.getPath() + '/' + CreateNewModuleTask.this.myContentRoot.getName() + ".iml", StdModuleTypes.JAVA.getId());
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)depModule).getModifiableModel();
                model.addContentEntry(CreateNewModuleTask.this.myContentRoot);
                model.commit();
                return depModule;
            }
        });
        if (AndroidFacet.getInstance(depModule) == null) {
            AndroidUtils.addAndroidFacetInWriteAction(depModule, this.myContentRoot, true);
        }
        AndroidSdkUtils.setupAndroidPlatformIfNecessary(depModule, false);
        this.setDepModule(depModule);
        return null;
    }

    @Override
    @NotNull
    public String getTitle() {
        String contentRootPath = FileUtil.toSystemDependentName((String)this.myContentRoot.getPath());
        String string = AndroidBundle.message("android.import.dependencies.new.module.task.title", this.getModuleName(), contentRootPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/importDependencies/CreateNewModuleTask", "getTitle"));
        }
        return string;
    }

    @Override
    public String getModuleName() {
        return this.myContentRoot.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateNewModuleTask that = (CreateNewModuleTask)o;
        if (!this.myContentRoot.equals(that.myContentRoot)) {
            return false;
        }
        return this.myProject.equals(that.myProject);
    }

    public int hashCode() {
        int result = this.myProject.hashCode();
        result = 31 * result + this.myContentRoot.hashCode();
        return result;
    }

    @Override
    @NotNull
    public VirtualFile getContentRoot() {
        VirtualFile virtualFile = this.myContentRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/importDependencies/CreateNewModuleTask", "getContentRoot"));
        }
        return virtualFile;
    }
}

