/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.utils.Pair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MoveToDebugManifestQuickFix
implements AndroidLintQuickFix {
    MoveToDebugManifestQuickFix() {
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag parent;
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/MoveToDebugManifestQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/MoveToDebugManifestQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/MoveToDebugManifestQuickFix", "apply"));
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class);
        if (attribute != null && (parent = attribute.getParent()) != null && parent.getName().equals("uses-permission")) {
            AndroidFacet facet;
            Module module = MoveToDebugManifestQuickFix.getModule((PsiElement)parent);
            assert ("android.permission.ACCESS_MOCK_LOCATION".equals(parent.getAttributeValue("name", "http://schemas.android.com/apk/res/android")));
            parent.delete();
            if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
                VirtualFile mainManifest = facet.getMainIdeaSourceProvider().getManifestFile();
                IdeaAndroidProject project = facet.getIdeaAndroidProject();
                if (project != null && mainManifest != null && mainManifest.getParent() != null && mainManifest.getParent().getParent() != null) {
                    VirtualFile src = mainManifest.getParent().getParent();
                    for (BuildTypeContainer container : project.getDelegate().getBuildTypes()) {
                        BuildType buildType = container.getBuildType();
                        if (!buildType.isDebuggable()) continue;
                        this.addManifest(module, src, buildType.getName());
                        return;
                    }
                    Messages.showErrorDialog((Project)module.getProject(), (String)"Did not find a debug build type", (String)"Move Permission");
                }
            }
        }
    }

    private void addManifest(@NotNull Module module, final @NotNull VirtualFile src, final @NotNull String buildTypeName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/inspections/lint/MoveToDebugManifestQuickFix", "addManifest"));
        }
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "org/jetbrains/android/inspections/lint/MoveToDebugManifestQuickFix", "addManifest"));
        }
        if (buildTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTypeName", "org/jetbrains/android/inspections/lint/MoveToDebugManifestQuickFix", "addManifest"));
        }
        Project project = module.getProject();
        final VirtualFile manifest = src.findFileByRelativePath(buildTypeName + '/' + "AndroidManifest.xml");
        Pair result = (Pair)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Pair<String, VirtualFile>>(){

            public Pair<String, VirtualFile> compute() {
                String text;
                int index;
                if (manifest == null) {
                    try {
                        VirtualFile newParentFolder = src.findChild(buildTypeName);
                        if (newParentFolder == null && (newParentFolder = src.createChildDirectory((Object)this, buildTypeName)) == null) {
                            String message = String.format("Could not create folder %1$s in %2$s", buildTypeName, src.getPath());
                            return Pair.of((Object)message, null);
                        }
                        VirtualFile newFile = newParentFolder.createChildData((Object)this, "AndroidManifest.xml");
                        String text2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <uses-permission android:name=\"android.permission.ACCESS_MOCK_LOCATION\" />\n</manifest>\n";
                        VfsUtil.saveText((VirtualFile)newFile, (String)text2);
                        return Pair.of(null, (Object)newFile);
                    }
                    catch (IOException e) {
                        String message = String.format("Failed to create file: %1$s", e.getMessage());
                        return Pair.of((Object)message, null);
                    }
                }
                Document document = FileDocumentManager.getInstance().getDocument(manifest);
                if (document != null && (index = (text = document.getText()).lastIndexOf("</manifest>")) != -1) {
                    document.insertString(index, (CharSequence)"    <uses-permission android:name=\"android.permission.ACCESS_MOCK_LOCATION\" />\n");
                    return Pair.of(null, (Object)manifest);
                }
                return Pair.of((Object)("Could not add to " + VfsUtilCore.virtualToIoFile((VirtualFile)manifest)), null);
            }
        });
        String error = (String)result.getFirst();
        VirtualFile newFile = (VirtualFile)result.getSecond();
        if (error != null) {
            Messages.showErrorDialog((Project)project, (String)error, (String)"Move Permission");
        } else {
            TemplateUtils.openEditor(project, newFile);
            TemplateUtils.selectEditor(project, newFile);
        }
    }

    @Nullable
    private static Module getModule(PsiElement element) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        return index.getModuleForFile(element.getContainingFile().getVirtualFile());
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/MoveToDebugManifestQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/MoveToDebugManifestQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "org/jetbrains/android/inspections/lint/MoveToDebugManifestQuickFix", "isApplicable"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class) != null;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Move to debug-specific manifest" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/MoveToDebugManifestQuickFix", "getName"));
        }
        return "Move to debug-specific manifest";
    }
}

