/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.logcat;

import com.android.ddmlib.Log;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.logcat.AndroidConfiguredLogFilters;
import org.jetbrains.android.logcat.AndroidLogcatFormatter;
import org.jetbrains.android.logcat.AndroidLogcatReceiver;
import org.jetbrains.android.logcat.AndroidLogcatView;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditLogFilterDialog
extends DialogWrapper {
    @NonNls
    private static final Key<JComponent> OWNER = new Key("Owner");
    private static final String NEW_FILTER_NAME_PREFIX = "Unnamed-";
    @NonNls
    private static final String EDIT_FILTER_DIALOG_DIMENSIONS_KEY = "edit.logcat.filter.dialog.dimensions";
    private final Splitter mySplitter;
    private JPanel myContentPanel;
    private JPanel myLeftPanel;
    private EditorTextField myFilterNameField;
    private EditorTextField myLogMessageField;
    private TextFieldWithAutoCompletion myTagField;
    private TextFieldWithAutoCompletion myPidField;
    private TextFieldWithAutoCompletion myPackageNameField;
    private JComboBox myLogLevelCombo;
    private JPanel myTagFieldWrapper;
    private JPanel myPidFieldWrapper;
    private JPanel myPackageNameFieldWrapper;
    private JBLabel myNameFieldLabel;
    private JBLabel myLogTagLabel;
    private JBLabel myLogMessageLabel;
    private JBLabel myPidLabel;
    private JBLabel myPackageNameLabel;
    private JBList myFiltersList;
    private CollectionListModel<String> myFiltersListModel;
    private AndroidConfiguredLogFilters.MyFilterEntry mySelectedEntry;
    private final List<AndroidConfiguredLogFilters.MyFilterEntry> myFilterEntries;
    private JPanel myFiltersToolbarPanel;
    private final AndroidLogcatView myView;
    private final Project myProject;
    private boolean myExistingMessagesParsed;
    private String[] myUsedTags;
    private String[] myUsedPids;
    private String[] myUsedPackageNames;

    protected EditLogFilterDialog(@NotNull AndroidLogcatView view, @Nullable String selectedFilter) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "org/jetbrains/android/logcat/EditLogFilterDialog", "<init>"));
        }
        super(view.getProject(), false);
        this.myExistingMessagesParsed = false;
        this.myView = view;
        this.$$$setupUI$$$();
        this.myProject = view.getProject();
        this.mySplitter = new Splitter(false, 0.25f);
        this.mySplitter.setFirstComponent((JComponent)this.myLeftPanel);
        this.mySplitter.setSecondComponent((JComponent)this.myContentPanel);
        this.myFilterEntries = AndroidConfiguredLogFilters.getInstance(this.myProject).getFilterEntries();
        if (selectedFilter != null) {
            for (AndroidConfiguredLogFilters.MyFilterEntry fe : this.myFilterEntries) {
                if (!selectedFilter.equals(fe.getName())) continue;
                this.mySelectedEntry = fe;
            }
        }
        if (this.mySelectedEntry == null) {
            this.mySelectedEntry = this.myFilterEntries.isEmpty() ? this.createNewFilterEntry() : this.myFilterEntries.get(0);
        }
        this.createEditorFields();
        this.initFiltersToolbar();
        this.initFiltersList();
        this.updateConfiguredFilters();
        this.init();
    }

    @Nullable
    @NonNls
    protected String getDimensionServiceKey() {
        return EDIT_FILTER_DIALOG_DIMENSIONS_KEY;
    }

    private void createEditorFields() {
        this.myNameFieldLabel.setLabelFor((Component)this.myFilterNameField);
        this.myLogMessageLabel.setLabelFor((Component)this.myLogMessageField);
        this.myTagField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null){

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                EditLogFilterDialog.this.parseExistingMessagesIfNecessary();
                this.setItems(Arrays.asList(EditLogFilterDialog.this.myUsedTags));
                Collection collection = super.getItems(prefix, cached, parameters);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/EditLogFilterDialog$1", "getItems"));
                }
                return collection;
            }
        }, true, null);
        this.myTagFieldWrapper.add((Component)this.myTagField);
        this.myLogTagLabel.setLabelFor((Component)this.myTagField);
        this.myPidField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null){

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                EditLogFilterDialog.this.parseExistingMessagesIfNecessary();
                this.setItems(Arrays.asList(EditLogFilterDialog.this.myUsedPids));
                Collection collection = super.getItems(prefix, cached, parameters);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/EditLogFilterDialog$2", "getItems"));
                }
                return collection;
            }

            public int compare(String item1, String item2) {
                int pid1 = Integer.parseInt(item1);
                int pid2 = Integer.parseInt(item2);
                return Comparing.compare((int)pid1, (int)pid2);
            }
        }, true, null);
        this.myPidFieldWrapper.add((Component)this.myPidField);
        this.myPidLabel.setLabelFor((Component)this.myPidField);
        this.myPackageNameField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null){

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                EditLogFilterDialog.this.parseExistingMessagesIfNecessary();
                this.setItems(Arrays.asList(EditLogFilterDialog.this.myUsedPackageNames));
                Collection collection = super.getItems(prefix, cached, parameters);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/EditLogFilterDialog$3", "getItems"));
                }
                return collection;
            }
        }, true, null);
        this.myPackageNameFieldWrapper.add((Component)this.myPackageNameField);
        this.myPackageNameLabel.setLabelFor((Component)this.myPackageNameField);
        this.myLogLevelCombo.setModel(new EnumComboBoxModel(Log.LogLevel.class));
        this.myLogLevelCombo.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(StringUtil.capitalize((String)((Log.LogLevel)value).getStringValue().toLowerCase()));
                }
            }
        });
        this.myLogLevelCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditLogFilterDialog.this.mySelectedEntry == null) {
                    return;
                }
                Log.LogLevel selectedItem = (Log.LogLevel)EditLogFilterDialog.this.myLogLevelCombo.getSelectedItem();
                EditLogFilterDialog.this.mySelectedEntry.setLogLevel(selectedItem.getStringValue());
            }
        });
        this.myFilterNameField.getDocument().putUserData(OWNER, (Object)this.myFilterNameField);
        this.myTagField.getDocument().putUserData(OWNER, (Object)this.myTagField);
        this.myLogMessageField.getDocument().putUserData(OWNER, (Object)this.myLogMessageField);
        this.myPidField.getDocument().putUserData(OWNER, (Object)this.myPidField);
        this.myPackageNameField.getDocument().putUserData(OWNER, (Object)this.myPackageNameField);
        DocumentAdapter l = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (EditLogFilterDialog.this.mySelectedEntry == null) {
                    return;
                }
                String text = e.getDocument().getText().trim();
                JComponent src = (JComponent)e.getDocument().getUserData(OWNER);
                if (src == EditLogFilterDialog.this.myTagField) {
                    EditLogFilterDialog.this.mySelectedEntry.setLogTagPattern(text);
                } else if (src == EditLogFilterDialog.this.myPidField) {
                    EditLogFilterDialog.this.mySelectedEntry.setPid(text);
                } else if (src == EditLogFilterDialog.this.myPackageNameField) {
                    EditLogFilterDialog.this.mySelectedEntry.setPackageNamePattern(text);
                } else if (src == EditLogFilterDialog.this.myLogMessageField) {
                    EditLogFilterDialog.this.mySelectedEntry.setLogMessagePattern(text);
                } else if (src == EditLogFilterDialog.this.myFilterNameField) {
                    int index = EditLogFilterDialog.this.myFiltersList.getSelectedIndex();
                    if (index != -1) {
                        EditLogFilterDialog.this.myFiltersListModel.setElementAt((Object)text, index);
                    }
                    EditLogFilterDialog.this.mySelectedEntry.setName(text);
                }
            }
        };
        this.myFilterNameField.getDocument().addDocumentListener((DocumentListener)l);
        this.myTagField.getDocument().addDocumentListener((DocumentListener)l);
        this.myLogMessageField.getDocument().addDocumentListener((DocumentListener)l);
        this.myPidField.getDocument().addDocumentListener((DocumentListener)l);
        this.myPackageNameField.getDocument().addDocumentListener((DocumentListener)l);
    }

    private void initFiltersList() {
        this.myFiltersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int i = EditLogFilterDialog.this.myFiltersList.getSelectedIndex();
                EditLogFilterDialog.this.mySelectedEntry = i == -1 ? null : (AndroidConfiguredLogFilters.MyFilterEntry)EditLogFilterDialog.this.myFilterEntries.get(i);
                EditLogFilterDialog.this.resetFieldEditors();
            }
        });
        this.myFiltersListModel = new CollectionListModel((Object[])new String[0]);
        for (AndroidConfiguredLogFilters.MyFilterEntry entry : this.myFilterEntries) {
            this.myFiltersListModel.add((Object)entry.getName());
        }
        this.myFiltersList.setModel(this.myFiltersListModel);
        this.myFiltersList.setEmptyText(AndroidBundle.message("android.logcat.edit.filter.dialog.no.filters", new Object[0]));
    }

    private void initFiltersToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new MyAddFilterAction());
        group.add((AnAction)new MyRemoveFilterAction());
        JComponent component = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        this.myFiltersToolbarPanel.add((Component)component, "Center");
    }

    private void parseExistingMessagesIfNecessary() {
        String[] lines;
        if (this.myExistingMessagesParsed) {
            return;
        }
        this.myExistingMessagesParsed = true;
        StringBuffer document = this.myView.getLogConsole().getOriginalDocument();
        if (document == null) {
            return;
        }
        HashSet tagSet = new HashSet();
        HashSet pidSet = new HashSet();
        HashSet pkgSet = new HashSet();
        for (String line : lines = StringUtil.splitByLines((String)document.toString())) {
            String pkg;
            Pair<AndroidLogcatReceiver.LogMessageHeader, String> result = AndroidLogcatFormatter.parseMessage(line);
            if (result.getFirst() == null) continue;
            String tag = ((AndroidLogcatReceiver.LogMessageHeader)result.getFirst()).myTag;
            if (StringUtil.isNotEmpty((String)tag)) {
                tagSet.add(tag);
            }
            if (StringUtil.isNotEmpty((String)(pkg = ((AndroidLogcatReceiver.LogMessageHeader)result.getFirst()).myAppPackage))) {
                pkgSet.add(pkg);
            }
            pidSet.add(Integer.toString(((AndroidLogcatReceiver.LogMessageHeader)result.getFirst()).myPid));
        }
        this.myUsedTags = tagSet.toArray(new String[tagSet.size()]);
        this.myUsedPids = pidSet.toArray(new String[pidSet.size()]);
        this.myUsedPackageNames = pkgSet.toArray(new String[pkgSet.size()]);
    }

    private void resetFieldEditors() {
        boolean enabled = this.mySelectedEntry != null;
        this.myFilterNameField.setEnabled(enabled);
        this.myTagField.setEnabled(enabled);
        this.myLogMessageField.setEnabled(enabled);
        this.myPidField.setEnabled(enabled);
        this.myPackageNameField.setEnabled(enabled);
        this.myLogLevelCombo.setEnabled(enabled);
        String name = enabled ? this.mySelectedEntry.getName() : "";
        String tag = enabled ? this.mySelectedEntry.getLogTagPattern() : "";
        String msg = enabled ? this.mySelectedEntry.getLogMessagePattern() : "";
        String pid = enabled ? this.mySelectedEntry.getPid() : "";
        String pkg = enabled ? this.mySelectedEntry.getPackageNamePattern() : "";
        Log.LogLevel logLevel = enabled ? Log.LogLevel.getByString((String)this.mySelectedEntry.getLogLevel()) : Log.LogLevel.VERBOSE;
        this.myFilterNameField.setText(name != null ? name : "");
        this.myTagField.setText(tag != null ? tag : "");
        this.myLogMessageField.setText(msg != null ? msg : "");
        this.myPidField.setText(pid != null ? pid : "");
        this.myPackageNameField.setText(pkg != null ? pkg : "");
        this.myLogLevelCombo.setSelectedItem(logLevel != null ? logLevel : Log.LogLevel.VERBOSE);
    }

    protected JComponent createCenterPanel() {
        return this.mySplitter;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFilterNameField.getText().length() == 0 ? this.myFilterNameField : this.myTagField;
    }

    protected void doOKAction() {
        AndroidConfiguredLogFilters.getInstance(this.myProject).setFilterEntries(this.myFilterEntries);
        super.doOKAction();
    }

    protected ValidationInfo doValidate() {
        if (!this.myFilterNameField.isEnabled()) {
            return null;
        }
        String name = this.myFilterNameField.getText().trim();
        if (name.isEmpty()) {
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.name.not.specified.error", new Object[0]), (JComponent)this.myFilterNameField);
        }
        if (name.equals(AndroidLogcatView.NO_FILTERS) || name.equals(AndroidLogcatView.SELECTED_APP_FILTER) || name.equals(AndroidLogcatView.EDIT_FILTER_CONFIGURATION)) {
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.name.busy.error", name));
        }
        AndroidConfiguredLogFilters.MyFilterEntry entry = AndroidConfiguredLogFilters.getInstance(this.myView.getProject()).findFilterEntryByName(name);
        if (entry != null && entry != this.mySelectedEntry) {
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.name.busy.error", name));
        }
        ValidationInfo info = EditLogFilterDialog.validatePattern(this.myTagField.getText().trim(), AndroidBundle.message("android.logcat.new.filter.dialog.incorrect.log.tag.pattern.error", new Object[0]));
        if (info != null) {
            return info;
        }
        info = EditLogFilterDialog.validatePattern(this.myLogMessageField.getText().trim(), AndroidBundle.message("android.logcat.new.filter.dialog.incorrect.message.pattern.error", new Object[0]));
        if (info != null) {
            return info;
        }
        info = EditLogFilterDialog.validatePattern(this.myPackageNameField.getText().trim(), AndroidBundle.message("android.logcat.new.filter.dialog.incorrect.application.name.pattern.error", new Object[0]));
        if (info != null) {
            return info;
        }
        boolean validPid = false;
        try {
            Integer pid;
            String pidStr = this.myPidField.getText().trim();
            Integer n = pid = pidStr.length() > 0 ? Integer.valueOf(Integer.parseInt(pidStr)) : null;
            if (pid == null || pid >= 0) {
                validPid = true;
            }
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        if (!validPid) {
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.incorrect.pid.error", new Object[0]));
        }
        return null;
    }

    private static ValidationInfo validatePattern(String pattern, String errorMessage) {
        try {
            if (!pattern.isEmpty()) {
                Pattern.compile(pattern, AndroidConfiguredLogFilters.getPatternCompileFlags(pattern));
            }
            return null;
        }
        catch (PatternSyntaxException e) {
            String message = e.getMessage();
            return new ValidationInfo(errorMessage + (message != null ? '\n' + message : ""));
        }
    }

    @Nullable
    public AndroidConfiguredLogFilters.MyFilterEntry getCustomLogFiltersEntry() {
        return this.mySelectedEntry;
    }

    private void updateConfiguredFilters() {
        this.myFiltersList.setEnabled(this.myFilterEntries.size() > 0);
        if (this.mySelectedEntry != null) {
            this.myFiltersList.setSelectedValue((Object)this.mySelectedEntry.getName(), true);
        } else if (!this.myFilterEntries.isEmpty()) {
            this.myFiltersList.setSelectedIndex(0);
        }
        this.resetFieldEditors();
    }

    private AndroidConfiguredLogFilters.MyFilterEntry createNewFilterEntry() {
        AndroidConfiguredLogFilters.MyFilterEntry entry = new AndroidConfiguredLogFilters.MyFilterEntry();
        this.myFilterEntries.add(entry);
        entry.setName(this.getUniqueName());
        return entry;
    }

    private String getUniqueName() {
        HashSet names = new HashSet(this.myFilterEntries.size());
        for (AndroidConfiguredLogFilters.MyFilterEntry fe : this.myFilterEntries) {
            names.add(fe.getName());
        }
        int i = 0;
        String n;
        while (names.contains(n = NEW_FILTER_NAME_PREFIX + i)) {
            ++i;
        }
        return n;
    }

    private String getSelectedFilterName() {
        return (String)this.myFiltersList.getSelectedValue();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBList jBList;
        JPanel jPanel2;
        EditorTextField editorTextField;
        EditorTextField editorTextField2;
        JPanel jPanel3;
        JBLabel jBLabel;
        JPanel jPanel4;
        JPanel jPanel5;
        JComboBox jComboBox;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JPanel jPanel6;
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(30);
        this.myContentPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 8, 2, 0, 3, 3, 3, null, null, null));
        this.myNameFieldLabel = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.name.label"));
        jPanel7.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLogTagLabel = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.tag.label"));
        jPanel7.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLogMessageLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.message.label"));
        jPanel7.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPidLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.pid.label"));
        jPanel7.add((Component)jBLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.log.level.label"));
        jPanel7.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLogLevelCombo = jComboBox = new JComboBox();
        jPanel7.add(jComboBox, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myTagFieldWrapper = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel5, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPidFieldWrapper = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel4, new GridConstraints(5, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPackageNameLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.package.name.label"));
        jPanel7.add((Component)jBLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageNameFieldWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel3, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.logcat.dialog.label"));
        jPanel7.add((Component)jBLabel6, new GridConstraints(1, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        this.myFilterNameField = editorTextField2 = new EditorTextField();
        jPanel7.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myLogMessageField = editorTextField = new EditorTextField();
        jPanel7.add((Component)editorTextField, new GridConstraints(3, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myLeftPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 3), 0, 1, false, false));
        jSplitPane.setLeftComponent(jPanel2);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, new Dimension(100, -1), null, null));
        this.myFiltersList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        this.myFiltersToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyRemoveFilterAction
    extends AnAction {
        private MyRemoveFilterAction() {
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), AndroidBundle.message("android.logcat.remove.logcat.filter.button", new Object[0]), IconUtil.getRemoveIcon());
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(EditLogFilterDialog.this.getSelectedFilterName() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            int i = EditLogFilterDialog.this.myFiltersList.getSelectedIndex();
            EditLogFilterDialog.this.myFilterEntries.remove(i);
            EditLogFilterDialog.this.myFiltersListModel.remove(i);
            EditLogFilterDialog.this.mySelectedEntry = null;
            if (EditLogFilterDialog.this.myFilterEntries.size() > 0) {
                if (i >= EditLogFilterDialog.this.myFilterEntries.size()) {
                    i = EditLogFilterDialog.this.myFilterEntries.size() - 1;
                }
                EditLogFilterDialog.this.mySelectedEntry = (AndroidConfiguredLogFilters.MyFilterEntry)EditLogFilterDialog.this.myFilterEntries.get(i);
            }
            EditLogFilterDialog.this.updateConfiguredFilters();
        }
    }

    private class MyAddFilterAction
    extends AnAction {
        private MyAddFilterAction() {
            super(CommonBundle.message((String)"button.add", (Object[])new Object[0]), AndroidBundle.message("android.logcat.add.logcat.filter.button", new Object[0]), IconUtil.getAddIcon());
        }

        public void actionPerformed(AnActionEvent e) {
            EditLogFilterDialog.this.mySelectedEntry = EditLogFilterDialog.this.createNewFilterEntry();
            EditLogFilterDialog.this.myFiltersListModel.add((Object)EditLogFilterDialog.this.mySelectedEntry.getName());
            EditLogFilterDialog.this.updateConfiguredFilters();
        }
    }
}

