/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.resourceManagers.ValueResourceInfoBase;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class IdResourceInfo
extends ValueResourceInfoBase {
    private final Project myProject;

    IdResourceInfo(@NotNull String name, @NotNull VirtualFile file, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/resourceManagers/IdResourceInfo", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/resourceManagers/IdResourceInfo", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/resourceManagers/IdResourceInfo", "<init>"));
        }
        super(name, ResourceType.ID, file);
        this.myProject = project;
    }

    @Override
    public XmlAttributeValue computeXmlElement() {
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        final Ref result = Ref.create();
        psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                String idInAttr;
                if (!result.isNull()) {
                    return;
                }
                if (AndroidResourceUtil.isIdDeclaration(attributeValue) && IdResourceInfo.this.myName.equals(idInAttr = AndroidResourceUtil.getResourceNameByReferenceText(attributeValue.getValue()))) {
                    result.set((Object)attributeValue);
                }
            }
        });
        return (XmlAttributeValue)result.get();
    }

    @Override
    protected int getSortingRank() {
        return 0;
    }
}

