/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.android.actions.RunAndroidAvdManagerAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AvdComboBox
extends ComboboxWithBrowseButton {
    private final boolean myAddEmptyElement;
    private final boolean myShowNotLaunchedOnly;
    private final Alarm myAlarm = new Alarm((Disposable)this);
    private IdDisplay[] myOldAvds = new IdDisplay[0];
    private final Project myProject;

    public AvdComboBox(@Nullable Project project, boolean addEmptyElement, boolean showNotLaunchedOnly) {
        this.myProject = project;
        this.myAddEmptyElement = addEmptyElement;
        this.myShowNotLaunchedOnly = showNotLaunchedOnly;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidPlatform platform = AvdComboBox.this.findAndroidPlatform();
                AvdComboBox avdComboBox = AvdComboBox.this;
                if (platform == null) {
                    Messages.showErrorDialog((Component)((Object)avdComboBox), (String)"Cannot find any configured Android SDK");
                    return;
                }
                RunAndroidAvdManagerAction action = new RunAndroidAvdManagerAction();
                action.openAvdManager(AvdComboBox.this.myProject);
                AvdInfo selected = action.getSelected();
                if (selected != null) {
                    AvdComboBox.this.getComboBox().setSelectedItem(new IdDisplay(selected.getName(), ""));
                }
            }
        });
        this.setMinimumSize(new Dimension(100, this.getMinimumSize().height));
    }

    public void startUpdatingAvds(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "org/jetbrains/android/run/AvdComboBox", "startUpdatingAvds"));
        }
        if (!this.getComboBox().isPopupVisible()) {
            this.doUpdateAvds();
        }
        this.addUpdatingRequest(modalityState);
    }

    private void addUpdatingRequest(final @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "org/jetbrains/android/run/AvdComboBox", "addUpdatingRequest"));
        }
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                AvdComboBox.this.startUpdatingAvds(modalityState);
            }
        }, 500, modalityState);
    }

    public void dispose() {
        this.myAlarm.cancelAllRequests();
        super.dispose();
    }

    private void doUpdateAvds() {
        Object[] newAvds;
        Module module = this.getModule();
        if (module == null || module.isDisposed()) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            AndroidDebugBridge debugBridge;
            HashSet filteringSet = new HashSet();
            if (this.myShowNotLaunchedOnly && (debugBridge = AndroidSdkUtils.getDebugBridge(facet.getModule().getProject())) != null) {
                for (IDevice iDevice : debugBridge.getDevices()) {
                    String avdName = iDevice.getAvdName();
                    if (avdName == null || avdName.length() <= 0) continue;
                    filteringSet.add(avdName);
                }
            }
            ArrayList<IdDisplay> newAvdList = new ArrayList<IdDisplay>();
            if (this.myAddEmptyElement) {
                newAvdList.add(new IdDisplay("", ""));
            }
            for (IDevice iDevice : facet.getAllAvds()) {
                String avdName;
                String displayName = (String)iDevice.getProperties().get("avd.ini.displayname");
                String string = avdName = displayName == null || displayName.isEmpty() ? iDevice.getName() : displayName;
                if (filteringSet.contains(avdName)) continue;
                newAvdList.add(new IdDisplay(iDevice.getName(), avdName));
            }
            newAvds = (IdDisplay[])ArrayUtil.toObjectArray(newAvdList, IdDisplay.class);
        } else {
            newAvds = new IdDisplay[]{};
        }
        if (!Arrays.equals(this.myOldAvds, newAvds)) {
            this.myOldAvds = newAvds;
            Object selected = this.getComboBox().getSelectedItem();
            this.getComboBox().setModel(new DefaultComboBoxModel<Object>(newAvds));
            this.getComboBox().setSelectedItem(selected);
        }
    }

    @Nullable
    public abstract Module getModule();

    @Nullable
    private AndroidPlatform findAndroidPlatform() {
        AndroidPlatform platform = this.findAndroidPlatformFromModule();
        if (platform != null) {
            return platform;
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            platform = AndroidPlatform.getInstance(sdk);
            if (platform == null) continue;
            return platform;
        }
        return null;
    }

    @Nullable
    private AndroidPlatform findAndroidPlatformFromModule() {
        Module module = this.getModule();
        return module != null ? AndroidPlatform.getInstance(module) : null;
    }
}

