/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.run.CloudConfigurationProvider;
import com.android.tools.idea.run.LaunchCompatibility;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.UsesFeature;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.DeviceChooserListener;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceChooser
implements Disposable {
    private static final String[] COLUMN_TITLES = new String[]{"Device", "Serial Number", "State", "Compatible"};
    private static final int DEVICE_NAME_COLUMN_INDEX = 0;
    private static final int SERIAL_COLUMN_INDEX = 1;
    private static final int DEVICE_STATE_COLUMN_INDEX = 2;
    private static final int COMPATIBILITY_COLUMN_INDEX = 3;
    private static final int REFRESH_INTERVAL_MS = 500;
    public static final IDevice[] EMPTY_DEVICE_ARRAY = new IDevice[0];
    private final List<DeviceChooserListener> myListeners;
    private final Alarm myRefreshingAlarm;
    private final AndroidDebugBridge myBridge;
    private volatile boolean myProcessSelectionFlag;
    private IDevice[] myDisplayedDevices;
    private AtomicReference<IDevice[]> myDetectedDevicesRef;
    private JComponent myPanel;
    private JBTable myDeviceTable;
    private final AndroidFacet myFacet;
    private final Condition<IDevice> myFilter;
    private final AndroidVersion myMinSdkVersion;
    private final IAndroidTarget myProjectTarget;
    private final EnumSet<IDevice.HardwareFeature> myRequiredHardwareFeatures;
    private final CloudConfigurationProvider myCloudConfigurationProvider;
    private int[] mySelectedRows;
    private final Runnable myUpdateRequest;

    public DeviceChooser(boolean multipleSelection, final @NotNull Action okAction, @NotNull AndroidFacet facet, @NotNull IAndroidTarget projectTarget, @Nullable Condition<IDevice> filter) {
        if (okAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okAction", "org/jetbrains/android/run/DeviceChooser", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/DeviceChooser", "<init>"));
        }
        if (projectTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectTarget", "org/jetbrains/android/run/DeviceChooser", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProcessSelectionFlag = true;
        this.myDisplayedDevices = EMPTY_DEVICE_ARRAY;
        this.myDetectedDevicesRef = new AtomicReference<IDevice[]>(EMPTY_DEVICE_ARRAY);
        this.myUpdateRequest = new Runnable(){

            @Override
            public void run() {
                DeviceChooser.this.updateTable();
                DeviceChooser.this.addUpdatingRequest();
            }
        };
        this.myCloudConfigurationProvider = CloudConfigurationProvider.getCloudConfigurationProvider();
        this.myFacet = facet;
        this.myFilter = filter;
        this.myMinSdkVersion = AndroidModuleInfo.get(facet).getRuntimeMinSdkVersion();
        this.myProjectTarget = projectTarget;
        this.myRequiredHardwareFeatures = DeviceChooser.getRequiredHardwareFeatures(ManifestInfo.get(facet.getModule(), true).getRequiredFeatures());
        this.myDeviceTable = new JBTable();
        this.myPanel = ScrollPaneFactory.createScrollPane((Component)this.myDeviceTable);
        this.myPanel.setPreferredSize(new Dimension(450, 220));
        this.myDeviceTable.setModel((TableModel)new MyDeviceTableModel(EMPTY_DEVICE_ARRAY));
        this.myDeviceTable.setSelectionMode(multipleSelection ? 2 : 0);
        this.myDeviceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DeviceChooser.this.myProcessSelectionFlag) {
                    DeviceChooser.this.fireSelectedDevicesChanged();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (DeviceChooser.this.myDeviceTable.isEnabled() && okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myDeviceTable);
        this.myDeviceTable.setDefaultRenderer(LaunchCompatibility.class, (TableCellRenderer)((Object)new LaunchCompatibilityRenderer()));
        this.myDeviceTable.setDefaultRenderer(IDevice.class, (TableCellRenderer)((Object)new DeviceRenderer.DeviceNameRenderer(facet.getAvdManagerSilently())));
        this.myDeviceTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                }
            }
        });
        this.setColumnWidth(this.myDeviceTable, 0, "Samsung Galaxy Nexus Android 4.1 (API 17)");
        this.setColumnWidth(this.myDeviceTable, 1, "0000-0000-00000");
        this.setColumnWidth(this.myDeviceTable, 2, "offline");
        this.setColumnWidth(this.myDeviceTable, 3, "yes");
        this.myDeviceTable.setAutoCreateColumnsFromModel(false);
        this.myDeviceTable.setAutoCreateRowSorter(true);
        this.myRefreshingAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myBridge = AndroidSdkUtils.getDebugBridge(this.myFacet.getModule().getProject());
    }

    private static EnumSet<IDevice.HardwareFeature> getRequiredHardwareFeatures(List<UsesFeature> requiredFeatures) {
        for (UsesFeature feature : requiredFeatures) {
            AndroidAttributeValue<String> name = feature.getName();
            if (name == null || !"android.hardware.type.watch".equals(name.getStringValue())) continue;
            return EnumSet.of(IDevice.HardwareFeature.WATCH);
        }
        return EnumSet.noneOf(IDevice.HardwareFeature.class);
    }

    private void setColumnWidth(JBTable deviceTable, int columnIndex, String sampleText) {
        int width = this.getWidth(deviceTable, sampleText);
        deviceTable.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
    }

    private int getWidth(JBTable deviceTable, String sampleText) {
        FontMetrics metrics = deviceTable.getFontMetrics(deviceTable.getFont());
        return metrics.stringWidth(sampleText);
    }

    public void init(@Nullable String[] selectedSerials) {
        this.updateTable();
        if (selectedSerials != null) {
            this.resetSelection(selectedSerials);
        }
        this.addUpdatingRequest();
    }

    private void addUpdatingRequest() {
        if (this.myRefreshingAlarm.isDisposed()) {
            return;
        }
        this.myRefreshingAlarm.cancelAllRequests();
        this.myRefreshingAlarm.addRequest(this.myUpdateRequest, 500);
    }

    private void resetSelection(@NotNull String[] selectedSerials) {
        if (selectedSerials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedSerials", "org/jetbrains/android/run/DeviceChooser", "resetSelection"));
        }
        MyDeviceTableModel model = (MyDeviceTableModel)this.myDeviceTable.getModel();
        HashSet selectedSerialsSet = new HashSet();
        Collections.addAll(selectedSerialsSet, selectedSerials);
        IDevice[] myDevices = model.myDevices;
        ListSelectionModel selectionModel = this.myDeviceTable.getSelectionModel();
        boolean cleared = false;
        int n = myDevices.length;
        for (int i = 0; i < n; ++i) {
            String serialNumber = myDevices[i].getSerialNumber();
            if (!selectedSerialsSet.contains(serialNumber)) continue;
            if (!cleared) {
                selectionModel.clearSelection();
                cleared = true;
            }
            selectionModel.addSelectionInterval(i, i);
        }
    }

    void updateTable() {
        Object[] devices;
        Object[] objectArray = devices = this.myBridge != null ? this.getFilteredDevices(this.myBridge) : EMPTY_DEVICE_ARRAY;
        if (devices.length > 1) {
            Arrays.sort(devices, new Comparator<IDevice>(){

                @Override
                public int compare(IDevice device1, IDevice device2) {
                    int apiLevel1 = this.safeGetApiLevel(device1);
                    int apiLevel2 = this.safeGetApiLevel(device2);
                    return apiLevel2 - apiLevel1;
                }

                private int safeGetApiLevel(IDevice device) {
                    try {
                        String s = device.getProperty("ro.build.version.sdk");
                        return StringUtil.isNotEmpty((String)s) ? Integer.parseInt(s) : 0;
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
            });
        }
        if (!Arrays.equals(this.myDisplayedDevices, devices)) {
            this.myDetectedDevicesRef.set((IDevice[])devices);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeviceChooser.this.refreshTable();
                }
            }, ModalityState.stateForComponent((Component)this.myDeviceTable));
        }
    }

    private void refreshTable() {
        IDevice[] devices = this.myDetectedDevicesRef.get();
        this.myDisplayedDevices = devices;
        Object[] selectedDevices = this.getSelectedDevices();
        TIntArrayList selectedRows = new TIntArrayList();
        for (int i = 0; i < devices.length; ++i) {
            if (ArrayUtil.indexOf((Object[])selectedDevices, (Object)devices[i]) < 0) continue;
            selectedRows.add(i);
        }
        this.myProcessSelectionFlag = false;
        this.myDeviceTable.setModel((TableModel)new MyDeviceTableModel(devices));
        if (selectedRows.size() == 0 && devices.length > 0) {
            this.myDeviceTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        for (int selectedRow : selectedRows.toNativeArray()) {
            if (selectedRow >= devices.length) continue;
            this.myDeviceTable.getSelectionModel().addSelectionInterval(selectedRow, selectedRow);
        }
        this.fireSelectedDevicesChanged();
        this.myProcessSelectionFlag = true;
    }

    public boolean hasDevices() {
        return this.myDetectedDevicesRef.get().length > 0;
    }

    public JComponent getPreferredFocusComponent() {
        return this.myDeviceTable;
    }

    @Nullable
    public JComponent getPanel() {
        return this.myPanel;
    }

    @NotNull
    public IDevice[] getSelectedDevices() {
        int[] rows = this.mySelectedRows != null ? this.mySelectedRows : this.myDeviceTable.getSelectedRows();
        ArrayList<IDevice> result = new ArrayList<IDevice>();
        block0: for (int row : rows) {
            IDevice[] devices;
            if (row < 0) continue;
            Object serial = this.myDeviceTable.getValueAt(row, 1);
            AndroidDebugBridge bridge = AndroidSdkUtils.getDebugBridge(this.myFacet.getModule().getProject());
            if (bridge == null) {
                if (EMPTY_DEVICE_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/DeviceChooser", "getSelectedDevices"));
                }
                return EMPTY_DEVICE_ARRAY;
            }
            for (IDevice device : devices = this.getFilteredDevices(bridge)) {
                if (!device.getSerialNumber().equals(serial.toString())) continue;
                result.add(device);
                continue block0;
            }
        }
        IDevice[] iDeviceArray = result.toArray(new IDevice[result.size()]);
        if (iDeviceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/DeviceChooser", "getSelectedDevices"));
        }
        return iDeviceArray;
    }

    @NotNull
    private IDevice[] getFilteredDevices(AndroidDebugBridge bridge) {
        ArrayList<IDevice> filteredDevices = new ArrayList<IDevice>();
        for (IDevice device : bridge.getDevices()) {
            if (this.myFilter != null && !this.myFilter.value((Object)device)) continue;
            filteredDevices.add(device);
        }
        if (this.myCloudConfigurationProvider != null) {
            filteredDevices.addAll(this.myCloudConfigurationProvider.getLaunchingCloudDevices());
        }
        IDevice[] iDeviceArray = filteredDevices.toArray(new IDevice[filteredDevices.size()]);
        if (iDeviceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/DeviceChooser", "getFilteredDevices"));
        }
        return iDeviceArray;
    }

    public void finish() {
        this.mySelectedRows = this.myDeviceTable.getSelectedRows();
    }

    public void dispose() {
    }

    public void setEnabled(boolean enabled) {
        this.myDeviceTable.setEnabled(enabled);
    }

    @NotNull
    private static String getDeviceState(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/DeviceChooser", "getDeviceState"));
        }
        IDevice.DeviceState state = device.getState();
        String string = state != null ? StringUtil.capitalize((String)state.name().toLowerCase()) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/DeviceChooser", "getDeviceState"));
        }
        return string;
    }

    public void fireSelectedDevicesChanged() {
        for (DeviceChooserListener listener : this.myListeners) {
            listener.selectedDevicesChanged();
        }
    }

    public void addListener(@NotNull DeviceChooserListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/android/run/DeviceChooser", "addListener"));
        }
        this.myListeners.add(listener);
    }

    private static class LaunchCompatibilityRenderer
    extends ColoredTableCellRenderer {
        private LaunchCompatibilityRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (!(value instanceof LaunchCompatibility)) {
                return;
            }
            LaunchCompatibility compatibility = (LaunchCompatibility)value;
            ThreeState compatible = compatibility.isCompatible();
            if (compatible == ThreeState.YES) {
                this.append("Yes");
            } else {
                if (compatible == ThreeState.NO) {
                    this.append("No", SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    this.append("Maybe");
                }
                String reason = compatibility.getReason();
                if (reason != null) {
                    this.append(", ");
                    this.append(reason);
                }
            }
        }
    }

    private class MyDeviceTableModel
    extends AbstractTableModel {
        private final IDevice[] myDevices;

        public MyDeviceTableModel(IDevice[] devices) {
            this.myDevices = devices;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_TITLES[column];
        }

        @Override
        public int getRowCount() {
            return this.myDevices.length;
        }

        @Override
        public int getColumnCount() {
            return COLUMN_TITLES.length;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.myDevices.length) {
                return null;
            }
            IDevice device = this.myDevices[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return device;
                }
                case 1: {
                    return device.getSerialNumber();
                }
                case 2: {
                    return DeviceChooser.getDeviceState(device);
                }
                case 3: {
                    return LaunchCompatibility.canRunOnDevice(DeviceChooser.this.myMinSdkVersion, DeviceChooser.this.myProjectTarget, DeviceChooser.this.myRequiredHardwareFeatures, device, null);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return LaunchCompatibility.class;
            }
            if (columnIndex == 0) {
                return IDevice.class;
            }
            return String.class;
        }
    }
}

