/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.spellchecker;

import com.android.utils.Pair;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class AndroidTextSpellcheckingStrategy
extends SpellcheckingStrategy {
    private final AtomicReference<Pair<VirtualFile, Boolean>> myLastVirtualFileIgnoredState = new AtomicReference();

    public boolean isMyContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/spellchecker/AndroidTextSpellcheckingStrategy", "isMyContext"));
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return false;
        }
        return this.isIgnored(file.getViewProvider().getVirtualFile());
    }

    private boolean isIgnored(@NotNull VirtualFile virtualFile) {
        String name;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/android/spellchecker/AndroidTextSpellcheckingStrategy", "isIgnored"));
        }
        Pair<VirtualFile, Boolean> pair = this.myLastVirtualFileIgnoredState.get();
        if (pair != null && virtualFile.equals(pair.getFirst())) {
            return Boolean.TRUE == pair.getSecond();
        }
        FileType fileType = virtualFile.getFileType();
        boolean lastIgnore = false;
        if (fileType == FileTypes.PLAIN_TEXT) {
            String name2 = virtualFile.getName();
            if (Comparing.equal((String)name2, (String)"R.txt", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name2, (String)"gradlew", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name2, (String)"gradlew.bat", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name2, (String)"import-summary.txt", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name2, (String)".gitignore", (boolean)SystemInfo.isFileSystemCaseSensitive)) {
                lastIgnore = true;
            }
        } else if (fileType == StdFileTypes.PROPERTIES && (Comparing.equal((String)(name = virtualFile.getName()), (String)"gradle-wrapper.properties", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name, (String)"local.properties", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name, (String)"gradle.properties", (boolean)SystemInfo.isFileSystemCaseSensitive))) {
            lastIgnore = true;
        }
        this.myLastVirtualFileIgnoredState.lazySet((Pair<VirtualFile, Boolean>)Pair.of((Object)virtualFile, (Object)lastIgnore));
        return lastIgnore;
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/spellchecker/AndroidTextSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }
}

