/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.android.uipreview.ColorListener;
import org.jetbrains.android.uipreview.SlideComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorPicker
extends JPanel
implements ColorListener,
DocumentListener {
    private static final String COLOR_CHOOSER_COLORS_KEY = "ColorChooser.RecentColors";
    private static final String HSB_PROPERTY = "color.picker.is.hsb";
    private Color myColor;
    private ColorPreviewComponent myPreviewComponent;
    private final ColorWheelPanel myColorWheelPanel;
    private final JTextField myAlpha;
    private final JTextField myRed;
    private final JTextField myGreen;
    private final JTextField myBlue;
    private final JTextField myHex;
    private final Alarm myUpdateQueue;
    private final ColorPickerListener[] myExternalListeners;
    private final boolean myOpacityInPercent;
    private RecentColorsComponent myRecentColorsComponent;
    private final ColorPipette myPicker;
    private final JLabel myA;
    private final JLabel myR;
    private final JLabel myG;
    private final JLabel myB;
    private final JLabel myR_after;
    private final JLabel myG_after;
    private final JLabel myB_after;
    private final JComboBox myFormat;

    public ColorPicker(@NotNull Disposable parent, @Nullable Color color, boolean enableOpacity, ColorPickerListener ... listeners) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/uipreview/ColorPicker", "<init>"));
        }
        this(parent, color, true, enableOpacity, listeners, false);
    }

    private ColorPicker(Disposable parent, @Nullable Color color, boolean restoreColors, boolean enableOpacity, ColorPickerListener[] listeners, boolean opacityInPercent) {
        Color c;
        this.myA = new JLabel("A:");
        this.myR = new JLabel("R:");
        this.myG = new JLabel("G:");
        this.myB = new JLabel("B:");
        this.myR_after = new JLabel("");
        this.myG_after = new JLabel("");
        this.myB_after = new JLabel("");
        this.myFormat = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                UIManager.LookAndFeelInfo info = LafManager.getInstance().getCurrentLookAndFeel();
                if (info != null && info.getName().contains("Windows")) {
                    size.width += 10;
                }
                return size;
            }
        };
        this.myUpdateQueue = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parent);
        this.myAlpha = this.createColorField(false);
        this.myRed = this.createColorField(false);
        this.myGreen = this.createColorField(false);
        this.myBlue = this.createColorField(false);
        this.myHex = this.createColorField(true);
        this.myOpacityInPercent = opacityInPercent;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{"RGB", "HSB"});
        if (enableOpacity) {
            model.addElement("ARGB");
        }
        this.myFormat.setModel(model);
        this.myColorWheelPanel = new ColorWheelPanel(this, enableOpacity, this.myOpacityInPercent);
        this.myExternalListeners = listeners;
        this.myFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesComponent.getInstance().setValue(ColorPicker.HSB_PROPERTY, String.valueOf(!ColorPicker.this.isRGBMode()));
                ColorPicker.this.myA.setVisible(ColorPicker.this.isARGBMode());
                ColorPicker.this.myAlpha.setVisible(ColorPicker.this.isARGBMode());
                ColorPicker.this.myR.setText(ColorPicker.this.isRGBMode() ? "R:" : "H:");
                ColorPicker.this.myG.setText(ColorPicker.this.isRGBMode() ? "G:" : "S:");
                ColorPicker.this.myR_after.setText(ColorPicker.this.isRGBMode() ? "" : "\u00b0");
                ColorPicker.this.myG.setText(ColorPicker.this.isRGBMode() ? "G:" : "S:");
                ColorPicker.this.myG_after.setText(ColorPicker.this.isRGBMode() ? "" : "%");
                ColorPicker.this.myB_after.setText(ColorPicker.this.isRGBMode() ? "" : "%");
                ColorPicker.this.applyColor(ColorPicker.this.myColor);
                ColorPicker.this.applyColorToHEX(ColorPicker.this.myColor);
            }
        });
        this.myPicker = new ColorPipette(this, this.getColor());
        this.myPicker.setListener(new ColorListener(){

            @Override
            public void colorChanged(Color color, Object source) {
                ColorPicker.this.setColor(color, source);
            }
        });
        try {
            this.add((Component)this.buildTopPanel(true), "North");
            this.add((Component)this.myColorWheelPanel, "Center");
            this.myRecentColorsComponent = new RecentColorsComponent(new ColorListener(){

                @Override
                public void colorChanged(Color color, Object source) {
                    ColorPicker.this.setColor(color, source);
                }
            }, restoreColors);
            this.add((Component)this.myRecentColorsComponent, "South");
        }
        catch (ParseException ignore) {
            // empty catch block
        }
        Color color2 = c = color == null ? this.myRecentColorsComponent.getMostRecentColor() : color;
        if (c == null) {
            c = Color.WHITE;
        }
        this.setColor(c, this);
        this.setSize(300, 350);
        boolean hsb = PropertiesComponent.getInstance().getBoolean(HSB_PROPERTY, false);
        if (hsb) {
            this.myFormat.setSelectedIndex(1);
        }
    }

    private boolean isRGBMode() {
        return this.myFormat.getSelectedIndex() == 0 || this.isARGBMode();
    }

    private boolean isARGBMode() {
        return this.myFormat.getSelectedIndex() == 2;
    }

    public void pickRGB() {
        this.myFormat.setSelectedIndex(0);
    }

    public void pickHSB() {
        this.myFormat.setSelectedIndex(1);
    }

    public void pickARGB() {
        this.myFormat.setSelectedIndex(2);
    }

    private JTextField createColorField(boolean hex) {
        NumberDocument doc = new NumberDocument(hex);
        int lafFix = UIUtil.isUnderWindowsLookAndFeel() || UIUtil.isUnderDarcula() ? 1 : 0;
        UIManager.LookAndFeelInfo info = LafManager.getInstance().getCurrentLookAndFeel();
        if (info != null && (info.getName().startsWith("IDEA") || info.getName().equals("Windows Classic"))) {
            lafFix = 1;
        }
        final JTextField field = new JTextField(doc, "", (hex ? 5 : 2) + lafFix);
        field.setSize(50, -1);
        doc.setSource(field);
        field.getDocument().addDocumentListener(this);
        field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                field.selectAll();
            }
        });
        return field;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHex;
    }

    private void setColor(Color color, Object src) {
        this.colorChanged(color, src);
        this.myColorWheelPanel.setColor(color, src);
    }

    public void appendRecentColor() {
        this.myRecentColorsComponent.appendColor(this.myColor);
    }

    public void saveRecentColors() {
        this.myRecentColorsComponent.saveColors();
    }

    public Color getColor() {
        return this.myColor;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(((NumberDocument)e.getDocument()).mySrc);
    }

    private void update(final JTextField src) {
        this.myUpdateQueue.cancelAllRequests();
        this.myUpdateQueue.addRequest(new Runnable(){

            @Override
            public void run() {
                ColorPicker.this.validateAndUpdatePreview(src);
            }
        }, 300);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(((NumberDocument)e.getDocument()).mySrc);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void validateAndUpdatePreview(JTextField src) {
        Color color;
        if (this.myHex.hasFocus()) {
            if (this.isARGBMode()) {
                String text = this.myHex.getText();
                int rgbIndex = Math.max(0, text.length() - 6);
                String rgb = text.substring(rgbIndex);
                String alphaText = text.substring(0, rgbIndex);
                int alpha = alphaText.isEmpty() ? 255 : Integer.parseInt(alphaText, 16);
                Color c = ColorUtil.fromHex((String)rgb, null);
                color = c != null ? ColorUtil.toAlpha((Color)c, (int)alpha) : null;
            } else {
                Color c = ColorUtil.fromHex((String)this.myHex.getText(), null);
                color = c != null ? ColorUtil.toAlpha((Color)c, (int)this.myColorWheelPanel.myColorWheel.myOpacity) : null;
            }
        } else {
            color = this.gatherRGB();
        }
        if (color != null) {
            if (this.myAlpha.hasFocus()) {
                this.myColorWheelPanel.myOpacityComponent.setValue(color.getAlpha());
                this.myColorWheelPanel.myOpacityComponent.repaint();
            } else if (this.myColorWheelPanel.myOpacityComponent != null && !this.isARGBMode()) {
                color = ColorUtil.toAlpha((Color)color, (int)this.myColorWheelPanel.myOpacityComponent.getValue());
            }
            this.updatePreview(color, src == this.myHex);
        }
    }

    private void updatePreview(Color color, boolean fromHex) {
        if (color != null && !color.equals(this.myColor)) {
            this.myColor = color;
            this.myPreviewComponent.setColor(color);
            this.myColorWheelPanel.setColor(color, fromHex ? this.myHex : null);
            if (fromHex) {
                this.applyColor(color);
            } else {
                this.applyColorToHEX(color);
            }
            this.fireColorChanged(color);
        }
    }

    @Override
    public void colorChanged(Color color, Object source) {
        if (color != null && !color.equals(this.myColor)) {
            this.myColor = color;
            this.applyColor(color);
            if (source != this.myHex) {
                this.applyColorToHEX(color);
            }
            this.myPreviewComponent.setColor(color);
            this.fireColorChanged(color);
        }
    }

    private void fireColorChanged(Color color) {
        if (this.myExternalListeners == null) {
            return;
        }
        for (ColorPickerListener listener : this.myExternalListeners) {
            listener.colorChanged(color);
        }
    }

    private void fireClosed(@Nullable Color color) {
        if (this.myExternalListeners == null) {
            return;
        }
        for (ColorPickerListener listener : this.myExternalListeners) {
            listener.closed(color);
        }
    }

    @Nullable
    private Color gatherRGB() {
        try {
            int r = Integer.parseInt(this.myRed.getText());
            int g = Integer.parseInt(this.myGreen.getText());
            int b = Integer.parseInt(this.myBlue.getText());
            int a = Integer.parseInt(this.myAlpha.getText());
            return this.isRGBMode() ? new Color(r, g, b, a) : new Color(Color.HSBtoRGB((float)r / 360.0f, (float)g / 100.0f, (float)b / 100.0f));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void applyColorToHEX(Color c) {
        if (this.isARGBMode()) {
            this.myHex.setText(String.format("%08X", c.getRGB()));
        } else {
            this.myHex.setText(String.format("%06X", 0xFFFFFF & c.getRGB()));
        }
    }

    private void applyColorToRGB(Color color) {
        this.myAlpha.setText(String.valueOf(color.getAlpha()));
        this.myRed.setText(String.valueOf(color.getRed()));
        this.myGreen.setText(String.valueOf(color.getGreen()));
        this.myBlue.setText(String.valueOf(color.getBlue()));
    }

    private void applyColorToHSB(Color c) {
        this.myAlpha.setText(String.valueOf(c.getAlpha()));
        float[] hbs = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.myRed.setText(String.valueOf((int)(360.0f * hbs[0])));
        this.myGreen.setText(String.valueOf((int)(100.0f * hbs[1])));
        this.myBlue.setText(String.valueOf((int)(100.0f * hbs[2])));
    }

    private void applyColor(Color color) {
        if (this.isRGBMode()) {
            this.applyColorToRGB(color);
        } else {
            this.applyColorToHSB(color);
        }
    }

    @Nullable
    public static Color showDialog(Component parent, String caption, @Nullable Color preselectedColor, boolean enableOpacity, @Nullable ColorPickerListener[] listeners, boolean opacityInPercent) {
        ColorPickerDialog dialog = new ColorPickerDialog(parent, caption, preselectedColor, enableOpacity, listeners, opacityInPercent);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            return dialog.getColor();
        }
        return null;
    }

    private JComponent buildTopPanel(boolean enablePipette) throws ParseException {
        JPanel result = new JPanel(new BorderLayout());
        JPanel previewPanel = new JPanel(new BorderLayout());
        if (enablePipette && ColorPipette.isAvailable()) {
            JButton pipette = new JButton();
            pipette.setUI(new BasicButtonUI());
            pipette.setRolloverEnabled(true);
            pipette.setIcon(AllIcons.Ide.Pipette);
            pipette.setBorder(IdeBorderFactory.createEmptyBorder());
            pipette.setRolloverIcon(AllIcons.Ide.Pipette_rollover);
            pipette.setFocusable(false);
            pipette.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorPicker.this.myPicker.myOldColor = ColorPicker.this.getColor();
                    ColorPicker.this.myPicker.pick();
                }
            });
            previewPanel.add((Component)pipette, "West");
        }
        this.myPreviewComponent = new ColorPreviewComponent();
        previewPanel.add((Component)this.myPreviewComponent, "Center");
        result.add((Component)previewPanel, "North");
        JPanel rgbPanel = new JPanel();
        rgbPanel.setLayout(new BoxLayout(rgbPanel, 0));
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            this.myR_after.setPreferredSize(new Dimension(14, -1));
            this.myG_after.setPreferredSize(new Dimension(14, -1));
            this.myB_after.setPreferredSize(new Dimension(14, -1));
        }
        rgbPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        rgbPanel.add(this.myA);
        rgbPanel.add(this.myAlpha);
        this.myA.setVisible(this.isARGBMode());
        this.myAlpha.setVisible(this.isARGBMode());
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            rgbPanel.add(this.myR_after);
        }
        rgbPanel.add(Box.createHorizontalStrut(2));
        rgbPanel.add(this.myR);
        rgbPanel.add(this.myRed);
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            rgbPanel.add(this.myR_after);
        }
        rgbPanel.add(Box.createHorizontalStrut(2));
        rgbPanel.add(this.myG);
        rgbPanel.add(this.myGreen);
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            rgbPanel.add(this.myG_after);
        }
        rgbPanel.add(Box.createHorizontalStrut(2));
        rgbPanel.add(this.myB);
        rgbPanel.add(this.myBlue);
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            rgbPanel.add(this.myB_after);
        }
        rgbPanel.add(Box.createHorizontalStrut(2));
        rgbPanel.add(this.myFormat);
        result.add((Component)rgbPanel, "West");
        JPanel hexPanel = new JPanel();
        hexPanel.setLayout(new BoxLayout(hexPanel, 0));
        hexPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        hexPanel.add(new JLabel("#"));
        hexPanel.add(this.myHex);
        result.add((Component)hexPanel, "East");
        return result;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorPicker.showDialog(null, "", null, true, null, false);
            }
        });
    }

    private static class ColorPipette
    implements ImageObserver {
        private Dialog myPickerFrame;
        private final JComponent myParent;
        private Color myOldColor;
        private Timer myTimer;
        private Point myPoint = new Point();
        private Point myPickOffset;
        private Robot myRobot = null;
        private Color myPreviousColor;
        private Point myPreviousLocation;
        private Rectangle myCaptureRect;
        private Graphics2D myGraphics;
        private BufferedImage myImage;
        private Point myHotspot;
        private Point myCaptureOffset;
        private BufferedImage myMagnifierImage;
        private Color myTransparentColor = new Color(0, true);
        private Rectangle myZoomRect;
        private Rectangle myGlassRect;
        private ColorListener myColorListener;
        private BufferedImage myMaskImage;
        private Alarm myColorListenersNotifier = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

        private ColorPipette(JComponent parent, Color oldColor) {
            this.myParent = parent;
            this.myOldColor = oldColor;
            try {
                this.myRobot = new Robot();
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }

        public void setListener(ColorListener colorListener) {
            this.myColorListener = colorListener;
        }

        public void pick() {
            Dialog picker = this.getPicker();
            picker.setVisible(true);
            this.myTimer.start();
            WindowManager.getInstance().setAlphaModeRatio((Window)picker, SystemInfo.isMac ? 0.95f : 0.99f);
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
            return false;
        }

        private Dialog getPicker() {
            if (this.myPickerFrame == null) {
                Window owner = SwingUtilities.getWindowAncestor(this.myParent);
                this.myPickerFrame = owner instanceof Dialog ? new JDialog((Dialog)owner) : (owner instanceof Frame ? new JDialog((Frame)owner) : new JDialog(new JFrame()));
                this.myPickerFrame.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        e.consume();
                        ColorPipette.this.pickDone();
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        e.consume();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        ColorPipette.this.updatePipette();
                    }
                });
                this.myPickerFrame.addMouseMotionListener(new MouseAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        ColorPipette.this.updatePipette();
                    }
                });
                this.myPickerFrame.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        ColorPipette.this.cancelPipette();
                    }
                });
                this.myPickerFrame.setSize(50, 50);
                this.myPickerFrame.setUndecorated(true);
                this.myPickerFrame.setAlwaysOnTop(true);
                JRootPane rootPane = ((JDialog)this.myPickerFrame).getRootPane();
                rootPane.putClientProperty("Window.shadow", Boolean.FALSE);
                this.myGlassRect = new Rectangle(0, 0, 32, 32);
                this.myPickOffset = new Point(0, 0);
                this.myCaptureRect = new Rectangle(-4, -4, 8, 8);
                this.myCaptureOffset = new Point(this.myCaptureRect.x, this.myCaptureRect.y);
                this.myHotspot = new Point(14, 16);
                this.myZoomRect = new Rectangle(0, 0, 32, 32);
                this.myMaskImage = UIUtil.createImage((int)32, (int)32, (int)2);
                Graphics2D maskG = this.myMaskImage.createGraphics();
                maskG.setColor(Color.BLUE);
                maskG.fillRect(0, 0, 32, 32);
                maskG.setColor(Color.RED);
                maskG.setComposite(AlphaComposite.SrcOut);
                maskG.fillRect(0, 0, 32, 32);
                maskG.dispose();
                this.myMagnifierImage = UIUtil.createImage((int)32, (int)32, (int)2);
                Graphics2D graphics = this.myMagnifierImage.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                graphics.setColor(Color.BLACK);
                AllIcons.Ide.Pipette.paintIcon(null, graphics, 14, 0);
                graphics.dispose();
                this.myImage = this.myParent.getGraphicsConfiguration().createCompatibleImage(this.myMagnifierImage.getWidth(), this.myMagnifierImage.getHeight(), 3);
                this.myGraphics = (Graphics2D)this.myImage.getGraphics();
                this.myGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                this.myPickerFrame.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        switch (e.getKeyCode()) {
                            case 27: {
                                ColorPipette.this.cancelPipette();
                                break;
                            }
                            case 10: {
                                ColorPipette.this.pickDone();
                            }
                        }
                    }
                });
                this.myTimer = new Timer(5, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ColorPipette.this.updatePipette();
                    }
                });
            }
            return this.myPickerFrame;
        }

        private void cancelPipette() {
            this.myTimer.stop();
            this.myPickerFrame.setVisible(false);
            if (this.myColorListener != null && this.myOldColor != null) {
                this.myColorListener.colorChanged(this.myOldColor, this);
            }
        }

        public void pickDone() {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            Point location = pointerInfo.getLocation();
            Color pixelColor = this.myRobot.getPixelColor(location.x + this.myPickOffset.x, location.y + this.myPickOffset.y);
            this.cancelPipette();
            if (this.myColorListener != null) {
                this.myColorListener.colorChanged(pixelColor, this);
                this.myOldColor = pixelColor;
            }
        }

        private void updatePipette() {
            if (this.myPickerFrame != null && this.myPickerFrame.isShowing()) {
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                Point mouseLoc = pointerInfo.getLocation();
                this.myPickerFrame.setLocation(mouseLoc.x - this.myPickerFrame.getWidth() / 2, mouseLoc.y - this.myPickerFrame.getHeight() / 2);
                this.myPoint.x = mouseLoc.x + this.myPickOffset.x;
                this.myPoint.y = mouseLoc.y + this.myPickOffset.y;
                final Color c = this.myRobot.getPixelColor(this.myPoint.x, this.myPoint.y);
                if (!c.equals(this.myPreviousColor) || !mouseLoc.equals(this.myPreviousLocation)) {
                    this.myPreviousColor = c;
                    this.myPreviousLocation = mouseLoc;
                    this.myCaptureRect.setLocation(mouseLoc.x - 2, mouseLoc.y - 2);
                    this.myCaptureRect.setBounds(mouseLoc.x - 2, mouseLoc.y - 2, 5, 5);
                    BufferedImage capture = this.myRobot.createScreenCapture(this.myCaptureRect);
                    this.myGraphics.setComposite(AlphaComposite.Src);
                    this.myGraphics.setColor(this.myTransparentColor);
                    this.myGraphics.fillRect(0, 0, this.myImage.getWidth(), this.myImage.getHeight());
                    this.myGraphics.drawImage(capture, this.myZoomRect.x, this.myZoomRect.y, this.myZoomRect.width, this.myZoomRect.height, this);
                    this.myGraphics.setComposite(AlphaComposite.getInstance(8));
                    this.myGraphics.drawImage(this.myMaskImage, this.myZoomRect.x, this.myZoomRect.y, this.myZoomRect.width, this.myZoomRect.height, this);
                    this.myGraphics.setComposite(AlphaComposite.SrcOver);
                    this.myGraphics.drawImage((Image)this.myMagnifierImage, 0, 0, this);
                    this.myPickerFrame.setCursor(this.myParent.getToolkit().createCustomCursor(this.myImage, this.myHotspot, "ColorPicker"));
                    if (this.myColorListener != null) {
                        this.myColorListenersNotifier.cancelAllRequests();
                        this.myColorListenersNotifier.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                ColorPipette.this.myColorListener.colorChanged(c, ColorPipette.this);
                            }
                        }, 300);
                    }
                }
            }
        }

        public static boolean isAvailable() {
            try {
                Robot robot = new Robot();
                robot.createScreenCapture(new Rectangle(0, 0, 1, 1));
                return WindowManager.getInstance().isAlphaModeSupported();
            }
            catch (AWTException e) {
                return false;
            }
        }
    }

    public static class ColorWheelImageProducer
    extends MemoryImageSource {
        private int[] myPixels;
        private int myWidth;
        private int myHeight;
        private float myBrightness = 1.0f;
        private float[] myHues;
        private float[] mySat;
        private int[] myAlphas;

        public ColorWheelImageProducer(int w, int h, float brightness) {
            super(w, h, null, 0, w);
            this.myPixels = new int[w * h];
            this.myWidth = w;
            this.myHeight = h;
            this.myBrightness = brightness;
            this.generateLookupTables();
            this.newPixels(this.myPixels, ColorModel.getRGBdefault(), 0, w);
            this.setAnimated(true);
            this.generateColorWheel();
        }

        public int getRadius() {
            return Math.min(this.myWidth, this.myHeight) / 2 - 2;
        }

        private void generateLookupTables() {
            this.mySat = new float[this.myWidth * this.myHeight];
            this.myHues = new float[this.myWidth * this.myHeight];
            this.myAlphas = new int[this.myWidth * this.myHeight];
            float radius = this.getRadius();
            float blend = (radius + 2.0f) / radius - 1.0f;
            int cx = this.myWidth / 2;
            int cy = this.myHeight / 2;
            for (int x = 0; x < this.myWidth; ++x) {
                int kx = x - cx;
                int squarekx = kx * kx;
                for (int y = 0; y < this.myHeight; ++y) {
                    int ky = cy - y;
                    int index = x + y * this.myWidth;
                    this.mySat[index] = (float)Math.sqrt(squarekx + ky * ky) / radius;
                    if (this.mySat[index] <= 1.0f) {
                        this.myAlphas[index] = -16777216;
                    } else {
                        this.myAlphas[index] = (int)((blend - Math.min(blend, this.mySat[index] - 1.0f)) * 255.0f / blend) << 24;
                        this.mySat[index] = 1.0f;
                    }
                    if (this.myAlphas[index] == 0) continue;
                    this.myHues[index] = (float)(Math.atan2(ky, kx) / Math.PI / 2.0);
                }
            }
        }

        public void generateColorWheel() {
            for (int index = 0; index < this.myPixels.length; ++index) {
                if (this.myAlphas[index] == 0) continue;
                this.myPixels[index] = this.myAlphas[index] | 0xFFFFFF & Color.HSBtoRGB(this.myHues[index], this.mySat[index], this.myBrightness);
            }
            this.newPixels();
        }
    }

    static class ColorPickerDialog
    extends DialogWrapper {
        private final Color myPreselectedColor;
        private final ColorPickerListener[] myListeners;
        private ColorPicker myColorPicker;
        private final boolean myEnableOpacity;
        private ColorPipette myPicker;
        private final boolean myOpacityInPercent;

        public ColorPickerDialog(Component parent, String caption, @Nullable Color preselectedColor, boolean enableOpacity, @Nullable ColorPickerListener[] listeners, boolean opacityInPercent) {
            super(parent, true);
            this.myListeners = listeners;
            this.setTitle(caption);
            this.myPreselectedColor = preselectedColor;
            this.myEnableOpacity = enableOpacity;
            this.myOpacityInPercent = opacityInPercent;
            this.setResizable(false);
            this.setOKButtonText("Choose");
            this.init();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ColorPickerDialog.this.myPicker.cancelPipette();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ColorPickerDialog.this.myPicker.pick();
                }
            });
        }

        protected JComponent createCenterPanel() {
            if (this.myColorPicker == null) {
                this.myColorPicker = new ColorPicker(this.myDisposable, this.myPreselectedColor, true, this.myEnableOpacity, this.myListeners, this.myOpacityInPercent);
                this.myColorPicker.pickARGB();
            }
            return this.myColorPicker;
        }

        public Color getColor() {
            return this.myColorPicker.getColor();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myColorPicker.getPreferredFocusedComponent();
        }

        protected void doOKAction() {
            this.myColorPicker.appendRecentColor();
            this.myColorPicker.saveRecentColors();
            super.doOKAction();
        }

        public void show() {
            super.show();
            this.myColorPicker.fireClosed(this.getExitCode() == 0 ? this.getColor() : null);
        }
    }

    private class RecentColorsComponent
    extends JComponent {
        private static final int WIDTH = 313;
        private static final int HEIGHT = 65;
        private List<Color> myRecentColors = new ArrayList<Color>();

        private RecentColorsComponent(final ColorListener listener, boolean restoreColors) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Color color = RecentColorsComponent.this.getColor(e);
                    if (color != null) {
                        listener.colorChanged(color, RecentColorsComponent.this);
                    }
                }
            });
            if (restoreColors) {
                this.restoreColors();
            }
        }

        @Nullable
        public Color getMostRecentColor() {
            return this.myRecentColors.isEmpty() ? null : this.myRecentColors.get(this.myRecentColors.size() - 1);
        }

        private void restoreColors() {
            String value = PropertiesComponent.getInstance().getValue(ColorPicker.COLOR_CHOOSER_COLORS_KEY);
            if (value != null) {
                List colors = StringUtil.split((String)value, (String)",,,");
                for (String color : colors) {
                    if (color.contains("-")) {
                        List components = StringUtil.split((String)color, (String)"-");
                        if (components.size() != 4) continue;
                        this.myRecentColors.add(new Color(Integer.parseInt((String)components.get(0)), Integer.parseInt((String)components.get(1)), Integer.parseInt((String)components.get(2)), Integer.parseInt((String)components.get(3))));
                        continue;
                    }
                    this.myRecentColors.add(new Color(Integer.parseInt(color)));
                }
            }
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Color color = this.getColor(event);
            if (color != null) {
                return String.format("R: %d G: %d B: %d A: %s", color.getRed(), color.getGreen(), color.getBlue(), String.format("%.2f", Float.valueOf((float)((double)color.getAlpha() / 255.0))));
            }
            return super.getToolTipText(event);
        }

        @Nullable
        private Color getColor(MouseEvent event) {
            Pair<Integer, Integer> pair = this.pointToCellCoords(event.getPoint());
            if (pair != null) {
                int ndx = (Integer)pair.second + (Integer)pair.first * 10;
                if (this.myRecentColors.size() > ndx) {
                    return this.myRecentColors.get(ndx);
                }
            }
            return null;
        }

        public void saveColors() {
            ArrayList<String> values = new ArrayList<String>();
            for (Color recentColor : this.myRecentColors) {
                if (recentColor == null) break;
                values.add(String.format("%d-%d-%d-%d", recentColor.getRed(), recentColor.getGreen(), recentColor.getBlue(), recentColor.getAlpha()));
            }
            PropertiesComponent.getInstance().setValue(ColorPicker.COLOR_CHOOSER_COLORS_KEY, StringUtil.join(values, (String)",,,"));
        }

        public void appendColor(Color c) {
            if (!this.myRecentColors.contains(c)) {
                this.myRecentColors.add(c);
            }
            if (this.myRecentColors.size() > 20) {
                this.myRecentColors = new ArrayList<Color>(this.myRecentColors.subList(this.myRecentColors.size() - 20, this.myRecentColors.size()));
            }
        }

        @Nullable
        private Pair<Integer, Integer> pointToCellCoords(Point p) {
            int x = p.x;
            int y = p.y;
            Insets i = this.getInsets();
            Dimension d = this.getSize();
            int left = i.left + (d.width - i.left - i.right - 313) / 2;
            int top = i.top + (d.height - i.top - i.bottom - 65) / 2;
            int col = (x - left - 2) / 31;
            col = col > 9 ? 9 : col;
            int row = (y - top - 2) / 31;
            row = row > 1 ? 1 : row;
            return row >= 0 && col >= 0 ? Pair.create((Object)row, (Object)col) : null;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(313, 65);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Insets i = this.getInsets();
            Dimension d = this.getSize();
            int left = i.left + (d.width - i.left - i.right - 313) / 2;
            int top = i.top + (d.height - i.top - i.bottom - 65) / 2;
            g.setColor(Color.WHITE);
            g.fillRect(left, top, 313, 65);
            g.setColor(Color.GRAY);
            g.drawLine(left + 1, i.top + 32, left + 313 - 3, i.top + 32);
            g.drawRect(left + 1, top + 1, 310, 62);
            for (int k = 1; k < 10; ++k) {
                g.drawLine(left + 1 + k * 31, top + 1, left + 1 + k * 31, top + 65 - 3);
            }
            for (int r = 0; r < this.myRecentColors.size(); ++r) {
                int row = r / 10;
                int col = r % 10;
                Color color = this.myRecentColors.get(r);
                g.setColor(color);
                g.fillRect(left + 2 + col * 30 + col + 1, top + 2 + row * 30 + row + 1, 28, 28);
            }
        }
    }

    public class NumberDocument
    extends PlainDocument {
        private final boolean myHex;
        private JTextField mySrc;

        public NumberDocument(boolean hex) {
            this.myHex = hex;
        }

        void setSource(JTextField field) {
            this.mySrc = field;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            boolean rgb = ColorPicker.this.isRGBMode();
            char[] source = str.toCharArray();
            if (this.mySrc != null) {
                int selected = this.mySrc.getSelectionEnd() - this.mySrc.getSelectionStart();
                int newLen = this.mySrc.getText().length() - selected + str.length();
                if (newLen > (this.myHex ? (ColorPicker.this.isARGBMode() ? 8 : 6) : 3)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (this.myHex ? "0123456789abcdefABCDEF".indexOf(source[i]) >= 0 : Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            String toInsert = StringUtil.toUpperCase((String)new String(result, 0, j));
            String res = new StringBuilder(this.mySrc.getText()).insert(offs, toInsert).toString();
            try {
                if (!this.myHex) {
                    int num = Integer.parseInt(res);
                    if (rgb) {
                        if (num > 255) {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                    } else if (this.mySrc == ColorPicker.this.myRed && num > 359 || (this.mySrc == ColorPicker.this.myGreen || this.mySrc == ColorPicker.this.myBlue) && num > 100) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            super.insertString(offs, toInsert, a);
        }
    }

    private static class ColorPreviewComponent
    extends JComponent {
        private Color myColor;

        private ColorPreviewComponent() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(100, 32);
        }

        public void setColor(Color c) {
            this.myColor = c;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Insets i = this.getInsets();
            Rectangle r = this.getBounds();
            int width = r.width - i.left - i.right;
            int height = r.height - i.top - i.bottom;
            g.setColor(Color.WHITE);
            g.fillRect(i.left, i.top, width, height);
            g.setColor(this.myColor);
            g.fillRect(i.left, i.top, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(i.left, i.top, width - 1, height - 1);
            g.setColor(Color.WHITE);
            g.drawRect(i.left + 1, i.top + 1, width - 3, height - 3);
        }
    }

    private static class ColorWheel
    extends JComponent {
        private static final int BORDER_SIZE = 5;
        private float myBrightness = 1.0f;
        private float myHue = 1.0f;
        private float mySaturation = 0.0f;
        private Image myImage;
        private Rectangle myWheel;
        private boolean myShouldInvalidate = true;
        private Color myColor;
        private final List<ColorListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        private int myOpacity;

        private ColorWheel() {
            this.setOpaque(true);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ColorWheel.this.myShouldInvalidate = true;
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    int x = e.getX();
                    int y = e.getY();
                    int mx = ((ColorWheel)ColorWheel.this).myWheel.x + ((ColorWheel)ColorWheel.this).myWheel.width / 2;
                    int my = ((ColorWheel)ColorWheel.this).myWheel.y + ((ColorWheel)ColorWheel.this).myWheel.height / 2;
                    double s = Math.sqrt((x - mx) * (x - mx) + (y - my) * (y - my)) / (double)(((ColorWheel)ColorWheel.this).myWheel.height / 2);
                    double h = -Math.atan2(y - my, x - mx) / (Math.PI * 2);
                    if (h < 0.0) {
                        h += 1.0;
                    }
                    if (s > 1.0) {
                        s = 1.0;
                    }
                    ColorWheel.this.setHSBValue((float)h, (float)s, ColorWheel.this.myBrightness, ColorWheel.this.myOpacity);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int x = e.getX();
                    int y = e.getY();
                    int mx = ((ColorWheel)ColorWheel.this).myWheel.x + ((ColorWheel)ColorWheel.this).myWheel.width / 2;
                    int my = ((ColorWheel)ColorWheel.this).myWheel.y + ((ColorWheel)ColorWheel.this).myWheel.height / 2;
                    double s = Math.sqrt((x - mx) * (x - mx) + (y - my) * (y - my)) / (double)(((ColorWheel)ColorWheel.this).myWheel.height / 2);
                    double h = -Math.atan2(y - my, x - mx) / (Math.PI * 2);
                    if (h < 0.0) {
                        h += 1.0;
                    }
                    if (s <= 1.0) {
                        ColorWheel.this.setHSBValue((float)h, (float)s, ColorWheel.this.myBrightness, ColorWheel.this.myOpacity);
                    }
                }
            });
        }

        private void setHSBValue(float h, float s, float b, int opacity) {
            Color rgb = new Color(Color.HSBtoRGB(h, s, b));
            this.setColor(ColorUtil.toAlpha((Color)rgb, (int)opacity), this);
        }

        private void setColor(Color color, Object source) {
            float[] hsb = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
            this.myColor = color;
            this.myHue = hsb[0];
            this.mySaturation = hsb[1];
            this.myBrightness = hsb[2];
            this.myOpacity = color.getAlpha();
            this.fireColorChanged(source);
            this.repaint();
        }

        public void addListener(ColorListener listener) {
            this.myListeners.add(listener);
        }

        private void fireColorChanged(Object source) {
            for (ColorListener listener : this.myListeners) {
                listener.colorChanged(this.myColor, source);
            }
        }

        public void setBrightness(float brightness) {
            if (brightness != this.myBrightness) {
                this.myImage = null;
                this.setHSBValue(this.myHue, this.mySaturation, brightness, this.myOpacity);
            }
        }

        public void setOpacity(int opacity) {
            if (opacity != this.myOpacity) {
                this.setHSBValue(this.myHue, this.mySaturation, this.myBrightness, opacity);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(300, 300);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension size = this.getSize();
            int _size = Math.min(size.width, size.height);
            _size = Math.min(_size, 600);
            if (this.myImage != null && this.myShouldInvalidate && this.myImage.getWidth(null) != _size) {
                this.myImage = null;
            }
            this.myShouldInvalidate = false;
            if (this.myImage == null) {
                this.myImage = this.createImage(new ColorWheelImageProducer(_size - 10, _size - 10, this.myBrightness));
                this.myWheel = new Rectangle(5, 5, _size - 10, _size - 10);
            }
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setComposite(AlphaComposite.getInstance(3, (float)this.myOpacity / 255.0f));
            g.drawImage(this.myImage, this.myWheel.x, this.myWheel.y, null);
            g2d.setComposite(AlphaComposite.getInstance(2, 1.0f));
            int mx = this.myWheel.x + this.myWheel.width / 2;
            int my = this.myWheel.y + this.myWheel.height / 2;
            g.setColor(Color.white);
            int arcw = (int)((float)this.myWheel.width * this.mySaturation / 2.0f);
            int arch = (int)((float)this.myWheel.height * this.mySaturation / 2.0f);
            double th = (double)(this.myHue * 2.0f) * Math.PI;
            int x = (int)((double)mx + (double)arcw * Math.cos(th));
            int y = (int)((double)my - (double)arch * Math.sin(th));
            g.fillRect(x - 2, y - 2, 4, 4);
            g.setColor(Color.BLACK);
            g.drawRect(x - 2, y - 2, 4, 4);
        }

        public void dropImage() {
            this.myImage = null;
        }
    }

    private static class ColorWheelPanel
    extends JPanel {
        private ColorWheel myColorWheel;
        private SlideComponent myBrightnessComponent;
        private SlideComponent myOpacityComponent = null;

        private ColorWheelPanel(ColorListener listener, boolean enableOpacity, boolean opacityInPercent) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.myColorWheel = new ColorWheel();
            this.add((Component)this.myColorWheel, "Center");
            this.myColorWheel.addListener(listener);
            this.myBrightnessComponent = new SlideComponent("Brightness", true);
            this.myBrightnessComponent.setToolTipText("Brightness");
            this.myBrightnessComponent.addListener(new Consumer<Integer>(){

                public void consume(Integer value) {
                    ColorWheelPanel.this.myColorWheel.setBrightness(1.0f - (float)value.intValue() / 255.0f);
                    ColorWheelPanel.this.myColorWheel.repaint();
                }
            });
            this.add((Component)this.myBrightnessComponent, "East");
            if (enableOpacity) {
                this.myOpacityComponent = new SlideComponent("Opacity", false);
                this.myOpacityComponent.setUnits(opacityInPercent ? SlideComponent.Unit.PERCENT : SlideComponent.Unit.LEVEL);
                this.myOpacityComponent.setToolTipText("Opacity");
                this.myOpacityComponent.addListener(new Consumer<Integer>(){

                    public void consume(Integer integer) {
                        ColorWheelPanel.this.myColorWheel.setOpacity(integer);
                        ColorWheelPanel.this.myColorWheel.repaint();
                    }
                });
                this.add((Component)this.myOpacityComponent, "South");
            }
        }

        public void setColor(Color color, Object source) {
            float[] hsb = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
            this.myBrightnessComponent.setValue(255 - (int)(hsb[2] * 255.0f));
            this.myBrightnessComponent.repaint();
            this.myColorWheel.dropImage();
            if (this.myOpacityComponent != null && source instanceof ColorPicker) {
                this.myOpacityComponent.setValue(color.getAlpha());
                this.myOpacityComponent.repaint();
            }
            this.myColorWheel.setColor(color, source);
        }
    }
}

