/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.resources.IntArrayWrapper;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.util.Pair;
import com.android.utils.HtmlBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewLoader {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.ViewLoader");
    @NotNull
    private final Module myModule;
    @NotNull
    private final Map<String, Class<?>> myLoadedClasses;
    @Nullable
    private final Object myCredential;
    @NotNull
    private RenderLogger myLogger;
    @NotNull
    private final LayoutLibrary myLayoutLibrary;
    @Nullable
    private ModuleClassLoader myModuleClassLoader;

    public ViewLoader(@NotNull LayoutLibrary layoutLib, @NotNull AndroidFacet facet, @NotNull RenderLogger logger, @Nullable Object credential) {
        if (layoutLib == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutLib", "org/jetbrains/android/uipreview/ViewLoader", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/uipreview/ViewLoader", "<init>"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "org/jetbrains/android/uipreview/ViewLoader", "<init>"));
        }
        this.myLoadedClasses = new HashMap();
        this.myLayoutLibrary = layoutLib;
        this.myModule = facet.getModule();
        this.myLogger = logger;
        this.myCredential = credential;
    }

    public void setLogger(@Nullable RenderLogger logger) {
        this.myLogger = logger;
    }

    @Nullable
    public Object loadView(String className, Class[] constructorSignature, Object[] constructorArgs) throws ClassNotFoundException {
        Object aClass = this.loadClass(className, constructorSignature, constructorArgs, true);
        if (aClass != null) {
            return aClass;
        }
        try {
            Object o = this.createViewFromSuperclass(className, constructorSignature, constructorArgs);
            if (o != null) {
                return o;
            }
            return this.createMockView(className, constructorSignature, constructorArgs);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(className, e);
        }
        catch (InvocationTargetException e) {
            throw new ClassNotFoundException(className, e);
        }
        catch (NoSuchMethodException e) {
            throw new ClassNotFoundException(className, e);
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException(className, e);
        }
        catch (InstantiationException e) {
            throw new ClassNotFoundException(className, e);
        }
        catch (NoSuchFieldException e) {
            throw new ClassNotFoundException(className, e);
        }
    }

    @Nullable
    public Object loadClass(String className, Class[] constructorSignature, Object[] constructorArgs) throws ClassNotFoundException {
        if ("android.support.v7.widget.RecyclerView$Adapter".equals(className)) {
            className = "com.android.layoutlib.bridge.android.support.Adapter";
            constructorSignature = ArrayUtil.EMPTY_CLASS_ARRAY;
            constructorArgs = ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return this.loadClass(className, constructorSignature, constructorArgs, false);
    }

    @Nullable
    private Object loadClass(String className, Class[] constructorSignature, Object[] constructorArgs, boolean isView) {
        Class<?> aClass = this.myLoadedClasses.get(className);
        try {
            if (aClass != null) {
                this.checkModified(className);
                return this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
            }
            aClass = this.loadClass(className);
            if (aClass != null) {
                this.checkModified(className);
                Object viewObject = this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
                this.myLoadedClasses.put(className, aClass);
                return viewObject;
            }
        }
        catch (InconvertibleClassError e) {
            this.myLogger.addIncorrectFormatClass(e.getClassName(), e);
        }
        catch (LinkageError e) {
            this.myLogger.addBrokenClass(className, e);
        }
        catch (ClassNotFoundException e) {
            this.myLogger.addBrokenClass(className, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InconvertibleClassError) {
                InconvertibleClassError error = (InconvertibleClassError)cause;
                this.myLogger.addIncorrectFormatClass(error.getClassName(), error);
            } else {
                this.myLogger.addBrokenClass(className, cause);
            }
        }
        catch (IllegalAccessException e) {
            this.myLogger.addBrokenClass(className, e);
        }
        catch (InstantiationException e) {
            this.myLogger.addBrokenClass(className, e);
        }
        catch (NoSuchMethodException e) {
            this.myLogger.addBrokenClass(className, e);
        }
        return null;
    }

    private void checkModified(@NotNull String fqcn) {
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "org/jetbrains/android/uipreview/ViewLoader", "checkModified"));
        }
        if (this.myModuleClassLoader != null && this.myModuleClassLoader.isSourceModified(fqcn, this.myCredential)) {
            RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
            HtmlBuilder builder = problem.getHtmlBuilder();
            String className = fqcn.substring(fqcn.lastIndexOf(46) + 1);
            builder.addLink("The " + className + " custom view has been edited more recently than the last build: ", "Build", " the project.", this.myLogger.getLinkManager().createCompileModuleUrl());
            this.myLogger.addMessage(problem);
        }
    }

    @Nullable
    public Class<?> loadClass(@NotNull String className) throws InconvertibleClassError {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ViewLoader", "loadClass"));
        }
        try {
            return this.getModuleClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (!className.equals("fragment")) {
                this.myLogger.addMissingClass(className);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ModuleClassLoader getModuleClassLoader() {
        if (this.myModuleClassLoader == null) {
            boolean token = RenderSecurityManager.enterSafeRegion((Object)this.myCredential);
            try {
                this.myModuleClassLoader = ModuleClassLoader.get(this.myLayoutLibrary, this.myModule);
            }
            finally {
                RenderSecurityManager.exitSafeRegion((boolean)token);
            }
        }
        ModuleClassLoader moduleClassLoader = this.myModuleClassLoader;
        if (moduleClassLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ViewLoader", "getModuleClassLoader"));
        }
        return moduleClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object createViewFromSuperclass(final String className, final Class[] constructorSignature, final Object[] constructorArgs) {
        final Ref token = new Ref();
        token.set((Object)RenderSecurityManager.enterSafeRegion((Object)this.myCredential));
        try {
            Object object = ApplicationManager.getApplication().runReadAction((Computable)new Computable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public Object compute() {
                    String qName;
                    JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)ViewLoader.this.myModule.getProject());
                    PsiClass psiClass = facade.findClass(className, ViewLoader.this.myModule.getModuleWithDependenciesAndLibrariesScope(false));
                    if (psiClass == null) {
                        return null;
                    }
                    HashSet visited = new HashSet();
                    for (psiClass = psiClass.getSuperClass(); psiClass != null && (qName = psiClass.getQualifiedName()) != null && visited.add(qName) && !"android.view.View".equals(psiClass.getQualifiedName()); psiClass = psiClass.getSuperClass()) {
                        Object object;
                        if (AndroidUtils.isAbstract(psiClass)) continue;
                        Class<?> aClass = (Class<?>)ViewLoader.this.myLoadedClasses.get(qName);
                        if (aClass == null && ViewLoader.this.myLayoutLibrary.getClassLoader() != null && (aClass = ViewLoader.this.myLayoutLibrary.getClassLoader().loadClass(qName)) != null) {
                            ViewLoader.this.myLoadedClasses.put(qName, aClass);
                        }
                        if (aClass == null) continue;
                        try {
                            RenderSecurityManager.exitSafeRegion((boolean)((Boolean)token.get()));
                            object = ViewLoader.this.createNewInstance(aClass, constructorSignature, constructorArgs, true);
                        }
                        catch (Throwable throwable) {
                            try {
                                token.set((Object)RenderSecurityManager.enterSafeRegion((Object)ViewLoader.this.myCredential));
                                throw throwable;
                            }
                            catch (Throwable e) {
                                LOG.debug(e);
                            }
                        }
                        token.set((Object)RenderSecurityManager.enterSafeRegion((Object)ViewLoader.this.myCredential));
                        return object;
                    }
                    return null;
                }
            });
            return object;
        }
        finally {
            RenderSecurityManager.exitSafeRegion((boolean)((Boolean)token.get()));
        }
    }

    private Object createMockView(String className, Class[] constructorSignature, Object[] constructorArgs) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        Class<?> mockViewClass = this.getModuleClassLoader().loadClass("com.android.layoutlib.bridge.MockView");
        Object viewObject = this.createNewInstance(mockViewClass, constructorSignature, constructorArgs, true);
        Method setTextMethod = viewObject.getClass().getMethod("setText", CharSequence.class);
        String label = ViewLoader.getShortClassName(className);
        if (label.equals("fragment")) {
            label = "<fragment>";
        } else if (label.equals("include")) {
            label = "Text";
        }
        setTextMethod.invoke(viewObject, label);
        try {
            Class<?> gravityClass = Class.forName("android.view.Gravity", true, viewObject.getClass().getClassLoader());
            Field centerField = gravityClass.getField("CENTER");
            int center = centerField.getInt(null);
            Method setGravityMethod = viewObject.getClass().getMethod("setGravity", Integer.TYPE);
            setGravityMethod.invoke(viewObject, center);
        }
        catch (ClassNotFoundException e) {
            LOG.info((Throwable)e);
        }
        return viewObject;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ViewLoader", "getModule"));
        }
        return module;
    }

    private static String getShortClassName(String fqcn) {
        if (fqcn.startsWith("android.")) {
            int first = fqcn.indexOf(46);
            int last = fqcn.lastIndexOf(46);
            if (last > first) {
                return fqcn.substring(0, first) + ".." + fqcn.substring(last);
            }
        } else {
            int first = fqcn.indexOf(46);
            first = fqcn.indexOf(46, first + 1);
            int last = fqcn.lastIndexOf(46);
            if (last > first && first >= 0) {
                return fqcn.substring(0, first) + ".." + fqcn.substring(last);
            }
        }
        return fqcn;
    }

    private Object createNewInstance(Class<?> clazz, Class[] constructorSignature, Object[] constructorParameters, boolean isView) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor<?> constructor;
        block9: {
            constructor = null;
            try {
                constructor = clazz.getConstructor(constructorSignature);
            }
            catch (NoSuchMethodException e) {
                if (!isView) {
                    throw e;
                }
                int paramsCount = constructorSignature.length;
                if (paramsCount == 0) {
                    throw e;
                }
                for (int i = 3; i >= 1; --i) {
                    if (i == paramsCount) continue;
                    int k = paramsCount < i ? paramsCount : i;
                    Class[] sig = new Class[i];
                    System.arraycopy(constructorSignature, 0, sig, 0, k);
                    Object[] params = new Object[i];
                    System.arraycopy(constructorParameters, 0, params, 0, k);
                    for (int j = k + 1; j <= i; ++j) {
                        if (j == 2) {
                            sig[j - 1] = clazz.getClassLoader().loadClass("android.util.AttributeSet");
                            params[j - 1] = null;
                            continue;
                        }
                        if (j != 3) continue;
                        sig[j - 1] = Integer.TYPE;
                        params[j - 1] = 0;
                    }
                    constructorSignature = sig;
                    constructorParameters = params;
                    try {
                        constructor = clazz.getConstructor(constructorSignature);
                        if (constructor == null) continue;
                        if (constructorSignature.length >= 2) break;
                        LOG.info("wrong_constructor: Custom view " + clazz.getSimpleName() + " is not using the 2- or 3-argument " + "View constructors; XML attributes will not work");
                        this.myLogger.warning("wrongconstructor", String.format("Custom view %1$s is not using the 2- or 3-argument View constructors; XML attributes will not work", clazz.getSimpleName()), null);
                        break;
                    }
                    catch (NoSuchMethodException ignored) {
                        // empty catch block
                    }
                }
                if (constructor != null) break block9;
                throw e;
            }
        }
        constructor.setAccessible(true);
        return constructor.newInstance(constructorParameters);
    }

    @Nullable
    private static String getRClassName(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ViewLoader", "getRClassName"));
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null) {
                    return null;
                }
                Manifest manifest = facet.getManifest();
                if (manifest == null) {
                    return null;
                }
                String packageName = (String)manifest.getPackage().getValue();
                return packageName == null ? null : packageName + '.' + "R";
            }
        });
    }

    public void loadAndParseRClassSilently() {
        String rClassName = ViewLoader.getRClassName(this.myModule);
        try {
            if (rClassName == null) {
                LOG.info(String.format("loadAndParseRClass: failed to find manifest package for project %1$s", this.myModule.getProject().getName()));
                return;
            }
            this.myLogger.setResourceClass(rClassName);
            this.loadAndParseRClass(rClassName);
        }
        catch (ClassNotFoundException e) {
            this.myLogger.setMissingResourceClass(true);
        }
        catch (InconvertibleClassError e) {
            assert (rClassName != null);
            this.myLogger.addIncorrectFormatClass(rClassName, e);
        }
    }

    public void loadAndParseRClass(@NotNull String className) throws ClassNotFoundException, InconvertibleClassError {
        AppResourceRepository appResources;
        EnumMap<ResourceType, TObjectIntHashMap<String>> res2id;
        HashMap<IntArrayWrapper, String> styleableId2res;
        TIntObjectHashMap id2res;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ViewLoader", "loadAndParseRClass"));
        }
        Class<?> aClass = this.myLoadedClasses.get(className);
        if (aClass == null && (aClass = this.getModuleClassLoader().loadClass(className)) != null) {
            this.myLoadedClasses.put(className, aClass);
            this.myLogger.setHasLoadedClasses(true);
        }
        if (aClass != null && ViewLoader.parseClass(aClass, (TIntObjectHashMap<Pair<ResourceType, String>>)(id2res = new TIntObjectHashMap()), styleableId2res = new HashMap<IntArrayWrapper, String>(), res2id = new EnumMap<ResourceType, TObjectIntHashMap<String>>(ResourceType.class)) && (appResources = AppResourceRepository.getAppResources(this.myModule, true)) != null) {
            appResources.setCompiledResources((TIntObjectHashMap<Pair<ResourceType, String>>)id2res, styleableId2res, res2id);
        }
    }

    private static boolean parseClass(Class<?> rClass, TIntObjectHashMap<Pair<ResourceType, String>> id2res, Map<IntArrayWrapper, String> styleableId2Res, Map<ResourceType, TObjectIntHashMap<String>> res2id) throws ClassNotFoundException {
        try {
            Class<?>[] nestedClasses;
            try {
                nestedClasses = rClass.getDeclaredClasses();
            }
            catch (LinkageError e) {
                Throwable cause = e.getCause();
                if (cause instanceof ClassNotFoundException) {
                    LOG.debug((Throwable)e);
                    throw (ClassNotFoundException)cause;
                }
                throw e;
            }
            for (Class<?> resClass : nestedClasses) {
                ResourceType resType = ResourceType.getEnum((String)resClass.getSimpleName());
                if (resType == null) continue;
                TObjectIntHashMap resName2Id = new TObjectIntHashMap();
                res2id.put(resType, (TObjectIntHashMap<String>)resName2Id);
                for (Field field : resClass.getDeclaredFields()) {
                    int modifiers = field.getModifiers();
                    if (!Modifier.isStatic(modifiers)) continue;
                    Class<?> type = field.getType();
                    if (type.isArray() && type.getComponentType() == Integer.TYPE) {
                        styleableId2Res.put(new IntArrayWrapper((int[])field.get(null)), field.getName());
                        continue;
                    }
                    if (type == Integer.TYPE) {
                        Integer value = (Integer)field.get(null);
                        id2res.put(value.intValue(), (Object)Pair.of((Object)resType, (Object)field.getName()));
                        resName2Id.put((Object)field.getName(), value.intValue());
                        continue;
                    }
                    LOG.error("Unknown field type in R class: " + type);
                }
            }
        }
        catch (IllegalAccessException e) {
            LOG.info((Throwable)e);
            return false;
        }
        return true;
    }
}

