/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import org.jetbrains.annotations.NotNull;

public class WaitingStrategies {

    public static class WaitForever
    extends Strategy {
        private static final WaitForever INSTANCE = new WaitForever();

        private WaitForever() {
        }

        @NotNull
        public static WaitForever getInstance() {
            WaitForever waitForever = INSTANCE;
            if (waitForever == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/WaitingStrategies$WaitForever", "getInstance"));
            }
            return waitForever;
        }
    }

    public static class WaitForTime
    extends Strategy {
        private final int myTimeMs;

        private WaitForTime(int timeMs) {
            assert (timeMs > 0);
            this.myTimeMs = timeMs;
        }

        @NotNull
        public static WaitForTime getInstance(int timeMs) {
            WaitForTime waitForTime = new WaitForTime(timeMs);
            if (waitForTime == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/WaitingStrategies$WaitForTime", "getInstance"));
            }
            return waitForTime;
        }

        public int getTimeMs() {
            return this.myTimeMs;
        }
    }

    public static class DoNotWait
    extends Strategy {
        private static final DoNotWait INSTANCE = new DoNotWait();

        private DoNotWait() {
        }

        @NotNull
        public static DoNotWait getInstance() {
            DoNotWait doNotWait = INSTANCE;
            if (doNotWait == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/WaitingStrategies$DoNotWait", "getInstance"));
            }
            return doNotWait;
        }
    }

    public static abstract class Strategy {
        private Strategy() {
        }
    }
}

