/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Handler;
import android.support.v17.leanback.R;
import android.support.v17.leanback.app.BackgroundFragment;
import android.support.v17.leanback.app.BackgroundSupportFragment;
import android.support.v17.leanback.widget.BackgroundHelper;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import java.lang.ref.WeakReference;

public final class BackgroundManager {
    private static final String TAG = "BackgroundManager";
    private static final boolean DEBUG = false;
    private static final int FULL_ALPHA = 255;
    private static final int DIM_ALPHA_ON_SOLID = 204;
    private static final int CHANGE_BG_DELAY_MS = 500;
    private static final int FADE_DURATION = 500;
    private static final boolean USE_SEPARATE_WINDOW = false;
    private static final String WINDOW_NAME = "BackgroundManager";
    private static final String FRAGMENT_TAG = BackgroundManager.class.getCanonicalName();
    private Context mContext;
    private Handler mHandler;
    private Window mWindow;
    private WindowManager mWindowManager;
    private View mBgView;
    private BackgroundContinuityService mService;
    private int mThemeDrawableResourceId;
    private FragmentStateQueriable mFragmentState;
    private int mHeightPx;
    private int mWidthPx;
    private Drawable mBackgroundDrawable;
    private int mBackgroundColor;
    private boolean mAttached;
    private long mLastSetTime;
    private final Interpolator mAccelerateInterpolator;
    private final Interpolator mDecelerateInterpolator;
    private final ValueAnimator mAnimator;
    private final ValueAnimator mDimAnimator;
    private TranslucentLayerDrawable mLayerDrawable;
    private Drawable mDimDrawable;
    private ChangeBackgroundRunnable mChangeRunnable;
    private boolean mChangeRunnablePending;
    private final Animator.AnimatorListener mAnimationListener = new Animator.AnimatorListener(){
        final Runnable mRunnable = new Runnable(){

            @Override
            public void run() {
                BackgroundManager.this.postChangeRunnable();
            }
        };

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            if (BackgroundManager.this.mLayerDrawable != null) {
                BackgroundManager.this.mLayerDrawable.clearDrawable(R.id.background_imageout, BackgroundManager.this.mContext);
            }
            BackgroundManager.this.mHandler.post(this.mRunnable);
        }

        public void onAnimationCancel(Animator animation) {
        }
    };
    private final ValueAnimator.AnimatorUpdateListener mAnimationUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            int fadeInAlpha = (Integer)animation.getAnimatedValue();
            DrawableWrapper imageInWrapper = BackgroundManager.this.getImageInWrapper();
            if (imageInWrapper != null) {
                imageInWrapper.setAlpha(fadeInAlpha);
            } else {
                DrawableWrapper imageOutWrapper = BackgroundManager.this.getImageOutWrapper();
                if (imageOutWrapper != null) {
                    imageOutWrapper.setAlpha(255 - fadeInAlpha);
                }
            }
        }
    };
    private final ValueAnimator.AnimatorUpdateListener mDimUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            DrawableWrapper dimWrapper = BackgroundManager.this.getDimWrapper();
            if (dimWrapper != null) {
                dimWrapper.setAlpha((Integer)animation.getAnimatedValue());
            }
        }
    };

    private TranslucentLayerDrawable createOptimizedTranslucentLayerDrawable(LayerDrawable layerDrawable) {
        int numChildren = layerDrawable.getNumberOfLayers();
        Drawable[] drawables = new Drawable[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            drawables[i] = layerDrawable.getDrawable(i);
        }
        OptimizedTranslucentLayerDrawable result = new OptimizedTranslucentLayerDrawable(drawables);
        for (int i = 0; i < numChildren; ++i) {
            result.setId(i, layerDrawable.getId(i));
        }
        return result;
    }

    private Drawable getThemeDrawable() {
        Drawable drawable2 = null;
        if (this.mThemeDrawableResourceId != -1) {
            drawable2 = this.mService.getThemeDrawable(this.mContext, this.mThemeDrawableResourceId);
        }
        if (drawable2 == null) {
            drawable2 = BackgroundManager.createEmptyDrawable(this.mContext);
        }
        return drawable2;
    }

    public static BackgroundManager getInstance(Activity activity) {
        BackgroundManager manager;
        if (activity instanceof FragmentActivity) {
            return BackgroundManager.getSupportInstance((FragmentActivity)activity);
        }
        BackgroundFragment fragment = (BackgroundFragment)activity.getFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        if (fragment != null && (manager = fragment.getBackgroundManager()) != null) {
            return manager;
        }
        return new BackgroundManager(activity, false);
    }

    private static BackgroundManager getSupportInstance(FragmentActivity activity) {
        BackgroundManager manager;
        BackgroundSupportFragment fragment = (BackgroundSupportFragment)activity.getSupportFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        if (fragment != null && (manager = fragment.getBackgroundManager()) != null) {
            return manager;
        }
        return new BackgroundManager((Activity)activity, true);
    }

    private BackgroundManager(Activity activity, boolean isSupportFragmentActivity) {
        this.mContext = activity;
        this.mService = BackgroundContinuityService.getInstance();
        this.mHeightPx = this.mContext.getResources().getDisplayMetrics().heightPixels;
        this.mWidthPx = this.mContext.getResources().getDisplayMetrics().widthPixels;
        this.mHandler = new Handler();
        FastOutLinearInInterpolator defaultInterpolator = new FastOutLinearInInterpolator();
        this.mAccelerateInterpolator = AnimationUtils.loadInterpolator((Context)this.mContext, (int)17432581);
        this.mDecelerateInterpolator = AnimationUtils.loadInterpolator((Context)this.mContext, (int)17432582);
        this.mAnimator = ValueAnimator.ofInt((int[])new int[]{0, 255});
        this.mAnimator.addListener(this.mAnimationListener);
        this.mAnimator.addUpdateListener(this.mAnimationUpdateListener);
        this.mAnimator.setInterpolator((TimeInterpolator)defaultInterpolator);
        this.mDimAnimator = new ValueAnimator();
        this.mDimAnimator.addUpdateListener(this.mDimUpdateListener);
        TypedArray ta = activity.getTheme().obtainStyledAttributes(new int[]{16842836});
        this.mThemeDrawableResourceId = ta.getResourceId(0, -1);
        if (this.mThemeDrawableResourceId < 0) {
            // empty if block
        }
        ta.recycle();
        if (isSupportFragmentActivity) {
            this.createSupportFragment((FragmentActivity)activity);
        } else {
            this.createFragment(activity);
        }
    }

    private void createFragment(Activity activity) {
        BackgroundFragment fragment = (BackgroundFragment)activity.getFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        if (fragment == null) {
            fragment = new BackgroundFragment();
            activity.getFragmentManager().beginTransaction().add((Fragment)fragment, FRAGMENT_TAG).commit();
        } else if (fragment.getBackgroundManager() != null) {
            throw new IllegalStateException("Created duplicated BackgroundManager for same activity, please use getInstance() instead");
        }
        fragment.setBackgroundManager(this);
        this.mFragmentState = fragment;
    }

    private void createSupportFragment(FragmentActivity activity) {
        BackgroundSupportFragment fragment = (BackgroundSupportFragment)activity.getSupportFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        if (fragment == null) {
            fragment = new BackgroundSupportFragment();
            activity.getSupportFragmentManager().beginTransaction().add((android.support.v4.app.Fragment)fragment, FRAGMENT_TAG).commit();
        } else if (fragment.getBackgroundManager() != null) {
            throw new IllegalStateException("Created duplicated BackgroundManager for same activity, please use getInstance() instead");
        }
        fragment.setBackgroundManager(this);
        this.mFragmentState = fragment;
    }

    private DrawableWrapper getImageInWrapper() {
        return this.mLayerDrawable == null ? null : this.mLayerDrawable.findWrapperById(R.id.background_imagein);
    }

    private DrawableWrapper getImageOutWrapper() {
        return this.mLayerDrawable == null ? null : this.mLayerDrawable.findWrapperById(R.id.background_imageout);
    }

    private DrawableWrapper getDimWrapper() {
        return this.mLayerDrawable == null ? null : this.mLayerDrawable.findWrapperById(R.id.background_dim);
    }

    private DrawableWrapper getColorWrapper() {
        return this.mLayerDrawable == null ? null : this.mLayerDrawable.findWrapperById(R.id.background_color);
    }

    void onActivityStart() {
        if (this.mService == null) {
            return;
        }
        if (this.mLayerDrawable == null) {
            this.syncWithService();
        } else {
            this.mService.setColor(this.mBackgroundColor);
            this.mService.setDrawable(this.mBackgroundDrawable);
        }
    }

    void onResume() {
        this.postChangeRunnable();
    }

    private void syncWithService() {
        int color2 = this.mService.getColor();
        Drawable drawable2 = this.mService.getDrawable();
        this.mBackgroundColor = color2;
        this.mBackgroundDrawable = drawable2 == null ? null : drawable2.getConstantState().newDrawable().mutate();
        this.updateImmediate();
    }

    private void lazyInit() {
        if (this.mLayerDrawable != null) {
            return;
        }
        LayerDrawable layerDrawable = (LayerDrawable)ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.lb_background).mutate();
        this.mLayerDrawable = this.createOptimizedTranslucentLayerDrawable(layerDrawable);
        BackgroundHelper.setBackgroundPreservingAlpha(this.mBgView, (Drawable)this.mLayerDrawable);
        this.mLayerDrawable.clearDrawable(R.id.background_imageout, this.mContext);
        this.mLayerDrawable.updateDrawable(R.id.background_theme, this.getThemeDrawable());
        this.updateDimWrapper();
    }

    private void updateDimWrapper() {
        if (this.mDimDrawable == null) {
            this.mDimDrawable = this.getDefaultDimLayer();
        }
        Drawable dimDrawable = this.mDimDrawable.getConstantState().newDrawable(this.mContext.getResources()).mutate();
        if (this.mLayerDrawable != null) {
            this.mLayerDrawable.updateDrawable(R.id.background_dim, dimDrawable);
        }
    }

    public void attach(Window window) {
        this.attachToView(window.getDecorView());
    }

    public void setThemeDrawableResourceId(int resourceId) {
        this.mThemeDrawableResourceId = resourceId;
    }

    private void attachBehindWindow(Window window) {
        this.mWindow = window;
        this.mWindowManager = window.getWindowManager();
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(1001, 0x1000000, -3);
        params.setTitle((CharSequence)"BackgroundManager");
        params.width = -1;
        params.height = -1;
        View backgroundView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.lb_background_window, null);
        this.mWindowManager.addView(backgroundView, (ViewGroup.LayoutParams)params);
        this.attachToView(backgroundView);
    }

    private void attachToView(View sceneRoot) {
        this.mBgView = sceneRoot;
        this.mAttached = true;
        this.syncWithService();
    }

    public boolean isAttached() {
        return this.mAttached;
    }

    void detach() {
        this.release();
        if (this.mWindowManager != null && this.mBgView != null) {
            this.mWindowManager.removeViewImmediate(this.mBgView);
        }
        this.mWindowManager = null;
        this.mWindow = null;
        this.mBgView = null;
        this.mAttached = false;
        if (this.mService != null) {
            this.mService.unref();
            this.mService = null;
        }
    }

    public void release() {
        if (this.mLayerDrawable != null) {
            this.mLayerDrawable.clearDrawable(R.id.background_imagein, this.mContext);
            this.mLayerDrawable.clearDrawable(R.id.background_imageout, this.mContext);
            this.mLayerDrawable.clearDrawable(R.id.background_theme, this.mContext);
            this.mLayerDrawable = null;
        }
        if (this.mChangeRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.mChangeRunnable);
            this.mChangeRunnable = null;
        }
        this.releaseBackgroundBitmap();
    }

    private void releaseBackgroundBitmap() {
        this.mBackgroundDrawable = null;
    }

    private void setBackgroundDrawable(Drawable drawable2) {
        this.mBackgroundDrawable = drawable2;
        this.mService.setDrawable(this.mBackgroundDrawable);
    }

    public void setDimLayer(Drawable drawable2) {
        this.mDimDrawable = drawable2;
        this.updateDimWrapper();
    }

    public Drawable getDimLayer() {
        return this.mDimDrawable;
    }

    public Drawable getDefaultDimLayer() {
        return ContextCompat.getDrawable((Context)this.mContext, (int)R.color.lb_background_protection);
    }

    private void postChangeRunnable() {
        if (this.mChangeRunnable == null || !this.mChangeRunnablePending) {
            return;
        }
        if (!this.mAnimator.isStarted() && this.mFragmentState.isResumed() && this.mLayerDrawable.getAlpha() >= 255) {
            long delayMs = this.getRunnableDelay();
            this.mLastSetTime = System.currentTimeMillis();
            this.mHandler.postDelayed((Runnable)this.mChangeRunnable, delayMs);
            this.mChangeRunnablePending = false;
        }
    }

    private void updateImmediate() {
        DrawableWrapper dimWrapper;
        this.lazyInit();
        DrawableWrapper colorWrapper = this.getColorWrapper();
        if (colorWrapper != null) {
            colorWrapper.setColor(this.mBackgroundColor);
        }
        if ((dimWrapper = this.getDimWrapper()) != null) {
            dimWrapper.setAlpha(this.mBackgroundColor == 0 ? 0 : 204);
        }
        this.showWallpaper(this.mBackgroundColor == 0);
        if (this.mBackgroundDrawable == null) {
            this.mLayerDrawable.clearDrawable(R.id.background_imagein, this.mContext);
        } else {
            this.mLayerDrawable.updateDrawable(R.id.background_imagein, this.mBackgroundDrawable);
            if (dimWrapper != null) {
                dimWrapper.setAlpha(255);
            }
        }
    }

    public void setColor(int color2) {
        this.mBackgroundColor = color2;
        this.mService.setColor(this.mBackgroundColor);
        DrawableWrapper colorWrapper = this.getColorWrapper();
        if (colorWrapper != null) {
            colorWrapper.setColor(this.mBackgroundColor);
        }
    }

    public void setDrawable(Drawable drawable2) {
        this.setDrawableInternal(drawable2);
    }

    private void setDrawableInternal(Drawable drawable2) {
        if (!this.mAttached) {
            throw new IllegalStateException("Must attach before setting background drawable");
        }
        if (this.mChangeRunnable != null) {
            if (this.sameDrawable(drawable2, this.mChangeRunnable.mDrawable)) {
                return;
            }
            this.mHandler.removeCallbacks((Runnable)this.mChangeRunnable);
            this.mChangeRunnable = null;
        }
        if (this.mLayerDrawable == null || this.mLayerDrawable.getAlpha() == 0) {
            this.setBackgroundDrawable(drawable2);
            this.updateImmediate();
            return;
        }
        this.mChangeRunnable = new ChangeBackgroundRunnable(drawable2);
        this.mChangeRunnablePending = true;
        this.postChangeRunnable();
    }

    private long getRunnableDelay() {
        return Math.max(0L, this.mLastSetTime + 500L - System.currentTimeMillis());
    }

    public void setBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            this.setDrawableInternal(null);
            return;
        }
        if (bitmap.getWidth() <= 0 || bitmap.getHeight() <= 0) {
            return;
        }
        Matrix matrix = null;
        if (bitmap.getWidth() != this.mWidthPx || bitmap.getHeight() != this.mHeightPx) {
            int dheight;
            int dwidth = bitmap.getWidth();
            float scale = dwidth * this.mHeightPx > this.mWidthPx * (dheight = bitmap.getHeight()) ? (float)this.mHeightPx / (float)dheight : (float)this.mWidthPx / (float)dwidth;
            int subX = Math.min((int)((float)this.mWidthPx / scale), dwidth);
            int dx = Math.max(0, (dwidth - subX) / 2);
            matrix = new Matrix();
            matrix.setScale(scale, scale);
            matrix.preTranslate((float)(-dx), 0.0f);
        }
        BitmapDrawable bitmapDrawable = new BitmapDrawable(this.mContext.getResources(), bitmap, matrix);
        this.setDrawableInternal(bitmapDrawable);
    }

    private void applyBackgroundChanges() {
        DrawableWrapper imageInWrapper;
        if (!this.mAttached) {
            return;
        }
        int dimAlpha = -1;
        if (this.getImageOutWrapper() != null) {
            int n = dimAlpha = this.mBackgroundColor == 0 ? 0 : 204;
        }
        if ((imageInWrapper = this.getImageInWrapper()) == null && this.mBackgroundDrawable != null) {
            imageInWrapper = this.mLayerDrawable.updateDrawable(R.id.background_imagein, this.mBackgroundDrawable);
            imageInWrapper.setAlpha(0);
            dimAlpha = 255;
        }
        this.mAnimator.setDuration(500L);
        this.mAnimator.start();
        DrawableWrapper dimWrapper = this.getDimWrapper();
        if (dimWrapper != null && dimAlpha >= 0) {
            this.mDimAnimator.cancel();
            this.mDimAnimator.setIntValues(new int[]{dimWrapper.getAlpha(), dimAlpha});
            this.mDimAnimator.setDuration(500L);
            this.mDimAnimator.setInterpolator((TimeInterpolator)(dimAlpha == 255 ? this.mDecelerateInterpolator : this.mAccelerateInterpolator));
            this.mDimAnimator.start();
        }
    }

    public final int getColor() {
        return this.mBackgroundColor;
    }

    public Drawable getDrawable() {
        return this.mBackgroundDrawable;
    }

    private boolean sameDrawable(Drawable first, Drawable second) {
        if (first == null || second == null) {
            return false;
        }
        if (first == second) {
            return true;
        }
        return first instanceof BitmapDrawable && second instanceof BitmapDrawable && ((BitmapDrawable)first).getBitmap().sameAs(((BitmapDrawable)second).getBitmap());
    }

    private static Drawable createEmptyDrawable(Context context) {
        Bitmap bitmap = null;
        return new BitmapDrawable(context.getResources(), bitmap);
    }

    private void showWallpaper(boolean show) {
        if (this.mWindow == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.mWindow.getAttributes();
        if (show) {
            if ((layoutParams.flags & 0x100000) != 0) {
                return;
            }
            layoutParams.flags |= 0x100000;
        } else {
            if ((layoutParams.flags & 0x100000) == 0) {
                return;
            }
            layoutParams.flags &= 0xFFEFFFFF;
        }
        this.mWindow.setAttributes(layoutParams);
    }

    class ChangeBackgroundRunnable
    implements Runnable {
        private Drawable mDrawable;

        ChangeBackgroundRunnable(Drawable drawable2) {
            this.mDrawable = drawable2;
        }

        @Override
        public void run() {
            this.runTask();
            BackgroundManager.this.mChangeRunnable = null;
        }

        private void runTask() {
            if (BackgroundManager.this.mLayerDrawable == null) {
                return;
            }
            if (BackgroundManager.this.sameDrawable(this.mDrawable, BackgroundManager.this.mBackgroundDrawable)) {
                return;
            }
            BackgroundManager.this.releaseBackgroundBitmap();
            DrawableWrapper imageInWrapper = BackgroundManager.this.getImageInWrapper();
            if (imageInWrapper != null) {
                BackgroundManager.this.mLayerDrawable.clearDrawable(R.id.background_imagein, BackgroundManager.this.mContext);
                BackgroundManager.this.mLayerDrawable.updateDrawable(R.id.background_imageout, imageInWrapper.getDrawable());
            }
            BackgroundManager.this.setBackgroundDrawable(this.mDrawable);
            BackgroundManager.this.applyBackgroundChanges();
        }
    }

    private static class BackgroundContinuityService {
        private static final String TAG = "BackgroundContinuityService";
        private static boolean DEBUG = false;
        private static BackgroundContinuityService sService = new BackgroundContinuityService();
        private int mColor;
        private Drawable mDrawable;
        private int mCount;
        private int mLastThemeDrawableId;
        private WeakReference<Drawable.ConstantState> mLastThemeDrawableState;

        private BackgroundContinuityService() {
            this.reset();
        }

        private void reset() {
            this.mColor = 0;
            this.mDrawable = null;
        }

        public static BackgroundContinuityService getInstance() {
            int count = BackgroundContinuityService.sService.mCount++;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Returning instance with new count " + count));
            }
            return sService;
        }

        public void unref() {
            if (this.mCount <= 0) {
                throw new IllegalStateException("Can't unref, count " + this.mCount);
            }
            if (--this.mCount == 0) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)"mCount is zero, resetting");
                }
                this.reset();
            }
        }

        public int getColor() {
            return this.mColor;
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }

        public void setColor(int color2) {
            this.mColor = color2;
        }

        public void setDrawable(Drawable drawable2) {
            this.mDrawable = drawable2;
        }

        public Drawable getThemeDrawable(Context context, int themeDrawableId) {
            Drawable drawable2 = null;
            if (this.mLastThemeDrawableState != null && this.mLastThemeDrawableId == themeDrawableId) {
                Drawable.ConstantState drawableState = (Drawable.ConstantState)this.mLastThemeDrawableState.get();
                if (DEBUG) {
                    Log.v((String)TAG, (String)("got cached theme drawable state " + drawableState));
                }
                if (drawableState != null) {
                    drawable2 = drawableState.newDrawable();
                }
            }
            if (drawable2 == null) {
                drawable2 = ContextCompat.getDrawable((Context)context, (int)themeDrawableId);
                if (DEBUG) {
                    Log.v((String)TAG, (String)("loaded theme drawable " + drawable2));
                }
                this.mLastThemeDrawableState = new WeakReference<Drawable.ConstantState>(drawable2.getConstantState());
                this.mLastThemeDrawableId = themeDrawableId;
            }
            return drawable2;
        }
    }

    private class OptimizedTranslucentLayerDrawable
    extends TranslucentLayerDrawable {
        private PorterDuffColorFilter mColorFilter;
        private boolean mUpdatingColorFilter;

        public OptimizedTranslucentLayerDrawable(Drawable[] drawables) {
            super(drawables);
        }

        @Override
        protected void onAlphaChanged(int oldAlpha, int newAlpha) {
            if (newAlpha == 255 && oldAlpha < 255) {
                BackgroundManager.this.postChangeRunnable();
            }
        }

        public void invalidateSelf() {
            super.invalidateSelf();
            this.updateColorFilter();
        }

        public void invalidateDrawable(Drawable who) {
            if (!this.mUpdatingColorFilter) {
                this.invalidateSelf();
            }
        }

        private void updateColorFilter() {
            int dimColor;
            DrawableWrapper dimWrapper = this.findWrapperById(R.id.background_dim);
            DrawableWrapper imageInWrapper = this.findWrapperById(R.id.background_imagein);
            DrawableWrapper imageOutWrapper = this.findWrapperById(R.id.background_imageout);
            this.mColorFilter = null;
            if (imageInWrapper != null && imageInWrapper.getAlpha() == 255 && dimWrapper.getDrawable() instanceof ColorDrawable && Color.red((int)(dimColor = ((ColorDrawable)dimWrapper.getDrawable()).getColor())) == 0 && Color.green((int)dimColor) == 0 && Color.blue((int)dimColor) == 0) {
                int dimAlpha = 255 - Color.alpha((int)dimColor);
                int color2 = Color.argb((int)this.getAlpha(), (int)dimAlpha, (int)dimAlpha, (int)dimAlpha);
                this.mColorFilter = new PorterDuffColorFilter(color2, PorterDuff.Mode.MULTIPLY);
            }
            this.mUpdatingColorFilter = true;
            if (imageInWrapper != null) {
                imageInWrapper.setColorFilter((ColorFilter)this.mColorFilter);
            }
            if (imageOutWrapper != null) {
                imageOutWrapper.setColorFilter(null);
            }
            this.mUpdatingColorFilter = false;
        }

        @Override
        public void draw(Canvas canvas) {
            DrawableWrapper imageInWrapper = this.findWrapperById(R.id.background_imagein);
            if (imageInWrapper != null && imageInWrapper.getDrawable() != null && imageInWrapper.getColorFilter() != null) {
                imageInWrapper.getDrawable().draw(canvas);
            } else {
                super.draw(canvas);
            }
        }
    }

    static class TranslucentLayerDrawable
    extends LayerDrawable {
        private DrawableWrapper[] mWrapper;
        private Paint mPaint = new Paint();

        public TranslucentLayerDrawable(Drawable[] drawables) {
            super(drawables);
            int count = drawables.length;
            this.mWrapper = new DrawableWrapper[count];
            for (int i = 0; i < count; ++i) {
                this.mWrapper[i] = new DrawableWrapper(drawables[i]);
            }
        }

        public void setAlpha(int alpha) {
            if (this.mPaint.getAlpha() != alpha) {
                int previousAlpha = this.mPaint.getAlpha();
                this.mPaint.setAlpha(alpha);
                this.invalidateSelf();
                this.onAlphaChanged(previousAlpha, alpha);
            }
        }

        public int getAlpha() {
            return this.mPaint.getAlpha();
        }

        protected void onAlphaChanged(int oldAlpha, int newAlpha) {
        }

        public Drawable mutate() {
            Drawable drawable2 = super.mutate();
            int count = this.getNumberOfLayers();
            for (int i = 0; i < count; ++i) {
                if (this.mWrapper[i] == null) continue;
                this.mWrapper[i] = new DrawableWrapper(this.mWrapper[i], this.getDrawable(i));
            }
            this.invalidateSelf();
            return drawable2;
        }

        public int getOpacity() {
            return -3;
        }

        public boolean setDrawableByLayerId(int id2, Drawable drawable2) {
            return this.updateDrawable(id2, drawable2) != null;
        }

        public DrawableWrapper updateDrawable(int id2, Drawable drawable2) {
            super.setDrawableByLayerId(id2, drawable2);
            for (int i = 0; i < this.getNumberOfLayers(); ++i) {
                if (this.getId(i) != id2) continue;
                this.mWrapper[i] = new DrawableWrapper(drawable2);
                this.invalidateSelf();
                return this.mWrapper[i];
            }
            return null;
        }

        public void clearDrawable(int id2, Context context) {
            for (int i = 0; i < this.getNumberOfLayers(); ++i) {
                if (this.getId(i) != id2) continue;
                this.mWrapper[i] = null;
                super.setDrawableByLayerId(id2, BackgroundManager.createEmptyDrawable(context));
                break;
            }
        }

        public DrawableWrapper findWrapperById(int id2) {
            for (int i = 0; i < this.getNumberOfLayers(); ++i) {
                if (this.getId(i) != id2) continue;
                return this.mWrapper[i];
            }
            return null;
        }

        public void draw(Canvas canvas) {
            if (this.mPaint.getAlpha() < 255) {
                canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), this.mPaint, 31);
            }
            super.draw(canvas);
            if (this.mPaint.getAlpha() < 255) {
                canvas.restore();
            }
        }
    }

    private static class DrawableWrapper {
        private int mAlpha = 255;
        private Drawable mDrawable;
        private ColorFilter mColorFilter;

        public DrawableWrapper(Drawable drawable2) {
            this.mDrawable = drawable2;
            this.updateAlpha();
            this.updateColorFilter();
        }

        public DrawableWrapper(DrawableWrapper wrapper, Drawable drawable2) {
            this.mDrawable = drawable2;
            this.mAlpha = wrapper.getAlpha();
            this.updateAlpha();
            this.mColorFilter = wrapper.getColorFilter();
            this.updateColorFilter();
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }

        public void setAlpha(int alpha) {
            this.mAlpha = alpha;
            this.updateAlpha();
        }

        public int getAlpha() {
            return this.mAlpha;
        }

        private void updateAlpha() {
            this.mDrawable.setAlpha(this.mAlpha);
        }

        public ColorFilter getColorFilter() {
            return this.mColorFilter;
        }

        public void setColorFilter(ColorFilter colorFilter) {
            this.mColorFilter = colorFilter;
            this.updateColorFilter();
        }

        private void updateColorFilter() {
            this.mDrawable.setColorFilter(this.mColorFilter);
        }

        public void setColor(int color2) {
            ((ColorDrawable)this.mDrawable).setColor(color2);
        }
    }

    private static class BitmapDrawable
    extends Drawable {
        private ConstantState mState = new ConstantState();

        BitmapDrawable(Resources resources, Bitmap bitmap) {
            this(resources, bitmap, null);
        }

        BitmapDrawable(Resources resources, Bitmap bitmap, Matrix matrix) {
            this.mState.mBitmap = bitmap;
            this.mState.mMatrix = matrix != null ? matrix : new Matrix();
            this.mState.mPaint = new Paint();
            this.mState.mPaint.setFilterBitmap(true);
        }

        Bitmap getBitmap() {
            return this.mState.mBitmap;
        }

        public void draw(Canvas canvas) {
            if (this.mState.mBitmap == null) {
                return;
            }
            if (this.mState.mPaint.getAlpha() < 255 && this.mState.mPaint.getColorFilter() != null) {
                throw new IllegalStateException("Can't draw with translucent alpha and color filter");
            }
            canvas.drawBitmap(this.mState.mBitmap, this.mState.mMatrix, this.mState.mPaint);
        }

        public int getOpacity() {
            return -3;
        }

        public void setAlpha(int alpha) {
            if (this.mState.mPaint.getAlpha() != alpha) {
                this.mState.mPaint.setAlpha(alpha);
                this.invalidateSelf();
            }
        }

        public void setColorFilter(ColorFilter cf) {
            this.mState.mPaint.setColorFilter(cf);
        }

        public ColorFilter getColorFilter() {
            return this.mState.mPaint.getColorFilter();
        }

        public ConstantState getConstantState() {
            return this.mState;
        }

        static class ConstantState
        extends Drawable.ConstantState {
            Bitmap mBitmap;
            Matrix mMatrix;
            Paint mPaint;

            ConstantState() {
            }

            public Drawable newDrawable() {
                return new BitmapDrawable(null, this.mBitmap, this.mMatrix);
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static interface FragmentStateQueriable {
        public boolean isResumed();
    }
}

