/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.app.Fragment;
import android.os.Bundle;
import android.support.v17.leanback.widget.ItemBridgeAdapter;
import android.support.v17.leanback.widget.ListRow;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.OnChildViewHolderSelectedListener;
import android.support.v17.leanback.widget.PresenterSelector;
import android.support.v17.leanback.widget.Row;
import android.support.v17.leanback.widget.VerticalGridView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

abstract class BaseRowFragment
extends Fragment {
    private ObjectAdapter mAdapter;
    private VerticalGridView mVerticalGridView;
    private PresenterSelector mPresenterSelector;
    private ItemBridgeAdapter mBridgeAdapter;
    private int mSelectedPosition = -1;
    private final OnChildViewHolderSelectedListener mRowSelectedListener = new OnChildViewHolderSelectedListener(){

        @Override
        public void onChildViewHolderSelected(RecyclerView parent, RecyclerView.ViewHolder view, int position, int subposition) {
            BaseRowFragment.this.onRowSelected(parent, view, position, subposition);
        }
    };

    BaseRowFragment() {
    }

    abstract int getLayoutResourceId();

    void onRowSelected(RecyclerView parent, RecyclerView.ViewHolder view, int position, int subposition) {
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(this.getLayoutResourceId(), container, false);
        this.mVerticalGridView = this.findGridViewFromRoot(view);
        return view;
    }

    VerticalGridView findGridViewFromRoot(View view) {
        return (VerticalGridView)view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        if (this.mBridgeAdapter != null) {
            this.mVerticalGridView.setAdapter(this.mBridgeAdapter);
            if (this.mSelectedPosition != -1) {
                this.mVerticalGridView.setSelectedPosition(this.mSelectedPosition);
            }
        }
        this.mVerticalGridView.setOnChildViewHolderSelectedListener(this.mRowSelectedListener);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mVerticalGridView = null;
    }

    public final void setPresenterSelector(PresenterSelector presenterSelector) {
        this.mPresenterSelector = presenterSelector;
        this.updateAdapter();
    }

    public final PresenterSelector getPresenterSelector() {
        return this.mPresenterSelector;
    }

    public final void setAdapter(ObjectAdapter rowsAdapter) {
        this.mAdapter = rowsAdapter;
        this.updateAdapter();
    }

    public final ObjectAdapter getAdapter() {
        return this.mAdapter;
    }

    final ItemBridgeAdapter getBridgeAdapter() {
        return this.mBridgeAdapter;
    }

    public void setSelectedPosition(int position) {
        this.setSelectedPosition(position, true);
    }

    public void setSelectedPosition(int position, boolean smooth) {
        this.mSelectedPosition = position;
        if (this.mVerticalGridView != null && this.mVerticalGridView.getAdapter() != null) {
            if (smooth) {
                this.mVerticalGridView.setSelectedPositionSmooth(position);
            } else {
                this.mVerticalGridView.setSelectedPosition(position);
            }
        }
    }

    final VerticalGridView getVerticalGridView() {
        return this.mVerticalGridView;
    }

    void updateAdapter() {
        this.mBridgeAdapter = null;
        if (this.mAdapter != null) {
            this.mBridgeAdapter = new ItemBridgeAdapter(this.mAdapter, this.mPresenterSelector);
        }
        if (this.mVerticalGridView != null) {
            this.mVerticalGridView.setAdapter(this.mBridgeAdapter);
            if (this.mBridgeAdapter != null && this.mSelectedPosition != -1) {
                this.mVerticalGridView.setSelectedPosition(this.mSelectedPosition);
            }
        }
    }

    Object getItem(Row row, int position) {
        if (row instanceof ListRow) {
            return ((ListRow)row).getAdapter().get(position);
        }
        return null;
    }

    void onTransitionStart() {
        if (this.mVerticalGridView != null) {
            this.mVerticalGridView.setAnimateChildLayout(false);
            this.mVerticalGridView.setPruneChild(false);
            this.mVerticalGridView.setFocusSearchDisabled(true);
        }
    }

    void onTransitionEnd() {
        if (this.mVerticalGridView != null) {
            this.mVerticalGridView.setAnimateChildLayout(true);
            this.mVerticalGridView.setPruneChild(true);
            this.mVerticalGridView.setFocusSearchDisabled(false);
        }
    }

    void setItemAlignment() {
        if (this.mVerticalGridView != null) {
            this.mVerticalGridView.setItemAlignmentOffset(0);
            this.mVerticalGridView.setItemAlignmentOffsetPercent(-1.0f);
        }
    }

    void setWindowAlignmentFromTop(int alignedTop) {
        if (this.mVerticalGridView != null) {
            this.mVerticalGridView.setWindowAlignmentOffset(alignedTop);
            this.mVerticalGridView.setWindowAlignmentOffsetPercent(-1.0f);
            this.mVerticalGridView.setWindowAlignment(0);
        }
    }
}

