/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.os.Bundle;
import android.support.v17.leanback.app.BrandedSupportFragment;
import android.support.v17.leanback.transition.TransitionHelper;
import android.support.v17.leanback.transition.TransitionListener;
import android.view.View;
import android.view.ViewTreeObserver;

class BaseSupportFragment
extends BrandedSupportFragment {
    private boolean mEntranceTransitionEnabled = false;
    private boolean mStartEntranceTransitionPending = false;
    private Object mEntranceTransition;
    static TransitionHelper sTransitionHelper = TransitionHelper.getInstance();

    BaseSupportFragment() {
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.mStartEntranceTransitionPending) {
            this.mStartEntranceTransitionPending = false;
            this.startEntranceTransition();
        }
    }

    public void prepareEntranceTransition() {
        if (TransitionHelper.systemSupportsEntranceTransitions()) {
            this.mEntranceTransitionEnabled = true;
        }
    }

    boolean isEntranceTransitionEnabled() {
        return this.mEntranceTransitionEnabled;
    }

    protected Object createEntranceTransition() {
        return null;
    }

    protected void runEntranceTransition(Object entranceTransition) {
    }

    protected void onEntranceTransitionStart() {
    }

    protected void onEntranceTransitionEnd() {
    }

    public void startEntranceTransition() {
        if (!this.mEntranceTransitionEnabled || this.mEntranceTransition != null) {
            return;
        }
        if (this.getView() == null) {
            this.mStartEntranceTransitionPending = true;
            return;
        }
        final View view = this.getView();
        view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                BaseSupportFragment.this.internalCreateEntranceTransition();
                BaseSupportFragment.this.mEntranceTransitionEnabled = false;
                BaseSupportFragment.this.runEntranceTransition(BaseSupportFragment.this.mEntranceTransition);
                return false;
            }
        });
        view.invalidate();
    }

    void internalCreateEntranceTransition() {
        this.mEntranceTransition = this.createEntranceTransition();
        if (this.mEntranceTransition == null) {
            return;
        }
        sTransitionHelper.setTransitionListener(this.mEntranceTransition, new TransitionListener(){

            @Override
            public void onTransitionStart(Object transition2) {
                BaseSupportFragment.this.onEntranceTransitionStart();
            }

            @Override
            public void onTransitionEnd(Object transition2) {
                BaseSupportFragment.this.mEntranceTransition = null;
                BaseSupportFragment.this.onEntranceTransitionEnd();
            }
        });
    }
}

