/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.v17.leanback.R;
import android.support.v17.leanback.app.BaseSupportFragment;
import android.support.v17.leanback.app.HeadersSupportFragment;
import android.support.v17.leanback.app.RowsSupportFragment;
import android.support.v17.leanback.transition.TransitionListener;
import android.support.v17.leanback.widget.BrowseFrameLayout;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.OnItemViewClickedListener;
import android.support.v17.leanback.widget.OnItemViewSelectedListener;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.support.v17.leanback.widget.Row;
import android.support.v17.leanback.widget.RowHeaderPresenter;
import android.support.v17.leanback.widget.RowPresenter;
import android.support.v17.leanback.widget.TitleView;
import android.support.v17.leanback.widget.VerticalGridView;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class BrowseSupportFragment
extends BaseSupportFragment {
    static final String HEADER_STACK_INDEX = "headerStackIndex";
    static final String HEADER_SHOW = "headerShow";
    private static final String TAG = "BrowseSupportFragment";
    private static final String LB_HEADERS_BACKSTACK = "lbHeadersBackStack_";
    private static boolean DEBUG = false;
    public static final int HEADERS_ENABLED = 1;
    public static final int HEADERS_HIDDEN = 2;
    public static final int HEADERS_DISABLED = 3;
    private RowsSupportFragment mRowsSupportFragment;
    private HeadersSupportFragment mHeadersSupportFragment;
    private ObjectAdapter mAdapter;
    private int mHeadersState = 1;
    private int mBrandColor = 0;
    private boolean mBrandColorSet;
    private BrowseFrameLayout mBrowseFrame;
    private boolean mHeadersBackStackEnabled = true;
    private String mWithHeadersBackStackName;
    private boolean mShowingHeaders = true;
    private boolean mCanShowHeaders = true;
    private int mContainerListMarginStart;
    private int mContainerListAlignTop;
    private boolean mRowScaleEnabled = true;
    private OnItemViewSelectedListener mExternalOnItemViewSelectedListener;
    private OnItemViewClickedListener mOnItemViewClickedListener;
    private int mSelectedPosition = -1;
    private PresenterSelector mHeaderPresenterSelector;
    private final SetSelectionRunnable mSetSelectionRunnable = new SetSelectionRunnable();
    private Object mSceneWithHeaders;
    private Object mSceneWithoutHeaders;
    private Object mSceneAfterEntranceTransition;
    private Object mHeadersTransition;
    private BackStackListener mBackStackChangedListener;
    private BrowseTransitionListener mBrowseTransitionListener;
    private static final String ARG_TITLE = BrowseSupportFragment.class.getCanonicalName() + ".title";
    private static final String ARG_BADGE_URI = BrowseSupportFragment.class.getCanonicalName() + ".badge";
    private static final String ARG_HEADERS_STATE = BrowseSupportFragment.class.getCanonicalName() + ".headersState";
    private final BrowseFrameLayout.OnFocusSearchListener mOnFocusSearchListener = new BrowseFrameLayout.OnFocusSearchListener(){

        @Override
        public View onFocusSearch(View focused, int direction) {
            int towardEnd;
            if (BrowseSupportFragment.this.mCanShowHeaders && BrowseSupportFragment.this.isInHeadersTransition()) {
                return focused;
            }
            if (DEBUG) {
                Log.v((String)BrowseSupportFragment.TAG, (String)("onFocusSearch focused " + focused + " + direction " + direction));
            }
            if (BrowseSupportFragment.this.getTitleView() != null && focused != BrowseSupportFragment.this.getTitleView() && direction == 33) {
                return BrowseSupportFragment.this.getTitleView();
            }
            if (BrowseSupportFragment.this.getTitleView() != null && BrowseSupportFragment.this.getTitleView().hasFocus() && direction == 130) {
                return BrowseSupportFragment.this.mCanShowHeaders && BrowseSupportFragment.this.mShowingHeaders ? BrowseSupportFragment.this.mHeadersSupportFragment.getVerticalGridView() : BrowseSupportFragment.this.mRowsSupportFragment.getVerticalGridView();
            }
            boolean isRtl = ViewCompat.getLayoutDirection((View)focused) == 1;
            int towardStart = isRtl ? 66 : 17;
            int n = towardEnd = isRtl ? 17 : 66;
            if (BrowseSupportFragment.this.mCanShowHeaders && direction == towardStart) {
                if (BrowseSupportFragment.this.isVerticalScrolling() || BrowseSupportFragment.this.mShowingHeaders) {
                    return focused;
                }
                return BrowseSupportFragment.this.mHeadersSupportFragment.getVerticalGridView();
            }
            if (direction == towardEnd) {
                if (BrowseSupportFragment.this.isVerticalScrolling()) {
                    return focused;
                }
                return BrowseSupportFragment.this.mRowsSupportFragment.getVerticalGridView();
            }
            return null;
        }
    };
    private final BrowseFrameLayout.OnChildFocusListener mOnChildFocusListener = new BrowseFrameLayout.OnChildFocusListener(){

        @Override
        public boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
            if (BrowseSupportFragment.this.getChildFragmentManager().isDestroyed()) {
                return true;
            }
            if (BrowseSupportFragment.this.mCanShowHeaders && BrowseSupportFragment.this.mShowingHeaders && BrowseSupportFragment.this.mHeadersSupportFragment != null && BrowseSupportFragment.this.mHeadersSupportFragment.getView() != null && BrowseSupportFragment.this.mHeadersSupportFragment.getView().requestFocus(direction, previouslyFocusedRect)) {
                return true;
            }
            if (BrowseSupportFragment.this.mRowsSupportFragment != null && BrowseSupportFragment.this.mRowsSupportFragment.getView() != null && BrowseSupportFragment.this.mRowsSupportFragment.getView().requestFocus(direction, previouslyFocusedRect)) {
                return true;
            }
            return BrowseSupportFragment.this.getTitleView() != null && BrowseSupportFragment.this.getTitleView().requestFocus(direction, previouslyFocusedRect);
        }

        @Override
        public void onRequestChildFocus(View child, View focused) {
            if (BrowseSupportFragment.this.getChildFragmentManager().isDestroyed()) {
                return;
            }
            if (!BrowseSupportFragment.this.mCanShowHeaders || BrowseSupportFragment.this.isInHeadersTransition()) {
                return;
            }
            int childId = child.getId();
            if (childId == R.id.browse_container_dock && BrowseSupportFragment.this.mShowingHeaders) {
                BrowseSupportFragment.this.startHeadersTransitionInternal(false);
            } else if (childId == R.id.browse_headers_dock && !BrowseSupportFragment.this.mShowingHeaders) {
                BrowseSupportFragment.this.startHeadersTransitionInternal(true);
            }
        }
    };
    private HeadersSupportFragment.OnHeaderClickedListener mHeaderClickedListener = new HeadersSupportFragment.OnHeaderClickedListener(){

        @Override
        public void onHeaderClicked() {
            if (!BrowseSupportFragment.this.mCanShowHeaders || !BrowseSupportFragment.this.mShowingHeaders || BrowseSupportFragment.this.isInHeadersTransition()) {
                return;
            }
            BrowseSupportFragment.this.startHeadersTransitionInternal(false);
            BrowseSupportFragment.this.mRowsSupportFragment.getVerticalGridView().requestFocus();
        }
    };
    private OnItemViewSelectedListener mRowViewSelectedListener = new OnItemViewSelectedListener(){

        @Override
        public void onItemSelected(Presenter.ViewHolder itemViewHolder, Object item, RowPresenter.ViewHolder rowViewHolder, Row row) {
            int position = BrowseSupportFragment.this.mRowsSupportFragment.getVerticalGridView().getSelectedPosition();
            if (DEBUG) {
                Log.v((String)BrowseSupportFragment.TAG, (String)("row selected position " + position));
            }
            BrowseSupportFragment.this.onRowSelected(position);
            if (BrowseSupportFragment.this.mExternalOnItemViewSelectedListener != null) {
                BrowseSupportFragment.this.mExternalOnItemViewSelectedListener.onItemSelected(itemViewHolder, item, rowViewHolder, row);
            }
        }
    };
    private HeadersSupportFragment.OnHeaderViewSelectedListener mHeaderViewSelectedListener = new HeadersSupportFragment.OnHeaderViewSelectedListener(){

        @Override
        public void onHeaderSelected(RowHeaderPresenter.ViewHolder viewHolder, Row row) {
            int position = BrowseSupportFragment.this.mHeadersSupportFragment.getVerticalGridView().getSelectedPosition();
            if (DEBUG) {
                Log.v((String)BrowseSupportFragment.TAG, (String)("header selected position " + position));
            }
            BrowseSupportFragment.this.onRowSelected(position);
        }
    };

    public static Bundle createArgs(Bundle args, String title, int headersState) {
        if (args == null) {
            args = new Bundle();
        }
        args.putString(ARG_TITLE, title);
        args.putInt(ARG_HEADERS_STATE, headersState);
        return args;
    }

    public void setBrandColor(int color2) {
        this.mBrandColor = color2;
        this.mBrandColorSet = true;
        if (this.mHeadersSupportFragment != null) {
            this.mHeadersSupportFragment.setBackgroundColor(this.mBrandColor);
        }
    }

    public int getBrandColor() {
        return this.mBrandColor;
    }

    public void setAdapter(ObjectAdapter adapter) {
        this.mAdapter = adapter;
        if (this.mRowsSupportFragment != null) {
            this.mRowsSupportFragment.setAdapter(adapter);
            this.mHeadersSupportFragment.setAdapter(adapter);
        }
    }

    public ObjectAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setOnItemViewSelectedListener(OnItemViewSelectedListener listener) {
        this.mExternalOnItemViewSelectedListener = listener;
    }

    public OnItemViewSelectedListener getOnItemViewSelectedListener() {
        return this.mExternalOnItemViewSelectedListener;
    }

    public void setOnItemViewClickedListener(OnItemViewClickedListener listener) {
        this.mOnItemViewClickedListener = listener;
        if (this.mRowsSupportFragment != null) {
            this.mRowsSupportFragment.setOnItemViewClickedListener(listener);
        }
    }

    public OnItemViewClickedListener getOnItemViewClickedListener() {
        return this.mOnItemViewClickedListener;
    }

    public void startHeadersTransition(boolean withHeaders) {
        if (!this.mCanShowHeaders) {
            throw new IllegalStateException("Cannot start headers transition");
        }
        if (this.isInHeadersTransition() || this.mShowingHeaders == withHeaders) {
            return;
        }
        this.startHeadersTransitionInternal(withHeaders);
    }

    public boolean isInHeadersTransition() {
        return this.mHeadersTransition != null;
    }

    public boolean isShowingHeaders() {
        return this.mShowingHeaders;
    }

    public void setBrowseTransitionListener(BrowseTransitionListener listener) {
        this.mBrowseTransitionListener = listener;
    }

    public void enableRowScaling(boolean enable) {
        this.mRowScaleEnabled = enable;
        if (this.mRowsSupportFragment != null) {
            this.mRowsSupportFragment.enableRowScaling(this.mRowScaleEnabled);
        }
    }

    private void startHeadersTransitionInternal(final boolean withHeaders) {
        if (this.getFragmentManager().isDestroyed()) {
            return;
        }
        this.mShowingHeaders = withHeaders;
        this.mRowsSupportFragment.onExpandTransitionStart(!withHeaders, new Runnable(){

            @Override
            public void run() {
                BrowseSupportFragment.this.mHeadersSupportFragment.onTransitionStart();
                BrowseSupportFragment.this.createHeadersTransition();
                if (BrowseSupportFragment.this.mBrowseTransitionListener != null) {
                    BrowseSupportFragment.this.mBrowseTransitionListener.onHeadersTransitionStart(withHeaders);
                }
                BaseSupportFragment.sTransitionHelper.runTransition(withHeaders ? BrowseSupportFragment.this.mSceneWithHeaders : BrowseSupportFragment.this.mSceneWithoutHeaders, BrowseSupportFragment.this.mHeadersTransition);
                if (BrowseSupportFragment.this.mHeadersBackStackEnabled) {
                    if (!withHeaders) {
                        BrowseSupportFragment.this.getFragmentManager().beginTransaction().addToBackStack(BrowseSupportFragment.this.mWithHeadersBackStackName).commit();
                    } else {
                        int index = ((BrowseSupportFragment)BrowseSupportFragment.this).mBackStackChangedListener.mIndexOfHeadersBackStack;
                        if (index >= 0) {
                            FragmentManager.BackStackEntry entry = BrowseSupportFragment.this.getFragmentManager().getBackStackEntryAt(index);
                            BrowseSupportFragment.this.getFragmentManager().popBackStackImmediate(entry.getId(), 1);
                        }
                    }
                }
            }
        });
    }

    private boolean isVerticalScrolling() {
        return this.mHeadersSupportFragment.getVerticalGridView().getScrollState() != 0 || this.mRowsSupportFragment.getVerticalGridView().getScrollState() != 0;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mBackStackChangedListener != null) {
            this.mBackStackChangedListener.save(outState);
        } else {
            outState.putBoolean(HEADER_SHOW, this.mShowingHeaders);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TypedArray ta = this.getActivity().obtainStyledAttributes(R.styleable.LeanbackTheme);
        this.mContainerListMarginStart = (int)ta.getDimension(R.styleable.LeanbackTheme_browseRowsMarginStart, (float)this.getActivity().getResources().getDimensionPixelSize(R.dimen.lb_browse_rows_margin_start));
        this.mContainerListAlignTop = (int)ta.getDimension(R.styleable.LeanbackTheme_browseRowsMarginTop, (float)this.getActivity().getResources().getDimensionPixelSize(R.dimen.lb_browse_rows_margin_top));
        ta.recycle();
        this.readArguments(this.getArguments());
        if (this.mCanShowHeaders) {
            if (this.mHeadersBackStackEnabled) {
                this.mWithHeadersBackStackName = LB_HEADERS_BACKSTACK + (Object)((Object)this);
                this.mBackStackChangedListener = new BackStackListener();
                this.getFragmentManager().addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this.mBackStackChangedListener);
                this.mBackStackChangedListener.load(savedInstanceState);
            } else if (savedInstanceState != null) {
                this.mShowingHeaders = savedInstanceState.getBoolean(HEADER_SHOW);
            }
        }
    }

    public void onDestroy() {
        if (this.mBackStackChangedListener != null) {
            this.getFragmentManager().removeOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this.mBackStackChangedListener);
        }
        super.onDestroy();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.getChildFragmentManager().findFragmentById(R.id.browse_container_dock) == null) {
            this.mRowsSupportFragment = new RowsSupportFragment();
            this.mHeadersSupportFragment = new HeadersSupportFragment();
            this.getChildFragmentManager().beginTransaction().replace(R.id.browse_headers_dock, (Fragment)this.mHeadersSupportFragment).replace(R.id.browse_container_dock, (Fragment)this.mRowsSupportFragment).commit();
        } else {
            this.mHeadersSupportFragment = (HeadersSupportFragment)this.getChildFragmentManager().findFragmentById(R.id.browse_headers_dock);
            this.mRowsSupportFragment = (RowsSupportFragment)this.getChildFragmentManager().findFragmentById(R.id.browse_container_dock);
        }
        this.mHeadersSupportFragment.setHeadersGone(!this.mCanShowHeaders);
        this.mRowsSupportFragment.setAdapter(this.mAdapter);
        if (this.mHeaderPresenterSelector != null) {
            this.mHeadersSupportFragment.setPresenterSelector(this.mHeaderPresenterSelector);
        }
        this.mHeadersSupportFragment.setAdapter(this.mAdapter);
        this.mRowsSupportFragment.enableRowScaling(this.mRowScaleEnabled);
        this.mRowsSupportFragment.setOnItemViewSelectedListener(this.mRowViewSelectedListener);
        this.mHeadersSupportFragment.setOnHeaderViewSelectedListener(this.mHeaderViewSelectedListener);
        this.mHeadersSupportFragment.setOnHeaderClickedListener(this.mHeaderClickedListener);
        this.mRowsSupportFragment.setOnItemViewClickedListener(this.mOnItemViewClickedListener);
        View root = inflater.inflate(R.layout.lb_browse_fragment, container, false);
        this.setTitleView((TitleView)root.findViewById(R.id.browse_title_group));
        this.mBrowseFrame = (BrowseFrameLayout)root.findViewById(R.id.browse_frame);
        this.mBrowseFrame.setOnChildFocusListener(this.mOnChildFocusListener);
        this.mBrowseFrame.setOnFocusSearchListener(this.mOnFocusSearchListener);
        if (this.mBrandColorSet) {
            this.mHeadersSupportFragment.setBackgroundColor(this.mBrandColor);
        }
        this.mSceneWithHeaders = sTransitionHelper.createScene((ViewGroup)this.mBrowseFrame, new Runnable(){

            @Override
            public void run() {
                BrowseSupportFragment.this.showHeaders(true);
            }
        });
        this.mSceneWithoutHeaders = sTransitionHelper.createScene((ViewGroup)this.mBrowseFrame, new Runnable(){

            @Override
            public void run() {
                BrowseSupportFragment.this.showHeaders(false);
            }
        });
        this.mSceneAfterEntranceTransition = sTransitionHelper.createScene((ViewGroup)this.mBrowseFrame, new Runnable(){

            @Override
            public void run() {
                BrowseSupportFragment.this.setEntranceTransitionEndState();
            }
        });
        return root;
    }

    private void createHeadersTransition() {
        this.mHeadersTransition = sTransitionHelper.loadTransition((Context)this.getActivity(), this.mShowingHeaders ? R.transition.lb_browse_headers_in : R.transition.lb_browse_headers_out);
        sTransitionHelper.setTransitionListener(this.mHeadersTransition, new TransitionListener(){

            @Override
            public void onTransitionStart(Object transition2) {
            }

            @Override
            public void onTransitionEnd(Object transition2) {
                BrowseSupportFragment.this.mHeadersTransition = null;
                BrowseSupportFragment.this.mRowsSupportFragment.onTransitionEnd();
                BrowseSupportFragment.this.mHeadersSupportFragment.onTransitionEnd();
                if (BrowseSupportFragment.this.mShowingHeaders) {
                    VerticalGridView headerGridView = BrowseSupportFragment.this.mHeadersSupportFragment.getVerticalGridView();
                    if (headerGridView != null && !headerGridView.hasFocus()) {
                        headerGridView.requestFocus();
                    }
                } else {
                    VerticalGridView rowsGridView = BrowseSupportFragment.this.mRowsSupportFragment.getVerticalGridView();
                    if (rowsGridView != null && !rowsGridView.hasFocus()) {
                        rowsGridView.requestFocus();
                    }
                }
                if (BrowseSupportFragment.this.mBrowseTransitionListener != null) {
                    BrowseSupportFragment.this.mBrowseTransitionListener.onHeadersTransitionStop(BrowseSupportFragment.this.mShowingHeaders);
                }
            }
        });
    }

    public void setHeaderPresenterSelector(PresenterSelector headerPresenterSelector) {
        this.mHeaderPresenterSelector = headerPresenterSelector;
        if (this.mHeadersSupportFragment != null) {
            this.mHeadersSupportFragment.setPresenterSelector(this.mHeaderPresenterSelector);
        }
    }

    private void setRowsAlignedLeft(boolean alignLeft) {
        View containerList = this.mRowsSupportFragment.getView();
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)containerList.getLayoutParams();
        lp.setMarginStart(alignLeft ? 0 : this.mContainerListMarginStart);
        containerList.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void setHeadersOnScreen(boolean onScreen) {
        View containerList = this.mHeadersSupportFragment.getView();
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)containerList.getLayoutParams();
        lp.setMarginStart(onScreen ? 0 : -this.mContainerListMarginStart);
        containerList.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void showHeaders(boolean show) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("showHeaders " + show));
        }
        this.mHeadersSupportFragment.setHeadersEnabled(show);
        this.setHeadersOnScreen(show);
        this.setRowsAlignedLeft(!show);
        this.mRowsSupportFragment.setExpand(!show);
    }

    private void onRowSelected(int position) {
        if (position != this.mSelectedPosition) {
            this.mSetSelectionRunnable.post(position, 0, true);
            if (this.getAdapter() == null || this.getAdapter().size() == 0 || position == 0) {
                this.showTitle(true);
            } else {
                this.showTitle(false);
            }
        }
    }

    private void setSelection(int position, boolean smooth) {
        if (position != -1) {
            this.mRowsSupportFragment.setSelectedPosition(position, smooth);
            this.mHeadersSupportFragment.setSelectedPosition(position, smooth);
        }
        this.mSelectedPosition = position;
    }

    public void setSelectedPosition(int position) {
        this.setSelectedPosition(position, true);
    }

    public void setSelectedPosition(int position, boolean smooth) {
        this.mSetSelectionRunnable.post(position, 1, smooth);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.mHeadersSupportFragment.setWindowAlignmentFromTop(this.mContainerListAlignTop);
        this.mHeadersSupportFragment.setItemAlignment();
        this.mRowsSupportFragment.setWindowAlignmentFromTop(this.mContainerListAlignTop);
        this.mRowsSupportFragment.setItemAlignment();
        this.mRowsSupportFragment.setScalePivots(0.0f, this.mContainerListAlignTop);
        if (this.mCanShowHeaders && this.mShowingHeaders && this.mHeadersSupportFragment.getView() != null) {
            this.mHeadersSupportFragment.getView().requestFocus();
        } else if (!(this.mCanShowHeaders && this.mShowingHeaders || this.mRowsSupportFragment.getView() == null)) {
            this.mRowsSupportFragment.getView().requestFocus();
        }
        if (this.mCanShowHeaders) {
            this.showHeaders(this.mShowingHeaders);
        }
        if (this.isEntranceTransitionEnabled()) {
            this.setEntranceTransitionStartState();
        }
    }

    public final void setHeadersTransitionOnBackEnabled(boolean headersBackStackEnabled) {
        this.mHeadersBackStackEnabled = headersBackStackEnabled;
    }

    public final boolean isHeadersTransitionOnBackEnabled() {
        return this.mHeadersBackStackEnabled;
    }

    private void readArguments(Bundle args) {
        if (args == null) {
            return;
        }
        if (args.containsKey(ARG_TITLE)) {
            this.setTitle(args.getString(ARG_TITLE));
        }
        if (args.containsKey(ARG_HEADERS_STATE)) {
            this.setHeadersState(args.getInt(ARG_HEADERS_STATE));
        }
    }

    public void setHeadersState(int headersState) {
        if (headersState < 1 || headersState > 3) {
            throw new IllegalArgumentException("Invalid headers state: " + headersState);
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("setHeadersState " + headersState));
        }
        if (headersState != this.mHeadersState) {
            this.mHeadersState = headersState;
            switch (headersState) {
                case 1: {
                    this.mCanShowHeaders = true;
                    this.mShowingHeaders = true;
                    break;
                }
                case 2: {
                    this.mCanShowHeaders = true;
                    this.mShowingHeaders = false;
                    break;
                }
                case 3: {
                    this.mCanShowHeaders = false;
                    this.mShowingHeaders = false;
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)("Unknown headers state: " + headersState));
                }
            }
            if (this.mHeadersSupportFragment != null) {
                this.mHeadersSupportFragment.setHeadersGone(!this.mCanShowHeaders);
            }
        }
    }

    public int getHeadersState() {
        return this.mHeadersState;
    }

    @Override
    protected Object createEntranceTransition() {
        return sTransitionHelper.loadTransition((Context)this.getActivity(), R.transition.lb_browse_entrance_transition);
    }

    @Override
    protected void runEntranceTransition(Object entranceTransition) {
        sTransitionHelper.runTransition(this.mSceneAfterEntranceTransition, entranceTransition);
    }

    @Override
    protected void onEntranceTransitionStart() {
        this.mHeadersSupportFragment.onTransitionStart();
        this.mRowsSupportFragment.onTransitionStart();
    }

    @Override
    protected void onEntranceTransitionEnd() {
        this.mRowsSupportFragment.onTransitionEnd();
        this.mHeadersSupportFragment.onTransitionEnd();
    }

    void setSearchOrbViewOnScreen(boolean onScreen) {
        View searchOrbView = this.getTitleView().getSearchAffordanceView();
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)searchOrbView.getLayoutParams();
        lp.setMarginStart(onScreen ? 0 : -this.mContainerListMarginStart);
        searchOrbView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    void setEntranceTransitionStartState() {
        this.setHeadersOnScreen(false);
        this.setSearchOrbViewOnScreen(false);
        this.mRowsSupportFragment.setEntranceTransitionState(false);
    }

    void setEntranceTransitionEndState() {
        this.setHeadersOnScreen(this.mShowingHeaders);
        this.setSearchOrbViewOnScreen(true);
        this.mRowsSupportFragment.setEntranceTransitionState(true);
    }

    private class SetSelectionRunnable
    implements Runnable {
        static final int TYPE_INVALID = -1;
        static final int TYPE_INTERNAL_SYNC = 0;
        static final int TYPE_USER_REQUEST = 1;
        private int mPosition;
        private int mType;
        private boolean mSmooth;

        SetSelectionRunnable() {
            this.reset();
        }

        void post(int position, int type, boolean smooth) {
            if (type >= this.mType) {
                this.mPosition = position;
                this.mType = type;
                this.mSmooth = smooth;
                BrowseSupportFragment.this.mBrowseFrame.removeCallbacks(this);
                BrowseSupportFragment.this.mBrowseFrame.post(this);
            }
        }

        @Override
        public void run() {
            BrowseSupportFragment.this.setSelection(this.mPosition, this.mSmooth);
            this.reset();
        }

        private void reset() {
            this.mPosition = -1;
            this.mType = -1;
            this.mSmooth = false;
        }
    }

    public static class BrowseTransitionListener {
        public void onHeadersTransitionStart(boolean withHeaders) {
        }

        public void onHeadersTransitionStop(boolean withHeaders) {
        }
    }

    final class BackStackListener
    implements FragmentManager.OnBackStackChangedListener {
        int mLastEntryCount;
        int mIndexOfHeadersBackStack;

        BackStackListener() {
            this.mLastEntryCount = BrowseSupportFragment.this.getFragmentManager().getBackStackEntryCount();
            this.mIndexOfHeadersBackStack = -1;
        }

        void load(Bundle savedInstanceState) {
            if (savedInstanceState != null) {
                this.mIndexOfHeadersBackStack = savedInstanceState.getInt(BrowseSupportFragment.HEADER_STACK_INDEX, -1);
                BrowseSupportFragment.this.mShowingHeaders = this.mIndexOfHeadersBackStack == -1;
            } else if (!BrowseSupportFragment.this.mShowingHeaders) {
                BrowseSupportFragment.this.getFragmentManager().beginTransaction().addToBackStack(BrowseSupportFragment.this.mWithHeadersBackStackName).commit();
            }
        }

        void save(Bundle outState) {
            outState.putInt(BrowseSupportFragment.HEADER_STACK_INDEX, this.mIndexOfHeadersBackStack);
        }

        public void onBackStackChanged() {
            if (BrowseSupportFragment.this.getFragmentManager() == null) {
                Log.w((String)BrowseSupportFragment.TAG, (String)"getFragmentManager() is null, stack:", (Throwable)new Exception());
                return;
            }
            int count = BrowseSupportFragment.this.getFragmentManager().getBackStackEntryCount();
            if (count > this.mLastEntryCount) {
                FragmentManager.BackStackEntry entry = BrowseSupportFragment.this.getFragmentManager().getBackStackEntryAt(count - 1);
                if (BrowseSupportFragment.this.mWithHeadersBackStackName.equals(entry.getName())) {
                    this.mIndexOfHeadersBackStack = count - 1;
                }
            } else if (count < this.mLastEntryCount && this.mIndexOfHeadersBackStack >= count) {
                this.mIndexOfHeadersBackStack = -1;
                if (!BrowseSupportFragment.this.mShowingHeaders) {
                    BrowseSupportFragment.this.startHeadersTransitionInternal(true);
                }
            }
            this.mLastEntryCount = count;
        }
    }
}

