/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.support.v17.leanback.R;
import android.support.v17.leanback.app.BaseFragment;
import android.support.v17.leanback.app.RowsFragment;
import android.support.v17.leanback.widget.BrowseFrameLayout;
import android.support.v17.leanback.widget.FullWidthDetailsOverviewRowPresenter;
import android.support.v17.leanback.widget.ItemAlignmentFacet;
import android.support.v17.leanback.widget.ItemBridgeAdapter;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.OnItemViewClickedListener;
import android.support.v17.leanback.widget.OnItemViewSelectedListener;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.Row;
import android.support.v17.leanback.widget.RowPresenter;
import android.support.v17.leanback.widget.TitleHelper;
import android.support.v17.leanback.widget.TitleView;
import android.support.v17.leanback.widget.VerticalGridView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class DetailsFragment
extends BaseFragment {
    private static final String TAG = "DetailsFragment";
    private static boolean DEBUG = false;
    private RowsFragment mRowsFragment;
    private ObjectAdapter mAdapter;
    private int mContainerListAlignTop;
    private OnItemViewSelectedListener mExternalOnItemViewSelectedListener;
    private OnItemViewClickedListener mOnItemViewClickedListener;
    private Object mSceneAfterEntranceTransition;
    private final SetSelectionRunnable mSetSelectionRunnable = new SetSelectionRunnable();
    private final OnItemViewSelectedListener mOnItemViewSelectedListener = new OnItemViewSelectedListener(){

        @Override
        public void onItemSelected(Presenter.ViewHolder itemViewHolder, Object item, RowPresenter.ViewHolder rowViewHolder, Row row) {
            int position = DetailsFragment.this.mRowsFragment.getVerticalGridView().getSelectedPosition();
            int subposition = DetailsFragment.this.mRowsFragment.getVerticalGridView().getSelectedSubPosition();
            if (DEBUG) {
                Log.v((String)DetailsFragment.TAG, (String)("row selected position " + position + " subposition " + subposition));
            }
            DetailsFragment.this.onRowSelected(position, subposition);
            if (DetailsFragment.this.mExternalOnItemViewSelectedListener != null) {
                DetailsFragment.this.mExternalOnItemViewSelectedListener.onItemSelected(itemViewHolder, item, rowViewHolder, row);
            }
        }
    };

    public void setAdapter(ObjectAdapter adapter) {
        this.mAdapter = adapter;
        Presenter[] presenters = adapter.getPresenterSelector().getPresenters();
        if (presenters != null) {
            for (int i = 0; i < presenters.length; ++i) {
                this.setupPresenter(presenters[i]);
            }
        } else {
            Log.e((String)TAG, (String)"PresenterSelector.getPresenters() not implemented");
        }
        if (this.mRowsFragment != null) {
            this.mRowsFragment.setAdapter(adapter);
        }
    }

    public ObjectAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setOnItemViewSelectedListener(OnItemViewSelectedListener listener) {
        this.mExternalOnItemViewSelectedListener = listener;
    }

    public void setOnItemViewClickedListener(OnItemViewClickedListener listener) {
        if (this.mOnItemViewClickedListener != listener) {
            this.mOnItemViewClickedListener = listener;
            if (this.mRowsFragment != null) {
                this.mRowsFragment.setOnItemViewClickedListener(listener);
            }
        }
    }

    public OnItemViewClickedListener getOnItemViewClickedListener() {
        return this.mOnItemViewClickedListener;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mContainerListAlignTop = this.getResources().getDimensionPixelSize(R.dimen.lb_details_rows_align_top);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.lb_details_fragment, container, false);
        ViewGroup fragment_root = (ViewGroup)view.findViewById(R.id.details_fragment_root);
        View titleView = this.inflateTitle(inflater, fragment_root, savedInstanceState);
        if (titleView != null) {
            fragment_root.addView(titleView);
        }
        this.mRowsFragment = (RowsFragment)this.getChildFragmentManager().findFragmentById(R.id.details_rows_dock);
        if (this.mRowsFragment == null) {
            this.mRowsFragment = new RowsFragment();
            this.getChildFragmentManager().beginTransaction().replace(R.id.details_rows_dock, (Fragment)this.mRowsFragment).commit();
        }
        this.mRowsFragment.setAdapter(this.mAdapter);
        this.mRowsFragment.setOnItemViewSelectedListener(this.mOnItemViewSelectedListener);
        this.mRowsFragment.setOnItemViewClickedListener(this.mOnItemViewClickedListener);
        if (titleView != null) {
            View titleGroup = titleView.findViewById(R.id.browse_title_group);
            if (titleGroup instanceof TitleView) {
                this.setTitleView((TitleView)titleGroup);
            } else {
                this.setTitleView(null);
            }
        }
        this.mSceneAfterEntranceTransition = sTransitionHelper.createScene((ViewGroup)view, new Runnable(){

            @Override
            public void run() {
                DetailsFragment.this.mRowsFragment.setEntranceTransitionState(true);
            }
        });
        return view;
    }

    protected View inflateTitle(LayoutInflater inflater, ViewGroup parent, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.lb_browse_title, parent, false);
    }

    void setVerticalGridViewLayout(VerticalGridView listview) {
        listview.setItemAlignmentOffset(-this.mContainerListAlignTop);
        listview.setItemAlignmentOffsetPercent(-1.0f);
        listview.setWindowAlignmentOffset(0);
        listview.setWindowAlignmentOffsetPercent(-1.0f);
        listview.setWindowAlignment(0);
    }

    protected void setupPresenter(Presenter rowPresenter) {
        if (rowPresenter instanceof FullWidthDetailsOverviewRowPresenter) {
            this.setupDetailsOverviewRowPresenter((FullWidthDetailsOverviewRowPresenter)rowPresenter);
        }
    }

    protected void setupDetailsOverviewRowPresenter(FullWidthDetailsOverviewRowPresenter presenter) {
        ItemAlignmentFacet facet = new ItemAlignmentFacet();
        ItemAlignmentFacet.ItemAlignmentDef alignDef1 = new ItemAlignmentFacet.ItemAlignmentDef();
        alignDef1.setItemAlignmentViewId(R.id.details_frame);
        alignDef1.setItemAlignmentOffset(-this.getResources().getDimensionPixelSize(R.dimen.lb_details_v2_align_pos_for_actions));
        alignDef1.setItemAlignmentOffsetPercent(0.0f);
        ItemAlignmentFacet.ItemAlignmentDef alignDef2 = new ItemAlignmentFacet.ItemAlignmentDef();
        alignDef2.setItemAlignmentViewId(R.id.details_frame);
        alignDef2.setItemAlignmentFocusViewId(R.id.details_overview_description);
        alignDef2.setItemAlignmentOffset(-this.getResources().getDimensionPixelSize(R.dimen.lb_details_v2_align_pos_for_description));
        alignDef2.setItemAlignmentOffsetPercent(0.0f);
        ItemAlignmentFacet.ItemAlignmentDef[] defs = new ItemAlignmentFacet.ItemAlignmentDef[]{alignDef1, alignDef2};
        facet.setAlignmentDefs(defs);
        presenter.setFacet(ItemAlignmentFacet.class, facet);
    }

    VerticalGridView getVerticalGridView() {
        return this.mRowsFragment == null ? null : this.mRowsFragment.getVerticalGridView();
    }

    RowsFragment getRowsFragment() {
        return this.mRowsFragment;
    }

    private void setupChildFragmentLayout() {
        this.setVerticalGridViewLayout(this.mRowsFragment.getVerticalGridView());
    }

    private void setupFocusSearchListener() {
        TitleHelper titleHelper = this.getTitleHelper();
        if (titleHelper != null) {
            BrowseFrameLayout browseFrameLayout = (BrowseFrameLayout)this.getView().findViewById(R.id.details_fragment_root);
            browseFrameLayout.setOnFocusSearchListener(titleHelper.getOnFocusSearchListener());
        }
    }

    public void setSelectedPosition(int position) {
        this.setSelectedPosition(position, true);
    }

    public void setSelectedPosition(int position, boolean smooth) {
        this.mSetSelectionRunnable.mPosition = position;
        this.mSetSelectionRunnable.mSmooth = smooth;
        if (this.getView() != null && this.getView().getHandler() != null) {
            this.getView().getHandler().post((Runnable)this.mSetSelectionRunnable);
        }
    }

    private void onRowSelected(int selectedPosition, int selectedSubPosition) {
        ObjectAdapter adapter = this.getAdapter();
        if (adapter == null || adapter.size() == 0 || selectedPosition == 0 && selectedSubPosition == 0) {
            this.showTitle(true);
        } else {
            this.showTitle(false);
        }
        if (adapter != null && adapter.size() > selectedPosition) {
            VerticalGridView gridView = this.getVerticalGridView();
            int count = gridView.getChildCount();
            for (int i = 0; i < count; ++i) {
                ItemBridgeAdapter.ViewHolder bridgeViewHolder = (ItemBridgeAdapter.ViewHolder)gridView.getChildViewHolder(gridView.getChildAt(i));
                RowPresenter rowPresenter = (RowPresenter)bridgeViewHolder.getPresenter();
                this.onSetRowStatus(rowPresenter, rowPresenter.getRowViewHolder(bridgeViewHolder.getViewHolder()), bridgeViewHolder.getAdapterPosition(), selectedPosition, selectedSubPosition);
            }
        }
    }

    protected void onSetRowStatus(RowPresenter presenter, RowPresenter.ViewHolder viewHolder, int adapterPosition, int selectedPosition, int selectedSubPosition) {
        if (presenter instanceof FullWidthDetailsOverviewRowPresenter) {
            this.onSetDetailsOverviewRowStatus((FullWidthDetailsOverviewRowPresenter)presenter, (FullWidthDetailsOverviewRowPresenter.ViewHolder)viewHolder, adapterPosition, selectedPosition, selectedSubPosition);
        }
    }

    protected void onSetDetailsOverviewRowStatus(FullWidthDetailsOverviewRowPresenter presenter, FullWidthDetailsOverviewRowPresenter.ViewHolder viewHolder, int adapterPosition, int selectedPosition, int selectedSubPosition) {
        if (selectedPosition > adapterPosition) {
            presenter.setState(viewHolder, 0);
        } else if (selectedPosition == adapterPosition && selectedSubPosition == 1) {
            presenter.setState(viewHolder, 0);
        } else if (selectedPosition == adapterPosition && selectedSubPosition == 0) {
            presenter.setState(viewHolder, 1);
        } else {
            presenter.setState(viewHolder, 2);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        this.setupChildFragmentLayout();
        this.setupFocusSearchListener();
        this.mRowsFragment.getView().requestFocus();
        if (this.isEntranceTransitionEnabled()) {
            this.mRowsFragment.onTransitionStart();
            this.mRowsFragment.setEntranceTransitionState(false);
        }
    }

    @Override
    protected Object createEntranceTransition() {
        return sTransitionHelper.loadTransition((Context)this.getActivity(), R.transition.lb_details_enter_transition);
    }

    @Override
    protected void runEntranceTransition(Object entranceTransition) {
        sTransitionHelper.runTransition(this.mSceneAfterEntranceTransition, entranceTransition);
    }

    @Override
    protected void onEntranceTransitionEnd() {
        this.mRowsFragment.onTransitionEnd();
    }

    private class SetSelectionRunnable
    implements Runnable {
        int mPosition;
        boolean mSmooth = true;

        private SetSelectionRunnable() {
        }

        @Override
        public void run() {
            DetailsFragment.this.mRowsFragment.setSelectedPosition(this.mPosition, this.mSmooth);
        }
    }
}

