/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.TitleView;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

public class ErrorSupportFragment
extends Fragment {
    private View mErrorFrame;
    private String mTitle;
    private Drawable mBadgeDrawable;
    private TitleView mTitleView;
    private ImageView mImageView;
    private TextView mTextView;
    private Button mButton;
    private Drawable mDrawable;
    private CharSequence mMessage;
    private String mButtonText;
    private View.OnClickListener mButtonClickListener;
    private Drawable mBackgroundDrawable;
    private boolean mIsBackgroundTranslucent = true;

    public void setBadgeDrawable(Drawable drawable2) {
        this.mBadgeDrawable = drawable2;
        this.updateTitle();
    }

    public Drawable getBadgeDrawable() {
        return this.mBadgeDrawable;
    }

    public void setTitle(String title) {
        this.mTitle = title;
        this.updateTitle();
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setDefaultBackground(boolean translucent) {
        this.mBackgroundDrawable = null;
        this.mIsBackgroundTranslucent = translucent;
        this.updateBackground();
        this.updateMessage();
    }

    public boolean isBackgroundTranslucent() {
        return this.mIsBackgroundTranslucent;
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        this.mBackgroundDrawable = drawable2;
        if (drawable2 != null) {
            int opacity = drawable2.getOpacity();
            this.mIsBackgroundTranslucent = opacity == -3 || opacity == -2;
        }
        this.updateBackground();
        this.updateMessage();
    }

    public Drawable getBackgroundDrawable() {
        return this.mBackgroundDrawable;
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mDrawable = drawable2;
        this.updateImageDrawable();
    }

    public Drawable getImageDrawable() {
        return this.mDrawable;
    }

    public void setMessage(CharSequence message) {
        this.mMessage = message;
        this.updateMessage();
    }

    public CharSequence getMessage() {
        return this.mMessage;
    }

    public void setButtonText(String text) {
        this.mButtonText = text;
        this.updateButton();
    }

    public String getButtonText() {
        return this.mButtonText;
    }

    public void setButtonClickListener(View.OnClickListener clickListener) {
        this.mButtonClickListener = clickListener;
        this.updateButton();
    }

    public View.OnClickListener getButtonClickListener() {
        return this.mButtonClickListener;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.lb_error_fragment, container, false);
        this.mErrorFrame = root.findViewById(R.id.error_frame);
        this.updateBackground();
        this.mImageView = (ImageView)root.findViewById(R.id.image);
        this.updateImageDrawable();
        this.mTextView = (TextView)root.findViewById(R.id.message);
        this.updateMessage();
        this.mButton = (Button)root.findViewById(R.id.button);
        this.updateButton();
        this.mTitleView = (TitleView)root.findViewById(R.id.browse_title_group);
        this.updateTitle();
        Paint.FontMetricsInt metrics = ErrorSupportFragment.getFontMetricsInt(this.mTextView);
        int underImageBaselineMargin = container.getResources().getDimensionPixelSize(R.dimen.lb_error_under_image_baseline_margin);
        ErrorSupportFragment.setTopMargin(this.mTextView, underImageBaselineMargin + metrics.ascent);
        int underMessageBaselineMargin = container.getResources().getDimensionPixelSize(R.dimen.lb_error_under_message_baseline_margin);
        ErrorSupportFragment.setTopMargin((TextView)this.mButton, underMessageBaselineMargin - metrics.descent);
        return root;
    }

    private void updateBackground() {
        if (this.mErrorFrame != null) {
            if (this.mBackgroundDrawable != null) {
                this.mErrorFrame.setBackground(this.mBackgroundDrawable);
            } else {
                this.mErrorFrame.setBackgroundColor(this.mErrorFrame.getResources().getColor(this.mIsBackgroundTranslucent ? R.color.lb_error_background_color_translucent : R.color.lb_error_background_color_opaque));
            }
        }
    }

    private void updateTitle() {
        if (this.mTitleView != null) {
            this.mTitleView.setTitle(this.mTitle);
            this.mTitleView.setBadgeDrawable(this.mBadgeDrawable);
        }
    }

    private void updateMessage() {
        if (this.mTextView != null) {
            this.mTextView.setText(this.mMessage);
            this.mTextView.setVisibility(TextUtils.isEmpty((CharSequence)this.mMessage) ? 8 : 0);
        }
    }

    private void updateImageDrawable() {
        if (this.mImageView != null) {
            this.mImageView.setImageDrawable(this.mDrawable);
            this.mImageView.setVisibility(this.mDrawable == null ? 8 : 0);
        }
    }

    private void updateButton() {
        if (this.mButton != null) {
            this.mButton.setText((CharSequence)this.mButtonText);
            this.mButton.setOnClickListener(this.mButtonClickListener);
            this.mButton.setVisibility(TextUtils.isEmpty((CharSequence)this.mButtonText) ? 8 : 0);
            this.mButton.requestFocus();
        }
    }

    public void onStart() {
        super.onStart();
        this.mErrorFrame.requestFocus();
    }

    private static Paint.FontMetricsInt getFontMetricsInt(TextView textView) {
        Paint paint = new Paint(1);
        paint.setTextSize(textView.getTextSize());
        paint.setTypeface(textView.getTypeface());
        return paint.getFontMetricsInt();
    }

    private static void setTopMargin(TextView textView, int topMargin) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)textView.getLayoutParams();
        lp.topMargin = topMargin;
        textView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }
}

