/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v17.leanback.R;
import android.support.v17.leanback.animation.UntargetableAnimatorSet;
import android.support.v17.leanback.app.GuidedActionAdapter;
import android.support.v17.leanback.widget.GuidanceStylist;
import android.support.v17.leanback.widget.GuidedAction;
import android.support.v17.leanback.widget.GuidedActionsStylist;
import android.support.v17.leanback.widget.VerticalGridView;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.util.ArrayList;
import java.util.List;

public class GuidedStepFragment
extends Fragment
implements GuidedActionAdapter.ClickListener,
GuidedActionAdapter.FocusListener {
    private static final String TAG_LEAN_BACK_ACTIONS_FRAGMENT = "leanBackGuidedStepFragment";
    private static final String EXTRA_ACTION_SELECTED_INDEX = "selectedIndex";
    private static final String EXTRA_ACTION_ENTRY_TRANSITION_ENABLED = "entryTransitionEnabled";
    private static final String EXTRA_ENTRY_TRANSITION_PERFORMED = "entryTransitionPerformed";
    private static final String TAG = "GuidedStepFragment";
    private static final boolean DEBUG = true;
    private static final int ANIMATION_FRAGMENT_ENTER = 1;
    private static final int ANIMATION_FRAGMENT_EXIT = 2;
    private static final int ANIMATION_FRAGMENT_ENTER_POP = 3;
    private static final int ANIMATION_FRAGMENT_EXIT_POP = 4;
    private int mTheme;
    private GuidanceStylist mGuidanceStylist;
    private GuidedActionsStylist mActionsStylist;
    private GuidedActionAdapter mAdapter;
    private VerticalGridView mListView;
    private List<GuidedAction> mActions = new ArrayList<GuidedAction>();
    private int mSelectedIndex = -1;
    private boolean mEntryTransitionPerformed;
    private boolean mEntryTransitionEnabled = true;

    public GuidedStepFragment() {
        this.mTheme = this.onProvideTheme();
        this.mGuidanceStylist = this.onCreateGuidanceStylist();
        this.mActionsStylist = this.onCreateActionsStylist();
    }

    public GuidanceStylist onCreateGuidanceStylist() {
        return new GuidanceStylist();
    }

    public GuidedActionsStylist onCreateActionsStylist() {
        return new GuidedActionsStylist();
    }

    public int onProvideTheme() {
        return -1;
    }

    @NonNull
    public GuidanceStylist.Guidance onCreateGuidance(Bundle savedInstanceState) {
        return new GuidanceStylist.Guidance("", "", "", null);
    }

    public void onCreateActions(@NonNull List<GuidedAction> actions, Bundle savedInstanceState) {
    }

    @Override
    public void onGuidedActionClicked(GuidedAction action) {
    }

    @Override
    public void onGuidedActionFocused(GuidedAction action) {
    }

    public static int add(FragmentManager fragmentManager, GuidedStepFragment fragment) {
        return GuidedStepFragment.add(fragmentManager, fragment, 0x1020002);
    }

    private static int add(FragmentManager fm, GuidedStepFragment f, int id2) {
        boolean inGuidedStep = GuidedStepFragment.getCurrentGuidedStepFragment(fm) != null;
        FragmentTransaction ft = fm.beginTransaction();
        if (inGuidedStep) {
            ft.setCustomAnimations(1, 2, 3, 4);
            ft.addToBackStack(null);
        }
        return ft.replace(id2, (Fragment)f, TAG_LEAN_BACK_ACTIONS_FRAGMENT).commit();
    }

    public static GuidedStepFragment getCurrentGuidedStepFragment(FragmentManager fm) {
        Fragment f = fm.findFragmentByTag(TAG_LEAN_BACK_ACTIONS_FRAGMENT);
        if (f instanceof GuidedStepFragment) {
            return (GuidedStepFragment)f;
        }
        return null;
    }

    public GuidanceStylist getGuidanceStylist() {
        return this.mGuidanceStylist;
    }

    public GuidedActionsStylist getGuidedActionsStylist() {
        return this.mActionsStylist;
    }

    public List<GuidedAction> getActions() {
        return this.mActions;
    }

    public void setActions(List<GuidedAction> actions) {
        this.mActions = actions;
        if (this.mAdapter != null) {
            this.mAdapter.setActions(this.mActions);
        }
    }

    public View getActionItemView(int position) {
        return this.mListView.findViewHolderForPosition((int)position).itemView;
    }

    public void setSelectedActionPosition(int position) {
        this.mListView.setSelectedPosition(position);
    }

    public int getSelectedActionPosition() {
        return this.mListView.getSelectedPosition();
    }

    public void onCreate(Bundle savedInstanceState) {
        Bundle state;
        super.onCreate(savedInstanceState);
        Log.v((String)TAG, (String)"onCreate");
        Bundle bundle = state = savedInstanceState != null ? savedInstanceState : this.getArguments();
        if (state != null) {
            if (this.mSelectedIndex == -1) {
                this.mSelectedIndex = state.getInt(EXTRA_ACTION_SELECTED_INDEX, -1);
            }
            this.mEntryTransitionEnabled = state.getBoolean(EXTRA_ACTION_ENTRY_TRANSITION_ENABLED, true);
            this.mEntryTransitionPerformed = state.getBoolean(EXTRA_ENTRY_TRANSITION_PERFORMED, false);
        }
        this.mActions.clear();
        this.onCreateActions(this.mActions, savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Log.v((String)TAG, (String)"onCreateView");
        this.resolveTheme();
        inflater = this.getThemeInflater(inflater);
        View v = inflater.inflate(R.layout.lb_guidedstep_fragment, container, false);
        ViewGroup guidanceContainer = (ViewGroup)v.findViewById(R.id.content_fragment);
        ViewGroup actionContainer = (ViewGroup)v.findViewById(R.id.action_fragment);
        GuidanceStylist.Guidance guidance = this.onCreateGuidance(savedInstanceState);
        View guidanceView = this.mGuidanceStylist.onCreateView(inflater, guidanceContainer, guidance);
        guidanceContainer.addView(guidanceView);
        View actionsView = this.mActionsStylist.onCreateView(inflater, actionContainer);
        actionContainer.addView(actionsView);
        this.mAdapter = new GuidedActionAdapter(this.mActions, this, this, this.mActionsStylist);
        this.mListView = this.mActionsStylist.getActionsGridView();
        this.mListView.setAdapter(this.mAdapter);
        int pos = this.mSelectedIndex >= 0 && this.mSelectedIndex < this.mActions.size() ? this.mSelectedIndex : this.getFirstCheckedAction();
        this.mListView.setSelectedPosition(pos);
        return v;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(EXTRA_ACTION_SELECTED_INDEX, this.mListView != null ? this.getSelectedActionPosition() : this.mSelectedIndex);
        outState.putBoolean(EXTRA_ACTION_ENTRY_TRANSITION_ENABLED, this.mEntryTransitionEnabled);
        outState.putBoolean(EXTRA_ENTRY_TRANSITION_PERFORMED, this.mEntryTransitionPerformed);
    }

    public void onStart() {
        Log.v((String)TAG, (String)"onStart");
        super.onStart();
        if (this.isEntryTransitionEnabled() && !this.mEntryTransitionPerformed) {
            this.mEntryTransitionPerformed = true;
            this.performEntryTransition();
        }
    }

    public Animator onCreateAnimator(int transit, boolean enter, int nextAnim) {
        Log.v((String)TAG, (String)("onCreateAnimator: " + transit + " " + enter + " " + nextAnim));
        View mainView = this.getView();
        ArrayList<Animator> animators = new ArrayList<Animator>();
        switch (nextAnim) {
            case 1: {
                this.mGuidanceStylist.onFragmentEnter(animators);
                this.mActionsStylist.onFragmentEnter(animators);
                break;
            }
            case 2: {
                this.mGuidanceStylist.onFragmentExit(animators);
                this.mActionsStylist.onFragmentExit(animators);
                break;
            }
            case 3: {
                this.mGuidanceStylist.onFragmentReenter(animators);
                this.mActionsStylist.onFragmentReenter(animators);
                break;
            }
            case 4: {
                this.mGuidanceStylist.onFragmentReturn(animators);
                this.mActionsStylist.onFragmentReturn(animators);
                break;
            }
            default: {
                return super.onCreateAnimator(transit, enter, nextAnim);
            }
        }
        this.mEntryTransitionPerformed = true;
        return this.createDummyAnimator(mainView, animators);
    }

    protected boolean isEntryTransitionEnabled() {
        return this.mEntryTransitionEnabled;
    }

    protected void setEntryTransitionEnabled(boolean enabled) {
        this.mEntryTransitionEnabled = enabled;
    }

    private boolean isGuidedStepTheme(Context context) {
        int resId = R.attr.guidedStepThemeFlag;
        TypedValue typedValue = new TypedValue();
        boolean found = context.getTheme().resolveAttribute(resId, typedValue, true);
        Log.v((String)TAG, (String)("Found guided step theme flag? " + found));
        return found && typedValue.type == 18 && typedValue.data != 0;
    }

    private void resolveTheme() {
        boolean hasThemeReference = true;
        Activity activity = this.getActivity();
        if (this.mTheme == -1 && !this.isGuidedStepTheme((Context)activity)) {
            int resId = R.attr.guidedStepTheme;
            TypedValue typedValue = new TypedValue();
            boolean found = activity.getTheme().resolveAttribute(resId, typedValue, true);
            Log.v((String)TAG, (String)("Found guided step theme reference? " + found));
            if (found) {
                if (this.isGuidedStepTheme((Context)new ContextThemeWrapper((Context)activity, typedValue.resourceId))) {
                    this.mTheme = typedValue.resourceId;
                } else {
                    found = false;
                }
            }
            if (!found) {
                Log.e((String)TAG, (String)"GuidedStepFragment does not have an appropriate theme set.");
            }
        }
    }

    private LayoutInflater getThemeInflater(LayoutInflater inflater) {
        if (this.mTheme == -1) {
            return inflater;
        }
        ContextThemeWrapper ctw = new ContextThemeWrapper((Context)this.getActivity(), this.mTheme);
        return inflater.cloneInContext((Context)ctw);
    }

    private int getFirstCheckedAction() {
        int size = this.mActions.size();
        for (int i = 0; i < size; ++i) {
            if (!this.mActions.get(i).isChecked()) continue;
            return i;
        }
        return 0;
    }

    private void performEntryTransition() {
        Log.v((String)TAG, (String)"performEntryTransition");
        final View mainView = this.getView();
        mainView.setVisibility(4);
        ArrayList<Animator> animators = new ArrayList<Animator>();
        this.mGuidanceStylist.onActivityEnter(animators);
        this.mActionsStylist.onActivityEnter(animators);
        final Animator animator2 = this.createDummyAnimator(mainView, animators);
        mainView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                mainView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                if (!GuidedStepFragment.this.isAdded()) {
                    return;
                }
                mainView.setVisibility(0);
                animator2.start();
            }
        });
    }

    private Animator createDummyAnimator(View v, ArrayList<Animator> animators) {
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(animators);
        return new UntargetableAnimatorSet(animatorSet);
    }
}

