/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.support.v17.leanback.R;
import android.support.v17.leanback.app.BaseRowFragment;
import android.support.v17.leanback.widget.FocusHighlightHelper;
import android.support.v17.leanback.widget.ItemBridgeAdapter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.support.v17.leanback.widget.Row;
import android.support.v17.leanback.widget.RowHeaderPresenter;
import android.support.v17.leanback.widget.SinglePresenterSelector;
import android.support.v17.leanback.widget.VerticalGridView;
import android.support.v7.widget.RecyclerView;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;

public class HeadersFragment
extends BaseRowFragment {
    private OnHeaderViewSelectedListener mOnHeaderViewSelectedListener;
    private OnHeaderClickedListener mOnHeaderClickedListener;
    private boolean mHeadersEnabled = true;
    private boolean mHeadersGone = false;
    private int mBackgroundColor;
    private boolean mBackgroundColorSet;
    private static final PresenterSelector sHeaderPresenter = new SinglePresenterSelector(new RowHeaderPresenter(R.layout.lb_header));
    private final ItemBridgeAdapter.AdapterListener mAdapterListener = new ItemBridgeAdapter.AdapterListener(){

        @Override
        public void onCreate(ItemBridgeAdapter.ViewHolder viewHolder) {
            View headerView = viewHolder.getViewHolder().view;
            headerView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (HeadersFragment.this.mOnHeaderClickedListener != null) {
                        HeadersFragment.this.mOnHeaderClickedListener.onHeaderClicked();
                    }
                }
            });
            headerView.setFocusable(true);
            headerView.setFocusableInTouchMode(true);
            if (HeadersFragment.this.mWrapper != null) {
                viewHolder.itemView.addOnLayoutChangeListener(sLayoutChangeListener);
            } else {
                headerView.addOnLayoutChangeListener(sLayoutChangeListener);
            }
        }
    };
    private static View.OnLayoutChangeListener sLayoutChangeListener = new View.OnLayoutChangeListener(){

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            v.setPivotX(v.getLayoutDirection() == 1 ? (float)v.getWidth() : 0.0f);
            v.setPivotY((float)(v.getMeasuredHeight() / 2));
        }
    };
    private final ItemBridgeAdapter.Wrapper mWrapper = new ItemBridgeAdapter.Wrapper(){

        @Override
        public void wrap(View wrapper, View wrapped) {
            ((FrameLayout)wrapper).addView(wrapped);
        }

        @Override
        public View createWrapper(View root) {
            return new NoOverlappingFrameLayout(root.getContext());
        }
    };

    public HeadersFragment() {
        this.setPresenterSelector(sHeaderPresenter);
    }

    public void setOnHeaderClickedListener(OnHeaderClickedListener listener) {
        this.mOnHeaderClickedListener = listener;
    }

    public void setOnHeaderViewSelectedListener(OnHeaderViewSelectedListener listener) {
        this.mOnHeaderViewSelectedListener = listener;
    }

    @Override
    VerticalGridView findGridViewFromRoot(View view) {
        return (VerticalGridView)view.findViewById(R.id.browse_headers);
    }

    @Override
    void onRowSelected(RecyclerView parent, RecyclerView.ViewHolder viewHolder, int position, int subposition) {
        if (this.mOnHeaderViewSelectedListener != null) {
            if (viewHolder != null && position >= 0) {
                Row row = (Row)this.getAdapter().get(position);
                ItemBridgeAdapter.ViewHolder vh = (ItemBridgeAdapter.ViewHolder)viewHolder;
                this.mOnHeaderViewSelectedListener.onHeaderSelected((RowHeaderPresenter.ViewHolder)vh.getViewHolder(), row);
            } else {
                this.mOnHeaderViewSelectedListener.onHeaderSelected(null, null);
            }
        }
    }

    @Override
    int getLayoutResourceId() {
        return R.layout.lb_headers_fragment;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        VerticalGridView listView = this.getVerticalGridView();
        if (listView == null) {
            return;
        }
        if (this.getBridgeAdapter() != null) {
            FocusHighlightHelper.setupHeaderItemFocusHighlight(listView);
        }
        view.setBackgroundColor(this.getBackgroundColor());
        this.updateFadingEdgeToBrandColor(this.getBackgroundColor());
        this.updateListViewVisibility();
    }

    private void updateListViewVisibility() {
        VerticalGridView listView = this.getVerticalGridView();
        if (listView != null) {
            this.getView().setVisibility(this.mHeadersGone ? 8 : 0);
            if (!this.mHeadersGone) {
                if (this.mHeadersEnabled) {
                    listView.setChildrenVisibility(0);
                } else {
                    listView.setChildrenVisibility(4);
                }
            }
        }
    }

    void setHeadersEnabled(boolean enabled) {
        this.mHeadersEnabled = enabled;
        this.updateListViewVisibility();
    }

    void setHeadersGone(boolean gone) {
        this.mHeadersGone = gone;
        this.updateListViewVisibility();
    }

    @Override
    void updateAdapter() {
        super.updateAdapter();
        ItemBridgeAdapter adapter = this.getBridgeAdapter();
        if (adapter != null) {
            adapter.setAdapterListener(this.mAdapterListener);
            adapter.setWrapper(this.mWrapper);
        }
        if (adapter != null && this.getVerticalGridView() != null) {
            FocusHighlightHelper.setupHeaderItemFocusHighlight(this.getVerticalGridView());
        }
    }

    void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        this.mBackgroundColorSet = true;
        if (this.getView() != null) {
            this.getView().setBackgroundColor(this.mBackgroundColor);
            this.updateFadingEdgeToBrandColor(this.mBackgroundColor);
        }
    }

    private void updateFadingEdgeToBrandColor(int backgroundColor) {
        View fadingView = this.getView().findViewById(R.id.fade_out_edge);
        Drawable background = fadingView.getBackground();
        if (background instanceof GradientDrawable) {
            background.mutate();
            ((GradientDrawable)background).setColors(new int[]{0, backgroundColor});
        }
    }

    int getBackgroundColor() {
        if (this.getActivity() == null) {
            throw new IllegalStateException("Activity must be attached");
        }
        if (this.mBackgroundColorSet) {
            return this.mBackgroundColor;
        }
        TypedValue outValue = new TypedValue();
        if (this.getActivity().getTheme().resolveAttribute(R.attr.defaultBrandColor, outValue, true)) {
            return this.getResources().getColor(outValue.resourceId);
        }
        return this.getResources().getColor(R.color.lb_default_brand_color);
    }

    @Override
    void onTransitionStart() {
        VerticalGridView listView;
        super.onTransitionStart();
        if (!this.mHeadersEnabled && (listView = this.getVerticalGridView()) != null) {
            listView.setDescendantFocusability(131072);
            if (listView.hasFocus()) {
                listView.requestFocus();
            }
        }
    }

    @Override
    void onTransitionEnd() {
        VerticalGridView listView;
        if (this.mHeadersEnabled && (listView = this.getVerticalGridView()) != null) {
            listView.setDescendantFocusability(262144);
            if (listView.hasFocus()) {
                listView.requestFocus();
            }
        }
        super.onTransitionEnd();
    }

    static class NoOverlappingFrameLayout
    extends FrameLayout {
        public NoOverlappingFrameLayout(Context context) {
            super(context);
        }

        public boolean hasOverlappingRendering() {
            return false;
        }
    }

    static interface OnHeaderViewSelectedListener {
        public void onHeaderSelected(RowHeaderPresenter.ViewHolder var1, Row var2);
    }

    static interface OnHeaderClickedListener {
        public void onHeaderClicked();
    }
}

