/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.speech.SpeechRecognizer;
import android.support.v17.leanback.R;
import android.support.v17.leanback.app.RowsSupportFragment;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.OnItemViewClickedListener;
import android.support.v17.leanback.widget.OnItemViewSelectedListener;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.Row;
import android.support.v17.leanback.widget.RowPresenter;
import android.support.v17.leanback.widget.SearchBar;
import android.support.v17.leanback.widget.SpeechRecognitionCallback;
import android.support.v17.leanback.widget.VerticalGridView;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.List;

public class SearchSupportFragment
extends Fragment {
    private static final String TAG = SearchSupportFragment.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String EXTRA_LEANBACK_BADGE_PRESENT = "LEANBACK_BADGE_PRESENT";
    private static final String ARG_PREFIX = SearchSupportFragment.class.getCanonicalName();
    private static final String ARG_QUERY = ARG_PREFIX + ".query";
    private static final String ARG_TITLE = ARG_PREFIX + ".title";
    private static final long SPEECH_RECOGNITION_DELAY_MS = 300L;
    private static final int RESULTS_CHANGED = 1;
    private static final int QUERY_COMPLETE = 2;
    private final ObjectAdapter.DataObserver mAdapterObserver = new ObjectAdapter.DataObserver(){

        @Override
        public void onChanged() {
            SearchSupportFragment.this.mHandler.removeCallbacks(SearchSupportFragment.this.mResultsChangedCallback);
            SearchSupportFragment.this.mHandler.post(SearchSupportFragment.this.mResultsChangedCallback);
        }
    };
    private final Handler mHandler = new Handler();
    private final Runnable mResultsChangedCallback = new Runnable(){

        @Override
        public void run() {
            if (SearchSupportFragment.this.mRowsSupportFragment != null && SearchSupportFragment.this.mRowsSupportFragment.getAdapter() != SearchSupportFragment.this.mResultAdapter && (SearchSupportFragment.this.mRowsSupportFragment.getAdapter() != null || SearchSupportFragment.this.mResultAdapter.size() != 0)) {
                SearchSupportFragment.this.mRowsSupportFragment.setAdapter(SearchSupportFragment.this.mResultAdapter);
                SearchSupportFragment.this.mRowsSupportFragment.setSelectedPosition(0);
            }
            SearchSupportFragment.this.mStatus |= 1;
            if ((SearchSupportFragment.this.mStatus & 2) != 0) {
                SearchSupportFragment.this.updateFocus();
            }
            SearchSupportFragment.this.updateSearchBarNextFocusId();
        }
    };
    private final Runnable mSetSearchResultProvider = new Runnable(){

        @Override
        public void run() {
            if (SearchSupportFragment.this.mRowsSupportFragment == null) {
                return;
            }
            ObjectAdapter adapter = SearchSupportFragment.this.mProvider.getResultsAdapter();
            if (adapter != SearchSupportFragment.this.mResultAdapter) {
                boolean firstTime = SearchSupportFragment.this.mResultAdapter == null;
                SearchSupportFragment.this.releaseAdapter();
                SearchSupportFragment.this.mResultAdapter = adapter;
                if (SearchSupportFragment.this.mResultAdapter != null) {
                    SearchSupportFragment.this.mResultAdapter.registerObserver(SearchSupportFragment.this.mAdapterObserver);
                }
                if (!firstTime || SearchSupportFragment.this.mResultAdapter != null && SearchSupportFragment.this.mResultAdapter.size() != 0) {
                    SearchSupportFragment.this.mRowsSupportFragment.setAdapter(SearchSupportFragment.this.mResultAdapter);
                }
                SearchSupportFragment.this.executePendingQuery();
            }
            SearchSupportFragment.this.updateSearchBarNextFocusId();
            if (SearchSupportFragment.this.mAutoStartRecognition) {
                SearchSupportFragment.this.mHandler.removeCallbacks(SearchSupportFragment.this.mStartRecognitionRunnable);
                SearchSupportFragment.this.mHandler.postDelayed(SearchSupportFragment.this.mStartRecognitionRunnable, 300L);
            } else {
                SearchSupportFragment.this.updateFocus();
            }
        }
    };
    private final Runnable mStartRecognitionRunnable = new Runnable(){

        @Override
        public void run() {
            SearchSupportFragment.this.mAutoStartRecognition = false;
            SearchSupportFragment.this.mSearchBar.startRecognition();
        }
    };
    private RowsSupportFragment mRowsSupportFragment;
    private SearchBar mSearchBar;
    private SearchResultProvider mProvider;
    private String mPendingQuery = null;
    private OnItemViewSelectedListener mOnItemViewSelectedListener;
    private OnItemViewClickedListener mOnItemViewClickedListener;
    private ObjectAdapter mResultAdapter;
    private SpeechRecognitionCallback mSpeechRecognitionCallback;
    private String mTitle;
    private Drawable mBadgeDrawable;
    private ExternalQuery mExternalQuery;
    private SpeechRecognizer mSpeechRecognizer;
    private int mStatus;
    private boolean mAutoStartRecognition = true;

    public static Bundle createArgs(Bundle args, String query) {
        return SearchSupportFragment.createArgs(args, query, null);
    }

    public static Bundle createArgs(Bundle args, String query, String title) {
        if (args == null) {
            args = new Bundle();
        }
        args.putString(ARG_QUERY, query);
        args.putString(ARG_TITLE, title);
        return args;
    }

    public static SearchSupportFragment newInstance(String query) {
        SearchSupportFragment fragment = new SearchSupportFragment();
        Bundle args = SearchSupportFragment.createArgs(null, query);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        if (this.mAutoStartRecognition) {
            this.mAutoStartRecognition = savedInstanceState == null;
        }
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.lb_search_fragment, container, false);
        FrameLayout searchFrame = (FrameLayout)root.findViewById(R.id.lb_search_frame);
        this.mSearchBar = (SearchBar)searchFrame.findViewById(R.id.lb_search_bar);
        this.mSearchBar.setSearchBarListener(new SearchBar.SearchBarListener(){

            @Override
            public void onSearchQueryChange(String query) {
                if (null != SearchSupportFragment.this.mProvider) {
                    SearchSupportFragment.this.retrieveResults(query);
                } else {
                    SearchSupportFragment.this.mPendingQuery = query;
                }
            }

            @Override
            public void onSearchQuerySubmit(String query) {
                SearchSupportFragment.this.submitQuery(query);
            }

            @Override
            public void onKeyboardDismiss(String query) {
                SearchSupportFragment.this.queryComplete();
            }
        });
        this.mSearchBar.setSpeechRecognitionCallback(this.mSpeechRecognitionCallback);
        this.applyExternalQuery();
        this.readArguments(this.getArguments());
        if (null != this.mBadgeDrawable) {
            this.setBadgeDrawable(this.mBadgeDrawable);
        }
        if (null != this.mTitle) {
            this.setTitle(this.mTitle);
        }
        if (this.getChildFragmentManager().findFragmentById(R.id.lb_results_frame) == null) {
            this.mRowsSupportFragment = new RowsSupportFragment();
            this.getChildFragmentManager().beginTransaction().replace(R.id.lb_results_frame, (Fragment)this.mRowsSupportFragment).commit();
        } else {
            this.mRowsSupportFragment = (RowsSupportFragment)this.getChildFragmentManager().findFragmentById(R.id.lb_results_frame);
        }
        this.mRowsSupportFragment.setOnItemViewSelectedListener(new OnItemViewSelectedListener(){

            @Override
            public void onItemSelected(Presenter.ViewHolder itemViewHolder, Object item, RowPresenter.ViewHolder rowViewHolder, Row row) {
                int position = SearchSupportFragment.this.mRowsSupportFragment.getVerticalGridView().getSelectedPosition();
                SearchSupportFragment.this.mSearchBar.setVisibility(0 >= position ? 0 : 8);
                if (null != SearchSupportFragment.this.mOnItemViewSelectedListener) {
                    SearchSupportFragment.this.mOnItemViewSelectedListener.onItemSelected(itemViewHolder, item, rowViewHolder, row);
                }
            }
        });
        this.mRowsSupportFragment.setOnItemViewClickedListener(this.mOnItemViewClickedListener);
        this.mRowsSupportFragment.setExpand(true);
        if (null != this.mProvider) {
            this.onSetSearchResultProvider();
        }
        return root;
    }

    private void resultsAvailable() {
        if ((this.mStatus & 2) != 0) {
            this.focusOnResults();
        }
        this.updateSearchBarNextFocusId();
    }

    public void onStart() {
        super.onStart();
        VerticalGridView list = this.mRowsSupportFragment.getVerticalGridView();
        int mContainerListAlignTop = this.getResources().getDimensionPixelSize(R.dimen.lb_search_browse_rows_align_top);
        list.setItemAlignmentOffset(0);
        list.setItemAlignmentOffsetPercent(-1.0f);
        list.setWindowAlignmentOffset(mContainerListAlignTop);
        list.setWindowAlignmentOffsetPercent(-1.0f);
        list.setWindowAlignment(0);
    }

    public void onResume() {
        super.onResume();
        if (this.mSpeechRecognitionCallback == null && null == this.mSpeechRecognizer) {
            this.mSpeechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)this.getActivity());
            this.mSearchBar.setSpeechRecognizer(this.mSpeechRecognizer);
        }
        this.mSearchBar.stopRecognition();
    }

    public void onPause() {
        this.releaseRecognizer();
        super.onPause();
    }

    public void onDestroy() {
        this.releaseAdapter();
        super.onDestroy();
    }

    private void releaseRecognizer() {
        if (null != this.mSpeechRecognizer) {
            this.mSearchBar.setSpeechRecognizer(null);
            this.mSpeechRecognizer.destroy();
            this.mSpeechRecognizer = null;
        }
    }

    public void startRecognition() {
        this.mSearchBar.startRecognition();
    }

    public void setSearchResultProvider(SearchResultProvider searchResultProvider) {
        if (this.mProvider != searchResultProvider) {
            this.mProvider = searchResultProvider;
            this.onSetSearchResultProvider();
        }
    }

    public void setOnItemViewSelectedListener(OnItemViewSelectedListener listener) {
        this.mOnItemViewSelectedListener = listener;
    }

    public void setOnItemViewClickedListener(OnItemViewClickedListener listener) {
        if (listener != this.mOnItemViewClickedListener) {
            this.mOnItemViewClickedListener = listener;
            if (this.mRowsSupportFragment != null) {
                this.mRowsSupportFragment.setOnItemViewClickedListener(this.mOnItemViewClickedListener);
            }
        }
    }

    public void setTitle(String title) {
        this.mTitle = title;
        if (null != this.mSearchBar) {
            this.mSearchBar.setTitle(title);
        }
    }

    public String getTitle() {
        if (null != this.mSearchBar) {
            return this.mSearchBar.getTitle();
        }
        return null;
    }

    public void setBadgeDrawable(Drawable drawable2) {
        this.mBadgeDrawable = drawable2;
        if (null != this.mSearchBar) {
            this.mSearchBar.setBadgeDrawable(drawable2);
        }
    }

    public Drawable getBadgeDrawable() {
        if (null != this.mSearchBar) {
            return this.mSearchBar.getBadgeDrawable();
        }
        return null;
    }

    public void displayCompletions(List<String> completions) {
        this.mSearchBar.displayCompletions(completions);
    }

    public void setSpeechRecognitionCallback(SpeechRecognitionCallback callback) {
        this.mSpeechRecognitionCallback = callback;
        if (this.mSearchBar != null) {
            this.mSearchBar.setSpeechRecognitionCallback(this.mSpeechRecognitionCallback);
        }
        if (callback != null) {
            this.releaseRecognizer();
        }
    }

    public void setSearchQuery(String query, boolean submit) {
        if (query == null) {
            return;
        }
        this.mExternalQuery = new ExternalQuery(query, submit);
        this.applyExternalQuery();
        if (this.mAutoStartRecognition) {
            this.mAutoStartRecognition = false;
            this.mHandler.removeCallbacks(this.mStartRecognitionRunnable);
        }
    }

    public void setSearchQuery(Intent intent, boolean submit) {
        ArrayList matches = intent.getStringArrayListExtra("android.speech.extra.RESULTS");
        if (matches != null && matches.size() > 0) {
            this.setSearchQuery((String)matches.get(0), submit);
        }
    }

    public Intent getRecognizerIntent() {
        Intent recognizerIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        recognizerIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        recognizerIntent.putExtra("android.speech.extra.PARTIAL_RESULTS", true);
        if (this.mSearchBar != null && this.mSearchBar.getHint() != null) {
            recognizerIntent.putExtra("android.speech.extra.PROMPT", this.mSearchBar.getHint());
        }
        recognizerIntent.putExtra(EXTRA_LEANBACK_BADGE_PRESENT, this.mBadgeDrawable != null);
        return recognizerIntent;
    }

    private void retrieveResults(String searchQuery) {
        if (this.mProvider.onQueryTextChange(searchQuery)) {
            this.mStatus &= 0xFFFFFFFD;
        }
    }

    private void submitQuery(String query) {
        this.queryComplete();
        if (null != this.mProvider) {
            this.mProvider.onQueryTextSubmit(query);
        }
    }

    private void queryComplete() {
        this.mStatus |= 2;
        this.focusOnResults();
    }

    private void updateSearchBarNextFocusId() {
        if (this.mSearchBar == null || this.mResultAdapter == null) {
            return;
        }
        int viewId = this.mResultAdapter.size() == 0 || this.mRowsSupportFragment == null || this.mRowsSupportFragment.getVerticalGridView() == null ? 0 : this.mRowsSupportFragment.getVerticalGridView().getId();
        this.mSearchBar.setNextFocusDownId(viewId);
    }

    private void updateFocus() {
        if (this.mResultAdapter != null && this.mResultAdapter.size() > 0 && this.mRowsSupportFragment != null && this.mRowsSupportFragment.getAdapter() == this.mResultAdapter) {
            this.focusOnResults();
        } else {
            this.mSearchBar.requestFocus();
        }
    }

    private void focusOnResults() {
        if (this.mRowsSupportFragment == null || this.mRowsSupportFragment.getVerticalGridView() == null || this.mResultAdapter.size() == 0) {
            return;
        }
        if (this.mRowsSupportFragment.getVerticalGridView().requestFocus()) {
            this.mStatus &= 0xFFFFFFFE;
        }
    }

    private void onSetSearchResultProvider() {
        this.mHandler.removeCallbacks(this.mSetSearchResultProvider);
        this.mHandler.post(this.mSetSearchResultProvider);
    }

    private void releaseAdapter() {
        if (this.mResultAdapter != null) {
            this.mResultAdapter.unregisterObserver(this.mAdapterObserver);
            this.mResultAdapter = null;
        }
    }

    private void executePendingQuery() {
        if (null != this.mPendingQuery && null != this.mResultAdapter) {
            String query = this.mPendingQuery;
            this.mPendingQuery = null;
            this.retrieveResults(query);
        }
    }

    private void applyExternalQuery() {
        if (this.mExternalQuery == null || this.mSearchBar == null) {
            return;
        }
        this.mSearchBar.setSearchQuery(this.mExternalQuery.mQuery);
        if (this.mExternalQuery.mSubmit) {
            this.submitQuery(this.mExternalQuery.mQuery);
        }
        this.mExternalQuery = null;
    }

    private void readArguments(Bundle args) {
        if (null == args) {
            return;
        }
        if (args.containsKey(ARG_QUERY)) {
            this.setSearchQuery(args.getString(ARG_QUERY));
        }
        if (args.containsKey(ARG_TITLE)) {
            this.setTitle(args.getString(ARG_TITLE));
        }
    }

    private void setSearchQuery(String query) {
        this.mSearchBar.setSearchQuery(query);
    }

    static class ExternalQuery {
        String mQuery;
        boolean mSubmit;

        ExternalQuery(String query, boolean submit) {
            this.mQuery = query;
            this.mSubmit = submit;
        }
    }

    public static interface SearchResultProvider {
        public ObjectAdapter getResultsAdapter();

        public boolean onQueryTextChange(String var1);

        public boolean onQueryTextSubmit(String var1);
    }
}

