/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.system;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.support.v17.leanback.widget.ShadowOverlayContainer;

public class Settings {
    private static final String TAG = "Settings";
    private static final boolean DEBUG = false;
    private static final String ACTION_PARTNER_CUSTOMIZATION = "android.support.v17.leanback.action.PARTNER_CUSTOMIZATION";
    public static final String PREFER_STATIC_SHADOWS = "PREFER_STATIC_SHADOWS";
    private static Settings sInstance;
    private boolean mPreferStaticShadows;

    public static Settings getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new Settings(context);
        }
        return sInstance;
    }

    private Settings(Context context) {
        Customizations customizations = this.getCustomizations(context);
        this.generateShadowSetting(customizations);
    }

    public boolean preferStaticShadows() {
        return this.mPreferStaticShadows;
    }

    public boolean getBoolean(String key) {
        return this.getOrSetBoolean(key, false, false);
    }

    public void setBoolean(String key, boolean value) {
        this.getOrSetBoolean(key, true, value);
    }

    boolean getOrSetBoolean(String key, boolean set, boolean value) {
        if (key.compareTo(PREFER_STATIC_SHADOWS) == 0) {
            return set ? (this.mPreferStaticShadows = value) : this.mPreferStaticShadows;
        }
        throw new IllegalArgumentException("Invalid key");
    }

    private void generateShadowSetting(Customizations customizations) {
        if (ShadowOverlayContainer.supportsDynamicShadow()) {
            this.mPreferStaticShadows = false;
            if (customizations != null) {
                this.mPreferStaticShadows = customizations.getBoolean("leanback_prefer_static_shadows", this.mPreferStaticShadows);
            }
        } else {
            this.mPreferStaticShadows = true;
        }
    }

    private Customizations getCustomizations(Context context) {
        PackageManager pm = context.getPackageManager();
        Intent intent = new Intent(ACTION_PARTNER_CUSTOMIZATION);
        Resources resources = null;
        String packageName = null;
        for (ResolveInfo info : pm.queryBroadcastReceivers(intent, 0)) {
            packageName = info.activityInfo.packageName;
            if (packageName != null && Settings.isSystemApp(info)) {
                try {
                    resources = pm.getResourcesForApplication(packageName);
                }
                catch (PackageManager.NameNotFoundException ex) {
                    // empty catch block
                }
            }
            if (resources == null) continue;
            break;
        }
        return resources == null ? null : new Customizations(resources, packageName);
    }

    private static boolean isSystemApp(ResolveInfo info) {
        return info.activityInfo != null && (info.activityInfo.applicationInfo.flags & 1) != 0;
    }

    static class Customizations {
        Resources mResources;
        String mPackageName;

        public Customizations(Resources resources, String packageName) {
            this.mResources = resources;
            this.mPackageName = packageName;
        }

        public boolean getBoolean(String resourceName, boolean defaultValue) {
            int resId = this.mResources.getIdentifier(resourceName, "bool", this.mPackageName);
            return resId > 0 ? this.mResources.getBoolean(resId) : defaultValue;
        }
    }
}

