/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.Action;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;

class ActionPresenterSelector
extends PresenterSelector {
    private final Presenter mOneLineActionPresenter = new OneLineActionPresenter();
    private final Presenter mTwoLineActionPresenter = new TwoLineActionPresenter();
    private final Presenter[] mPresenters = new Presenter[]{this.mOneLineActionPresenter, this.mTwoLineActionPresenter};

    ActionPresenterSelector() {
    }

    @Override
    public Presenter getPresenter(Object item) {
        Action action = (Action)item;
        if (TextUtils.isEmpty((CharSequence)action.getLabel2())) {
            return this.mOneLineActionPresenter;
        }
        return this.mTwoLineActionPresenter;
    }

    @Override
    public Presenter[] getPresenters() {
        return this.mPresenters;
    }

    class TwoLineActionPresenter
    extends Presenter {
        TwoLineActionPresenter() {
        }

        @Override
        public Presenter.ViewHolder onCreateViewHolder(ViewGroup parent) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.lb_action_2_lines, parent, false);
            return new ActionViewHolder(v, parent.getLayoutDirection());
        }

        @Override
        public void onBindViewHolder(Presenter.ViewHolder viewHolder, Object item) {
            Action action = (Action)item;
            ActionViewHolder vh = (ActionViewHolder)viewHolder;
            Drawable icon = action.getIcon();
            vh.mAction = action;
            if (icon != null) {
                int startPadding = vh.view.getResources().getDimensionPixelSize(R.dimen.lb_action_with_icon_padding_start);
                int endPadding = vh.view.getResources().getDimensionPixelSize(R.dimen.lb_action_with_icon_padding_end);
                vh.view.setPaddingRelative(startPadding, 0, endPadding, 0);
            } else {
                int padding = vh.view.getResources().getDimensionPixelSize(R.dimen.lb_action_padding_horizontal);
                vh.view.setPaddingRelative(padding, 0, padding, 0);
            }
            if (vh.mLayoutDirection == 1) {
                vh.mButton.setCompoundDrawablesWithIntrinsicBounds(null, null, icon, null);
            } else {
                vh.mButton.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
            }
            CharSequence line1 = action.getLabel1();
            CharSequence line2 = action.getLabel2();
            if (TextUtils.isEmpty((CharSequence)line1)) {
                vh.mButton.setText(line2);
            } else if (TextUtils.isEmpty((CharSequence)line2)) {
                vh.mButton.setText(line1);
            } else {
                vh.mButton.setText((CharSequence)(line1 + "\n" + line2));
            }
        }

        @Override
        public void onUnbindViewHolder(Presenter.ViewHolder viewHolder) {
            ActionViewHolder vh = (ActionViewHolder)viewHolder;
            vh.mButton.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
            vh.view.setPadding(0, 0, 0, 0);
            vh.mAction = null;
        }
    }

    class OneLineActionPresenter
    extends Presenter {
        OneLineActionPresenter() {
        }

        @Override
        public Presenter.ViewHolder onCreateViewHolder(ViewGroup parent) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.lb_action_1_line, parent, false);
            return new ActionViewHolder(v, parent.getLayoutDirection());
        }

        @Override
        public void onBindViewHolder(Presenter.ViewHolder viewHolder, Object item) {
            Action action = (Action)item;
            ActionViewHolder vh = (ActionViewHolder)viewHolder;
            vh.mAction = action;
            vh.mButton.setText(action.getLabel1());
        }

        @Override
        public void onUnbindViewHolder(Presenter.ViewHolder viewHolder) {
            ((ActionViewHolder)viewHolder).mAction = null;
        }
    }

    static class ActionViewHolder
    extends Presenter.ViewHolder {
        Action mAction;
        Button mButton;
        int mLayoutDirection;

        public ActionViewHolder(View view, int layoutDirection) {
            super(view);
            this.mButton = (Button)view.findViewById(R.id.lb_action_button);
            this.mLayoutDirection = layoutDirection;
        }
    }
}

