/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ArrayObjectAdapter
extends ObjectAdapter {
    private ArrayList<Object> mItems = new ArrayList();

    public ArrayObjectAdapter(PresenterSelector presenterSelector) {
        super(presenterSelector);
    }

    public ArrayObjectAdapter(Presenter presenter) {
        super(presenter);
    }

    public ArrayObjectAdapter() {
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    @Override
    public Object get(int index) {
        return this.mItems.get(index);
    }

    public int indexOf(Object item) {
        return this.mItems.indexOf(item);
    }

    public void notifyArrayItemRangeChanged(int positionStart, int itemCount) {
        this.notifyItemRangeChanged(positionStart, itemCount);
    }

    public void add(Object item) {
        this.add(this.mItems.size(), item);
    }

    public void add(int index, Object item) {
        this.mItems.add(index, item);
        this.notifyItemRangeInserted(index, 1);
    }

    public void addAll(int index, Collection items) {
        int itemsCount = items.size();
        if (itemsCount == 0) {
            return;
        }
        this.mItems.addAll(index, items);
        this.notifyItemRangeInserted(index, itemsCount);
    }

    public boolean remove(Object item) {
        int index = this.mItems.indexOf(item);
        if (index >= 0) {
            this.mItems.remove(index);
            this.notifyItemRangeRemoved(index, 1);
        }
        return index >= 0;
    }

    public void replace(int position, Object item) {
        this.mItems.set(position, item);
        this.notifyItemRangeChanged(position, 1);
    }

    public int removeItems(int position, int count) {
        int itemsToRemove = Math.min(count, this.mItems.size() - position);
        if (itemsToRemove <= 0) {
            return 0;
        }
        for (int i = 0; i < itemsToRemove; ++i) {
            this.mItems.remove(position);
        }
        this.notifyItemRangeRemoved(position, itemsToRemove);
        return itemsToRemove;
    }

    public void clear() {
        int itemCount = this.mItems.size();
        if (itemCount == 0) {
            return;
        }
        this.mItems.clear();
        this.notifyItemRangeRemoved(0, itemCount);
    }

    public <E> List<E> unmodifiableList() {
        return Collections.unmodifiableList(this.mItems);
    }
}

