/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v17.leanback.R;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.FrameLayout;
import java.util.ArrayList;

public class BaseCardView
extends FrameLayout {
    private static final String TAG = "BaseCardView";
    private static final boolean DEBUG = false;
    public static final int CARD_TYPE_MAIN_ONLY = 0;
    public static final int CARD_TYPE_INFO_OVER = 1;
    public static final int CARD_TYPE_INFO_UNDER = 2;
    public static final int CARD_TYPE_INFO_UNDER_WITH_EXTRA = 3;
    public static final int CARD_REGION_VISIBLE_ALWAYS = 0;
    public static final int CARD_REGION_VISIBLE_ACTIVATED = 1;
    public static final int CARD_REGION_VISIBLE_SELECTED = 2;
    private static final int CARD_TYPE_INVALID = 4;
    private int mCardType;
    private int mInfoVisibility;
    private int mExtraVisibility;
    private ArrayList<View> mMainViewList;
    private ArrayList<View> mInfoViewList;
    private ArrayList<View> mExtraViewList;
    private int mMeasuredWidth;
    private int mMeasuredHeight;
    private boolean mDelaySelectedAnim;
    private int mSelectedAnimationDelay;
    private final int mActivatedAnimDuration;
    private final int mSelectedAnimDuration;
    private float mInfoOffset;
    private float mInfoVisFraction;
    private float mInfoAlpha = 1.0f;
    private Animation mAnim;
    private static final int[] LB_PRESSED_STATE_SET = new int[]{16842919};
    private final Runnable mAnimationTrigger = new Runnable(){

        @Override
        public void run() {
            BaseCardView.this.animateInfoOffset(true);
        }
    };

    public BaseCardView(Context context) {
        this(context, null);
    }

    public BaseCardView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.baseCardViewStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseCardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.lbBaseCardView, defStyle, 0);
        try {
            this.mCardType = a.getInteger(R.styleable.lbBaseCardView_cardType, 0);
            this.mInfoVisibility = a.getInteger(R.styleable.lbBaseCardView_infoVisibility, 1);
            this.mExtraVisibility = a.getInteger(R.styleable.lbBaseCardView_extraVisibility, 2);
            if (this.mExtraVisibility < this.mInfoVisibility) {
                this.mExtraVisibility = this.mInfoVisibility;
            }
            this.mSelectedAnimationDelay = a.getInteger(R.styleable.lbBaseCardView_selectedAnimationDelay, this.getResources().getInteger(R.integer.lb_card_selected_animation_delay));
            this.mSelectedAnimDuration = a.getInteger(R.styleable.lbBaseCardView_selectedAnimationDuration, this.getResources().getInteger(R.integer.lb_card_selected_animation_duration));
            this.mActivatedAnimDuration = a.getInteger(R.styleable.lbBaseCardView_activatedAnimationDuration, this.getResources().getInteger(R.integer.lb_card_activated_animation_duration));
        }
        finally {
            a.recycle();
        }
        this.mDelaySelectedAnim = true;
        this.mMainViewList = new ArrayList();
        this.mInfoViewList = new ArrayList();
        this.mExtraViewList = new ArrayList();
        this.mInfoOffset = 0.0f;
        this.mInfoVisFraction = 0.0f;
    }

    public void setSelectedAnimationDelayed(boolean delay) {
        this.mDelaySelectedAnim = delay;
    }

    public boolean isSelectedAnimationDelayed() {
        return this.mDelaySelectedAnim;
    }

    public void setCardType(int type) {
        if (this.mCardType != type) {
            if (type >= 0 && type < 4) {
                this.mCardType = type;
            } else {
                Log.e((String)TAG, (String)("Invalid card type specified: " + type + ". Defaulting to type CARD_TYPE_MAIN_ONLY."));
                this.mCardType = 0;
            }
            this.requestLayout();
        }
    }

    public int getCardType() {
        return this.mCardType;
    }

    public void setInfoVisibility(int visibility) {
        if (this.mInfoVisibility != visibility) {
            this.mInfoVisibility = visibility;
            this.mInfoVisFraction = this.mInfoVisibility == 2 && this.isSelected() ? 1.0f : 0.0f;
            this.requestLayout();
        }
    }

    public int getInfoVisibility() {
        return this.mInfoVisibility;
    }

    public void setExtraVisibility(int visibility) {
        if (this.mExtraVisibility != visibility) {
            this.mExtraVisibility = visibility;
            this.requestLayout();
        }
    }

    public int getExtraVisibility() {
        return this.mExtraVisibility;
    }

    public void setActivated(boolean activated) {
        if (activated != this.isActivated()) {
            super.setActivated(activated);
            this.applyActiveState(this.isActivated());
        }
    }

    public void setSelected(boolean selected) {
        if (selected != this.isSelected()) {
            super.setSelected(selected);
            this.applySelectedState(this.isSelected());
        }
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mMeasuredWidth = 0;
        this.mMeasuredHeight = 0;
        int state = 0;
        int mainHeight = 0;
        int infoHeight = 0;
        int extraHeight = 0;
        this.findChildrenViews();
        int unspecifiedSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        for (int i = 0; i < this.mMainViewList.size(); ++i) {
            View mainView = this.mMainViewList.get(i);
            if (mainView.getVisibility() == 8) continue;
            this.measureChild(mainView, unspecifiedSpec, unspecifiedSpec);
            this.mMeasuredWidth = Math.max(this.mMeasuredWidth, mainView.getMeasuredWidth());
            mainHeight += mainView.getMeasuredHeight();
            state = View.combineMeasuredStates((int)state, (int)mainView.getMeasuredState());
        }
        this.setPivotX(this.mMeasuredWidth / 2);
        this.setPivotY(mainHeight / 2);
        int cardWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMeasuredWidth, (int)0x40000000);
        if (this.hasInfoRegion()) {
            int i;
            for (i = 0; i < this.mInfoViewList.size(); ++i) {
                View infoView = this.mInfoViewList.get(i);
                if (infoView.getVisibility() == 8) continue;
                this.measureChild(infoView, cardWidthMeasureSpec, unspecifiedSpec);
                if (this.mCardType != 1) {
                    infoHeight += infoView.getMeasuredHeight();
                }
                state = View.combineMeasuredStates((int)state, (int)infoView.getMeasuredState());
            }
            if (this.hasExtraRegion()) {
                for (i = 0; i < this.mExtraViewList.size(); ++i) {
                    View extraView = this.mExtraViewList.get(i);
                    if (extraView.getVisibility() == 8) continue;
                    this.measureChild(extraView, cardWidthMeasureSpec, unspecifiedSpec);
                    extraHeight += extraView.getMeasuredHeight();
                    state = View.combineMeasuredStates((int)state, (int)extraView.getMeasuredState());
                }
            }
        }
        boolean infoAnimating = this.hasInfoRegion() && this.mInfoVisibility == 2;
        this.mMeasuredHeight = (int)((float)mainHeight + (infoAnimating ? (float)infoHeight * this.mInfoVisFraction : (float)infoHeight) + (float)extraHeight - (infoAnimating ? 0.0f : this.mInfoOffset));
        this.setMeasuredDimension(View.resolveSizeAndState((int)(this.mMeasuredWidth + this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec, (int)state), View.resolveSizeAndState((int)(this.mMeasuredHeight + this.getPaddingTop() + this.getPaddingBottom()), (int)heightMeasureSpec, (int)(state << 16)));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        float currBottom = this.getPaddingTop();
        for (int i = 0; i < this.mMainViewList.size(); ++i) {
            View mainView = this.mMainViewList.get(i);
            if (mainView.getVisibility() == 8) continue;
            mainView.layout(this.getPaddingLeft(), (int)currBottom, this.mMeasuredWidth + this.getPaddingLeft(), (int)(currBottom + (float)mainView.getMeasuredHeight()));
            currBottom += (float)mainView.getMeasuredHeight();
        }
        if (this.hasInfoRegion()) {
            int i;
            float infoHeight = 0.0f;
            for (i = 0; i < this.mInfoViewList.size(); ++i) {
                infoHeight += (float)this.mInfoViewList.get(i).getMeasuredHeight();
            }
            if (this.mCardType == 1) {
                if ((currBottom -= infoHeight) < 0.0f) {
                    currBottom = 0.0f;
                }
            } else if (this.mCardType == 2) {
                if (this.mInfoVisibility == 2) {
                    infoHeight *= this.mInfoVisFraction;
                }
            } else {
                currBottom -= this.mInfoOffset;
            }
            for (i = 0; i < this.mInfoViewList.size(); ++i) {
                View infoView = this.mInfoViewList.get(i);
                if (infoView.getVisibility() == 8) continue;
                int viewHeight = infoView.getMeasuredHeight();
                if ((float)viewHeight > infoHeight) {
                    viewHeight = (int)infoHeight;
                }
                infoView.layout(this.getPaddingLeft(), (int)currBottom, this.mMeasuredWidth + this.getPaddingLeft(), (int)(currBottom + (float)viewHeight));
                currBottom += (float)viewHeight;
                if ((infoHeight -= (float)viewHeight) <= 0.0f) break;
            }
            if (this.hasExtraRegion()) {
                for (i = 0; i < this.mExtraViewList.size(); ++i) {
                    View extraView = this.mExtraViewList.get(i);
                    if (extraView.getVisibility() == 8) continue;
                    extraView.layout(this.getPaddingLeft(), (int)currBottom, this.mMeasuredWidth + this.getPaddingLeft(), (int)(currBottom + (float)extraView.getMeasuredHeight()));
                    currBottom += (float)extraView.getMeasuredHeight();
                }
            }
        }
        this.onSizeChanged(0, 0, right - left, bottom - top);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mAnimationTrigger);
        this.cancelAnimations();
        this.mInfoOffset = 0.0f;
        this.mInfoVisFraction = 0.0f;
    }

    private boolean hasInfoRegion() {
        return this.mCardType != 0;
    }

    private boolean hasExtraRegion() {
        return this.mCardType == 3;
    }

    private boolean isRegionVisible(int regionVisibility) {
        switch (regionVisibility) {
            case 0: {
                return true;
            }
            case 1: {
                return this.isActivated();
            }
            case 2: {
                return this.isActivated() && this.isSelected();
            }
        }
        return false;
    }

    private void findChildrenViews() {
        boolean extraVisible;
        this.mMainViewList.clear();
        this.mInfoViewList.clear();
        this.mExtraViewList.clear();
        int count = this.getChildCount();
        boolean infoVisible = this.isRegionVisible(this.mInfoVisibility);
        boolean bl = extraVisible = this.hasExtraRegion() && this.mInfoOffset > 0.0f;
        if (this.mCardType == 2 && this.mInfoVisibility == 2) {
            infoVisible = infoVisible && this.mInfoVisFraction > 0.0f;
        }
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.viewType == 1) {
                this.mInfoViewList.add(child);
                child.setVisibility(infoVisible ? 0 : 8);
                continue;
            }
            if (lp.viewType == 2) {
                this.mExtraViewList.add(child);
                child.setVisibility(extraVisible ? 0 : 8);
                continue;
            }
            this.mMainViewList.add(child);
            child.setVisibility(0);
        }
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] s = super.onCreateDrawableState(extraSpace);
        int N = s.length;
        boolean pressed = false;
        boolean enabled = false;
        for (int i = 0; i < N; ++i) {
            if (s[i] == 16842919) {
                pressed = true;
            }
            if (s[i] != 16842910) continue;
            enabled = true;
        }
        if (pressed && enabled) {
            return View.PRESSED_ENABLED_STATE_SET;
        }
        if (pressed) {
            return LB_PRESSED_STATE_SET;
        }
        if (enabled) {
            return View.ENABLED_STATE_SET;
        }
        return View.EMPTY_STATE_SET;
    }

    private void applyActiveState(boolean active) {
        if (this.hasInfoRegion() && this.mInfoVisibility <= 1) {
            this.setInfoViewVisibility(active);
        }
        if (!this.hasExtraRegion() || this.mExtraVisibility <= 1) {
            // empty if block
        }
    }

    private void setInfoViewVisibility(boolean visible) {
        if (this.mCardType == 3) {
            if (visible) {
                for (int i = 0; i < this.mInfoViewList.size(); ++i) {
                    this.mInfoViewList.get(i).setVisibility(0);
                }
            } else {
                int i;
                for (i = 0; i < this.mInfoViewList.size(); ++i) {
                    this.mInfoViewList.get(i).setVisibility(8);
                }
                for (i = 0; i < this.mExtraViewList.size(); ++i) {
                    this.mExtraViewList.get(i).setVisibility(8);
                }
                this.mInfoOffset = 0.0f;
            }
        } else if (this.mCardType == 2) {
            if (this.mInfoVisibility == 2) {
                this.animateInfoHeight(visible);
            } else {
                for (int i = 0; i < this.mInfoViewList.size(); ++i) {
                    this.mInfoViewList.get(i).setVisibility(visible ? 0 : 8);
                }
            }
        } else if (this.mCardType == 1) {
            this.animateInfoAlpha(visible);
        }
    }

    private void applySelectedState(boolean focused) {
        this.removeCallbacks(this.mAnimationTrigger);
        if (this.mCardType == 3) {
            if (focused) {
                if (!this.mDelaySelectedAnim) {
                    this.post(this.mAnimationTrigger);
                    this.mDelaySelectedAnim = true;
                } else {
                    this.postDelayed(this.mAnimationTrigger, this.mSelectedAnimationDelay);
                }
            } else {
                this.animateInfoOffset(false);
            }
        } else if (this.mInfoVisibility == 2) {
            this.setInfoViewVisibility(focused);
        }
    }

    private void cancelAnimations() {
        if (this.mAnim != null) {
            this.mAnim.cancel();
            this.mAnim = null;
        }
    }

    private void animateInfoOffset(boolean shown) {
        this.cancelAnimations();
        int extraHeight = 0;
        if (shown) {
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMeasuredWidth, (int)0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            for (int i = 0; i < this.mExtraViewList.size(); ++i) {
                View extraView = this.mExtraViewList.get(i);
                extraView.setVisibility(0);
                extraView.measure(widthSpec, heightSpec);
                extraHeight = Math.max(extraHeight, extraView.getMeasuredHeight());
            }
        }
        this.mAnim = new InfoOffsetAnimation(this.mInfoOffset, shown ? (float)extraHeight : 0.0f);
        this.mAnim.setDuration((long)this.mSelectedAnimDuration);
        this.mAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.mAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (BaseCardView.this.mInfoOffset == 0.0f) {
                    for (int i = 0; i < BaseCardView.this.mExtraViewList.size(); ++i) {
                        ((View)BaseCardView.this.mExtraViewList.get(i)).setVisibility(8);
                    }
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation(this.mAnim);
    }

    private void animateInfoHeight(boolean shown) {
        this.cancelAnimations();
        int extraHeight = 0;
        if (shown) {
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMeasuredWidth, (int)0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            for (int i = 0; i < this.mExtraViewList.size(); ++i) {
                View extraView = this.mExtraViewList.get(i);
                extraView.setVisibility(0);
                extraView.measure(widthSpec, heightSpec);
                extraHeight = Math.max(extraHeight, extraView.getMeasuredHeight());
            }
        }
        this.mAnim = new InfoHeightAnimation(this.mInfoVisFraction, shown ? 1.0f : 0.0f);
        this.mAnim.setDuration((long)this.mSelectedAnimDuration);
        this.mAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.mAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (BaseCardView.this.mInfoOffset == 0.0f) {
                    for (int i = 0; i < BaseCardView.this.mExtraViewList.size(); ++i) {
                        ((View)BaseCardView.this.mExtraViewList.get(i)).setVisibility(8);
                    }
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation(this.mAnim);
    }

    private void animateInfoAlpha(boolean shown) {
        this.cancelAnimations();
        if (shown) {
            for (int i = 0; i < this.mInfoViewList.size(); ++i) {
                this.mInfoViewList.get(i).setVisibility(0);
            }
        }
        this.mAnim = new InfoAlphaAnimation(this.mInfoAlpha, shown ? 1.0f : 0.0f);
        this.mAnim.setDuration((long)this.mActivatedAnimDuration);
        this.mAnim.setInterpolator((Interpolator)new DecelerateInterpolator());
        this.mAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if ((double)BaseCardView.this.mInfoAlpha == 0.0) {
                    for (int i = 0; i < BaseCardView.this.mInfoViewList.size(); ++i) {
                        ((View)BaseCardView.this.mInfoViewList.get(i)).setVisibility(8);
                    }
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation(this.mAnim);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public String toString() {
        return super.toString();
    }

    private class InfoAlphaAnimation
    extends Animation {
        private float mStartValue;
        private float mDelta;

        public InfoAlphaAnimation(float start, float end) {
            this.mStartValue = start;
            this.mDelta = end - start;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            BaseCardView.this.mInfoAlpha = this.mStartValue + interpolatedTime * this.mDelta;
            for (int i = 0; i < BaseCardView.this.mInfoViewList.size(); ++i) {
                ((View)BaseCardView.this.mInfoViewList.get(i)).setAlpha(BaseCardView.this.mInfoAlpha);
            }
        }
    }

    private class InfoHeightAnimation
    extends Animation {
        private float mStartValue;
        private float mDelta;

        public InfoHeightAnimation(float start, float end) {
            this.mStartValue = start;
            this.mDelta = end - start;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            BaseCardView.this.mInfoVisFraction = this.mStartValue + interpolatedTime * this.mDelta;
            BaseCardView.this.requestLayout();
        }
    }

    private class InfoOffsetAnimation
    extends Animation {
        private float mStartValue;
        private float mDelta;

        public InfoOffsetAnimation(float start, float end) {
            this.mStartValue = start;
            this.mDelta = end - start;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            BaseCardView.this.mInfoOffset = this.mStartValue + interpolatedTime * this.mDelta;
            BaseCardView.this.requestLayout();
        }
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public static final int VIEW_TYPE_MAIN = 0;
        public static final int VIEW_TYPE_INFO = 1;
        public static final int VIEW_TYPE_EXTRA = 2;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=0, to="MAIN"), @ViewDebug.IntToString(from=1, to="INFO"), @ViewDebug.IntToString(from=2, to="EXTRA")})
        public int viewType = 0;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.lbBaseCardView_Layout);
            this.viewType = a.getInt(R.styleable.lbBaseCardView_Layout_layout_viewType, 0);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.viewType = source.viewType;
        }
    }
}

