/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.GridLayoutManager;
import android.support.v17.leanback.widget.OnChildLaidOutListener;
import android.support.v17.leanback.widget.OnChildSelectedListener;
import android.support.v17.leanback.widget.OnChildViewHolderSelectedListener;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;

abstract class BaseGridView
extends RecyclerView {
    public static final int FOCUS_SCROLL_ALIGNED = 0;
    public static final int FOCUS_SCROLL_ITEM = 1;
    public static final int FOCUS_SCROLL_PAGE = 2;
    public static final int WINDOW_ALIGN_LOW_EDGE = 1;
    public static final int WINDOW_ALIGN_HIGH_EDGE = 2;
    public static final int WINDOW_ALIGN_BOTH_EDGE = 3;
    public static final int WINDOW_ALIGN_NO_EDGE = 0;
    public static final float WINDOW_ALIGN_OFFSET_PERCENT_DISABLED = -1.0f;
    public static final float ITEM_ALIGN_OFFSET_PERCENT_DISABLED = -1.0f;
    public static final int SAVE_NO_CHILD = 0;
    public static final int SAVE_ON_SCREEN_CHILD = 1;
    public static final int SAVE_LIMITED_CHILD = 2;
    public static final int SAVE_ALL_CHILD = 3;
    final GridLayoutManager mLayoutManager = new GridLayoutManager(this);
    private boolean mAnimateChildLayout = true;
    private boolean mHasOverlappingRendering = true;
    private RecyclerView.ItemAnimator mSavedItemAnimator;
    private OnTouchInterceptListener mOnTouchInterceptListener;
    private OnMotionInterceptListener mOnMotionInterceptListener;
    private OnKeyInterceptListener mOnKeyInterceptListener;
    private RecyclerView.RecyclerListener mChainedRecyclerListener;
    private OnUnhandledKeyListener mOnUnhandledKeyListener;

    public BaseGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setLayoutManager(this.mLayoutManager);
        this.setDescendantFocusability(262144);
        this.setHasFixedSize(true);
        this.setChildrenDrawingOrderEnabled(true);
        this.setWillNotDraw(true);
        this.setOverScrollMode(2);
        this.getItemAnimator().setSupportsChangeAnimations(false);
        super.setRecyclerListener(new RecyclerView.RecyclerListener(){

            public void onViewRecycled(RecyclerView.ViewHolder holder) {
                BaseGridView.this.mLayoutManager.onChildRecycled(holder);
                if (BaseGridView.this.mChainedRecyclerListener != null) {
                    BaseGridView.this.mChainedRecyclerListener.onViewRecycled(holder);
                }
            }
        });
    }

    protected void initBaseGridViewAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.lbBaseGridView);
        boolean throughFront = a.getBoolean(R.styleable.lbBaseGridView_focusOutFront, false);
        boolean throughEnd = a.getBoolean(R.styleable.lbBaseGridView_focusOutEnd, false);
        this.mLayoutManager.setFocusOutAllowed(throughFront, throughEnd);
        this.mLayoutManager.setVerticalMargin(a.getDimensionPixelSize(R.styleable.lbBaseGridView_verticalMargin, 0));
        this.mLayoutManager.setHorizontalMargin(a.getDimensionPixelSize(R.styleable.lbBaseGridView_horizontalMargin, 0));
        if (a.hasValue(R.styleable.lbBaseGridView_android_gravity)) {
            this.setGravity(a.getInt(R.styleable.lbBaseGridView_android_gravity, 0));
        }
        a.recycle();
    }

    public void setFocusScrollStrategy(int scrollStrategy) {
        if (scrollStrategy != 0 && scrollStrategy != 1 && scrollStrategy != 2) {
            throw new IllegalArgumentException("Invalid scrollStrategy");
        }
        this.mLayoutManager.setFocusScrollStrategy(scrollStrategy);
        this.requestLayout();
    }

    public int getFocusScrollStrategy() {
        return this.mLayoutManager.getFocusScrollStrategy();
    }

    public void setWindowAlignment(int windowAlignment) {
        this.mLayoutManager.setWindowAlignment(windowAlignment);
        this.requestLayout();
    }

    public int getWindowAlignment() {
        return this.mLayoutManager.getWindowAlignment();
    }

    public void setWindowAlignmentOffset(int offset) {
        this.mLayoutManager.setWindowAlignmentOffset(offset);
        this.requestLayout();
    }

    public int getWindowAlignmentOffset() {
        return this.mLayoutManager.getWindowAlignmentOffset();
    }

    public void setWindowAlignmentOffsetPercent(float offsetPercent) {
        this.mLayoutManager.setWindowAlignmentOffsetPercent(offsetPercent);
        this.requestLayout();
    }

    public float getWindowAlignmentOffsetPercent() {
        return this.mLayoutManager.getWindowAlignmentOffsetPercent();
    }

    public void setItemAlignmentOffset(int offset) {
        this.mLayoutManager.setItemAlignmentOffset(offset);
        this.requestLayout();
    }

    public int getItemAlignmentOffset() {
        return this.mLayoutManager.getItemAlignmentOffset();
    }

    public void setItemAlignmentOffsetWithPadding(boolean withPadding) {
        this.mLayoutManager.setItemAlignmentOffsetWithPadding(withPadding);
        this.requestLayout();
    }

    public boolean isItemAlignmentOffsetWithPadding() {
        return this.mLayoutManager.isItemAlignmentOffsetWithPadding();
    }

    public void setItemAlignmentOffsetPercent(float offsetPercent) {
        this.mLayoutManager.setItemAlignmentOffsetPercent(offsetPercent);
        this.requestLayout();
    }

    public float getItemAlignmentOffsetPercent() {
        return this.mLayoutManager.getItemAlignmentOffsetPercent();
    }

    public void setItemAlignmentViewId(int viewId) {
        this.mLayoutManager.setItemAlignmentViewId(viewId);
    }

    public int getItemAlignmentViewId() {
        return this.mLayoutManager.getItemAlignmentViewId();
    }

    public void setItemMargin(int margin) {
        this.mLayoutManager.setItemMargin(margin);
        this.requestLayout();
    }

    public void setVerticalMargin(int margin) {
        this.mLayoutManager.setVerticalMargin(margin);
        this.requestLayout();
    }

    public int getVerticalMargin() {
        return this.mLayoutManager.getVerticalMargin();
    }

    public void setHorizontalMargin(int margin) {
        this.mLayoutManager.setHorizontalMargin(margin);
        this.requestLayout();
    }

    public int getHorizontalMargin() {
        return this.mLayoutManager.getHorizontalMargin();
    }

    public void setOnChildLaidOutListener(OnChildLaidOutListener listener) {
        this.mLayoutManager.setOnChildLaidOutListener(listener);
    }

    public void setOnChildSelectedListener(OnChildSelectedListener listener) {
        this.mLayoutManager.setOnChildSelectedListener(listener);
    }

    public void setOnChildViewHolderSelectedListener(OnChildViewHolderSelectedListener listener) {
        this.mLayoutManager.setOnChildViewHolderSelectedListener(listener);
    }

    public void setSelectedPosition(int position) {
        this.mLayoutManager.setSelection(this, position, 0);
    }

    public void setSelectedPositionWithSub(int position, int subposition) {
        this.mLayoutManager.setSelectionWithSub(this, position, subposition, 0);
    }

    public void setSelectedPosition(int position, int scrollExtra) {
        this.mLayoutManager.setSelection(this, position, scrollExtra);
    }

    public void setSelectedPositionWithSub(int position, int subposition, int scrollExtra) {
        this.mLayoutManager.setSelectionWithSub(this, position, subposition, scrollExtra);
    }

    public void setSelectedPositionSmooth(int position) {
        this.mLayoutManager.setSelectionSmooth(this, position);
    }

    public void setSelectedPositionSmoothWithSub(int position, int subposition) {
        this.mLayoutManager.setSelectionSmoothWithSub(this, position, subposition);
    }

    public int getSelectedPosition() {
        return this.mLayoutManager.getSelection();
    }

    public int getSelectedSubPosition() {
        return this.mLayoutManager.getSubSelection();
    }

    public void setAnimateChildLayout(boolean animateChildLayout) {
        if (this.mAnimateChildLayout != animateChildLayout) {
            this.mAnimateChildLayout = animateChildLayout;
            if (!this.mAnimateChildLayout) {
                this.mSavedItemAnimator = this.getItemAnimator();
                super.setItemAnimator(null);
            } else {
                super.setItemAnimator(this.mSavedItemAnimator);
            }
        }
    }

    public boolean isChildLayoutAnimated() {
        return this.mAnimateChildLayout;
    }

    public void setGravity(int gravity) {
        this.mLayoutManager.setGravity(gravity);
        this.requestLayout();
    }

    public boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        return this.mLayoutManager.gridOnRequestFocusInDescendants(this, direction, previouslyFocusedRect);
    }

    public void getViewSelectedOffsets(View view, int[] offsets) {
        this.mLayoutManager.getViewSelectedOffsets(view, offsets);
    }

    public int getChildDrawingOrder(int childCount, int i) {
        return this.mLayoutManager.getChildDrawingOrder(this, childCount, i);
    }

    final boolean isChildrenDrawingOrderEnabledInternal() {
        return this.isChildrenDrawingOrderEnabled();
    }

    public final void setFocusSearchDisabled(boolean disabled) {
        this.setDescendantFocusability(disabled ? 393216 : 262144);
        this.mLayoutManager.setFocusSearchDisabled(disabled);
    }

    public final boolean isFocusSearchDisabled() {
        return this.mLayoutManager.isFocusSearchDisabled();
    }

    public void setLayoutEnabled(boolean layoutEnabled) {
        this.mLayoutManager.setLayoutEnabled(layoutEnabled);
    }

    public void setChildrenVisibility(int visibility) {
        this.mLayoutManager.setChildrenVisibility(visibility);
    }

    public void setPruneChild(boolean pruneChild) {
        this.mLayoutManager.setPruneChild(pruneChild);
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.mLayoutManager.setScrollEnabled(scrollEnabled);
    }

    public boolean isScrollEnabled() {
        return this.mLayoutManager.isScrollEnabled();
    }

    public boolean hasPreviousViewInSameRow(int position) {
        return this.mLayoutManager.hasPreviousViewInSameRow(position);
    }

    public void setFocusDrawingOrderEnabled(boolean enabled) {
        super.setChildrenDrawingOrderEnabled(enabled);
    }

    public boolean isFocusDrawingOrderEnabled() {
        return super.isChildrenDrawingOrderEnabled();
    }

    public void setOnTouchInterceptListener(OnTouchInterceptListener listener) {
        this.mOnTouchInterceptListener = listener;
    }

    public void setOnMotionInterceptListener(OnMotionInterceptListener listener) {
        this.mOnMotionInterceptListener = listener;
    }

    public void setOnKeyInterceptListener(OnKeyInterceptListener listener) {
        this.mOnKeyInterceptListener = listener;
    }

    public void setOnUnhandledKeyListener(OnUnhandledKeyListener listener) {
        this.mOnUnhandledKeyListener = listener;
    }

    public OnUnhandledKeyListener getOnUnhandledKeyListener() {
        return this.mOnUnhandledKeyListener;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.mOnKeyInterceptListener != null && this.mOnKeyInterceptListener.onInterceptKeyEvent(event)) {
            return true;
        }
        if (super.dispatchKeyEvent(event)) {
            return true;
        }
        return this.mOnUnhandledKeyListener != null && this.mOnUnhandledKeyListener.onUnhandledKey(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.mOnTouchInterceptListener != null && this.mOnTouchInterceptListener.onInterceptTouchEvent(event)) {
            return true;
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean dispatchGenericFocusedEvent(MotionEvent event) {
        if (this.mOnMotionInterceptListener != null && this.mOnMotionInterceptListener.onInterceptMotionEvent(event)) {
            return true;
        }
        return super.dispatchGenericFocusedEvent(event);
    }

    public final int getSaveChildrenPolicy() {
        return this.mLayoutManager.mChildrenStates.getSavePolicy();
    }

    public final int getSaveChildrenLimitNumber() {
        return this.mLayoutManager.mChildrenStates.getLimitNumber();
    }

    public final void setSaveChildrenPolicy(int savePolicy) {
        this.mLayoutManager.mChildrenStates.setSavePolicy(savePolicy);
    }

    public final void setSaveChildrenLimitNumber(int limitNumber) {
        this.mLayoutManager.mChildrenStates.setLimitNumber(limitNumber);
    }

    public boolean hasOverlappingRendering() {
        return this.mHasOverlappingRendering;
    }

    public void setHasOverlappingRendering(boolean hasOverlapping) {
        this.mHasOverlappingRendering = hasOverlapping;
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        this.mLayoutManager.onRtlPropertiesChanged(layoutDirection);
    }

    public void setRecyclerListener(RecyclerView.RecyclerListener listener) {
        this.mChainedRecyclerListener = listener;
    }

    public static interface OnUnhandledKeyListener {
        public boolean onUnhandledKey(KeyEvent var1);
    }

    public static interface OnKeyInterceptListener {
        public boolean onInterceptKeyEvent(KeyEvent var1);
    }

    public static interface OnMotionInterceptListener {
        public boolean onInterceptMotionEvent(MotionEvent var1);
    }

    public static interface OnTouchInterceptListener {
        public boolean onInterceptTouchEvent(MotionEvent var1);
    }
}

