/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

public class BrowseFrameLayout
extends FrameLayout {
    private OnFocusSearchListener mListener;
    private OnChildFocusListener mOnChildFocusListener;

    public BrowseFrameLayout(Context context) {
        this(context, null, 0);
    }

    public BrowseFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BrowseFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setOnFocusSearchListener(OnFocusSearchListener listener) {
        this.mListener = listener;
    }

    public OnFocusSearchListener getOnFocusSearchListener() {
        return this.mListener;
    }

    public void setOnChildFocusListener(OnChildFocusListener listener) {
        this.mOnChildFocusListener = listener;
    }

    public OnChildFocusListener getOnChildFocusListener() {
        return this.mOnChildFocusListener;
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        if (this.mOnChildFocusListener != null) {
            return this.mOnChildFocusListener.onRequestFocusInDescendants(direction, previouslyFocusedRect);
        }
        return super.onRequestFocusInDescendants(direction, previouslyFocusedRect);
    }

    public View focusSearch(View focused, int direction) {
        View view;
        if (this.mListener != null && (view = this.mListener.onFocusSearch(focused, direction)) != null) {
            return view;
        }
        return super.focusSearch(focused, direction);
    }

    public void requestChildFocus(View child, View focused) {
        super.requestChildFocus(child, focused);
        if (this.mOnChildFocusListener != null) {
            this.mOnChildFocusListener.onRequestChildFocus(child, focused);
        }
    }

    public static interface OnChildFocusListener {
        public boolean onRequestFocusInDescendants(int var1, Rect var2);

        public void onRequestChildFocus(View var1, View var2);
    }

    public static interface OnFocusSearchListener {
        public View onFocusSearch(View var1, int var2);
    }
}

