/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

class ControlBar
extends LinearLayout {
    private int mChildMarginFromCenter;
    private OnChildFocusedListener mOnChildFocusedListener;

    public ControlBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ControlBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (this.getChildCount() > 0 && this.getChildAt(this.getChildCount() / 2).requestFocus(direction, previouslyFocusedRect)) {
            return true;
        }
        return super.requestFocus(direction, previouslyFocusedRect);
    }

    public void setOnChildFocusedListener(OnChildFocusedListener listener) {
        this.mOnChildFocusedListener = listener;
    }

    public void setChildMarginFromCenter(int marginFromCenter) {
        this.mChildMarginFromCenter = marginFromCenter;
    }

    public void requestChildFocus(View child, View focused) {
        super.requestChildFocus(child, focused);
        if (this.mOnChildFocusedListener != null) {
            this.mOnChildFocusedListener.onChildFocusedListener(child, focused);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mChildMarginFromCenter <= 0) {
            return;
        }
        int totalExtraMargin = 0;
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            View first = this.getChildAt(i);
            View second = this.getChildAt(i + 1);
            int measuredWidth = first.getMeasuredWidth() + second.getMeasuredWidth();
            int marginStart = this.mChildMarginFromCenter - measuredWidth / 2;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)second.getLayoutParams();
            int extraMargin = marginStart - lp.getMarginStart();
            lp.setMarginStart(marginStart);
            second.setLayoutParams((ViewGroup.LayoutParams)lp);
            totalExtraMargin += extraMargin;
        }
        this.setMeasuredDimension(this.getMeasuredWidth() + totalExtraMargin, this.getMeasuredHeight());
    }

    public static interface OnChildFocusedListener {
        public void onChildFocusedListener(View var1, View var2);
    }
}

