/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.ControlBar;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.Presenter;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

class ControlBarPresenter
extends Presenter {
    private static final int MAX_CONTROLS = 7;
    private OnControlClickedListener mOnControlClickedListener;
    private OnControlSelectedListener mOnControlSelectedListener;
    private int mLayoutResourceId;
    private static int sChildMarginDefault;
    private static int sControlIconWidth;

    public ControlBarPresenter(int layoutResourceId) {
        this.mLayoutResourceId = layoutResourceId;
    }

    public int getLayoutResourceId() {
        return this.mLayoutResourceId;
    }

    public void setOnControlClickedListener(OnControlClickedListener listener) {
        this.mOnControlClickedListener = listener;
    }

    public OnControlClickedListener getOnItemViewClickedListener() {
        return this.mOnControlClickedListener;
    }

    public void setOnControlSelectedListener(OnControlSelectedListener listener) {
        this.mOnControlSelectedListener = listener;
    }

    public OnControlSelectedListener getOnItemControlListener() {
        return this.mOnControlSelectedListener;
    }

    public void setBackgroundColor(ViewHolder vh, int color2) {
        vh.mControlsContainer.setBackgroundColor(color2);
    }

    @Override
    public Presenter.ViewHolder onCreateViewHolder(ViewGroup parent) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutResourceId(), parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(Presenter.ViewHolder holder, Object item) {
        ViewHolder vh = (ViewHolder)holder;
        BoundData data = (BoundData)item;
        if (vh.mAdapter != data.adapter) {
            vh.mAdapter = data.adapter;
            if (vh.mAdapter != null) {
                vh.mAdapter.registerObserver(vh.mDataObserver);
            }
        }
        vh.mPresenter = data.presenter;
        vh.mData = data;
        vh.showControls(vh.mPresenter);
    }

    @Override
    public void onUnbindViewHolder(Presenter.ViewHolder holder) {
        ViewHolder vh = (ViewHolder)holder;
        if (vh.mAdapter != null) {
            vh.mAdapter.unregisterObserver(vh.mDataObserver);
            vh.mAdapter = null;
        }
        vh.mData = null;
    }

    int getChildMarginDefault(Context context) {
        if (sChildMarginDefault == 0) {
            sChildMarginDefault = context.getResources().getDimensionPixelSize(R.dimen.lb_playback_controls_child_margin_default);
        }
        return sChildMarginDefault;
    }

    int getControlIconWidth(Context context) {
        if (sControlIconWidth == 0) {
            sControlIconWidth = context.getResources().getDimensionPixelSize(R.dimen.lb_control_icon_width);
        }
        return sControlIconWidth;
    }

    class ViewHolder
    extends Presenter.ViewHolder {
        ObjectAdapter mAdapter;
        BoundData mData;
        Presenter mPresenter;
        ControlBar mControlBar;
        View mControlsContainer;
        SparseArray<Presenter.ViewHolder> mViewHolders;
        ObjectAdapter.DataObserver mDataObserver;

        ViewHolder(View rootView) {
            super(rootView);
            this.mViewHolders = new SparseArray();
            this.mControlsContainer = rootView.findViewById(R.id.controls_container);
            this.mControlBar = (ControlBar)rootView.findViewById(R.id.control_bar);
            if (this.mControlBar == null) {
                throw new IllegalStateException("Couldn't find control_bar");
            }
            this.mControlBar.setOnChildFocusedListener(new ControlBar.OnChildFocusedListener(){

                @Override
                public void onChildFocusedListener(View child, View focused) {
                    if (ControlBarPresenter.this.mOnControlSelectedListener == null) {
                        return;
                    }
                    for (int position = 0; position < ViewHolder.this.mViewHolders.size(); ++position) {
                        if (((Presenter.ViewHolder)ViewHolder.this.mViewHolders.get((int)position)).view != child) continue;
                        ControlBarPresenter.this.mOnControlSelectedListener.onControlSelected((Presenter.ViewHolder)ViewHolder.this.mViewHolders.get(position), ViewHolder.this.getDisplayedAdapter().get(position), ViewHolder.this.mData);
                        break;
                    }
                }
            });
            this.mDataObserver = new ObjectAdapter.DataObserver(){

                @Override
                public void onChanged() {
                    if (ViewHolder.this.mAdapter == ViewHolder.this.getDisplayedAdapter()) {
                        ViewHolder.this.showControls(ViewHolder.this.mPresenter);
                    }
                }

                @Override
                public void onItemRangeChanged(int positionStart, int itemCount) {
                    if (ViewHolder.this.mAdapter == ViewHolder.this.getDisplayedAdapter()) {
                        for (int i = 0; i < itemCount; ++i) {
                            ViewHolder.this.bindControlToAction(positionStart + i, ViewHolder.this.mPresenter);
                        }
                    }
                }
            };
        }

        int getChildMarginFromCenter(Context context, int numControls) {
            return ControlBarPresenter.this.getChildMarginDefault(context) + ControlBarPresenter.this.getControlIconWidth(context);
        }

        void showControls(Presenter presenter) {
            ObjectAdapter adapter = this.getDisplayedAdapter();
            int adapterSize = adapter == null ? 0 : adapter.size();
            View focusedView = this.mControlBar.getFocusedChild();
            if (focusedView != null && adapterSize > 0 && this.mControlBar.indexOfChild(focusedView) >= adapterSize) {
                this.mControlBar.getChildAt(adapter.size() - 1).requestFocus();
            }
            for (int i = this.mControlBar.getChildCount() - 1; i >= adapterSize; --i) {
                this.mControlBar.removeViewAt(i);
            }
            for (int position = 0; position < adapterSize && position < 7; ++position) {
                this.bindControlToAction(position, adapter, presenter);
            }
            this.mControlBar.setChildMarginFromCenter(this.getChildMarginFromCenter(this.mControlBar.getContext(), adapterSize));
        }

        void bindControlToAction(int position, Presenter presenter) {
            this.bindControlToAction(position, this.getDisplayedAdapter(), presenter);
        }

        private void bindControlToAction(final int position, ObjectAdapter adapter, Presenter presenter) {
            Presenter.ViewHolder vh = (Presenter.ViewHolder)this.mViewHolders.get(position);
            Object item = adapter.get(position);
            if (vh == null) {
                vh = presenter.onCreateViewHolder((ViewGroup)this.mControlBar);
                this.mViewHolders.put(position, (Object)vh);
                final Presenter.ViewHolder itemViewHolder = vh;
                presenter.setOnClickListener(vh, new View.OnClickListener(){

                    public void onClick(View v) {
                        Object item = ViewHolder.this.getDisplayedAdapter().get(position);
                        if (ControlBarPresenter.this.mOnControlClickedListener != null) {
                            ControlBarPresenter.this.mOnControlClickedListener.onControlClicked(itemViewHolder, item, ViewHolder.this.mData);
                        }
                    }
                });
            }
            if (vh.view.getParent() == null) {
                this.mControlBar.addView(vh.view);
            }
            presenter.onBindViewHolder(vh, item);
        }

        ObjectAdapter getDisplayedAdapter() {
            return this.mAdapter;
        }
    }

    static interface OnControlClickedListener {
        public void onControlClicked(Presenter.ViewHolder var1, Object var2, BoundData var3);
    }

    static interface OnControlSelectedListener {
        public void onControlSelected(Presenter.ViewHolder var1, Object var2, BoundData var3);
    }

    static class BoundData {
        ObjectAdapter adapter;
        Presenter presenter;

        BoundData() {
        }
    }
}

