/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.Action;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

public class ControlButtonPresenterSelector
extends PresenterSelector {
    private final Presenter mPrimaryPresenter = new ControlButtonPresenter(R.layout.lb_control_button_primary);
    private final Presenter mSecondaryPresenter = new ControlButtonPresenter(R.layout.lb_control_button_secondary);
    private final Presenter[] mPresenters = new Presenter[]{this.mPrimaryPresenter};

    public Presenter getPrimaryPresenter() {
        return this.mPrimaryPresenter;
    }

    public Presenter getSecondaryPresenter() {
        return this.mSecondaryPresenter;
    }

    @Override
    public Presenter getPresenter(Object item) {
        return this.mPrimaryPresenter;
    }

    @Override
    public Presenter[] getPresenters() {
        return this.mPresenters;
    }

    static class ControlButtonPresenter
    extends Presenter {
        private int mLayoutResourceId;

        ControlButtonPresenter(int layoutResourceId) {
            this.mLayoutResourceId = layoutResourceId;
        }

        @Override
        public Presenter.ViewHolder onCreateViewHolder(ViewGroup parent) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.mLayoutResourceId, parent, false);
            return new ActionViewHolder(v);
        }

        @Override
        public void onBindViewHolder(Presenter.ViewHolder viewHolder, Object item) {
            CharSequence contentDescription;
            Action action = (Action)item;
            ActionViewHolder vh = (ActionViewHolder)viewHolder;
            vh.mIcon.setImageDrawable(action.getIcon());
            if (vh.mLabel != null) {
                if (action.getIcon() == null) {
                    vh.mLabel.setText(action.getLabel1());
                } else {
                    vh.mLabel.setText(null);
                }
            }
            CharSequence charSequence = contentDescription = TextUtils.isEmpty((CharSequence)action.getLabel2()) ? action.getLabel1() : action.getLabel2();
            if (!TextUtils.equals((CharSequence)vh.mFocusableView.getContentDescription(), (CharSequence)contentDescription)) {
                vh.mFocusableView.setContentDescription(contentDescription);
                vh.mFocusableView.sendAccessibilityEvent(32768);
            }
        }

        @Override
        public void onUnbindViewHolder(Presenter.ViewHolder viewHolder) {
            ActionViewHolder vh = (ActionViewHolder)viewHolder;
            vh.mIcon.setImageDrawable(null);
            if (vh.mLabel != null) {
                vh.mLabel.setText(null);
            }
            vh.mFocusableView.setContentDescription(null);
        }

        @Override
        public void setOnClickListener(Presenter.ViewHolder viewHolder, View.OnClickListener listener) {
            ((ActionViewHolder)viewHolder).mFocusableView.setOnClickListener(listener);
        }
    }

    static class ActionViewHolder
    extends Presenter.ViewHolder {
        ImageView mIcon;
        TextView mLabel;
        View mFocusableView;

        public ActionViewHolder(View view) {
            super(view);
            this.mIcon = (ImageView)view.findViewById(R.id.icon);
            this.mLabel = (TextView)view.findViewById(R.id.label);
            this.mFocusableView = view.findViewById(R.id.button);
        }
    }
}

