/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v17.leanback.widget.Action;
import android.support.v17.leanback.widget.ActionPresenterSelector;
import android.support.v17.leanback.widget.ArrayObjectAdapter;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.support.v17.leanback.widget.Row;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class DetailsOverviewRow
extends Row {
    private Object mItem;
    private Drawable mImageDrawable;
    private boolean mImageScaleUpAllowed = true;
    private ArrayList<WeakReference<Listener>> mListeners;
    private PresenterSelector mDefaultActionPresenter = new ActionPresenterSelector();
    private ObjectAdapter mActionsAdapter = new ArrayObjectAdapter(this.mDefaultActionPresenter);

    public DetailsOverviewRow(Object item) {
        super(null);
        this.mItem = item;
        this.verify();
    }

    final void addListener(Listener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        } else {
            int i = 0;
            while (i < this.mListeners.size()) {
                Listener l = (Listener)this.mListeners.get(i).get();
                if (l == null) {
                    this.mListeners.remove(i);
                    continue;
                }
                if (l == listener) {
                    return;
                }
                ++i;
            }
        }
        this.mListeners.add(new WeakReference<Listener>(listener));
    }

    final void removeListener(Listener listener) {
        if (this.mListeners != null) {
            int i = 0;
            while (i < this.mListeners.size()) {
                Listener l = (Listener)this.mListeners.get(i).get();
                if (l == null) {
                    this.mListeners.remove(i);
                    continue;
                }
                if (l == listener) {
                    this.mListeners.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    final void notifyItemChanged() {
        if (this.mListeners != null) {
            int i = 0;
            while (i < this.mListeners.size()) {
                Listener l = (Listener)this.mListeners.get(i).get();
                if (l == null) {
                    this.mListeners.remove(i);
                    continue;
                }
                l.onItemChanged(this);
                ++i;
            }
        }
    }

    final void notifyImageDrawableChanged() {
        if (this.mListeners != null) {
            int i = 0;
            while (i < this.mListeners.size()) {
                Listener l = (Listener)this.mListeners.get(i).get();
                if (l == null) {
                    this.mListeners.remove(i);
                    continue;
                }
                l.onImageDrawableChanged(this);
                ++i;
            }
        }
    }

    final void notifyActionsAdapterChanged() {
        if (this.mListeners != null) {
            int i = 0;
            while (i < this.mListeners.size()) {
                Listener l = (Listener)this.mListeners.get(i).get();
                if (l == null) {
                    this.mListeners.remove(i);
                    continue;
                }
                l.onActionsAdapterChanged(this);
                ++i;
            }
        }
    }

    public final Object getItem() {
        return this.mItem;
    }

    public final void setItem(Object item) {
        if (item != this.mItem) {
            this.mItem = item;
            this.notifyItemChanged();
        }
    }

    public final void setImageDrawable(Drawable drawable2) {
        if (this.mImageDrawable != drawable2) {
            this.mImageDrawable = drawable2;
            this.notifyImageDrawableChanged();
        }
    }

    public final void setImageBitmap(Context context, Bitmap bm) {
        this.mImageDrawable = new BitmapDrawable(context.getResources(), bm);
        this.notifyImageDrawableChanged();
    }

    public final Drawable getImageDrawable() {
        return this.mImageDrawable;
    }

    public void setImageScaleUpAllowed(boolean allowed) {
        if (allowed != this.mImageScaleUpAllowed) {
            this.mImageScaleUpAllowed = allowed;
            this.notifyImageDrawableChanged();
        }
    }

    public boolean isImageScaleUpAllowed() {
        return this.mImageScaleUpAllowed;
    }

    private ArrayObjectAdapter getArrayObjectAdapter() {
        return (ArrayObjectAdapter)this.mActionsAdapter;
    }

    public final void addAction(Action action) {
        this.getArrayObjectAdapter().add(action);
    }

    public final void addAction(int pos, Action action) {
        this.getArrayObjectAdapter().add(pos, action);
    }

    public final boolean removeAction(Action action) {
        return this.getArrayObjectAdapter().remove(action);
    }

    public final List<Action> getActions() {
        return this.getArrayObjectAdapter().unmodifiableList();
    }

    public final ObjectAdapter getActionsAdapter() {
        return this.mActionsAdapter;
    }

    public final void setActionsAdapter(ObjectAdapter adapter) {
        if (adapter != this.mActionsAdapter) {
            this.mActionsAdapter = adapter;
            if (this.mActionsAdapter.getPresenterSelector() == null) {
                this.mActionsAdapter.setPresenterSelector(this.mDefaultActionPresenter);
            }
            this.notifyActionsAdapterChanged();
        }
    }

    public Action getActionForKeyCode(int keyCode) {
        ObjectAdapter adapter = this.getActionsAdapter();
        if (adapter != null) {
            for (int i = 0; i < adapter.size(); ++i) {
                Action action = (Action)adapter.get(i);
                if (!action.respondsToKeyCode(keyCode)) continue;
                return action;
            }
        }
        return null;
    }

    private void verify() {
        if (this.mItem == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
    }

    public static class Listener {
        public void onImageDrawableChanged(DetailsOverviewRow row) {
        }

        public void onItemChanged(DetailsOverviewRow row) {
        }

        public void onActionsAdapterChanged(DetailsOverviewRow row) {
        }
    }
}

