/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.Action;
import android.support.v17.leanback.widget.BaseGridView;
import android.support.v17.leanback.widget.DetailsOverviewLogoPresenter;
import android.support.v17.leanback.widget.DetailsOverviewRow;
import android.support.v17.leanback.widget.HorizontalGridView;
import android.support.v17.leanback.widget.ItemBridgeAdapter;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.OnActionClickedListener;
import android.support.v17.leanback.widget.OnChildSelectedListener;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.RoundedRectHelper;
import android.support.v17.leanback.widget.RowPresenter;
import android.support.v7.widget.RecyclerView;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class FullWidthDetailsOverviewRowPresenter
extends RowPresenter {
    private static final String TAG = "FullWidthDetailsOverviewRowPresenter";
    private static final boolean DEBUG = false;
    private static Rect sTmpRect = new Rect();
    public static final int STATE_HALF = 0;
    public static final int STATE_FULL = 1;
    public static final int STATE_SMALL = 2;
    protected int mInitialState = 0;
    private final Presenter mDetailsPresenter;
    private final DetailsOverviewLogoPresenter mDetailsOverviewLogoPresenter;
    private OnActionClickedListener mActionClickedListener;
    private int mBackgroundColor = 0;
    private boolean mBackgroundColorSet;
    private Listener mListener;
    private boolean mParticipatingEntranceTransition;

    public FullWidthDetailsOverviewRowPresenter(Presenter detailsPresenter) {
        this(detailsPresenter, new DetailsOverviewLogoPresenter());
    }

    public FullWidthDetailsOverviewRowPresenter(Presenter detailsPresenter, DetailsOverviewLogoPresenter logoPresenter) {
        this.setHeaderPresenter(null);
        this.setSelectEffectEnabled(false);
        this.mDetailsPresenter = detailsPresenter;
        this.mDetailsOverviewLogoPresenter = logoPresenter;
    }

    public void setOnActionClickedListener(OnActionClickedListener listener) {
        this.mActionClickedListener = listener;
    }

    public OnActionClickedListener getOnActionClickedListener() {
        return this.mActionClickedListener;
    }

    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        this.mBackgroundColorSet = true;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public final boolean isParticipatingEntranceTransition() {
        return this.mParticipatingEntranceTransition;
    }

    public final void setParticipatingEntranceTransition(boolean participating) {
        this.mParticipatingEntranceTransition = participating;
    }

    public final void setInitialState(int state) {
        this.mInitialState = state;
    }

    public final int getInitialState() {
        return this.mInitialState;
    }

    @Override
    protected boolean isClippingChildren() {
        return true;
    }

    public final void setListener(Listener listener) {
        this.mListener = listener;
    }

    private int getDefaultBackgroundColor(Context context) {
        TypedValue outValue = new TypedValue();
        if (context.getTheme().resolveAttribute(R.attr.defaultBrandColor, outValue, true)) {
            return context.getResources().getColor(outValue.resourceId);
        }
        return context.getResources().getColor(R.color.lb_default_brand_color);
    }

    protected int getLayoutResourceId() {
        return R.layout.lb_fullwidth_details_overview;
    }

    @Override
    protected RowPresenter.ViewHolder createRowViewHolder(ViewGroup parent) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutResourceId(), parent, false);
        final ViewHolder vh = new ViewHolder(v, this.mDetailsPresenter, this.mDetailsOverviewLogoPresenter);
        this.mDetailsOverviewLogoPresenter.setContext(vh.mDetailsLogoViewHolder, vh, this);
        this.setState(vh, this.mInitialState);
        vh.mActionBridgeAdapter = new ActionsItemBridgeAdapter(vh);
        ViewGroup overview = vh.mOverviewFrame;
        int bgColor = this.mBackgroundColorSet ? this.mBackgroundColor : this.getDefaultBackgroundColor(overview.getContext());
        overview.setBackgroundColor(bgColor);
        RoundedRectHelper.getInstance().setClipToRoundedOutline((View)overview, true);
        vh.mActionsRow.setOnUnhandledKeyListener(new BaseGridView.OnUnhandledKeyListener(){

            @Override
            public boolean onUnhandledKey(KeyEvent event) {
                return vh.getOnKeyListener() != null && vh.getOnKeyListener().onKey(vh.view, event.getKeyCode(), event);
            }
        });
        return vh;
    }

    private static int getNonNegativeWidth(Drawable drawable2) {
        int width = drawable2 == null ? 0 : drawable2.getIntrinsicWidth();
        return width > 0 ? width : 0;
    }

    private static int getNonNegativeHeight(Drawable drawable2) {
        int height = drawable2 == null ? 0 : drawable2.getIntrinsicHeight();
        return height > 0 ? height : 0;
    }

    @Override
    protected void onBindRowViewHolder(RowPresenter.ViewHolder holder, Object item) {
        super.onBindRowViewHolder(holder, item);
        DetailsOverviewRow row = (DetailsOverviewRow)item;
        ViewHolder vh = (ViewHolder)holder;
        this.mDetailsOverviewLogoPresenter.onBindViewHolder(vh.mDetailsLogoViewHolder, row);
        this.mDetailsPresenter.onBindViewHolder(vh.mDetailsDescriptionViewHolder, row.getItem());
        vh.bindActions(row.getActionsAdapter());
        row.addListener(vh.mRowListener);
    }

    @Override
    protected void onUnbindRowViewHolder(RowPresenter.ViewHolder holder) {
        ViewHolder vh = (ViewHolder)holder;
        DetailsOverviewRow dor = (DetailsOverviewRow)vh.getRow();
        dor.removeListener(vh.mRowListener);
        this.mDetailsPresenter.onUnbindViewHolder(vh.mDetailsDescriptionViewHolder);
        this.mDetailsOverviewLogoPresenter.onUnbindViewHolder(vh.mDetailsLogoViewHolder);
        super.onUnbindRowViewHolder(holder);
    }

    @Override
    public final boolean isUsingDefaultSelectEffect() {
        return false;
    }

    @Override
    protected void onRowViewAttachedToWindow(RowPresenter.ViewHolder vh) {
        super.onRowViewAttachedToWindow(vh);
        ViewHolder viewHolder = (ViewHolder)vh;
        this.mDetailsPresenter.onViewAttachedToWindow(viewHolder.mDetailsDescriptionViewHolder);
        this.mDetailsOverviewLogoPresenter.onViewAttachedToWindow(viewHolder.mDetailsLogoViewHolder);
    }

    @Override
    protected void onRowViewDetachedFromWindow(RowPresenter.ViewHolder vh) {
        super.onRowViewDetachedFromWindow(vh);
        ViewHolder viewHolder = (ViewHolder)vh;
        this.mDetailsPresenter.onViewDetachedFromWindow(viewHolder.mDetailsDescriptionViewHolder);
        this.mDetailsOverviewLogoPresenter.onViewDetachedFromWindow(viewHolder.mDetailsLogoViewHolder);
    }

    public final void notifyOnBindLogo(ViewHolder viewHolder) {
        this.onLayoutOverviewFrame(viewHolder, viewHolder.getState(), true);
        this.onLayoutLogo(viewHolder, viewHolder.getState(), true);
        if (this.mListener != null) {
            this.mListener.onBindLogo(viewHolder);
        }
    }

    protected void onLayoutLogo(ViewHolder viewHolder, int oldState, boolean logoChanged) {
        View v = viewHolder.getLogoViewHolder().view;
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        lp.setMarginStart(v.getResources().getDimensionPixelSize(R.dimen.lb_details_v2_left) - lp.width);
        switch (viewHolder.getState()) {
            default: {
                lp.topMargin = v.getResources().getDimensionPixelSize(R.dimen.lb_details_v2_blank_height) - lp.height / 2;
                break;
            }
            case 0: {
                lp.topMargin = v.getResources().getDimensionPixelSize(R.dimen.lb_details_v2_blank_height) + v.getResources().getDimensionPixelSize(R.dimen.lb_details_v2_actions_height) + v.getResources().getDimensionPixelSize(R.dimen.lb_details_v2_description_margin_top);
                break;
            }
            case 2: {
                lp.topMargin = 0;
            }
        }
        v.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    protected void onLayoutOverviewFrame(ViewHolder viewHolder, int oldState, boolean logoChanged) {
        boolean isBanner;
        boolean wasBanner = oldState == 2;
        boolean bl = isBanner = viewHolder.getState() == 2;
        if (wasBanner != isBanner || logoChanged) {
            int framePaddingStart;
            Resources res = viewHolder.view.getResources();
            ViewGroup.MarginLayoutParams lpFrame = (ViewGroup.MarginLayoutParams)viewHolder.getOverviewView().getLayoutParams();
            if (isBanner) {
                lpFrame.topMargin = 0;
                if (this.mDetailsOverviewLogoPresenter.isBoundToImage(viewHolder.getLogoViewHolder(), (DetailsOverviewRow)viewHolder.getRow())) {
                    View logoView = viewHolder.getLogoViewHolder().view;
                    ViewGroup.MarginLayoutParams lpLogo = (ViewGroup.MarginLayoutParams)logoView.getLayoutParams();
                    framePaddingStart = lpLogo.width;
                } else {
                    framePaddingStart = 0;
                }
                lpFrame.leftMargin = lpFrame.rightMargin = res.getDimensionPixelSize(R.dimen.lb_details_v2_left) - framePaddingStart;
            } else {
                lpFrame.topMargin = res.getDimensionPixelSize(R.dimen.lb_details_v2_blank_height);
                framePaddingStart = res.getDimensionPixelSize(R.dimen.lb_details_v2_left);
                lpFrame.rightMargin = 0;
                lpFrame.leftMargin = 0;
            }
            viewHolder.getOverviewView().setLayoutParams((ViewGroup.LayoutParams)lpFrame);
            viewHolder.getOverviewView().setPaddingRelative(framePaddingStart, viewHolder.getOverviewView().getPaddingTop(), viewHolder.getOverviewView().getPaddingEnd(), viewHolder.getOverviewView().getPaddingBottom());
            ViewGroup.LayoutParams lpActions = viewHolder.getActionsRow().getLayoutParams();
            lpActions.height = isBanner ? 0 : res.getDimensionPixelSize(R.dimen.lb_details_v2_actions_height);
            viewHolder.getActionsRow().setLayoutParams(lpActions);
        }
    }

    public final void setState(ViewHolder viewHolder, int state) {
        if (viewHolder.getState() != state) {
            int oldState = viewHolder.getState();
            viewHolder.mState = state;
            this.onStateChanged(viewHolder, oldState);
        }
    }

    protected void onStateChanged(ViewHolder viewHolder, int oldState) {
        this.onLayoutOverviewFrame(viewHolder, oldState, false);
        this.onLayoutLogo(viewHolder, oldState, false);
    }

    @Override
    public void setEntranceTransitionState(RowPresenter.ViewHolder holder, boolean afterEntrance) {
        super.setEntranceTransitionState(holder, afterEntrance);
        if (this.mParticipatingEntranceTransition) {
            holder.view.setVisibility(afterEntrance ? 0 : 4);
        }
    }

    public class ViewHolder
    extends RowPresenter.ViewHolder {
        protected final DetailsOverviewRow.Listener mRowListener;
        final ViewGroup mOverviewRoot;
        final ViewGroup mOverviewFrame;
        final FrameLayout mDetailsDescriptionFrame;
        final HorizontalGridView mActionsRow;
        final Presenter.ViewHolder mDetailsDescriptionViewHolder;
        final DetailsOverviewLogoPresenter.ViewHolder mDetailsLogoViewHolder;
        int mNumItems;
        boolean mShowMoreRight;
        boolean mShowMoreLeft;
        ItemBridgeAdapter mActionBridgeAdapter;
        protected final Handler mHandler;
        int mState;
        final Runnable mUpdateDrawableCallback;
        final View.OnLayoutChangeListener mLayoutChangeListener;
        final OnChildSelectedListener mChildSelectedListener;
        final RecyclerView.OnScrollListener mScrollListener;

        protected DetailsOverviewRow.Listener createRowListener() {
            return new DetailsOverviewRowListener();
        }

        void bindActions(ObjectAdapter adapter) {
            this.mActionBridgeAdapter.setAdapter(adapter);
            this.mActionsRow.setAdapter(this.mActionBridgeAdapter);
            this.mNumItems = this.mActionBridgeAdapter.getItemCount();
            this.mShowMoreRight = false;
            this.mShowMoreLeft = true;
            this.showMoreLeft(false);
        }

        void dispatchItemSelection(View view) {
            if (!this.isSelected()) {
                return;
            }
            ItemBridgeAdapter.ViewHolder ibvh = (ItemBridgeAdapter.ViewHolder)(view != null ? this.mActionsRow.getChildViewHolder(view) : this.mActionsRow.findViewHolderForPosition(this.mActionsRow.getSelectedPosition()));
            if (ibvh == null) {
                if (this.getOnItemViewSelectedListener() != null) {
                    this.getOnItemViewSelectedListener().onItemSelected(null, null, this, this.getRow());
                }
            } else if (this.getOnItemViewSelectedListener() != null) {
                this.getOnItemViewSelectedListener().onItemSelected(ibvh.getViewHolder(), ibvh.getItem(), this, this.getRow());
            }
        }

        private int getViewCenter(View view) {
            return (view.getRight() - view.getLeft()) / 2;
        }

        private void checkFirstAndLastPosition(boolean fromScroll) {
            RecyclerView.ViewHolder viewHolder = this.mActionsRow.findViewHolderForPosition(this.mNumItems - 1);
            boolean showRight = viewHolder == null || viewHolder.itemView.getRight() > this.mActionsRow.getWidth();
            viewHolder = this.mActionsRow.findViewHolderForPosition(0);
            boolean showLeft = viewHolder == null || viewHolder.itemView.getLeft() < 0;
            this.showMoreRight(showRight);
            this.showMoreLeft(showLeft);
        }

        private void showMoreLeft(boolean show) {
            if (show != this.mShowMoreLeft) {
                this.mActionsRow.setFadingLeftEdge(show);
                this.mShowMoreLeft = show;
            }
        }

        private void showMoreRight(boolean show) {
            if (show != this.mShowMoreRight) {
                this.mActionsRow.setFadingRightEdge(show);
                this.mShowMoreRight = show;
            }
        }

        public ViewHolder(View rootView, Presenter detailsPresenter, DetailsOverviewLogoPresenter logoPresenter) {
            super(rootView);
            this.mRowListener = this.createRowListener();
            this.mHandler = new Handler();
            this.mState = 0;
            this.mUpdateDrawableCallback = new Runnable(){

                @Override
                public void run() {
                    FullWidthDetailsOverviewRowPresenter.this.mDetailsOverviewLogoPresenter.onBindViewHolder(ViewHolder.this.mDetailsLogoViewHolder, ViewHolder.this.getRow());
                }
            };
            this.mLayoutChangeListener = new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    ViewHolder.this.checkFirstAndLastPosition(false);
                }
            };
            this.mChildSelectedListener = new OnChildSelectedListener(){

                @Override
                public void onChildSelected(ViewGroup parent, View view, int position, long id2) {
                    ViewHolder.this.dispatchItemSelection(view);
                }
            };
            this.mScrollListener = new RecyclerView.OnScrollListener(){

                public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                }

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    ViewHolder.this.checkFirstAndLastPosition(true);
                }
            };
            this.mOverviewRoot = (ViewGroup)rootView.findViewById(R.id.details_root);
            this.mOverviewFrame = (ViewGroup)rootView.findViewById(R.id.details_frame);
            this.mDetailsDescriptionFrame = (FrameLayout)rootView.findViewById(R.id.details_overview_description);
            this.mActionsRow = (HorizontalGridView)this.mOverviewFrame.findViewById(R.id.details_overview_actions);
            this.mActionsRow.setHasOverlappingRendering(false);
            this.mActionsRow.setOnScrollListener(this.mScrollListener);
            this.mActionsRow.setAdapter(this.mActionBridgeAdapter);
            this.mActionsRow.setOnChildSelectedListener(this.mChildSelectedListener);
            int fadeLength = rootView.getResources().getDimensionPixelSize(R.dimen.lb_details_overview_actions_fade_size);
            this.mActionsRow.setFadingRightEdgeLength(fadeLength);
            this.mActionsRow.setFadingLeftEdgeLength(fadeLength);
            this.mDetailsDescriptionViewHolder = detailsPresenter.onCreateViewHolder((ViewGroup)this.mDetailsDescriptionFrame);
            this.mDetailsDescriptionFrame.addView(this.mDetailsDescriptionViewHolder.view);
            this.mDetailsLogoViewHolder = (DetailsOverviewLogoPresenter.ViewHolder)logoPresenter.onCreateViewHolder(this.mOverviewRoot);
            this.mOverviewRoot.addView(this.mDetailsLogoViewHolder.view);
        }

        public final ViewGroup getOverviewView() {
            return this.mOverviewFrame;
        }

        public final DetailsOverviewLogoPresenter.ViewHolder getLogoViewHolder() {
            return this.mDetailsLogoViewHolder;
        }

        public final Presenter.ViewHolder getDetailsDescriptionViewHolder() {
            return this.mDetailsDescriptionViewHolder;
        }

        public final ViewGroup getDetailsDescriptionFrame() {
            return this.mDetailsDescriptionFrame;
        }

        public final ViewGroup getActionsRow() {
            return this.mActionsRow;
        }

        public final int getState() {
            return this.mState;
        }

        public class DetailsOverviewRowListener
        extends DetailsOverviewRow.Listener {
            @Override
            public void onImageDrawableChanged(DetailsOverviewRow row) {
                ViewHolder.this.mHandler.removeCallbacks(ViewHolder.this.mUpdateDrawableCallback);
                ViewHolder.this.mHandler.post(ViewHolder.this.mUpdateDrawableCallback);
            }

            @Override
            public void onItemChanged(DetailsOverviewRow row) {
                if (ViewHolder.this.mDetailsDescriptionViewHolder != null) {
                    FullWidthDetailsOverviewRowPresenter.this.mDetailsPresenter.onUnbindViewHolder(ViewHolder.this.mDetailsDescriptionViewHolder);
                }
                FullWidthDetailsOverviewRowPresenter.this.mDetailsPresenter.onBindViewHolder(ViewHolder.this.mDetailsDescriptionViewHolder, row.getItem());
            }

            @Override
            public void onActionsAdapterChanged(DetailsOverviewRow row) {
                ViewHolder.this.bindActions(row.getActionsAdapter());
            }
        }
    }

    class ActionsItemBridgeAdapter
    extends ItemBridgeAdapter {
        ViewHolder mViewHolder;

        ActionsItemBridgeAdapter(ViewHolder viewHolder) {
            this.mViewHolder = viewHolder;
        }

        @Override
        public void onBind(final ItemBridgeAdapter.ViewHolder ibvh) {
            if (this.mViewHolder.getOnItemViewClickedListener() != null || FullWidthDetailsOverviewRowPresenter.this.mActionClickedListener != null) {
                ibvh.getPresenter().setOnClickListener(ibvh.getViewHolder(), new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ActionsItemBridgeAdapter.this.mViewHolder.getOnItemViewClickedListener() != null) {
                            ActionsItemBridgeAdapter.this.mViewHolder.getOnItemViewClickedListener().onItemClicked(ibvh.getViewHolder(), ibvh.getItem(), ActionsItemBridgeAdapter.this.mViewHolder, ActionsItemBridgeAdapter.this.mViewHolder.getRow());
                        }
                        if (FullWidthDetailsOverviewRowPresenter.this.mActionClickedListener != null) {
                            FullWidthDetailsOverviewRowPresenter.this.mActionClickedListener.onActionClicked((Action)ibvh.getItem());
                        }
                    }
                });
            }
        }

        @Override
        public void onUnbind(ItemBridgeAdapter.ViewHolder ibvh) {
            if (this.mViewHolder.getOnItemViewClickedListener() != null || FullWidthDetailsOverviewRowPresenter.this.mActionClickedListener != null) {
                ibvh.getPresenter().setOnClickListener(ibvh.getViewHolder(), null);
            }
        }

        @Override
        public void onAttachedToWindow(ItemBridgeAdapter.ViewHolder viewHolder) {
            viewHolder.itemView.removeOnLayoutChangeListener(this.mViewHolder.mLayoutChangeListener);
            viewHolder.itemView.addOnLayoutChangeListener(this.mViewHolder.mLayoutChangeListener);
        }

        @Override
        public void onDetachedFromWindow(ItemBridgeAdapter.ViewHolder viewHolder) {
            viewHolder.itemView.removeOnLayoutChangeListener(this.mViewHolder.mLayoutChangeListener);
            this.mViewHolder.checkFirstAndLastPosition(false);
        }
    }

    public static abstract class Listener {
        public void onBindLogo(ViewHolder vh) {
        }
    }
}

