/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.widget.StaggeredGridDefault;
import android.support.v4.util.CircularIntArray;
import java.io.PrintWriter;

abstract class Grid {
    public static final int START_DEFAULT = -1;
    protected Provider mProvider;
    protected boolean mReversedFlow;
    protected int mMargin;
    protected int mNumRows;
    protected int mFirstVisibleIndex = -1;
    protected int mLastVisibleIndex = -1;
    protected CircularIntArray[] mTmpItemPositionsInRows;
    protected int mStartIndex = -1;

    Grid() {
    }

    public static Grid createStaggeredMultipleRows(int rows) {
        StaggeredGridDefault grid = new StaggeredGridDefault();
        grid.setNumRows(rows);
        return grid;
    }

    public final void setMargin(int margin) {
        this.mMargin = margin;
    }

    public final void setReversedFlow(boolean reversedFlow) {
        this.mReversedFlow = reversedFlow;
    }

    public boolean isReversedFlow() {
        return this.mReversedFlow;
    }

    public void setProvider(Provider provider) {
        this.mProvider = provider;
    }

    public void setStart(int startIndex) {
        this.mStartIndex = startIndex;
    }

    public int getNumRows() {
        return this.mNumRows;
    }

    void setNumRows(int numRows) {
        if (numRows <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.mNumRows == numRows) {
            return;
        }
        this.mNumRows = numRows;
        this.mTmpItemPositionsInRows = new CircularIntArray[this.mNumRows];
        for (int i = 0; i < this.mNumRows; ++i) {
            this.mTmpItemPositionsInRows[i] = new CircularIntArray();
        }
    }

    public final int getFirstVisibleIndex() {
        return this.mFirstVisibleIndex;
    }

    public final int getLastVisibleIndex() {
        return this.mLastVisibleIndex;
    }

    public void resetVisibleIndex() {
        this.mLastVisibleIndex = -1;
        this.mFirstVisibleIndex = -1;
    }

    public void invalidateItemsAfter(int index) {
        if (index < 0) {
            return;
        }
        if (this.mLastVisibleIndex < 0) {
            return;
        }
        while (this.mLastVisibleIndex >= index) {
            this.mProvider.removeItem(this.mLastVisibleIndex);
            --this.mLastVisibleIndex;
        }
        this.resetVisbileIndexIfEmpty();
        if (this.getFirstVisibleIndex() < 0) {
            this.setStart(index);
        }
    }

    public final int getRowIndex(int index) {
        return this.getLocation((int)index).row;
    }

    public abstract Location getLocation(int var1);

    public final int findRowMin(boolean findLarge, int[] indices) {
        return this.findRowMin(findLarge, this.mReversedFlow ? this.mLastVisibleIndex : this.mFirstVisibleIndex, indices);
    }

    protected abstract int findRowMin(boolean var1, int var2, int[] var3);

    public final int findRowMax(boolean findLarge, int[] indices) {
        return this.findRowMax(findLarge, this.mReversedFlow ? this.mFirstVisibleIndex : this.mLastVisibleIndex, indices);
    }

    protected abstract int findRowMax(boolean var1, int var2, int[] var3);

    protected final boolean checkAppendOverLimit(int toLimit) {
        if (this.mLastVisibleIndex < 0) {
            return false;
        }
        return this.mReversedFlow ? this.findRowMin(true, null) <= toLimit + this.mMargin : this.findRowMax(false, null) >= toLimit - this.mMargin;
    }

    protected final boolean checkPrependOverLimit(int toLimit) {
        if (this.mLastVisibleIndex < 0) {
            return false;
        }
        return this.mReversedFlow ? this.findRowMax(false, null) >= toLimit + this.mMargin : this.findRowMin(true, null) <= toLimit - this.mMargin;
    }

    public abstract CircularIntArray[] getItemPositionsInRows(int var1, int var2);

    public final CircularIntArray[] getItemPositionsInRows() {
        return this.getItemPositionsInRows(this.getFirstVisibleIndex(), this.getLastVisibleIndex());
    }

    public final boolean prependOneColumnVisibleItems() {
        return this.prependVisibleItems(this.mReversedFlow ? Integer.MIN_VALUE : Integer.MAX_VALUE, true);
    }

    public final void prependVisibleItems(int toLimit) {
        this.prependVisibleItems(toLimit, false);
    }

    protected abstract boolean prependVisibleItems(int var1, boolean var2);

    public boolean appendOneColumnVisibleItems() {
        return this.appendVisibleItems(this.mReversedFlow ? Integer.MAX_VALUE : Integer.MIN_VALUE, true);
    }

    public final void appendVisibleItems(int toLimit) {
        this.appendVisibleItems(toLimit, false);
    }

    protected abstract boolean appendVisibleItems(int var1, boolean var2);

    public void removeInvisibleItemsAtEnd(int aboveIndex, int toLimit) {
        while (this.mLastVisibleIndex >= this.mFirstVisibleIndex && this.mLastVisibleIndex > aboveIndex) {
            boolean offEnd;
            boolean bl = !this.mReversedFlow ? this.mProvider.getEdge(this.mLastVisibleIndex) >= toLimit : (offEnd = this.mProvider.getEdge(this.mLastVisibleIndex) <= toLimit);
            if (!offEnd) break;
            this.mProvider.removeItem(this.mLastVisibleIndex);
            --this.mLastVisibleIndex;
        }
        this.resetVisbileIndexIfEmpty();
    }

    public void removeInvisibleItemsAtFront(int belowIndex, int toLimit) {
        while (this.mLastVisibleIndex >= this.mFirstVisibleIndex && this.mFirstVisibleIndex < belowIndex) {
            boolean offFront;
            boolean bl = !this.mReversedFlow ? this.mProvider.getEdge(this.mFirstVisibleIndex) + this.mProvider.getSize(this.mFirstVisibleIndex) <= toLimit : (offFront = this.mProvider.getEdge(this.mFirstVisibleIndex) - this.mProvider.getSize(this.mFirstVisibleIndex) >= toLimit);
            if (!offFront) break;
            this.mProvider.removeItem(this.mFirstVisibleIndex);
            ++this.mFirstVisibleIndex;
        }
        this.resetVisbileIndexIfEmpty();
    }

    private void resetVisbileIndexIfEmpty() {
        if (this.mLastVisibleIndex < this.mFirstVisibleIndex) {
            this.resetVisibleIndex();
        }
    }

    public abstract void debugPrint(PrintWriter var1);

    public static class Location {
        public int row;

        public Location(int row) {
            this.row = row;
        }
    }

    public static interface Provider {
        public int getCount();

        public int createItem(int var1, boolean var2, Object[] var3);

        public void addItem(Object var1, int var2, int var3, int var4, int var5);

        public void removeItem(int var1);

        public int getEdge(int var1);

        public int getSize(int var1);
    }
}

